/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.business.domian.handler;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.sdk.hr.hspm.common.utils.BusinessUtils;

public class CalServiceLengthHandler {
    private static final Log LOGGER = LogFactory.getLog(CalServiceLengthHandler.class);
    private static final HRBaseServiceHelper EMPENTREL_HELPER = new HRBaseServiceHelper("hrpi_empentrel");
    private static final HRBaseServiceHelper EMPLOYEE_HELPER = new HRBaseServiceHelper("hrpi_employee");

    public static Map<Long, BigDecimal> calcAndSetEmpentrelContinuation(List<DynamicObject> continuationDys, boolean persistFlag, String calFirstAdjTime, DynamicObject[] dyArr) {
        Map<Long, BigDecimal> totalServiceLengthMap = CalServiceLengthHandler.calcEmpentrelContinuation(continuationDys, calFirstAdjTime, "0");
        if (persistFlag) {
            CalServiceLengthHandler.setRefValueToDyArr(dyArr, totalServiceLengthMap);
        }
        return totalServiceLengthMap;
    }

    public static Map<Long, Date> getUseDateByEmployeeId(Set<Long> empIds) {
        if (CollectionUtils.isEmpty(empIds)) {
            return new HashMap<Long, Date>(1);
        }
        HRBaseServiceHelper empentrelHepler = new HRBaseServiceHelper("hrpi_employee");
        QFilter statusQFilter = new QFilter("iscurrentversion", "=", (Object)"1").and(new QFilter("datastatus", "=", (Object)"1"));
        QFilter filter = new QFilter("id", "in", empIds).and(statusQFilter);
        DynamicObject[] dys = empentrelHepler.query("id, person.id, laborrelstatus, enddate", new QFilter[]{filter});
        if (dys == null || dys.length == 0) {
            return new HashMap<Long, Date>(1);
        }
        HashMap<Long, Date> empIdEndDateMap = new HashMap<Long, Date>(dys.length);
        for (DynamicObject dy : dys) {
            Date date = new Date();
            long empId = dy.getLong("id");
            if (empId == 0L) continue;
            DynamicObject laborrelstatusDy = dy.getDynamicObject("laborrelstatus");
            if (laborrelstatusDy != null) {
                long statusId;
                long l = statusId = laborrelstatusDy.getDynamicObject("labrelstatusprd") != null ? laborrelstatusDy.getLong("labrelstatusprd.id") : 0L;
                if (statusId == 1020L) {
                    date = dy.getDate("enddate");
                }
            }
            if (date == null) {
                date = new Date();
            }
            empIdEndDateMap.put(empId, date);
        }
        return empIdEndDateMap;
    }

    public static Map<Long, Date> getPersonIdUseDate(Set<Long> personIds) {
        if (CollectionUtils.isEmpty(personIds)) {
            return new HashMap<Long, Date>(1);
        }
        Map<Long, DynamicObject> personIdempDyMap = CalServiceLengthHandler.getPersonLabrelstatus(personIds);
        if (CollectionUtils.isEmpty(personIdempDyMap)) {
            return new HashMap<Long, Date>(1);
        }
        HashMap<Long, Date> personIdEndMap = new HashMap<Long, Date>(personIdempDyMap.size());
        for (Long personId : personIds) {
            DynamicObject laborrelstatusDy;
            Date date = new Date();
            DynamicObject personStatusDy = personIdempDyMap.get(personId);
            if (personStatusDy != null && (laborrelstatusDy = personStatusDy.getDynamicObject("laborrelstatus")) != null) {
                long statusId;
                long l = statusId = laborrelstatusDy.getDynamicObject("labrelstatusprd") != null ? laborrelstatusDy.getLong("labrelstatusprd.id") : 0L;
                if (statusId == 1020L) {
                    date = personStatusDy.getDate("enddate");
                }
            }
            if (date == null) {
                date = new Date();
            }
            personIdEndMap.put(personId, date);
        }
        return personIdEndMap;
    }

    public static Map<Long, DynamicObject> getPersonLabrelstatus(Set<Long> personIds) {
        if (CollectionUtils.isEmpty(personIds)) {
            return new HashMap<Long, DynamicObject>(1);
        }
        QFilter statusQFilter = new QFilter("iscurrentversion", "=", (Object)"1").and(new QFilter("datastatus", "=", (Object)"1"));
        QFilter isLatestFilter = new QFilter("islatestrecord", "=", (Object)"1");
        HRBaseServiceHelper empentrelHepler = new HRBaseServiceHelper("hrpi_employee");
        QFilter filter = new QFilter("person.id", "in", personIds).and(statusQFilter).and(isLatestFilter);
        DynamicObject[] dys = empentrelHepler.query("person.id, laborrelstatus, enddate", new QFilter[]{filter});
        return Arrays.stream(dys).filter(dy -> dy.getLong("person.id") != 0L).collect(Collectors.toMap(dy -> dy.getLong("person.id"), dy -> dy, (oldVal, newVal) -> newVal));
    }

    public static Map<Long, BigDecimal> calcEmpentrelContinuation(List<DynamicObject> continuationDys, String calFirstAdjTime, String judgeTime) {
        HashMap<Long, BigDecimal> totalServiceLengthMap = new HashMap<Long, BigDecimal>(16);
        if (continuationDys.size() == 0) {
            return totalServiceLengthMap;
        }
        Set<Long> empMid = continuationDys.stream().filter(conDy -> conDy.getLong("employee.mid") != 0L).map(conDy -> conDy.getLong("employee.mid")).collect(Collectors.toSet());
        Object[] empMidDys = CalServiceLengthHandler.queryEmployeeByMid(empMid);
        if (empMid.size() == 0 || HRArrayUtils.isEmpty((Object[])empMidDys)) {
            return totalServiceLengthMap;
        }
        Set<Long> empIds = Arrays.stream(empMidDys).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        Object[] oldEmpentrelDys = CalServiceLengthHandler.queryEmpentrelByEmpId(empIds);
        if (HRArrayUtils.isEmpty((Object[])oldEmpentrelDys)) {
            return totalServiceLengthMap;
        }
        Map<Long, List<DynamicObject>> midEmpentrelMap = Arrays.stream(oldEmpentrelDys).collect(Collectors.groupingBy(conDy -> conDy.getLong("employee.mid")));
        for (DynamicObject conDy2 : continuationDys) {
            long lastId = conDy2.getLong("boid");
            long mid = conDy2.getLong("employee.mid");
            Date sData = conDy2.getDate("startdate");
            List<DynamicObject> oldEmpentrelTmpDys = midEmpentrelMap.get(mid);
            if (oldEmpentrelTmpDys == null || oldEmpentrelTmpDys.size() == 0) continue;
            oldEmpentrelTmpDys.sort(CalServiceLengthHandler::compare);
            BigDecimal lastServiceLength = new BigDecimal(0);
            for (DynamicObject oldEmpentrelDy : oldEmpentrelTmpDys) {
                Date endDate;
                Date startDate = oldEmpentrelDy.getDate("startdate");
                if ("1".equals(judgeTime) && sData.before(startDate)) continue;
                long oldId = oldEmpentrelDy.getLong("boid");
                BigDecimal adjustLength = oldEmpentrelDy.getBigDecimal("adjustlength");
                if (lastId == oldId) {
                    endDate = new Date();
                    long statusPro = oldEmpentrelDy.getLong("labrelstatusprd.id");
                    if (statusPro == 1020L) {
                        endDate = oldEmpentrelDy.getDate("enddate");
                    }
                    if ("1".equals(calFirstAdjTime)) {
                        lastServiceLength = lastServiceLength.add(CalServiceLengthHandler.calcServiceLength(startDate, endDate, adjustLength, null));
                        continue;
                    }
                    lastServiceLength = lastServiceLength.add(CalServiceLengthHandler.calcServiceLength(startDate, endDate, null));
                    continue;
                }
                endDate = oldEmpentrelDy.getDate("enddate");
                if (startDate == null || endDate == null) continue;
                lastServiceLength = lastServiceLength.add(CalServiceLengthHandler.calcServiceLength(startDate, endDate, adjustLength, null));
                String serviceAgeScheme = oldEmpentrelDy.getString("serviceagescheme");
                if ("2".equals(serviceAgeScheme)) continue;
                break;
            }
            totalServiceLengthMap.put(mid, lastServiceLength);
        }
        return totalServiceLengthMap;
    }

    private static int compare(DynamicObject dynamicObject, DynamicObject dynamicObject1) {
        return dynamicObject.getDate("startdate").after(dynamicObject1.getDate("startdate")) ? -1 : 1;
    }

    private static void setRefValueToDyArr(DynamicObject[] dyArray, Map<Long, BigDecimal> totalServiceLengthMap) {
        for (DynamicObject dynamicObject : dyArray) {
            CalServiceLengthHandler.setToDy(totalServiceLengthMap, dynamicObject);
        }
    }

    private static void setToDy(Map<Long, BigDecimal> totalServiceLengthMap, DynamicObject dynamicObject) {
        String serviceAgeScheme = dynamicObject.getString("serviceagescheme");
        if (!"2".equals(serviceAgeScheme)) {
            return;
        }
        long mid = dynamicObject.getLong("employee.mid");
        BigDecimal serviceLength = totalServiceLengthMap.get(mid);
        if (serviceLength != null) {
            dynamicObject.set("servicelength", (Object)serviceLength);
        }
    }

    public static BigDecimal calcServiceLength(Date startdate, Date endDate, BigDecimal adjustlength, DynamicObject dynamicObject) {
        BigDecimal years = CalServiceLengthHandler.calcYearsDiff(endDate, startdate);
        BigDecimal serviceLength = years.add(adjustlength);
        if (dynamicObject != null) {
            dynamicObject.set("servicelength", (Object)serviceLength);
        }
        return serviceLength;
    }

    public static BigDecimal calcServiceLength(Date startdate, Date endDate, DynamicObject dynamicObject) {
        BigDecimal serviceLength = CalServiceLengthHandler.calcYearsDiff(endDate, startdate);
        if (dynamicObject != null) {
            dynamicObject.set("servicelength", (Object)serviceLength);
        }
        return serviceLength;
    }

    private static DynamicObject[] queryEmpentrelByEmpId(Set<Long> empIds) {
        QFilter qFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter midFilter = new QFilter("employee", "in", empIds);
        return EMPENTREL_HELPER.query("id,boid,person,entservicelen,employee.mid,servicelength,adjustlength,startdate,enddate,iscurrentversion,serviceagescheme,boid,labrelstatusprd", new QFilter[]{qFilter, midFilter});
    }

    private static DynamicObject[] queryEmployeeByMid(Set<Long> empMid) {
        QFilter qFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter dataStatusQFilter = new QFilter("datastatus", "=", (Object)"1");
        QFilter midFilter = new QFilter("mid", "in", empMid);
        return EMPLOYEE_HELPER.query("id,mid", new QFilter[]{qFilter, midFilter, dataStatusQFilter});
    }

    @Deprecated
    public static BigDecimal calcYearsDiff(Date dateO, Date dateT) {
        return BusinessUtils.calcYearsDiff((Date)dateO, (Date)dateT);
    }
}

