/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.business.domian.repository;

import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hspm.common.constants.report.enums.SortRuleEnum;

public class ReportDisplayRepository {
    private static final HRBaseServiceHelper DISPLAY_PLAN_HELPER = new HRBaseServiceHelper("hspm_displayplan");

    public static Map<String, String> getField(Long id) {
        DynamicObjectCollection entity = ReportDisplayRepository.getPlan(id);
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
        if (entity != null && entity.size() > 0) {
            for (DynamicObject rocord : entity) {
                fields.put(rocord.getString("shownodeid"), rocord.getString("displayalias"));
            }
        }
        return fields;
    }

    public static Map<String, DynamicObject> getConfigs(Long id) {
        DynamicObjectCollection entity = ReportDisplayRepository.getPlan(id);
        int size = entity == null ? 16 : entity.size();
        LinkedHashMap fields = Maps.newLinkedHashMapWithExpectedSize((int)size);
        if (entity != null) {
            entity.forEach(item -> fields.put(item.getString("shownodeid"), item));
        }
        return fields;
    }

    public static DynamicObjectCollection getPlan(Long id) {
        String select = "id,shownodeid,displayalias,columnwidth,aligntype";
        DynamicObject obj = DISPLAY_PLAN_HELPER.queryOne(select, (Object)id);
        DynamicObjectCollection entity = null;
        if (obj != null) {
            entity = obj.getDynamicObjectCollection("detailshowentity");
        }
        return entity;
    }

    private static DynamicObjectCollection getSortPlan(Long id) {
        String select = "id,shownodeid,displayalias,detailshowentity.sortrule,detailshowentity.sortnum";
        QFilter filter = new QFilter("id", "=", (Object)id);
        DynamicObject obj = DISPLAY_PLAN_HELPER.queryOne(select, new QFilter[]{filter}, "detailshowentity.sortnum asc");
        DynamicObjectCollection entity = null;
        if (obj != null && !CollectionUtils.isEmpty((Collection)(entity = obj.getDynamicObjectCollection("detailshowentity")))) {
            entity.sort((Comparator)new Comparator<DynamicObject>(){

                @Override
                public int compare(DynamicObject o1, DynamicObject o2) {
                    int o1Num = o1.getInt("sortnum");
                    int o2Num = o2.getInt("sortnum");
                    if (o1Num == 0 && o2Num == 0) {
                        return 0;
                    }
                    if (o1Num == 0) {
                        return 1;
                    }
                    if (o2Num == 0) {
                        return -1;
                    }
                    return Integer.compare(o1Num, o2Num);
                }
            });
        }
        return entity;
    }

    public static String getSort(Long id) {
        DynamicObjectCollection entity = ReportDisplayRepository.getSortPlan(id);
        StringBuilder sortSb = new StringBuilder();
        if (entity == null || entity.size() < 1) {
            return null;
        }
        for (DynamicObject record : entity) {
            String sortRule = record.getString("sortrule");
            if (SortRuleEnum.NONE.getType().equals(sortRule)) continue;
            String key = record.getString("shownodeid");
            sortSb.append(MessageFormat.format("{0} {1},", key, ((SortRuleEnum)SortRuleEnum.TYPE_CACHE.get(sortRule)).getRule()));
        }
        if (sortSb.length() > 0) {
            sortSb.deleteCharAt(sortSb.length() - 1);
        } else {
            sortSb.append("startdate desc");
        }
        return sortSb.toString();
    }
}

