/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.business.domian.repository.infoclassify;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.hr.hspm.common.utils.HrpiServiceOperateParam;
import kd.sdk.hr.hspm.common.utils.QFilterUtil;

public class PercreRepository {
    private final HRBaseServiceHelper SERVICE_HELPER = new HRBaseServiceHelper("hspm_percre");
    private final HRBaseServiceHelper HRPI_PERCRE_SERVICE_HELPER = new HRBaseServiceHelper("hrpi_percre");

    private PercreRepository() {
    }

    public static PercreRepository getInstance() {
        return Holder.INSTANCE;
    }

    public DynamicObject getPercre(Long percreId, String selectProperties) {
        DynamicObject dbDy;
        DynamicObject dynamicObject = dbDy = HRStringUtils.isEmpty((String)selectProperties) ? this.SERVICE_HELPER.loadSingle((Object)percreId) : this.SERVICE_HELPER.queryOne(selectProperties, (Object)percreId);
        if (HRObjectUtils.isEmpty((Object)dbDy)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\u3002", (String)"EmpproexpRepository_0", (String)"hr-hspm-business", (Object[])new Object[0]));
        }
        return dbDy;
    }

    public int queryOtherExistsByPersonIdAndPkId(long personId, Long pkId) {
        QFilter qFilter = new QFilter("person", "=", (Object)personId);
        qFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        qFilter.and(QFilterUtil.getDataStatusFilter());
        qFilter.and(new QFilter("id", "!=", (Object)pkId));
        return this.SERVICE_HELPER.count(this.SERVICE_HELPER.getEntityName(), qFilter.toArray());
    }

    public DynamicObject[] queryByPkIdList(List<Long> pkIdList) {
        return this.SERVICE_HELPER.query(new QFilter[]{new QFilter("id", "in", pkIdList)});
    }

    public DynamicObject getHrpiPercre(Long percreId) {
        return this.getHrpiPercre(percreId, "");
    }

    public DynamicObject getHrpiPercre(Long percreId, String selectProperties) {
        DynamicObject dbDy;
        DynamicObject dynamicObject = dbDy = HRStringUtils.isEmpty((String)selectProperties) ? this.HRPI_PERCRE_SERVICE_HELPER.loadSingle((Object)percreId) : this.HRPI_PERCRE_SERVICE_HELPER.queryOne(selectProperties, (Object)percreId);
        if (HRObjectUtils.isEmpty((Object)dbDy)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\u3002", (String)"EmpproexpRepository_0", (String)"hr-hspm-business", (Object[])new Object[0]));
        }
        return dbDy;
    }

    public DynamicObject[] queryHrpiPercreForPerChg(List<Long> pkIdList) {
        QFilter idFilter = new QFilter("id", "in", pkIdList);
        DynamicObject[] dynamicObjects = this.HRPI_PERCRE_SERVICE_HELPER.query("id,person,boid,sourcevid", idFilter.toArray());
        if (HRObjectUtils.isEmpty((Object)dynamicObjects) || dynamicObjects.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\u3002", (String)"EmpproexpRepository_0", (String)"hr-hspm-business", (Object[])new Object[0]));
        }
        return dynamicObjects;
    }

    public DynamicObjectCollection getInvokeSaveOrUpdateByPercre(List<DynamicObject> saveOrUpdateDyList) {
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
        for (DynamicObject saveOrUpdateDy : saveOrUpdateDyList) {
            long pkId = saveOrUpdateDy.getLong("id");
            long boid = saveOrUpdateDy.getLong("boid");
            if (pkId == 0L || boid == 0L) {
                DynamicObject insertDy = HrpiServiceOperateParam.getSaveDy((HRBaseServiceHelper)this.HRPI_PERCRE_SERVICE_HELPER, (DynamicObject)saveOrUpdateDy);
                if (boid == 0L) {
                    insertDy.set("id", (Object)pkId);
                }
                dynamicObjectCollection.add((Object)insertDy);
                continue;
            }
            DynamicObject dbDy = this.getHrpiPercre(pkId);
            DynamicObject updateDy = HrpiServiceOperateParam.getUpdateDy((HRBaseServiceHelper)this.HRPI_PERCRE_SERVICE_HELPER, (DynamicObject)saveOrUpdateDy, (DynamicObject)dbDy);
            dynamicObjectCollection.add((Object)updateDy);
        }
        if (dynamicObjectCollection.getDynamicObjectType() != null) {
            dynamicObjectCollection.getDynamicObjectType().setExtendName(this.HRPI_PERCRE_SERVICE_HELPER.getEntityName());
        }
        return dynamicObjectCollection;
    }

    public DynamicObject[] queryByCredentialstypeAndNumber(long personId, long credentialstypeId, String number) {
        QFilter qFilter = new QFilter("person", "=", (Object)personId);
        qFilter.and(new QFilter("credentialstype", "=", (Object)credentialstypeId));
        qFilter.and(new QFilter("number", "=", (Object)number));
        qFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        return this.SERVICE_HELPER.query("id", qFilter.toArray());
    }

    public DynamicObject[] queryByCredentialstype(long personId, long credentialstypeId) {
        QFilter qFilter = new QFilter("person", "=", (Object)personId);
        qFilter.and(new QFilter("credentialstype", "=", (Object)credentialstypeId));
        qFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        qFilter.and(QFilterUtil.getDataStatusFilter());
        return this.SERVICE_HELPER.query("id", qFilter.toArray());
    }

    public DynamicObject[] queryMainPercreByPersonId(long personId) {
        QFilter qFilter = new QFilter("person", "=", (Object)personId);
        qFilter.and(new QFilter("ismajor", "=", (Object)"1"));
        qFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        qFilter.and(QFilterUtil.getDataStatusFilter());
        return this.HRPI_PERCRE_SERVICE_HELPER.loadDynamicObjectArray(qFilter.toArray());
    }

    public DynamicObject[] queryByPersonId(long personId) {
        QFilter qFilter = new QFilter("person", "=", (Object)personId);
        qFilter.and(QFilterUtil.getDataStatusFilter());
        qFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        return this.HRPI_PERCRE_SERVICE_HELPER.loadDynamicObjectArray(qFilter.toArray());
    }

    public DynamicObject[] queryIsMajorByPkIdList(List<Long> pkIdList) {
        QFilter qFilter = new QFilter("id", "in", pkIdList);
        return this.SERVICE_HELPER.query("id,number,credentialstype,ismajor", qFilter.toArray());
    }

    public DynamicObject[] getImportSaveByPercre(DynamicObject[] dataEntities) {
        DynamicObject[] importSaveDys = new DynamicObject[dataEntities.length];
        for (int i = 0; i < dataEntities.length; ++i) {
            DynamicObject importSaveDy;
            importSaveDys[i] = importSaveDy = HrpiServiceOperateParam.getSaveDy((HRBaseServiceHelper)this.HRPI_PERCRE_SERVICE_HELPER, (DynamicObject)dataEntities[i]);
        }
        return importSaveDys;
    }

    public DynamicObject[] getImportOverrideByPercre(DynamicObject[] dataEntities) {
        DynamicObject[] importOverrideDys = new DynamicObject[dataEntities.length];
        for (int i = 0; i < dataEntities.length; ++i) {
            DynamicObject dy = dataEntities[i];
            Long pkId = (Long)dy.getPkValue();
            DynamicObject dbDy = this.getHrpiPercre(pkId, "");
            HRDynamicObjectUtils.copy((DynamicObject)dy, (DynamicObject)dbDy);
            dbDy.set("id", (Object)pkId);
            importOverrideDys[i] = dbDy;
        }
        return importOverrideDys;
    }

    private static class Holder {
        static final PercreRepository INSTANCE = new PercreRepository();

        private Holder() {
        }
    }
}

