/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.business.domian.repository.infoclassify;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.hr.hspm.business.helper.BasedataHelper;
import kd.sdk.hr.hspm.business.repository.ErmanFileRepository;
import kd.sdk.hr.hspm.common.enums.PersoninfoFieldEnum;
import kd.sdk.hr.hspm.common.utils.BusinessUtils;
import kd.sdk.hr.hspm.common.utils.DynamicPropUtil;
import kd.sdk.hr.hspm.common.utils.QFilterUtil;

public class PersoninfoRepository {
    private static final HRBaseServiceHelper SERVICE_HELPER = new HRBaseServiceHelper("hspm_personinfo");
    private static final HRBaseServiceHelper HRPI_PERNONTSPROP_SERVICE_HELPER = new HRBaseServiceHelper(PersoninfoFieldEnum.HRPI_PERNONTSPROP.getFormKey());
    private static final HRBaseServiceHelper HRPI_PERTSPROP_SERVICE_HELPER = new HRBaseServiceHelper(PersoninfoFieldEnum.HRPI_PERTSPROP.getFormKey());
    private static final HRBaseServiceHelper HRPI_PERREGION_SERVICE_HELPER = new HRBaseServiceHelper(PersoninfoFieldEnum.HRPI_PERREGION.getFormKey());
    private static final HRBaseServiceHelper HRPI_PERSON_SERVICE_HELPER = new HRBaseServiceHelper(PersoninfoFieldEnum.HRPI_PERSON.getFormKey());
    private static final HRBaseServiceHelper HSPM_ERMANFILE_SERVICE_HELPER = new HRBaseServiceHelper(PersoninfoFieldEnum.HSPM_ERMANFILE.getFormKey());
    private static final HRBaseServiceHelper HRPI_PERSON_SERLEN_HELPER = new HRBaseServiceHelper(PersoninfoFieldEnum.HRPI_PERSERLEN.getFormKey());

    private PersoninfoRepository() {
    }

    public static PersoninfoRepository getInstance() {
        return Holder.INSTANCE;
    }

    public DynamicObject createPersoninfo() {
        return SERVICE_HELPER.generateEmptyDynamicObject();
    }

    public DynamicObject[] queryByPkIdList(List<Long> pkIdList) {
        return SERVICE_HELPER.query(new QFilter[]{new QFilter("id", "in", pkIdList)});
    }

    public DynamicObject getPersoninfo(Long pkId, String selectProperties) {
        DynamicObject dbDy;
        DynamicObject dynamicObject = dbDy = HRStringUtils.isEmpty((String)selectProperties) ? SERVICE_HELPER.loadSingle((Object)pkId) : SERVICE_HELPER.queryOne(selectProperties, (Object)pkId);
        if (HRObjectUtils.isEmpty((Object)dbDy)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\u3002", (String)"EmpproexpRepository_0", (String)"hr-hspm-business", (Object[])new Object[0]));
        }
        return dbDy;
    }

    public DynamicObject getPernonspropById(Long pernontspropId) {
        return this.getPernonspropById(pernontspropId, "");
    }

    public DynamicObject getPernonspropById(Long pernontspropId, String selectProperties) {
        DynamicObject dbDy;
        DynamicObject dynamicObject = dbDy = HRStringUtils.isEmpty((String)selectProperties) ? HRPI_PERNONTSPROP_SERVICE_HELPER.loadSingle((Object)pernontspropId) : HRPI_PERNONTSPROP_SERVICE_HELPER.queryOne(selectProperties, (Object)pernontspropId);
        if (HRObjectUtils.isEmpty((Object)dbDy)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\u3002", (String)"EmpproexpRepository_0", (String)"hr-hspm-business", (Object[])new Object[0]));
        }
        return dbDy;
    }

    public DynamicObject getPernonspropByPersonid(Long personId, String selectProperties) {
        QFilter pertspropFilter = new QFilter("person", "=", (Object)personId);
        pertspropFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        pertspropFilter.and(QFilterUtil.getDataStatusFilter());
        if (HRStringUtils.isEmpty((String)selectProperties)) {
            return HRPI_PERNONTSPROP_SERVICE_HELPER.loadDynamicObject(pertspropFilter);
        }
        return HRPI_PERNONTSPROP_SERVICE_HELPER.queryOne(selectProperties, pertspropFilter);
    }

    public DynamicObject getPernontspropInfoByPersonId(long personId) {
        return this.getPernonspropByPersonid(personId, "name,gender,folk,nationality,birthday");
    }

    public DynamicObject getPertspropByPersonid(Long personId) {
        String selectProperties = this.getSelectProperties(MetadataServiceHelper.getDataEntityType((String)HRPI_PERTSPROP_SERVICE_HELPER.getEntityName()).getProperties(), "person");
        return this.getPertspropByPersonid(personId, selectProperties);
    }

    private String getSelectProperties(DataEntityPropertyCollection properties, String extraSelectProperties) {
        DataEntityPropertyCollection mainProperties = MetadataServiceHelper.getDataEntityType((String)SERVICE_HELPER.getEntityName()).getProperties();
        DataEntityPropertyCollection pernonsPropProperties = MetadataServiceHelper.getDataEntityType((String)HRPI_PERNONTSPROP_SERVICE_HELPER.getEntityName()).getProperties();
        return DynamicPropUtil.getSelectProperties((DataEntityPropertyCollection)mainProperties, (DataEntityPropertyCollection)pernonsPropProperties, (DataEntityPropertyCollection)properties, (String)extraSelectProperties);
    }

    public DynamicObject getPertspropByPersonid(Long personId, String selectProperties) {
        QFilter pertspropFilter = new QFilter("person", "=", (Object)personId);
        pertspropFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        pertspropFilter.and(QFilterUtil.getDataStatusFilter());
        if (HRStringUtils.isEmpty((String)selectProperties)) {
            return HRPI_PERTSPROP_SERVICE_HELPER.loadDynamicObject(pertspropFilter);
        }
        return HRPI_PERTSPROP_SERVICE_HELPER.queryOne(selectProperties, pertspropFilter);
    }

    public DynamicObject getPerrrgionByPersonid(Long personId) {
        String selectProperties = this.getSelectProperties(MetadataServiceHelper.getDataEntityType((String)HRPI_PERREGION_SERVICE_HELPER.getEntityName()).getProperties(), "person");
        return this.getPerrrgionByPersonid(personId, selectProperties);
    }

    public DynamicObject getPerrrgionByPersonid(Long personId, String selectProperties) {
        QFilter perregionFilter = new QFilter("person", "=", (Object)personId);
        perregionFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        perregionFilter.and(QFilterUtil.getDataStatusFilter());
        if (HRStringUtils.isEmpty((String)selectProperties)) {
            return HRPI_PERREGION_SERVICE_HELPER.loadDynamicObject(perregionFilter);
        }
        return HRPI_PERREGION_SERVICE_HELPER.queryOne(selectProperties, perregionFilter);
    }

    public DynamicObject getPersonById(Long personId) {
        String selectProperties = this.getSelectProperties(MetadataServiceHelper.getDataEntityType((String)HRPI_PERSON_SERVICE_HELPER.getEntityName()).getProperties(), "headsculpture,name");
        return this.getPersonById(personId, selectProperties);
    }

    public DynamicObject getPersonById(Long personId, String selectProperties) {
        DynamicObject dbDy;
        DynamicObject dynamicObject = dbDy = HRStringUtils.isEmpty((String)selectProperties) ? HRPI_PERSON_SERVICE_HELPER.loadSingle((Object)personId) : HRPI_PERSON_SERVICE_HELPER.queryOne(selectProperties, (Object)personId);
        if (HRObjectUtils.isEmpty((Object)dbDy)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\u3002", (String)"EmpproexpRepository_0", (String)"hr-hspm-business", (Object[])new Object[0]));
        }
        return dbDy;
    }

    public DynamicObject getPerSerLenByPersonId(Long personId, String selectProperties) {
        QFilter perregionFilter = new QFilter("person", "=", (Object)personId);
        perregionFilter.and(new QFilter("iscurrentversion", "=", (Object)"1").and("datastatus", "=", (Object)"1"));
        perregionFilter.and(QFilterUtil.getDataStatusFilter());
        if (HRStringUtils.isEmpty((String)selectProperties)) {
            return HRPI_PERSON_SERLEN_HELPER.loadDynamicObject(perregionFilter);
        }
        return HRPI_PERSON_SERLEN_HELPER.queryOne(selectProperties, perregionFilter);
    }

    public DynamicObjectCollection getInvokeSaveOrUpdateByPernonsprop(Long pernontspropId, DynamicObject dataEntity) {
        DynamicObject updateDy = HRPI_PERNONTSPROP_SERVICE_HELPER.generateEmptyDynamicObject();
        DynamicObject dbDy = this.getPernonspropById(pernontspropId, "");
        DataEntityPropertyCollection mainProperties = MetadataServiceHelper.getDataEntityType((String)SERVICE_HELPER.getEntityName()).getProperties();
        String selectProperties = DynamicPropUtil.getSelectProperties((DataEntityPropertyCollection)mainProperties, (DataEntityPropertyCollection)MetadataServiceHelper.getDataEntityType((String)HRPI_PERNONTSPROP_SERVICE_HELPER.getEntityName()).getProperties());
        return this.getInvokeSaveOrUpdateParam(dataEntity, updateDy, dbDy, selectProperties);
    }

    public DynamicObjectCollection getInvokeSaveOrUpdateByPertsprop(Long personId, DynamicObject dataEntity) {
        DynamicObject updateDy = HRPI_PERTSPROP_SERVICE_HELPER.generateEmptyDynamicObject();
        updateDy.set("person", (Object)personId);
        DynamicObject dbDy = this.getPertspropByPersonid(personId, "");
        String selectProperties = this.getSelectProperties(MetadataServiceHelper.getDataEntityType((String)HRPI_PERTSPROP_SERVICE_HELPER.getEntityName()).getProperties(), "person");
        return this.getInvokeSaveOrUpdateParam(dataEntity, updateDy, dbDy, selectProperties);
    }

    public DynamicObjectCollection getInvokeSaveOrUpdateByPerregion(Long personId, DynamicObject dataEntity) {
        DynamicObject updateDy = HRPI_PERREGION_SERVICE_HELPER.generateEmptyDynamicObject();
        updateDy.set("person", (Object)personId);
        DynamicObject dbDy = this.getPerrrgionByPersonid(personId, "");
        String selectProperties = this.getSelectProperties(MetadataServiceHelper.getDataEntityType((String)HRPI_PERREGION_SERVICE_HELPER.getEntityName()).getProperties(), "person");
        return this.getInvokeSaveOrUpdateParam(dataEntity, updateDy, dbDy, selectProperties);
    }

    public DynamicObjectCollection getInvokeSaveOrUpdateByPerson(Long personId, DynamicObject dataEntity) {
        DynamicObject updateDy = HRPI_PERSON_SERVICE_HELPER.generateEmptyDynamicObject();
        DynamicObject dbDy = this.getPersonById(personId, "");
        String selectProperties = this.getSelectProperties(MetadataServiceHelper.getDataEntityType((String)HRPI_PERSON_SERVICE_HELPER.getEntityName()).getProperties(), "headsculpture,name");
        return this.getInvokeSaveOrUpdateParam(dataEntity, updateDy, dbDy, selectProperties);
    }

    public DynamicObjectCollection getInvokeSaveOrUpdateByErmanfile(Long personId, DynamicObject dataEntity, Map<Long, DynamicObject> ermanFileDbMap) {
        DynamicObject[] dbDyArr = ErmanFileRepository.getErmanFile((Long)personId);
        String selectProperties = this.getSelectProperties(MetadataServiceHelper.getDataEntityType((String)HSPM_ERMANFILE_SERVICE_HELPER.getEntityName()).getProperties(), "name");
        String[] props = selectProperties.split(",");
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
        for (DynamicObject dbDy : dbDyArr) {
            DynamicObject updateDy = HSPM_ERMANFILE_SERVICE_HELPER.generateEmptyDynamicObject();
            for (String prop : props) {
                dbDy.set(prop, dataEntity.get(prop));
            }
            this.getInvokeSaveOrUpdateByErmanfile(dynamicObjectCollection, updateDy, dbDy, ermanFileDbMap);
        }
        return dynamicObjectCollection;
    }

    public DynamicObjectCollection getInvokeSaveOrUpdateByPerSerLen(Long personId, DynamicObject dataEntity) {
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
        DynamicObject updateDy = HRPI_PERSON_SERLEN_HELPER.generateEmptyDynamicObject();
        DynamicObject dbDy = this.getPerSerLenByPersonId(personId, "");
        if (dbDy != null) {
            HRDynamicObjectUtils.copy((DynamicObject)dbDy, (DynamicObject)updateDy);
            Date beginServiceDate = dataEntity.getDate("beginservicedate");
            updateDy.set("joinworktime", (Object)beginServiceDate);
            BigDecimal adjustTime = dbDy.getBigDecimal("adjustworkage");
            BigDecimal serviceLen = adjustTime.add(BusinessUtils.calcYearsDiff((Date)new Date(), (Date)beginServiceDate));
            updateDy.set("workyear", (Object)serviceLen);
            updateDy.set("socialworkage", (Object)serviceLen);
            BasedataHelper.setInitData((DynamicObject)updateDy);
            updateDy.set("id", (Object)ORM.create().genLongId(updateDy.getDataEntityType().getExtendName()));
            dynamicObjectCollection.add((Object)updateDy);
        }
        return dynamicObjectCollection;
    }

    private void getInvokeSaveOrUpdateByErmanfile(DynamicObjectCollection dynamicObjectCollection, DynamicObject updateDy, DynamicObject dbDy, Map<Long, DynamicObject> ermanFileDbMap) {
        HRDynamicObjectUtils.copy((DynamicObject)dbDy, (DynamicObject)updateDy);
        BasedataHelper.setInitData((DynamicObject)updateDy);
        dynamicObjectCollection.add((Object)updateDy);
        ermanFileDbMap.put(dbDy.getLong("boid"), dbDy);
    }

    private DynamicObjectCollection getInvokeSaveOrUpdateParam(DynamicObject dataEntity, DynamicObject updateDy, DynamicObject dbDy, String properties) {
        String[] props = properties.split(",");
        if (dbDy != null) {
            for (String prop : props) {
                dbDy.set(prop, dataEntity.get(prop));
            }
            HRDynamicObjectUtils.copy((DynamicObject)dbDy, (DynamicObject)updateDy);
        } else {
            for (String prop : props) {
                updateDy.set(prop, dataEntity.get(prop));
            }
        }
        long pkId = ORM.create().genLongId(updateDy.getDataEntityType().getExtendName());
        updateDy.set("id", (Object)pkId);
        BasedataHelper.setInitData((DynamicObject)updateDy);
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
        dynamicObjectCollection.add((Object)updateDy);
        return dynamicObjectCollection;
    }

    private static class Holder {
        static final PersoninfoRepository INSTANCE = new PersoninfoRepository();

        private Holder() {
        }
    }
}

