/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.business.domian.repository.inforevise;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;

public class DepEmpRepository {
    private static final HRBaseServiceHelper SERVICE_HELPER = new HRBaseServiceHelper("hrpi_depemp");

    private DepEmpRepository() {
    }

    public static DepEmpRepository getInstance() {
        return Holder.INSTANCE;
    }

    public DynamicObject loadByPkIdList(List<Long> pkIdList) {
        return SERVICE_HELPER.loadDynamicObject(new QFilter[]{new QFilter("id", "in", pkIdList)});
    }

    public DynamicObject[] queryByPkIdList(List<Long> pkIdList) {
        return SERVICE_HELPER.query(new QFilter[]{new QFilter("id", "in", pkIdList)});
    }

    public DynamicObject[] queryEffectiveHisDataByBoIds(Long boId) {
        QFilter boidFilter = new QFilter("boid", "=", (Object)boId);
        QFilter hisFilter = new QFilter("iscurrentversion", "=", (Object)"0");
        QFilter dataStatusFilter = new QFilter("datastatus", "in", Arrays.asList(EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()));
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        return SERVICE_HELPER.loadDynamicObjectArray(new QFilter[]{boidFilter, hisFilter, dataStatusFilter, initStatusFilter});
    }

    public DynamicObject[] queryHisDataByBoIdAndBsed(Long boId, Date bsed, Date bsled) {
        QFilter boidFilter = new QFilter("boid", "=", (Object)boId);
        QFilter bsedFilter = new QFilter("bsed", "=", (Object)bsed).and(new QFilter("bsled", "=", (Object)bsled));
        QFilter hisFilter = new QFilter("iscurrentversion", "=", (Object)"0");
        QFilter dataStatusFilter = new QFilter("datastatus", "in", Arrays.asList(EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()));
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        return SERVICE_HELPER.loadDynamicObjectArray(new QFilter[]{boidFilter, hisFilter, dataStatusFilter, initStatusFilter, bsedFilter});
    }

    private static class Holder {
        static final DepEmpRepository INSTANCE = new DepEmpRepository();

        private Holder() {
        }
    }
}

