/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.business.domian.repository.inforevise;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.sdk.hr.hspm.common.utils.QFilterUtil;

public class EmployeeRepository {
    private static final HRBaseServiceHelper SERVICE_HELPER = new HRBaseServiceHelper("hrpi_employee");

    private EmployeeRepository() {
    }

    public static EmployeeRepository getInstance() {
        return Holder.INSTANCE;
    }

    public DynamicObject[] queryByPkIdList(List<Long> pkIdList) {
        return SERVICE_HELPER.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", pkIdList)});
    }

    public DynamicObject queryByPkId(Long pkId) {
        return SERVICE_HELPER.loadDynamicObject(new QFilter[]{new QFilter("id", "=", (Object)pkId)});
    }

    public DynamicObject[] queryEffectiveHisDataByBoIds(Long boId) {
        QFilter boidFilter = new QFilter("boid", "=", (Object)boId);
        QFilter hisFilter = new QFilter("iscurrentversion", "=", (Object)"0");
        QFilter dataStatusFilter = new QFilter("datastatus", "in", Arrays.asList(EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()));
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        return SERVICE_HELPER.loadDynamicObjectArray(new QFilter[]{boidFilter, hisFilter, dataStatusFilter, initStatusFilter});
    }

    public DynamicObject[] queryHisDataByBoIdAndBsed(Long boId, Date bsed, Date bsled) {
        QFilter boidFilter = new QFilter("boid", "=", (Object)boId);
        QFilter bsedFilter = new QFilter("bsed", "=", (Object)bsed).and(new QFilter("bsled", "=", (Object)bsled));
        QFilter hisFilter = new QFilter("iscurrentversion", "=", (Object)"0");
        QFilter dataStatusFilter = new QFilter("datastatus", "in", Arrays.asList(EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()));
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        return SERVICE_HELPER.loadDynamicObjectArray(new QFilter[]{boidFilter, hisFilter, dataStatusFilter, initStatusFilter, bsedFilter});
    }

    public Map<Long, Long> queryEmpEntRelMap(Set<Long> empIdSet) {
        QFilter qFilter = new QFilter("employee", "in", empIdSet);
        qFilter.and(QFilterUtil.getCurrentQf());
        return new HRBaseServiceHelper("hrpi_empentrel").queryOriginalCollection("id,employee", qFilter.toArray()).stream().collect(Collectors.toMap(dy -> dy.getLong("employee"), dy -> dy.getLong("id"), (k1, k2) -> k2));
    }

    public DynamicObject[] queryDynArrayByMIdSet(Set<Long> mIdSet, String orderBy) {
        QFilter mIdFilter = new QFilter("mid", "in", mIdSet);
        mIdFilter.and(QFilterUtil.getCurrentQf());
        mIdFilter.and(QFilterUtil.getDataStatusFilter());
        return SERVICE_HELPER.query("id, mid, boid, startdate, enddate", new QFilter[]{mIdFilter}, orderBy);
    }

    private static class Holder {
        static final EmployeeRepository INSTANCE = new EmployeeRepository();

        private Holder() {
        }
    }
}

