/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.business.domian.repository.inforevise;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class ErfiletypeRepository {
    private static final HRBaseServiceHelper SERVICE_HELPER = new HRBaseServiceHelper("hspm_erfiletype");

    private ErfiletypeRepository() {
    }

    public static ErfiletypeRepository getInstance() {
        return Holder.INSTANCE;
    }

    public Map<String, Long> getFileTypeByLabAndPosType(Collection<String> labAndPosTypes) {
        if (CollectionUtils.isEmpty(labAndPosTypes)) {
            return Maps.newHashMapWithExpectedSize((int)labAndPosTypes.size());
        }
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter filter = null;
        for (String item : labAndPosTypes) {
            String[] items = item.split("_");
            Long labTypeId = Long.valueOf(items[0]);
            Long posTypeId = Long.valueOf(items[1]);
            QFilter labTypeFilter = new QFilter("laborreltypemul.fbasedataid", "=", (Object)labTypeId);
            QFilter posTypeFilter = new QFilter("postype", "=", (Object)posTypeId);
            QFilter labAndPosTypeFilter = labTypeFilter.and(posTypeFilter);
            if (filter == null) {
                filter = labAndPosTypeFilter;
                continue;
            }
            filter.or(labAndPosTypeFilter);
        }
        DynamicObject[] dys = SERVICE_HELPER.query("id,postype_id,laborreltype_id,laborreltypemul", new QFilter[]{filter, enableFilter});
        HashMap<String, Long> result = new HashMap<String, Long>(dys.length * 3);
        for (DynamicObject dy : dys) {
            MulBasedataDynamicObjectCollection labRelTypes = (MulBasedataDynamicObjectCollection)dy.getDynamicObjectCollection("laborreltypemul");
            String postypeIdStr = dy.getString("postype_id");
            long fileTypeId = dy.getLong("id");
            labRelTypes.forEach(labRelType -> {
                String labTypeIdStr = labRelType.getString("fbasedataid.id");
                result.put(labTypeIdStr + "_" + postypeIdStr, fileTypeId);
            });
        }
        return result;
    }

    private static class Holder {
        static final ErfiletypeRepository INSTANCE = new ErfiletypeRepository();

        private Holder() {
        }
    }
}

