/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.business.domian.service.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.openservicehelper.odc.AdminOrgServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hspm.business.domian.service.ICompanyChangeService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class CompanyChangeServiceImpl
implements ICompanyChangeService {
    private static final Log LOGGER = LogFactory.getLog(CompanyChangeServiceImpl.class);
    private static volatile ICompanyChangeService INSTANCE = null;
    private static final String KEY_IS_SUCCESS = "isSuccess";
    private static final String KEY_ERROR_MSG = "errorMsg";
    private static final HRBaseServiceHelper EMPPOSORGREL_SERVICE_HELPER = new HRBaseServiceHelper("hrpi_empposorgrel");
    private static final HRBaseServiceHelper EMPORGRELALL_SERVICE_HELPER = new HRBaseServiceHelper("hrpi_emporgrelall");
    private static final HRBaseServiceHelper CMPEMP_SERVICE_HELPER = new HRBaseServiceHelper("hrpi_cmpemp");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ICompanyChangeService getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<CompanyChangeServiceImpl> clazz = CompanyChangeServiceImpl.class;
        synchronized (CompanyChangeServiceImpl.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new CompanyChangeServiceImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private CompanyChangeServiceImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> companyChangeSync(Set<Long> orgBoIdSet, Long companyId, Date effectDate) {
        LOGGER.info("CompanyChangeService.companyChangeSync start , orgBoIdSet:{}, companyId:{}, effectDate:{},", new Object[]{orgBoIdSet, companyId, effectDate});
        long start = System.currentTimeMillis();
        Map<String, Object> resultMap = this.successMap();
        try {
            DynamicObjectCollection empposDyColl = EMPPOSORGREL_SERVICE_HELPER.queryOriginalCollection("id,boid,cmpemp.id,depemp.id,adminorg.id,company.id,isprimary", new QFilter[]{new QFilter("adminorg.id", "in", orgBoIdSet), new QFilter("datastatus", "=", (Object)"1"), new QFilter("iscurrentversion", "=", (Object)"1")});
            empposDyColl.removeIf(empposDy -> Objects.equals(empposDy.getLong("company.id"), companyId));
            if (empposDyColl.isEmpty()) {
                LOGGER.info("CompanyChangeService.companyChangeSync not data update.");
                Map<String, Object> map = resultMap;
                return map;
            }
            ArrayList<Long> empposBoid = new ArrayList<Long>(empposDyColl.size());
            ArrayList<Long> depempBoid = new ArrayList<Long>(empposDyColl.size());
            ArrayList<Long> cmpempBoid = new ArrayList<Long>(empposDyColl.size());
            empposDyColl.forEach(empposDy -> {
                long boid = empposDy.getLong("boid");
                empposBoid.add(boid);
                long depempId = empposDy.getLong("depemp.id");
                depempBoid.add(depempId);
                String isprimary = empposDy.getString("isprimary");
                if (HRStringUtils.equals((String)isprimary, (String)"1")) {
                    long cmpempId = empposDy.getLong("cmpemp.id");
                    cmpempBoid.add(cmpempId);
                }
            });
            String companyName = this.adminOrgInfoQueryReturnCompanyName(companyId, effectDate);
            try (TXHandle required = TX.required();){
                try {
                    this.updateEmpposorgrel(empposBoid, companyId);
                    this.updateEmporgrelall(depempBoid, companyName);
                    this.updateCmpemp(cmpempBoid, companyId);
                }
                catch (Exception ex) {
                    required.markRollback();
                    LOGGER.error(String.format("CompanyChangeService.companyChangeSync updateError! %s", ex.getMessage()), (Throwable)ex);
                    this.setFail(resultMap, ex.getMessage());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(String.format("CompanyChangeService.companyChangeSync error! %s", e.getMessage()), (Throwable)e);
            this.setFail(resultMap, e.getMessage());
        }
        finally {
            LOGGER.info("CompanyChangeService.companyChangeSync end. time is: {} ms.", (Object)(System.currentTimeMillis() - start));
        }
        return resultMap;
    }

    private String adminOrgInfoQueryReturnCompanyName(Long companyId, Date effectDate) {
        Map companyInfoMap = AdminOrgServiceHelper.adminOrgInfoQuery((List)Lists.newArrayList((Object[])new Long[]{companyId}), (Date)effectDate);
        Map companyInfo = (Map)companyInfoMap.get(String.valueOf(companyId));
        String companyName = MapUtils.getString((Map)companyInfo, (Object)"name");
        LOGGER.info("CompanyChangeService.companyChangeSync adminOrgInfoQuery, companyId:{}, companyName:{},", (Object)companyId, (Object)companyName);
        return companyName;
    }

    private void updateEmpposorgrel(List<Long> empposBoid, Long companyId) {
        DynamicObject[] empposDyArr;
        LOGGER.info("CompanyChangeService.companyChangeSync adminOrgInfoQuery, updateEmpposorgrel empposBoid:{}", empposBoid);
        for (DynamicObject empposDy : empposDyArr = EMPPOSORGREL_SERVICE_HELPER.query("id,boid,adminorg,company", new QFilter[]{new QFilter("boid", "in", empposBoid)})) {
            empposDy.set("company", (Object)companyId);
        }
        EMPPOSORGREL_SERVICE_HELPER.update(empposDyArr);
    }

    private void updateEmporgrelall(List<Long> depempBoid, String companyName) {
        DynamicObject[] empposAllDyArr;
        LOGGER.info("CompanyChangeService.companyChangeSync updateEmporgrelall, updateEmpposorgrel depempBoid:{}", depempBoid);
        for (DynamicObject empposAllDy : empposAllDyArr = EMPORGRELALL_SERVICE_HELPER.query("id,boid,adminorg,company", new QFilter[]{new QFilter("depemp", "in", depempBoid)})) {
            empposAllDy.set("company", (Object)companyName);
        }
        EMPORGRELALL_SERVICE_HELPER.update(empposAllDyArr);
    }

    private void updateCmpemp(List<Long> cmpempBoid, Long companyId) {
        LOGGER.info("CompanyChangeService.companyChangeSync updateCmpemp, updateEmpposorgrel cmpempBoid:{}", cmpempBoid);
        if (CollectionUtils.isNotEmpty(cmpempBoid)) {
            DynamicObject[] cmpempDyArr;
            for (DynamicObject cmpempDy : cmpempDyArr = CMPEMP_SERVICE_HELPER.query("id,boid,company", new QFilter[]{new QFilter("boid", "in", cmpempBoid)})) {
                cmpempDy.set("company", (Object)companyId);
            }
            CMPEMP_SERVICE_HELPER.update(cmpempDyArr);
        }
    }

    private Map<String, Object> successMap() {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        resultMap.put(KEY_IS_SUCCESS, true);
        resultMap.put(KEY_ERROR_MSG, "");
        return resultMap;
    }

    private void setFail(Map<String, Object> resultMap, String errMsg) {
        resultMap.put(KEY_IS_SUCCESS, false);
        resultMap.put(KEY_ERROR_MSG, errMsg);
    }
}

