/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.business.domian.service.impl;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hspm.business.domian.service.HSPMServiceFactory;
import kd.hr.hspm.business.domian.service.IErmanFileService;
import kd.sdk.hr.hspm.business.repository.ErmanFileRepository;
import kd.sdk.hr.hspm.common.utils.DynamicTransformUtil;
import org.apache.commons.lang.time.StopWatch;

public class ErmanFileServiceImpl
implements IErmanFileService {
    private static final Log LOGGER = LogFactory.getLog(ErmanFileServiceImpl.class);
    private static volatile ErmanFileServiceImpl INSTANCE;
    private static final String HEADSCULPTURE = "images/pc/emotion/default_person_82_82.png";
    private static final Set<String> MODIFY_PROP_ERMANFILE;

    private ErmanFileServiceImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ErmanFileServiceImpl getInstance() {
        if (null != INSTANCE) return INSTANCE;
        Class<ErmanFileServiceImpl> clazz = ErmanFileServiceImpl.class;
        synchronized (ErmanFileServiceImpl.class) {
            if (null != INSTANCE) return INSTANCE;
            INSTANCE = new ErmanFileServiceImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    @Override
    public List<Map<String, Object>> listErmanFileInfos(List<Long> ermanFileIds) {
        LOGGER.info("getCardFields ermanFileIds {}", ermanFileIds);
        Object[] ermanDyList = ErmanFileRepository.listErmanfiles(ermanFileIds);
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(ermanDyList.length);
        if (!HRArrayUtils.isEmpty((Object[])ermanDyList)) {
            HashSet<Long> personIds = new HashSet<Long>(ermanDyList.length);
            HashMap<Long, Map<Long, Long>> orgMaps = new HashMap<Long, Map<Long, Long>>(ermanDyList.length);
            ArrayListMultimap idMapping = ArrayListMultimap.create();
            HashMap<Long, Long> depempIdMapping = new HashMap<Long, Long>(ermanDyList.length);
            HashMap<Long, Map<String, Object>> ermanIdMap = new HashMap<Long, Map<String, Object>>(ermanDyList.length);
            try {
                for (Object ermanFileDy : ermanDyList) {
                    Map<String, Object> ermanMap = this.setResultMap((DynamicObject)ermanFileDy);
                    personIds.add(ermanFileDy.getLong("person.id"));
                    Object adminOrgObj = ermanMap.get("adminorg_id");
                    long adminorgId = adminOrgObj == null ? 0L : (Long)adminOrgObj;
                    this.getOrgPersonMap(orgMaps, (DynamicObject)ermanFileDy, adminorgId);
                    idMapping.put((Object)ermanFileDy.getLong("person.id"), (Object)ermanFileDy.getLong("id"));
                    depempIdMapping.put(ermanFileDy.getLong("depemp.id"), ermanFileDy.getLong("id"));
                    ermanIdMap.put(ermanFileDy.getLong("id"), ermanMap);
                }
                LOGGER.info("getCardFields idMapping {}", (Object)idMapping);
                LOGGER.info("getCardFields depempIdMapping {}", depempIdMapping);
                this.getExtInfo(personIds, (Multimap<Long, Long>)idMapping, ermanIdMap);
                this.getExtDepempInfo(depempIdMapping, ermanIdMap);
                this.getExtOrgRelationInfo(orgMaps, ermanIdMap);
            }
            catch (Exception ex) {
                LOGGER.error("listErmanFileInfos getfileds", (Throwable)ex);
            }
            if (!ermanIdMap.isEmpty()) {
                resultList = new ArrayList(ermanIdMap.values());
            }
        }
        return resultList;
    }

    @Override
    public List<Map<String, Object>> listErmanFileRelationInfos(List<Long> ermanFileIds) {
        LOGGER.info("listErmanFileRelationInfos ermanFileIds {}", ermanFileIds);
        Object[] ermanDyList = ErmanFileRepository.listErmanDepempfiles(ermanFileIds);
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(ermanDyList.length);
        if (!HRArrayUtils.isEmpty((Object[])ermanDyList)) {
            HashMap<Long, Long> depempIdMapping = new HashMap<Long, Long>(ermanDyList.length);
            HashMap<Long, Map<Long, Long>> orgMaps = new HashMap<Long, Map<Long, Long>>(ermanDyList.length);
            HashMap<Long, Map<String, Object>> ermanIdMap = new HashMap<Long, Map<String, Object>>(ermanDyList.length);
            try {
                for (Object ermanFileDy : ermanDyList) {
                    HashMap<String, Long> ermanMap = new HashMap<String, Long>(16);
                    ermanMap.put("id", ermanFileDy.getLong("id"));
                    ermanMap.put("person_id", ermanFileDy.getLong("person.id"));
                    long adminOrgId = ermanFileDy.getLong("depemp.adminorg");
                    this.getOrgPersonMap(orgMaps, (DynamicObject)ermanFileDy, adminOrgId);
                    depempIdMapping.put(ermanFileDy.getLong("depemp.id"), ermanFileDy.getLong("id"));
                    ermanIdMap.put(ermanFileDy.getLong("id"), ermanMap);
                }
                this.getExtDepempInfo(depempIdMapping, ermanIdMap);
                this.getExtOrgRelationInfo(orgMaps, ermanIdMap);
            }
            catch (Exception ex) {
                LOGGER.error("listErmanFileRelationInfos getfileds", (Throwable)ex);
            }
            if (!ermanIdMap.isEmpty()) {
                resultList = new ArrayList(ermanIdMap.values());
            }
        }
        return resultList;
    }

    private void getOrgPersonMap(Map<Long, Map<Long, Long>> orgMaps, DynamicObject ermanFileDy, long adminOrgId) {
        Map<Long, Long> ermanPersonMapping = orgMaps.get(adminOrgId);
        if (ermanPersonMapping == null) {
            ermanPersonMapping = new HashMap<Long, Long>(16);
        }
        ermanPersonMapping.put(ermanFileDy.getLong("id"), ermanFileDy.getLong("person.id"));
        orgMaps.put(adminOrgId, ermanPersonMapping);
    }

    @Override
    public DynamicObject[] getErmanFileIdByEmporgRel(List<Map<String, Object>> importList) {
        HashSet<String> numberSet = new HashSet<String>(importList.size());
        HashSet<String> positionNumberSet = new HashSet<String>(importList.size());
        HashSet<String> stdPositionNumbersSet = new HashSet<String>(importList.size());
        HashSet<String> jobNumberSet = new HashSet<String>(importList.size());
        HashSet<String> orgNumberSet = new HashSet<String>(importList.size());
        for (Map<String, Object> param : importList) {
            numberSet.add((String)param.get("number"));
            String positionNumber = (String)param.get("position");
            String stdPositionNumber = (String)param.get("stdposition");
            String jobNumber = (String)param.get("job");
            if (!HRStringUtils.isEmpty((String)positionNumber)) {
                positionNumberSet.add(positionNumber);
            }
            if (!HRStringUtils.isEmpty((String)stdPositionNumber)) {
                stdPositionNumbersSet.add(stdPositionNumber);
            }
            if (!HRStringUtils.isEmpty((String)jobNumber)) {
                jobNumberSet.add(jobNumber);
            }
            orgNumberSet.add((String)param.get("adminorg"));
        }
        if (numberSet.isEmpty() || orgNumberSet.isEmpty()) {
            throw new KDBizException(" param error.");
        }
        return ErmanFileRepository.getErmanFileIdByEmporgRel(numberSet, orgNumberSet, positionNumberSet, stdPositionNumbersSet, jobNumberSet);
    }

    @Override
    public DynamicObject[] getAllErmanFileIdByEmporgRel(List<Map<String, Object>> importList) {
        HashSet<String> numberSet = new HashSet<String>(importList.size());
        HashSet<String> positionNumberSet = new HashSet<String>(importList.size());
        HashSet<String> stdPositionNumbersSet = new HashSet<String>(importList.size());
        HashSet<String> jobNumberSet = new HashSet<String>(importList.size());
        HashSet<String> orgNumberSet = new HashSet<String>(importList.size());
        for (Map<String, Object> param : importList) {
            numberSet.add((String)param.get("number"));
            String positionNumber = (String)param.get("position");
            String stdPositionNumber = (String)param.get("stdposition");
            String jobNumber = (String)param.get("job");
            if (!HRStringUtils.isEmpty((String)positionNumber)) {
                positionNumberSet.add(positionNumber);
            }
            if (!HRStringUtils.isEmpty((String)stdPositionNumber)) {
                stdPositionNumbersSet.add(stdPositionNumber);
            }
            if (!HRStringUtils.isEmpty((String)jobNumber)) {
                jobNumberSet.add(jobNumber);
            }
            orgNumberSet.add((String)param.get("adminorg"));
        }
        if (numberSet.isEmpty() || orgNumberSet.isEmpty()) {
            throw new KDBizException(" param error.");
        }
        return ErmanFileRepository.getAllErmanFileIdByEmporgRel(numberSet, orgNumberSet, positionNumberSet, stdPositionNumbersSet, jobNumberSet);
    }

    @Override
    public Map<String, Object> hisVersionChange(Map<Long, Map<String, Object>> fileList) {
        Set<Long> boIdList = fileList.keySet();
        DynamicObject[] erManFiles = ErmanFileRepository.loadOriginalErmanfiles(boIdList);
        Map<Long, DynamicObject> fileMap = Arrays.stream(erManFiles).collect(Collectors.toMap(dy -> (Long)dy.get("id"), dy -> dy, (dy1, dy2) -> dy1));
        MainEntityType erManFileType = EntityMetadataCache.getDataEntityType((String)"hspm_ermanfile");
        DynamicObjectCollection erManFileList = new DynamicObjectCollection((DynamicObjectType)erManFileType, null);
        long[] ids = ORM.create().genLongIds("hspm_ermanfile", fileList.size());
        int i = 0;
        ArrayList errorMsg = Lists.newArrayListWithExpectedSize((int)fileList.size());
        for (Map.Entry<Long, Map<String, Object>> file : fileList.entrySet()) {
            Long boId = (Long)file.getValue().get("boId");
            DynamicObject oldFile = fileMap.get(boId);
            if (!this.validateFile(errorMsg, file.getValue(), oldFile, boId)) continue;
            DynamicObject newFile = ErmanFileRepository.generateDynamic();
            HRDynamicObjectUtils.copy((DynamicObject)oldFile, (DynamicObject)newFile);
            for (Map.Entry<String, Object> value : file.getValue().entrySet()) {
                if (!MODIFY_PROP_ERMANFILE.contains(value.getKey())) continue;
                DynamicTransformUtil.setLocalProp((MainEntityType)erManFileType, (DynamicObject)newFile, value);
            }
            newFile.set("id", (Object)ids[i]);
            erManFileList.add((Object)newFile);
            ++i;
        }
        Map<String, Object> result = HSPMServiceFactory.outService.saveBatch(false, erManFileList);
        this.wrapResult(result, errorMsg);
        return result;
    }

    private boolean validateFile(List<Map<String, Object>> errorMsg, Map<String, Object> oldFile, DynamicObject newFile, Long boId) {
        boolean flag = true;
        if (newFile == null) {
            HashMap<String, Object> msg = new HashMap<String, Object>(16);
            msg.put("id", boId);
            msg.put("errMsg", ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u6ca1\u6709\u6b64\u6863\u6848ID\u3002", (String)"ErmanFileServiceImpl_0", (String)"hr-hspm-business", (Object[])new Object[0]));
            errorMsg.add(msg);
            flag = false;
        }
        return flag;
    }

    private void wrapResult(Map<String, Object> result, List<Map<String, Object>> errorMsg) {
        Object errInfos = result.get("errInfos");
        List errorDatas = errInfos != null ? (List)((Map)((List)errInfos).get(0)).get("errorDatas") : new ArrayList();
        if (!CollectionUtils.isEmpty(errorMsg)) {
            result.put("success", false);
            result.put("message", "fail");
            errorDatas.addAll(errorMsg);
        }
        result.put("errInfos", errorDatas);
    }

    private void getExtInfo(Set<Long> personIds, Multimap<Long, Long> idMapping, Map<Long, Map<String, Object>> ermanIdMap) {
        if (!personIds.isEmpty()) {
            List locationList;
            QFilter creQFilter;
            List percreList;
            List percontactList = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"listBatchPersonAttachs", (Object[])new Object[]{new ArrayList<Long>(personIds), null, "hrpi_percontact"});
            if (null != percontactList && percontactList.size() > 0) {
                LOGGER.info("getCardFields percontactList {}", (Object)percontactList.size());
                for (Map perContract : percontactList) {
                    long personId = (Long)perContract.get("person_id");
                    Collection ermanIds = idMapping.get((Object)personId);
                    ermanIds.forEach(id -> {
                        Map tmpMapInfo = (Map)ermanIdMap.get(id);
                        tmpMapInfo.put("phone", perContract.get("phone"));
                        tmpMapInfo.put("peremail", perContract.get("peremail"));
                    });
                }
            }
            if (null != (percreList = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"listBatchPersonAttachs", (Object[])new Object[]{new ArrayList<Long>(personIds), creQFilter = new QFilter("ismajor", "=", (Object)"1"), "hrpi_percre"})) && percreList.size() > 0) {
                LOGGER.info("getCardFields percreList {}", (Object)percreList.size());
                for (Map percre : percreList) {
                    long personId = (Long)percre.get("person_id");
                    Collection ermanIds = idMapping.get((Object)personId);
                    ermanIds.forEach(id -> {
                        Map tmpMapInfo = (Map)ermanIdMap.get(id);
                        tmpMapInfo.put("credentialstype", percre.get("credentialstype"));
                        tmpMapInfo.put("credentialstype_id", percre.get("credentialstype_id"));
                        tmpMapInfo.put("identitynumber", percre.get("number"));
                    });
                }
            }
            if (null != (locationList = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIEmployeeService", (String)"listBatchEmployeeByPerson", (Object[])new Object[]{new ArrayList<Long>(personIds), null, "hrpi_baselocation"})) && locationList.size() > 0) {
                for (Map location : locationList) {
                    long personId = (Long)location.get("person_id");
                    Collection ermanIds = idMapping.get((Object)personId);
                    ermanIds.forEach(id -> {
                        Map tmpMapInfo = (Map)ermanIdMap.get(id);
                        tmpMapInfo.put("baselocation", location.get("id"));
                    });
                }
            }
        }
    }

    private void getExtDepempInfo(Map<Long, Long> depempIdMapping, Map<Long, Map<String, Object>> ermanIdMap) {
        Map superiorInfo = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIWorkRoleService", (String)"getDirectSuperiorByDepempId", (Object[])new Object[]{new ArrayList<Long>(depempIdMapping.keySet())});
        if (!superiorInfo.isEmpty()) {
            for (Map.Entry superior : superiorInfo.entrySet()) {
                Long depempId = (Long)superior.getKey();
                Long ermanId = depempIdMapping.get(depempId);
                List value = (List)superior.getValue();
                ArrayList tmpList = new ArrayList(value.size());
                HashSet superiorPersonSet = new HashSet(value.size());
                value.forEach(sup -> {
                    Long personId = (Long)sup.get("person.id");
                    if (superiorPersonSet.add(personId)) {
                        HashMap<String, Long> simpleMap = new HashMap<String, Long>(16);
                        simpleMap.put("id", personId);
                        simpleMap.put("name", (Long)sup.get("superior.name"));
                        simpleMap.put("number", (Long)sup.get("superior.number"));
                        simpleMap.put("headsculpture", (Long)sup.get("superior.headsculpture"));
                        simpleMap.put("postype", (Long)sup.get("postype"));
                        simpleMap.put("position", (Long)sup.get("position"));
                        simpleMap.put("adminorg.name", (Long)sup.get("superioradminorg.name"));
                        simpleMap.put("depemp", (Long)sup.get("depemp.id"));
                        tmpList.add(simpleMap);
                    }
                });
                Map<String, Object> tmpMapInfo = ermanIdMap.get(ermanId);
                tmpMapInfo.put("superiorinfo", tmpList);
            }
        }
    }

    private void putValues(List<Map<String, Object>> list, Multimap<Long, Long> idMapping, String ermanKey, String mapkey, Map<Long, Map<String, Object>> ermanIdMap) {
    }

    private void getExtOrgRelationInfo(Map<Long, Map<Long, Long>> orgMaps, Map<Long, Map<String, Object>> ermanIdMap) {
        if (!orgMaps.isEmpty()) {
            LOGGER.info("getExtOrgRelationInfo IHRPIChargeService orgMaps:{}", orgMaps.keySet());
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            Map result = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIChargeService", (String)"queryChargeWithParentByOrgId", (Object[])new Object[]{new ArrayList<Long>(orgMaps.keySet()), new Date()});
            stopWatch.stop();
            for (Map.Entry entry : result.entrySet()) {
                Long orgId = (Long)entry.getKey();
                List entryValue = (List)entry.getValue();
                if (entryValue == null) {
                    LOGGER.info("getExtOrgRelationInfo queryChargeWithParentByOrgId Empty,orgId:{}", (Object)orgId);
                    continue;
                }
                List currentCollect = entryValue.stream().filter(map -> map.containsKey("person") && map.containsKey("adminorg")).collect(Collectors.toList());
                if (currentCollect == null || currentCollect.size() == 0) {
                    LOGGER.info("getExtOrgRelationInfo queryChargeWithParentByOrgId currentCollect is null,orgId:{}", (Object)orgId);
                    continue;
                }
                for (Map map2 : entryValue) {
                    map2.put("id", map2.get("person"));
                }
                Set person = currentCollect.stream().map(map -> (Long)map.get("person")).collect(Collectors.toSet());
                List<Object> chargeResultList = new ArrayList();
                Map<Long, Long> ermanPersonMap = orgMaps.get(orgId);
                if (ermanPersonMap == null) {
                    LOGGER.info("getExtOrgRelationInfo queryChargeWithParentByOrgId orgMaps null,orgId:{}", (Object)orgId);
                    continue;
                }
                for (Map.Entry<Long, Long> ermanfile : ermanPersonMap.entrySet()) {
                    Map<String, Object> tmpMapInfo = ermanIdMap.get(ermanfile.getKey());
                    Long ermanfileValue = ermanfile.getValue();
                    if (person.contains(ermanfileValue)) {
                        LOGGER.info("getExtOrgRelationInfo contains currentPersonId :{}", (Object)ermanfileValue);
                        Long parentOrg = (Long)((Map)entryValue.get(0)).get("parentorg");
                        if (parentOrg != null && result.get(parentOrg) != null) {
                            chargeResultList = ((List)result.get(parentOrg)).stream().filter(map -> map.containsKey("person") && map.containsKey("adminorg")).collect(Collectors.toList());
                        }
                    } else {
                        chargeResultList = currentCollect;
                        LOGGER.info("getExtOrgRelationInfo not contains currentPersonId personId,ermanId,resultSize:{},{},{}", new Object[]{ermanfile.getValue(), ermanfile.getKey(), chargeResultList.size()});
                    }
                    tmpMapInfo.put("chargeinfo", chargeResultList);
                }
            }
        }
    }

    private Map<String, Object> setResultMap(DynamicObject ermanFileDy) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("id", ermanFileDy.getLong("id"));
        map.put("name", ermanFileDy.getString("name"));
        map.put("number", ermanFileDy.getString("number"));
        String headPicture = ermanFileDy.getString("person.headsculpture");
        map.put("headsculpture", HRStringUtils.isEmpty((String)headPicture) ? HEADSCULPTURE : headPicture);
        map.put("entservicelen", ermanFileDy.getBigDecimal("pernontsprop.entservicelen"));
        this.setBaseData("gender", ermanFileDy.getDynamicObject("pernontsprop.gender"), map);
        this.setBaseData("nationality", ermanFileDy.getDynamicObject("pernontsprop.nationality"), map);
        this.setBaseData("laborrelstatus", ermanFileDy.getDynamicObject("empentrel.laborrelstatus"), map);
        this.setBaseData("laborreltype", ermanFileDy.getDynamicObject("empentrel.laborreltype"), map);
        this.setBaseData("enterprise", ermanFileDy.getDynamicObject("empentrel.enterprise"), map);
        map.put("startdate", ermanFileDy.getDate("empentrel.startdate"));
        map.put("enddate", ermanFileDy.getDate("empentrel.enddate"));
        map.put("filestartdate", ermanFileDy.getDate("startdate"));
        map.put("fileenddate", ermanFileDy.getDate("enddate"));
        this.setBaseData("adminorg", ermanFileDy.getDynamicObject("empposrel.adminorg"), map);
        this.setBaseData("position", ermanFileDy.getDynamicObject("empposrel.position"), map);
        this.setBaseData("stdposition", ermanFileDy.getDynamicObject("empposrel.stdposition"), map);
        map.put("darkposition_id", ermanFileDy.getLong("empposrel.darkposition.id"));
        this.setBaseData("job", ermanFileDy.getDynamicObject("empposrel.job"), map);
        map.put("isprimary", ermanFileDy.getBoolean("empposrel.isprimary"));
        this.setBaseData("posstatus", ermanFileDy.getDynamicObject("empposrel.posstatus"), map);
        this.setBaseData("postype", ermanFileDy.getDynamicObject("empposrel.postype"), map);
        this.setBaseData("location", ermanFileDy.getDynamicObject("empposrel.workplace"), map);
        this.setBaseData("company", ermanFileDy.getDynamicObject("empposrel.company"), map);
        this.setBaseData("managingscope", ermanFileDy.getDynamicObject("cmpemp.managingscope"), map);
        this.getPostionType(ermanFileDy.getString("empposrel.apositiontype"), map);
        this.getLocationCountry(ermanFileDy.getDynamicObject("empposrel.workplace"), map);
        this.setBaseData("org", ermanFileDy.getDynamicObject("org"), map);
        this.setBaseData("affiliateadminorg", ermanFileDy.getDynamicObject("affiliateadminorg"), map);
        this.setBaseData("empgroup", ermanFileDy.getDynamicObject("empgroup"), map);
        map.put("ismanaged", ermanFileDy.getBoolean("ismanaged"));
        this.setBaseData("dependency", ermanFileDy.getDynamicObject("dependency"), map);
        this.setBaseData("dependencytype", ermanFileDy.getDynamicObject("dependencytype"), map);
        this.setBaseData("filetype", ermanFileDy.getDynamicObject("filetype"), map);
        map.put("businessstatus", ermanFileDy.getString("businessstatus"));
        map.put("person_id", ermanFileDy.getLong("person.id"));
        map.put("depemp_id", ermanFileDy.getLong("depemp.id"));
        map.put("cmpemp_id", ermanFileDy.getLong("cmpemp.id"));
        map.put("employee_id", ermanFileDy.getLong("employee.id"));
        return map;
    }

    private void getPostionType(String positionType, Map<String, Object> map) {
        String positionDesc = "";
        if ("1".equals(positionType)) {
            positionDesc = (String)map.get("position");
        }
        if ("0".equals(positionType)) {
            positionDesc = (String)map.get("stdposition");
        }
        if ("2".equals(positionType)) {
            positionDesc = (String)map.get("job");
        }
        map.put("apositiontype", positionType);
        map.put("apositiontypedesc", positionDesc);
    }

    private void getLocationCountry(DynamicObject workPlaceDy, Map<String, Object> map) {
        if (null != workPlaceDy) {
            long workPlaceId = workPlaceDy.getLong("id");
            QFilter qf = new QFilter("id", "=", (Object)workPlaceId);
            Map entityCfMap = BusinessDataServiceHelper.loadFromCache((String)"hbss_workplace", (String)"country.id,country.name,country.number", (QFilter[])new QFilter[]{qf});
            if (!CollectionUtils.isEmpty((Map)entityCfMap)) {
                map.put("location_country", ((DynamicObject)entityCfMap.values().stream().findFirst().get()).getLocaleString("country.name").getLocaleValue());
                map.put("location_country_id", ((DynamicObject)entityCfMap.values().stream().findFirst().get()).get("country.id"));
                map.put("location_country_number", ((DynamicObject)entityCfMap.values().stream().findFirst().get()).get("country.number"));
            }
        }
    }

    private void setBaseData(String mapKey, DynamicObject baseData, Map<String, Object> map) {
        if (null != baseData) {
            DataEntityPropertyCollection properties = baseData.getDataEntityType().getProperties();
            if (null != properties.get((Object)"name")) {
                Object name = baseData.get("name");
                if (name instanceof ILocaleString) {
                    String localeValue = ((ILocaleString)name).getLocaleValue();
                    if (HRStringUtils.isEmpty((String)localeValue)) {
                        localeValue = ((ILocaleString)name).getLocaleValue_zh_CN();
                    }
                    map.put(mapKey, localeValue);
                } else {
                    map.put(mapKey, baseData.getString("name"));
                }
            }
            if (null != properties.get((Object)"number")) {
                map.put(mapKey + "_number", baseData.getString("number"));
            }
            map.put(mapKey + "_id", baseData.getLong("id"));
        }
    }

    static {
        MODIFY_PROP_ERMANFILE = new HashSet<String>(Arrays.asList("description", "startdate", "enddate", "sysenddate", "affiliateadminorg", "empgroup", "ismanaged", "dependency", "dependencytype", "filetype", "businessstatus", "org"));
    }
}

