/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.business.domian.service.impl.infoclassify;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hspm.business.domian.repository.infoclassify.PerprotitleRepository;
import kd.hr.hspm.business.domian.service.infoclassify.IPerprotitleService;
import kd.sdk.hr.hspm.business.helper.HpfsChgexternalrecordQueueHelper;
import kd.sdk.hr.hspm.common.dto.InfoClassifyEntityKeyDTO;
import kd.sdk.hr.hspm.common.result.HrpiServiceOperateResult;

public class PerprotitleServiceImpl
implements IPerprotitleService {
    private static final Log LOGGER = LogFactory.getLog(PerprotitleServiceImpl.class);
    private final PerprotitleRepository perprotitleRepository = PerprotitleRepository.getInstance();

    @Override
    public DynamicObject getPerprotitleByPkId(Long pkId) {
        return this.perprotitleRepository.getPerprotitle(pkId, "");
    }

    @Override
    public HrpiServiceOperateResult insertPerprotitle(DynamicObject dataEntity) {
        InfoClassifyEntityKeyDTO infoClassifyEntityKeyDTO = InfoClassifyEntityKeyDTO.getEntityKeyEnumByFormKey((String)"hspm_perprotitle");
        HashMap<String, DynamicObjectCollection> paramMap = new HashMap<String, DynamicObjectCollection>(16);
        paramMap.put(infoClassifyEntityKeyDTO.getSourceKey(), this.perprotitleRepository.getInvokeSaveByPerprotitle(dataEntity));
        Map resultMap = attacheHandlerService.invokeSaveOrUpdate(paramMap);
        HrpiServiceOperateResult operateResult = HrpiServiceOperateResult.build((Map)resultMap);
        if (operateResult.isSuccess()) {
            Long pkId = (Long)operateResult.getDataMapForIds().get(0);
            dataEntity.set("id", (Object)pkId);
            LOGGER.info(String.format(Locale.ROOT, "insertPerprotitle the id is %s.", pkId));
            HpfsChgexternalrecordQueueHelper.sendHisNonLineInsertMsg((DynamicObject)dataEntity, (String)infoClassifyEntityKeyDTO.getSourceKey(), (String)infoClassifyEntityKeyDTO.getFormKey());
        }
        return operateResult;
    }

    @Override
    public HrpiServiceOperateResult updatePerprotitle(Long pkId, DynamicObject dataEntity) {
        InfoClassifyEntityKeyDTO infoClassifyEntityKeyDTO = InfoClassifyEntityKeyDTO.getEntityKeyEnumByFormKey((String)"hspm_perprotitle");
        HashMap<String, DynamicObjectCollection> paramMap = new HashMap<String, DynamicObjectCollection>(16);
        paramMap.put(infoClassifyEntityKeyDTO.getSourceKey(), this.perprotitleRepository.getInvokeUpdateByPerprotitle(pkId, dataEntity));
        Map resultMap = attacheHandlerService.invokeSaveOrUpdate(paramMap);
        HrpiServiceOperateResult operateResult = HrpiServiceOperateResult.build((Map)resultMap);
        if (operateResult.isSuccess()) {
            LOGGER.info(String.format(Locale.ROOT, "updatePerprotitle the id is %s.", pkId));
            HpfsChgexternalrecordQueueHelper.sendHisNonLineUpdateMsg((DynamicObject)dataEntity, (String)infoClassifyEntityKeyDTO.getSourceKey(), (String)infoClassifyEntityKeyDTO.getFormKey());
        }
        return operateResult;
    }

    @Override
    public HrpiServiceOperateResult deletePerprotitle(List<Long> pkIdList) {
        InfoClassifyEntityKeyDTO infoClassifyEntityKeyDTO = InfoClassifyEntityKeyDTO.getEntityKeyEnumByFormKey((String)"hspm_perprotitle");
        DynamicObject[] dbDyArr = this.perprotitleRepository.queryHrpiPerprotitleForPerChg(pkIdList);
        Map resultMap = attacheHandlerService.invokeDel(pkIdList, infoClassifyEntityKeyDTO.getSourceKey(), Boolean.TRUE);
        HrpiServiceOperateResult.validate((Map)resultMap);
        HrpiServiceOperateResult operateResult = HrpiServiceOperateResult.build((Map)resultMap);
        if (operateResult.isSuccess()) {
            LOGGER.info(String.format(Locale.ROOT, "deletePerprotitle the id is %s.", pkIdList));
            HpfsChgexternalrecordQueueHelper.sendBatchHisNonLineDeleteMsg((DynamicObject[])dbDyArr, (String)infoClassifyEntityKeyDTO.getSourceKey(), (String)infoClassifyEntityKeyDTO.getFormKey());
        }
        return operateResult;
    }

    @Override
    public HrpiServiceOperateResult saveImportPerprotitle(String importtype, DynamicObject[] dataEntities) {
        InfoClassifyEntityKeyDTO infoClassifyEntityKeyDTO = InfoClassifyEntityKeyDTO.getEntityKeyEnumByFormKey((String)"hspm_perprotitle");
        DynamicObject[] importSaveDys = this.perprotitleRepository.getImportSaveByPerprotitle(dataEntities);
        Map resultMap = attacheHandlerService.invokeHisNonLineImportData(importtype, importSaveDys);
        HrpiServiceOperateResult operateResult = HrpiServiceOperateResult.build((Map)resultMap);
        if (operateResult.isSuccess()) {
            LOGGER.info(String.format(Locale.ROOT, "saveImportPerprotitle the id is %s.", operateResult.getDataMapForIds()));
            HpfsChgexternalrecordQueueHelper.sendBatchHisNonLineInsertMsg((DynamicObject[])dataEntities, (String)infoClassifyEntityKeyDTO.getSourceKey(), (String)infoClassifyEntityKeyDTO.getFormKey());
        }
        return operateResult;
    }

    @Override
    public List<Long> queryExistsIdByPkIdList(List<Long> pkIdList) {
        DynamicObject[] existsPkIdArr = this.perprotitleRepository.queryByPkIdList(pkIdList);
        if (existsPkIdArr.length > 0) {
            return Arrays.stream(existsPkIdArr).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        }
        return new ArrayList<Long>();
    }
}

