/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.business.domian.service.impl.infoclassify;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hspm.business.domian.repository.infoclassify.PersoninfoRepository;
import kd.hr.hspm.business.domian.service.infoclassify.IPersoninfoService;
import kd.sdk.hr.hspm.business.helper.HpfsChgexternalrecordQueueHelper;
import kd.sdk.hr.hspm.business.service.AttacheHandlerService;
import kd.sdk.hr.hspm.common.enums.PersoninfoFieldEnum;
import kd.sdk.hr.hspm.common.result.HrpiServiceOperateResult;

public class PersoninfoServiceImpl
implements IPersoninfoService {
    private static final Log LOGGER = LogFactory.getLog(PersoninfoServiceImpl.class);
    protected final AttacheHandlerService attacheHandlerService = AttacheHandlerService.getInstance();
    private final PersoninfoRepository personinfoRepository = PersoninfoRepository.getInstance();
    private final PersoninfoFieldEnum hrpiPernontspropEnum = PersoninfoFieldEnum.HRPI_PERNONTSPROP;
    private final PersoninfoFieldEnum hrpiPertspropEnum = PersoninfoFieldEnum.HRPI_PERTSPROP;
    private final PersoninfoFieldEnum hrpiPerregionEnum = PersoninfoFieldEnum.HRPI_PERREGION;
    private final PersoninfoFieldEnum hrpiPersonEnum = PersoninfoFieldEnum.HRPI_PERSON;
    private final PersoninfoFieldEnum hspmErmanfileEnum = PersoninfoFieldEnum.HSPM_ERMANFILE;
    private final PersoninfoFieldEnum perserlenEnum = PersoninfoFieldEnum.HRPI_PERSERLEN;

    @Override
    public DynamicObject getPersoninfo(Long pernontspropId) {
        DynamicObject personinfoDy = this.personinfoRepository.getPersoninfo(pernontspropId, "");
        long personId = personinfoDy.getLong("person.id");
        DataEntityPropertyCollection mainProperties = personinfoDy.getDynamicObjectType().getProperties();
        DynamicObject pertspropDy = this.personinfoRepository.getPertspropByPersonid(personId);
        this.setPersoninfoPropertyValue(personinfoDy, mainProperties, pertspropDy);
        DynamicObject perregionDy = this.personinfoRepository.getPerrrgionByPersonid(personId);
        this.setPersoninfoPropertyValue(personinfoDy, mainProperties, perregionDy);
        DynamicObject personDy = this.personinfoRepository.getPersonById(personId);
        this.setPersoninfoPropertyValue(personinfoDy, mainProperties, personDy);
        return personinfoDy;
    }

    private void setPersoninfoPropertyValue(DynamicObject personinfoDy, DataEntityPropertyCollection mainProperties, DynamicObject relateDy) {
        if (!HRObjectUtils.isEmpty((Object)relateDy)) {
            for (IDataEntityProperty property : relateDy.getDynamicObjectType().getProperties()) {
                String propName = property.getName();
                if (!mainProperties.containsKey((Object)propName) || HRStringUtils.equals((String)propName, (String)"multilanguagetext")) continue;
                personinfoDy.set(propName, relateDy.get(propName));
            }
        }
    }

    @Override
    public HrpiServiceOperateResult updatePersoninfo(Long pkId, DynamicObject dataEntity, Map<String, Boolean> checkChangedMap) {
        HashMap<Long, DynamicObject> ermanFileDbMap = new HashMap<Long, DynamicObject>(16);
        Map<String, DynamicObjectCollection> paramMap = this.getInvokeSaveOrUpdateParamMap(dataEntity, checkChangedMap, pkId, ermanFileDbMap);
        long personId = dataEntity.getLong("person.id");
        boolean syncFlag = this.attacheHandlerService.validateSyncFieldsUpdateChange(paramMap, personId, true);
        DynamicObject hrpiPertspropDy = this.getHrpiPertspropDyWithCheckChanged(checkChangedMap, personId);
        Map resultMap = this.attacheHandlerService.invokeSaveOrUpdate(paramMap);
        HrpiServiceOperateResult operateResult = HrpiServiceOperateResult.build((Map)resultMap);
        if (operateResult.isSuccess()) {
            LOGGER.info(String.format(Locale.ROOT, "updatePersoninfo the id is %s.", pkId));
            HpfsChgexternalrecordQueueHelper.sendCustomerHisNonLineUpdateMsgByPersoninfo((long)personId, paramMap, (DynamicObject)hrpiPertspropDy, ermanFileDbMap, (HrpiServiceOperateResult)operateResult);
            operateResult.setSyncFlag(syncFlag);
        }
        return operateResult;
    }

    @Override
    public HrpiServiceOperateResult saveImportPersoninfo(String importtype, DynamicObject dataEntity, Map<String, Boolean> checkChangedMap, Long eventId) {
        HashMap<Long, DynamicObject> ermanFileDbMap = new HashMap<Long, DynamicObject>(16);
        Long pkId = (Long)dataEntity.getPkValue();
        Map<String, DynamicObjectCollection> paramMap = this.getInvokeSaveOrUpdateParamMap(dataEntity, checkChangedMap, pkId, ermanFileDbMap);
        long personId = dataEntity.getLong("person.id");
        boolean syncFlag = this.attacheHandlerService.validateSyncFieldsUpdateChange(paramMap, personId, true);
        DynamicObject hrpiPertspropDy = this.getHrpiPertspropDyWithCheckChanged(checkChangedMap, personId);
        Map resultMap = this.attacheHandlerService.invokeHisImportDataByBatchEventid(paramMap, eventId.longValue());
        HrpiServiceOperateResult operateResult = HrpiServiceOperateResult.build((Map)resultMap);
        if (operateResult.isSuccess()) {
            LOGGER.info(String.format(Locale.ROOT, "updatePersoninfo the id is %s.", pkId));
            HpfsChgexternalrecordQueueHelper.sendCustomerHisNonLineUpdateMsgByPersoninfo((long)personId, paramMap, (DynamicObject)hrpiPertspropDy, ermanFileDbMap, (HrpiServiceOperateResult)operateResult);
            operateResult.setSyncFlag(syncFlag);
        }
        return operateResult;
    }

    private DynamicObject getHrpiPertspropDyWithCheckChanged(Map<String, Boolean> checkChangedMap, long personId) {
        DynamicObject hrpiPertspropDy = null;
        if (checkChangedMap.get(this.hrpiPertspropEnum.getFormKey()).booleanValue()) {
            hrpiPertspropDy = this.personinfoRepository.getPertspropByPersonid(personId, null);
        }
        return hrpiPertspropDy;
    }

    private Map<String, DynamicObjectCollection> getInvokeSaveOrUpdateParamMap(DynamicObject dataEntity, Map<String, Boolean> checkChangedMap, Long pkId, Map<Long, DynamicObject> ermanFileDbMap) {
        DynamicObjectCollection dys;
        HashMap<String, DynamicObjectCollection> paramMap = new HashMap<String, DynamicObjectCollection>(16);
        DynamicObject personinfoDy = this.personinfoRepository.getPersoninfo(pkId, "");
        long personId = personinfoDy.getLong("person.id");
        if (checkChangedMap.get(this.hrpiPernontspropEnum.getFormKey()).booleanValue()) {
            paramMap.put(this.hrpiPernontspropEnum.getFormKey(), this.personinfoRepository.getInvokeSaveOrUpdateByPernonsprop(pkId, dataEntity));
        }
        if (checkChangedMap.get(this.hrpiPertspropEnum.getFormKey()).booleanValue()) {
            paramMap.put(this.hrpiPertspropEnum.getFormKey(), this.personinfoRepository.getInvokeSaveOrUpdateByPertsprop(personId, dataEntity));
        }
        if (checkChangedMap.get(this.hrpiPerregionEnum.getFormKey()).booleanValue()) {
            paramMap.put(this.hrpiPerregionEnum.getFormKey(), this.personinfoRepository.getInvokeSaveOrUpdateByPerregion(personId, dataEntity));
        }
        if (checkChangedMap.get(this.hrpiPersonEnum.getFormKey()).booleanValue()) {
            paramMap.put(this.hrpiPersonEnum.getFormKey(), this.personinfoRepository.getInvokeSaveOrUpdateByPerson(personId, dataEntity));
        }
        if (checkChangedMap.get(this.hspmErmanfileEnum.getFormKey()).booleanValue()) {
            paramMap.put(this.hspmErmanfileEnum.getFormKey(), this.personinfoRepository.getInvokeSaveOrUpdateByErmanfile(personId, dataEntity, ermanFileDbMap));
        }
        if (Optional.ofNullable(checkChangedMap.get(this.perserlenEnum.getFormKey())).orElse(false).booleanValue() && (dys = this.personinfoRepository.getInvokeSaveOrUpdateByPerSerLen(personId, dataEntity)).size() > 0) {
            this.updatePernontsProp(paramMap, dys);
            paramMap.put(this.perserlenEnum.getFormKey(), dys);
        }
        return paramMap;
    }

    private void updatePernontsProp(Map<String, DynamicObjectCollection> paramMap, DynamicObjectCollection dys) {
        DynamicObjectCollection collection = paramMap.get(this.hrpiPernontspropEnum.getFormKey());
        if (collection != null && collection.size() > 0) {
            ((DynamicObject)collection.get(0)).set("servicelen", (Object)((DynamicObject)dys.get(0)).getBigDecimal("workyear"));
        }
    }

    @Override
    public List<Long> queryExistsIdByPkIdList(List<Long> pkIdList) {
        DynamicObject[] existsPkIdArr = this.personinfoRepository.queryByPkIdList(pkIdList);
        if (existsPkIdArr.length > 0) {
            return Arrays.stream(existsPkIdArr).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        }
        return new ArrayList<Long>();
    }

    @Override
    public String getNameByPersonId(Long personId) {
        DynamicObject person = this.personinfoRepository.getPersonById(personId, "name");
        return person.getString("name");
    }
}

