/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.business.domian.service.impl.infoclassify;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hspm.business.domian.repository.infoclassify.RsmprosklRepository;
import kd.hr.hspm.business.domian.service.infoclassify.IRsmprosklService;
import kd.sdk.hr.hspm.business.helper.HpfsChgexternalrecordQueueHelper;
import kd.sdk.hr.hspm.business.service.AttacheHandlerService;
import kd.sdk.hr.hspm.common.dto.InfoClassifyEntityKeyDTO;
import kd.sdk.hr.hspm.common.result.HrpiServiceOperateResult;

public class RsmprosklServiceImpl
implements IRsmprosklService {
    private static final Log LOGGER = LogFactory.getLog(RsmprosklServiceImpl.class);
    protected final AttacheHandlerService attacheHandlerService = AttacheHandlerService.getInstance();
    private final RsmprosklRepository rsmprosklRepository = RsmprosklRepository.getInstance();

    @Override
    public DynamicObject getRsmprosklByPkId(Long pkId) {
        return this.rsmprosklRepository.getRsmproskl(pkId, "");
    }

    @Override
    public HrpiServiceOperateResult insertRsmproskl(DynamicObject dataEntity) {
        InfoClassifyEntityKeyDTO infoClassifyEntityKeyDTO = InfoClassifyEntityKeyDTO.getEntityKeyEnumByFormKey((String)"hspm_rsmproskl");
        HashMap<String, DynamicObjectCollection> paramMap = new HashMap<String, DynamicObjectCollection>(16);
        paramMap.put(infoClassifyEntityKeyDTO.getSourceKey(), this.rsmprosklRepository.getInvokeSaveByRsmproskl(dataEntity));
        Map resultMap = this.attacheHandlerService.invokeSaveOrUpdate(paramMap);
        HrpiServiceOperateResult operateResult = HrpiServiceOperateResult.build((Map)resultMap);
        if (operateResult.isSuccess()) {
            Long pkId = (Long)operateResult.getDataMapForIds().get(0);
            dataEntity.set("id", (Object)pkId);
            LOGGER.info(String.format(Locale.ROOT, "insertRsmproskl the id is %s.", pkId));
            HpfsChgexternalrecordQueueHelper.sendHisNonLineInsertMsg((DynamicObject)dataEntity, (String)infoClassifyEntityKeyDTO.getSourceKey(), (String)infoClassifyEntityKeyDTO.getFormKey());
        }
        return operateResult;
    }

    @Override
    public HrpiServiceOperateResult updateRsmproskl(Long pkId, DynamicObject dataEntity) {
        InfoClassifyEntityKeyDTO infoClassifyEntityKeyDTO = InfoClassifyEntityKeyDTO.getEntityKeyEnumByFormKey((String)"hspm_rsmproskl");
        HashMap<String, DynamicObjectCollection> paramMap = new HashMap<String, DynamicObjectCollection>(16);
        paramMap.put(infoClassifyEntityKeyDTO.getSourceKey(), this.rsmprosklRepository.getInvokeUpdateByRsmproskl(pkId, dataEntity));
        Map resultMap = this.attacheHandlerService.invokeSaveOrUpdate(paramMap);
        HrpiServiceOperateResult operateResult = HrpiServiceOperateResult.build((Map)resultMap);
        if (operateResult.isSuccess()) {
            LOGGER.info(String.format(Locale.ROOT, "updateRsmproskl the id is %s.", pkId));
            HpfsChgexternalrecordQueueHelper.sendHisNonLineUpdateMsg((DynamicObject)dataEntity, (String)infoClassifyEntityKeyDTO.getSourceKey(), (String)infoClassifyEntityKeyDTO.getFormKey());
        }
        return operateResult;
    }

    @Override
    public HrpiServiceOperateResult deleteRsmproskl(List<Long> pkIdList) {
        InfoClassifyEntityKeyDTO infoClassifyEntityKeyDTO = InfoClassifyEntityKeyDTO.getEntityKeyEnumByFormKey((String)"hspm_rsmproskl");
        DynamicObject[] dbDyArr = this.rsmprosklRepository.queryHrpiRsmprosklForPerChg(pkIdList);
        Map resultMap = this.attacheHandlerService.invokeDel(pkIdList, infoClassifyEntityKeyDTO.getSourceKey(), Boolean.TRUE);
        HrpiServiceOperateResult operateResult = HrpiServiceOperateResult.build((Map)resultMap);
        if (operateResult.isSuccess()) {
            LOGGER.info(String.format(Locale.ROOT, "deleteRsmproskl the id is %s.", pkIdList));
            HpfsChgexternalrecordQueueHelper.sendBatchHisNonLineDeleteMsg((DynamicObject[])dbDyArr, (String)infoClassifyEntityKeyDTO.getSourceKey(), (String)infoClassifyEntityKeyDTO.getFormKey());
        }
        return operateResult;
    }

    @Override
    public HrpiServiceOperateResult saveImportRsmproskl(String importtype, DynamicObject[] dataEntities) {
        InfoClassifyEntityKeyDTO infoClassifyEntityKeyDTO = InfoClassifyEntityKeyDTO.getEntityKeyEnumByFormKey((String)"hspm_rsmproskl");
        DynamicObject[] importSaveDys = this.rsmprosklRepository.getImportSaveByRsmproskl(dataEntities);
        Map resultMap = this.attacheHandlerService.invokeHisNonLineImportData(importtype, importSaveDys);
        HrpiServiceOperateResult operateResult = HrpiServiceOperateResult.build((Map)resultMap);
        if (operateResult.isSuccess()) {
            LOGGER.info(String.format(Locale.ROOT, "saveImportRsmproskl the id is %s.", operateResult.getDataMapForIds()));
            HpfsChgexternalrecordQueueHelper.sendBatchHisNonLineInsertMsg((DynamicObject[])dataEntities, (String)infoClassifyEntityKeyDTO.getSourceKey(), (String)infoClassifyEntityKeyDTO.getFormKey());
        }
        return operateResult;
    }

    @Override
    public List<Long> queryExistsIdByPkIdList(List<Long> pkIdList) {
        DynamicObject[] existsPkIdArr = this.rsmprosklRepository.queryByPkIdList(pkIdList);
        if (existsPkIdArr.length > 0) {
            return Arrays.stream(existsPkIdArr).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        }
        return new ArrayList<Long>();
    }
}

