/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.business.domian.service.impl.inforevise;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.model.org.staff.StaffResponse;
import kd.hr.hbp.common.util.DateUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hspm.business.domian.repository.inforevise.AttachreviseconRepository;
import kd.hr.hspm.business.domian.repository.inforevise.DepEmpRepository;
import kd.hr.hspm.business.domian.repository.inforevise.EmployeeRepository;
import kd.hr.hspm.business.domian.repository.inforevise.EmpposorgrelRepository;
import kd.hr.hspm.business.domian.repository.inforevise.EmpposorgrelallRepository;
import kd.hr.hspm.business.domian.repository.inforevise.ErfiletypeRepository;
import kd.hr.hspm.business.domian.repository.inforevise.ErmanfileRepository;
import kd.hr.hspm.business.domian.repository.inforevise.PersonRoleRelRepository;
import kd.hr.hspm.business.domian.service.inforevise.IInfoReviseService;
import kd.hr.hspm.business.revise.helper.PersonReviseHelper;
import kd.sdk.hr.common.entity.DepEmpEntity;
import kd.sdk.hr.common.entity.DiscardChargePerson;
import kd.sdk.hr.common.plugin.perm.service.PositionTypeEnum;
import kd.sdk.hr.hpfs.business.perchg.executor.enums.ChgModeEnum;
import kd.sdk.hr.hpfs.utils.PersonParamsBuilder;
import kd.sdk.hr.hspm.business.service.AttacheHandlerService;
import kd.sdk.hr.hspm.common.result.HrpiServiceOperateResult;
import kd.sdk.hr.hspm.common.utils.DynamicPropValidateUtil;
import org.apache.commons.lang3.StringUtils;

public class EmpposorgrelServiceImpl
implements IInfoReviseService {
    private static final Log LOGGER = LogFactory.getLog(EmpposorgrelServiceImpl.class);
    protected final AttacheHandlerService attacheHandlerService = AttacheHandlerService.getInstance();
    private static DynamicObjectType empposorgrelType = EntityMetadataCache.getDataEntityType((String)"hrpi_empposorgrel");
    private static DynamicObjectType depType = EntityMetadataCache.getDataEntityType((String)"hrpi_depemp");
    private static DynamicObjectType empPosAllType = EntityMetadataCache.getDataEntityType((String)"hrpi_emporgrelall");
    private static DynamicObjectType erManFileType = EntityMetadataCache.getDataEntityType((String)"hspm_ermanfile");
    private static DynamicObjectType workRoleType = EntityMetadataCache.getDataEntityType((String)"hrpi_personrolerel");
    private final String[] empExpAllProps = new String[]{"bsed", "businessstatus", "isinsystem", "apositiontype", "employee", "person", "cmpemp", "depemp", "isprimary", "startdate", "enddate", "lastworkdate", "workplace"};

    @Override
    public HrpiServiceOperateResult saveBatch(DynamicObject modelEntity) {
        if (modelEntity == null) {
            return HrpiServiceOperateResult.build((Boolean)Boolean.FALSE, (String)ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"EmpposorgrelServiceImpl_0", (String)"hr-hspm-business", (Object[])new Object[0]));
        }
        DynamicObject dataEntity = (DynamicObject)empposorgrelType.createInstance();
        HRDynamicObjectUtils.copy((DynamicObject)modelEntity, (DynamicObject)dataEntity);
        dataEntity.set("id", (Object)modelEntity.getLong("id"));
        Long employeeId = dataEntity.getLong("employee.id");
        Long personId = dataEntity.getLong("person.id");
        if (employeeId == null || employeeId == 0L || personId == null || personId == 0L) {
            return HrpiServiceOperateResult.build((Boolean)Boolean.FALSE, (String)ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u81ea\u7136\u4eba\u6216\u4f01\u4e1a\u4eba\u3002", (String)"EmpposorgrelServiceImpl_1", (String)"hr-hspm-business", (Object[])new Object[0]));
        }
        DynamicObject dep = this.buildDepEmpDy(dataEntity);
        dataEntity.set("depemp", (Object)dep);
        DynamicObject erManfile = this.buildErManFileDy(dataEntity);
        DynamicObject empExpAll = this.buildEmpExpAll(dataEntity);
        DynamicObject workRole = this.buildWorkRole(dataEntity);
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        ArrayList<Map<String, Object>> datas = new ArrayList<Map<String, Object>>();
        this.buildHisDynMap(dataEntity, datas);
        this.buildHisDynMap(dep, datas);
        this.buildHisDynMap(erManfile, datas);
        this.buildHisDynMap(empExpAll, datas);
        this.buildHisDynMap(workRole, datas);
        paramMap.put("data", datas);
        paramMap.put("caller", "hspm");
        paramMap.put("mustAllSuccess", true);
        Map result = this.attacheHandlerService.invokeSaveBatch(paramMap);
        LOGGER.info(MessageFormat.format("invokeSaveEmpposorgrel result:[{0}]", result));
        if (((Boolean)result.get("success")).booleanValue()) {
            StaffResponse syncStaffResult = (StaffResponse)HRMServiceHelper.invokeHRMPService((String)"haos", (String)"IHAOSStaffService", (String)"syncOnePersonStaff", (Object[])new Object[]{dataEntity.getLong("person.id"), dataEntity.getDate("startdate")});
            LOGGER.info(MessageFormat.format("invokeSaveEmpposorgrel,syncOnePersonStaff:[{0}]", syncStaffResult));
            try {
                this.treatChargePersonForNew(modelEntity, result);
            }
            catch (Exception ex) {
                LOGGER.error("EmpposorgrelServiceImpl#treatChargePersonForNew error!", (Throwable)ex);
            }
            AttacheHandlerService.getInstance().sendChangeInfoSyncToSysUser(Collections.singletonList(dataEntity.getLong("person.id")));
        }
        return HrpiServiceOperateResult.build((Map)result);
    }

    private void treatChargePersonForNew(DynamicObject modelEntity, Map<String, Object> result) {
        String isLeader;
        String aPositionType = modelEntity.getString("apositiontype");
        if (PositionTypeEnum.POSITIONTYPE_POSITION.getValue().equals(aPositionType) && "1".equals(isLeader = modelEntity.getString("position.isleader"))) {
            ArrayList depEmpEntityList = Lists.newArrayListWithExpectedSize((int)1);
            DynamicObject[] resultEmpPosOrgRelDynArr = PersonReviseHelper.analyzeReviseNewResultData(result, "hrpi_empposorgrel");
            if (resultEmpPosOrgRelDynArr.length > 0) {
                long depEmpId = resultEmpPosOrgRelDynArr[0].getLong("depemp.id");
                DepEmpEntity depEmpEntity = new DepEmpEntity(Long.valueOf(depEmpId), ChgModeEnum.ADD_NEW.getChgMode(), null, null);
                depEmpEntityList.add(depEmpEntity);
                PersonParamsBuilder personParamsBuilder = new PersonParamsBuilder();
                personParamsBuilder.setChargePerson((List)depEmpEntityList);
            }
        }
    }

    @Override
    public HrpiServiceOperateResult revise(DynamicObject modelEntity) {
        Map<String, Object> result;
        if (modelEntity == null) {
            return HrpiServiceOperateResult.build((Boolean)Boolean.FALSE, (String)ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"EmpposorgrelServiceImpl_0", (String)"hr-hspm-business", (Object[])new Object[0]));
        }
        DynamicObject[] empposorgrelDyns = EmpposorgrelRepository.getInstance().queryEffectiveHisDataByIds(Collections.singletonList(modelEntity.getLong("id")));
        if (empposorgrelDyns == null || empposorgrelDyns.length == 0) {
            return HrpiServiceOperateResult.build((Boolean)Boolean.FALSE, (String)ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\u3002", (String)"EmpposorgrelServiceImpl_3", (String)"hr-hspm-business", (Object[])new Object[0]));
        }
        DynamicObject empposorgrelFromDB = (DynamicObject)empposorgrelType.createInstance();
        HRDynamicObjectUtils.copy((DynamicObject)empposorgrelDyns[0], (DynamicObject)empposorgrelFromDB);
        empposorgrelFromDB.set("id", (Object)empposorgrelDyns[0].getLong("id"));
        DynamicObject dataEntity = empposorgrelDyns[0];
        HRDynamicObjectUtils.copy((DynamicObject)modelEntity, (DynamicObject)dataEntity);
        dataEntity.set("id", (Object)modelEntity.getLong("id"));
        Map changedPropMap = DynamicPropValidateUtil.checkChangedPropMap((DynamicObject)dataEntity, (DynamicObject)empposorgrelFromDB);
        DynamicObject[] attachreviseconDyns = AttachreviseconRepository.getInstance().getAttachrevisecon(dataEntity.getDataEntityType().getExtendName(), Collections.singletonList(1010L));
        List corePropNames = attachreviseconDyns[0].getDynamicObjectCollection("entryentity").stream().map(dyn -> dyn.getString("fieldtag")).collect(Collectors.toList());
        ArrayList<String> hasChangedCoreProps = new ArrayList<String>(10);
        ArrayList<String> hasChangedNoCoreProps = new ArrayList<String>(10);
        List hasChangedProps = (List)changedPropMap.get("hasChangedProps");
        for (String hasChangedProp : hasChangedProps) {
            if (corePropNames.contains(hasChangedProp)) {
                hasChangedCoreProps.add(hasChangedProp);
                continue;
            }
            hasChangedNoCoreProps.add(hasChangedProp);
        }
        Map<String, Map<String, DynamicObject>> relationDynMap = this.handleRelationDynMap(hasChangedCoreProps, dataEntity, empposorgrelFromDB, hasChangedNoCoreProps);
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        ArrayList<Map<String, Object>> datas = new ArrayList<Map<String, Object>>(10);
        HashMap modelEntityMap = relationDynMap.get(dataEntity.getDataEntityType().getName());
        if (modelEntityMap == null) {
            modelEntityMap = Maps.newHashMapWithExpectedSize((int)16);
        }
        modelEntityMap.put(dataEntity.getString("id"), dataEntity);
        relationDynMap.put(dataEntity.getDataEntityType().getName(), modelEntityMap);
        Map<String, DynamicObject> empposorgrelMap = relationDynMap.get("hrpi_empposorgrel");
        if (empposorgrelMap != null && !empposorgrelMap.isEmpty()) {
            for (Map.Entry<String, DynamicObject> empposorgrel : empposorgrelMap.entrySet()) {
                String apositiontype = empposorgrel.getValue().getString("apositiontype");
                if (HRStringUtils.equals((String)"1", (String)apositiontype)) continue;
                if (hasChangedProps.contains("job") || hasChangedProps.contains("jobvid")) {
                    empposorgrel.getValue().set("position", null);
                }
                if (!hasChangedProps.contains("stdposition") && !hasChangedProps.contains("stdpositionvid")) continue;
                empposorgrel.getValue().set("position", null);
            }
        }
        if (((Boolean)(result = this.invokeRevise(relationDynMap, datas, paramMap)).get("success")).booleanValue()) {
            StaffResponse syncStaffResult = (StaffResponse)HRMServiceHelper.invokeHRMPService((String)"haos", (String)"IHAOSStaffService", (String)"syncOnePersonStaff", (Object[])new Object[]{dataEntity.getLong("person.id"), dataEntity.getDate("startdate")});
            LOGGER.info(MessageFormat.format("invokeReviseEmpposorgrel,syncOnePersonStaff:[{0}]", syncStaffResult));
            try {
                this.treatChargePersonForRevise(result);
            }
            catch (Exception ex) {
                LOGGER.error("EmpposorgrelServiceImpl#treatChargePersonForRevise error!", (Throwable)ex);
            }
            AttacheHandlerService.getInstance().sendChangeInfoSyncToSysUser(Collections.singletonList(dataEntity.getLong("person.id")));
        }
        return HrpiServiceOperateResult.build(result);
    }

    private void treatChargePersonForRevise(Map<String, Object> result) {
        DynamicObject[] resultEmpPosOrgRelDynArr = PersonReviseHelper.analyzeReviseResultData(result, "hrpi_empposorgrel");
        DynamicObject newDyn = Arrays.stream(resultEmpPosOrgRelDynArr).filter(dyn -> dyn.getString("datastatus").equals("1") || dyn.getString("datastatus").equals("0")).findFirst().get();
        DynamicObject hisDyn = Arrays.stream(resultEmpPosOrgRelDynArr).filter(dyn -> dyn.getString("datastatus").equals("-4")).findFirst().get();
        boolean isLeaderPositionForHis = this.isLeaderPositionForHis(hisDyn);
        boolean isLeaderPositionForNew = this.isLeaderPositionForHis(newDyn);
        if (!isLeaderPositionForHis && isLeaderPositionForNew) {
            this.callNewChargeMethod(newDyn);
        }
        if (isLeaderPositionForHis && !isLeaderPositionForNew) {
            this.callDiscardChargeMethod(hisDyn);
        }
        boolean notModifyFlag = this.isNotModifyFlag(newDyn, hisDyn);
        if (isLeaderPositionForHis && isLeaderPositionForNew && !notModifyFlag) {
            this.callModifyChargeMethod(hisDyn, newDyn);
        }
    }

    public boolean isLeaderPositionForHis(DynamicObject dyn) {
        String aPositionTypeForHis = dyn.getString("apositiontype");
        String isLeader = dyn.getString("position.isleader");
        return HRStringUtils.equals((String)PositionTypeEnum.POSITIONTYPE_POSITION.getValue(), (String)aPositionTypeForHis) && HRStringUtils.equals((String)"1", (String)isLeader);
    }

    private boolean isNotModifyFlag(DynamicObject newDyn, DynamicObject hisDyn) {
        long adminOrgForNew = newDyn.getLong("adminorg.boid");
        Date startDateForNew = HRDateTimeUtils.truncateDate((Date)newDyn.getDate("startdate"));
        Date endDateForNew = HRDateTimeUtils.truncateDate((Date)newDyn.getDate("enddate"));
        long adminOrgForHis = hisDyn.getLong("adminorg.boid");
        Date startDateForHis = HRDateTimeUtils.truncateDate((Date)hisDyn.getDate("startdate"));
        Date endDateForHis = HRDateTimeUtils.truncateDate((Date)hisDyn.getDate("enddate"));
        return adminOrgForNew == adminOrgForHis && HRDateTimeUtils.dayEquals((Date)startDateForNew, (Date)startDateForHis) && HRDateTimeUtils.dayEquals((Date)endDateForNew, (Date)endDateForHis);
    }

    public void callNewChargeMethod(DynamicObject dyn) {
        ArrayList depEmpEntityList = Lists.newArrayListWithExpectedSize((int)1);
        long depEmpId = dyn.getLong("depemp.id");
        DepEmpEntity depEmpEntity = new DepEmpEntity(Long.valueOf(depEmpId), ChgModeEnum.ADD_NEW.getChgMode(), null, null);
        depEmpEntityList.add(depEmpEntity);
        LOGGER.info("EmpposorgrelServiceImpl#callNewChargeMethod.depEmpEntityList={}", (Object)SerializationUtils.toJsonString((Object)depEmpEntityList));
        PersonParamsBuilder personParamsBuilder = new PersonParamsBuilder();
        personParamsBuilder.setChargePerson((List)depEmpEntityList);
    }

    public void callBatchNewChargeMethod(List<DynamicObject> dynList) {
        ArrayList depEmpEntityList = Lists.newArrayListWithExpectedSize((int)1);
        for (DynamicObject dyn : dynList) {
            long depEmpId = dyn.getLong("depemp.id");
            DepEmpEntity depEmpEntity = new DepEmpEntity(Long.valueOf(depEmpId), ChgModeEnum.ADD_NEW.getChgMode(), null, null);
            depEmpEntityList.add(depEmpEntity);
        }
        LOGGER.info("EmpposorgrelServiceImpl#callBatchNewChargeMethod.depEmpEntityList={}", (Object)SerializationUtils.toJsonString((Object)depEmpEntityList));
        PersonParamsBuilder personParamsBuilder = new PersonParamsBuilder();
        personParamsBuilder.setChargePerson((List)depEmpEntityList);
    }

    public void callModifyChargeMethod(DynamicObject hisDyn, DynamicObject newDyn) {
        long adminOrgForNew = newDyn.getLong("adminorg.boid");
        Date endDateForNew = HRDateTimeUtils.truncateDate((Date)newDyn.getDate("enddate"));
        Date startDateForNew = HRDateTimeUtils.truncateDate((Date)newDyn.getDate("startdate"));
        long adminOrgForHis = hisDyn.getLong("adminorg.boid");
        Date startDateForHis = HRDateTimeUtils.truncateDate((Date)hisDyn.getDate("startdate"));
        Map chargeResultMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIChargeService", (String)"queryPastChargeByOrgId", (Object[])new Object[]{Collections.singletonList(adminOrgForHis), startDateForHis});
        LOGGER.info("saveBatchPersonAttach result:{}", (Object)chargeResultMap);
        List chargeList = (List)chargeResultMap.get(adminOrgForHis);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)chargeList)) {
            return;
        }
        Long changeType = 1040L;
        Long depEmpId = hisDyn.getLong("depemp.id");
        List chargeInfoList = chargeList.stream().filter(map -> !changeType.equals((Long)map.get("changesource.id"))).filter(map -> depEmpId.equals((Long)map.get("depemp"))).collect(Collectors.toList());
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(chargeInfoList)) {
            ArrayList chargePersonInfParamList = Lists.newArrayListWithExpectedSize((int)1);
            for (Map chargeInfo : chargeInfoList) {
                HashMap chargeMap = Maps.newHashMapWithExpectedSize((int)3);
                Long chargeId = (Long)chargeInfo.get("id");
                chargeMap.put("id", chargeId);
                chargeMap.put("chargeperson", depEmpId);
                chargeMap.put("adminorg", adminOrgForNew);
                chargeMap.put("effdt", startDateForNew);
                chargeMap.put("leffdt", endDateForNew);
                chargePersonInfParamList.add(chargeMap);
            }
            LOGGER.info("EmpposorgrelServiceImpl#callModifyChargeMethod.chargePersonInfParamList={}", (Object)SerializationUtils.toJsonString((Object)chargePersonInfParamList));
            PersonParamsBuilder personParamsBuilder = new PersonParamsBuilder();
            personParamsBuilder.updateChargePerson((List)chargePersonInfParamList);
        }
    }

    public void callDiscardChargeMethod(DynamicObject hisDyn) {
        Long depEmpId = hisDyn.getLong("depemp.id");
        Long adminOrgBoId = hisDyn.getLong("adminorg.boid");
        ArrayList discardChargePersonList = Lists.newArrayListWithExpectedSize((int)1);
        DiscardChargePerson discardChargePerson = new DiscardChargePerson(depEmpId, adminOrgBoId, true);
        discardChargePerson.setDepEmpId(depEmpId);
        discardChargePerson.setAdminOrgId(adminOrgBoId);
        discardChargePersonList.add(discardChargePerson);
        LOGGER.info("EmpposorgrelServiceImpl#callDiscardChargeMethod.discardChargePersonList={}", (Object)SerializationUtils.toJsonString((Object)discardChargePersonList));
        PersonParamsBuilder personParamsBuilder = new PersonParamsBuilder();
        personParamsBuilder.discardChargePerson((List)discardChargePersonList);
    }

    public void callBatchDiscardChargeMethod(List<DynamicObject> dynList) {
        ArrayList discardChargePersonList = Lists.newArrayListWithExpectedSize((int)dynList.size());
        for (DynamicObject dyn : dynList) {
            Long depEmpId = dyn.getLong("depemp.id");
            Long adminOrgBoId = dyn.getLong("adminorg.boid");
            DiscardChargePerson discardChargePerson = new DiscardChargePerson(depEmpId, adminOrgBoId, true);
            discardChargePersonList.add(discardChargePerson);
        }
        LOGGER.info("EmpposorgrelServiceImpl#callBatchDiscardChargeMethod.discardChargePersonList={}", (Object)SerializationUtils.toJsonString((Object)discardChargePersonList));
        PersonParamsBuilder personParamsBuilder = new PersonParamsBuilder();
        personParamsBuilder.discardChargePerson((List)discardChargePersonList);
    }

    private Map<String, Object> invokeRevise(Map<String, Map<String, DynamicObject>> relationDynMap, List<Map<String, Object>> datas, Map<String, Object> paramMap) {
        for (Map.Entry<String, Map<String, DynamicObject>> relationDynMapEntry : relationDynMap.entrySet()) {
            HashMap<String, DynamicObjectCollection> personGenericDataEntityMap = new HashMap<String, DynamicObjectCollection>(16);
            DynamicObjectCollection hisDyns = new DynamicObjectCollection();
            hisDyns.addAll(relationDynMapEntry.getValue().values());
            personGenericDataEntityMap.put("hisDyns", hisDyns);
            datas.add(personGenericDataEntityMap);
        }
        paramMap.put("data", datas);
        paramMap.put("caller", "hspm");
        paramMap.put("mustAllSuccess", true);
        Map result = this.attacheHandlerService.invokeReviseVersion(paramMap);
        LOGGER.info(MessageFormat.format("invokeReviseEmpposorgrel result:[{0}]", result));
        return result;
    }

    private Map<String, Map<String, DynamicObject>> handleRelationDynMap(List<String> hasChangedCoreProps, DynamicObject dataEntity, DynamicObject empposorgrelFromDB, List<String> hasChangedNoCoreProps) {
        HashMap relationDynMap = Maps.newHashMapWithExpectedSize((int)16);
        if (!hasChangedCoreProps.isEmpty()) {
            DynamicObject[] empposorgrelHisDyns = EmpposorgrelRepository.getInstance().queryEffectiveHisDataByBoIds(dataEntity.getLong("boid"), dataEntity.getLong("id"));
            DynamicObject[] depEmpHisDyns = DepEmpRepository.getInstance().queryEffectiveHisDataByBoIds(dataEntity.getLong("depemp.boid"));
            DynamicObject[] empposorgrelallHisDyns = EmpposorgrelallRepository.getInstance().queryEffectiveHisDataByDepempId(dataEntity.getLong("depemp.boid"));
            DynamicObject[] ermanfileHisDyns = ErmanfileRepository.getInstance().queryEffectiveHisDataByDepempId(dataEntity.getLong("depemp.boid"));
            DynamicObject[] personRoleRelDyns = PersonRoleRelRepository.getInstance().queryEffectiveHisDataByDepEmpIdAndRoleId(empposorgrelFromDB.getLong("employee.id"), empposorgrelFromDB.getLong("position.workrole.id"));
            this.handleRelationEntityCoreProp(dataEntity, empposorgrelHisDyns, hasChangedCoreProps, relationDynMap);
            this.handleRelationEntityCoreProp(dataEntity, depEmpHisDyns, hasChangedCoreProps, relationDynMap);
            this.handleRelationEntityCoreProp(dataEntity, empposorgrelallHisDyns, hasChangedCoreProps, relationDynMap);
            this.handleRelationEntityCoreProp(dataEntity, ermanfileHisDyns, hasChangedCoreProps, relationDynMap);
            this.handleRelationEntityCoreProp(dataEntity, personRoleRelDyns, hasChangedCoreProps, relationDynMap);
        }
        if (!hasChangedNoCoreProps.isEmpty()) {
            DynamicObject[] depEmpHisDyns = DepEmpRepository.getInstance().queryHisDataByBoIdAndBsed(dataEntity.getLong("depemp.boid"), empposorgrelFromDB.getDate("bsed"), empposorgrelFromDB.getDate("bsled"));
            this.handleRelationEntityNoCoreProp(dataEntity, depEmpHisDyns, relationDynMap, hasChangedNoCoreProps);
            DynamicObject[] empposorgrelallHisDyns = EmpposorgrelallRepository.getInstance().queryHisDataByBoIdAndBsed(dataEntity.getLong("depemp.boid"), empposorgrelFromDB.getDate("bsed"), empposorgrelFromDB.getDate("bsled"));
            this.handleRelationEntityNoCoreProp(dataEntity, empposorgrelallHisDyns, relationDynMap, hasChangedNoCoreProps);
            DynamicObject[] ermanfileHisDyns = ErmanfileRepository.getInstance().queryHisDataByBoIdAndBsed(dataEntity.getLong("depemp.boid"), empposorgrelFromDB.getDate("bsed"), empposorgrelFromDB.getDate("bsled"));
            this.handleRelationEntityNoCoreProp(dataEntity, ermanfileHisDyns, relationDynMap, hasChangedNoCoreProps);
            DynamicObject[] personRoleRelDyns = PersonRoleRelRepository.getInstance().queryHisDataByBoIdAndBsed(empposorgrelFromDB.getLong("employee.id"), empposorgrelFromDB.getLong("position.workrole.id"), empposorgrelFromDB.getDate("bsed"), empposorgrelFromDB.getDate("bsled"));
            this.handleRelationEntityNoCoreProp(dataEntity, personRoleRelDyns, relationDynMap, hasChangedNoCoreProps);
        }
        return relationDynMap;
    }

    @Override
    public HrpiServiceOperateResult discardBo(List<Long> boIdList) {
        DynamicObject[] empposorgrels = EmpposorgrelRepository.getInstance().queryCurrentVersionDataByBoIds(boIdList);
        if (empposorgrels == null || empposorgrels.length < 1) {
            return HrpiServiceOperateResult.build((Boolean)Boolean.FALSE, (String)ResManager.loadKDString((String)"\u4efb\u804c\u7ecf\u5386\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"EmpposorgrelServiceImpl_2", (String)"hr-hspm-business", (Object[])new Object[0]));
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        ArrayList datas = new ArrayList();
        HashMap<String, Object> empposorgrelBoIdMap = new HashMap<String, Object>(16);
        empposorgrelBoIdMap.put("entityNumber", "hrpi_empposorgrel");
        HashMap<String, Object> depempBoIdMap = new HashMap<String, Object>(16);
        depempBoIdMap.put("entityNumber", "hrpi_depemp");
        HashMap<String, Object> empPosAllBoIdMap = new HashMap<String, Object>(16);
        empPosAllBoIdMap.put("entityNumber", "hrpi_emporgrelall");
        HashMap<String, Object> erManFileBoIdMap = new HashMap<String, Object>(16);
        erManFileBoIdMap.put("entityNumber", "hspm_ermanfile");
        HashMap<String, Object> personRoleRelBoIdMap = new HashMap<String, Object>(16);
        personRoleRelBoIdMap.put("entityNumber", "hrpi_personrolerel");
        ArrayList<Long> empposorgrelBoIds = new ArrayList<Long>(empposorgrels.length);
        ArrayList<Long> depempBoIds = new ArrayList<Long>(empposorgrels.length);
        ArrayList<Long> employeeBoIds = new ArrayList<Long>(empposorgrels.length);
        ArrayList<Long> workroleBoIds = new ArrayList<Long>(empposorgrels.length);
        ArrayList<Long> personRoleRelBoIds = new ArrayList<Long>(empposorgrels.length);
        HashMap<Long, Date> personToStartdateMap = new HashMap<Long, Date>(16);
        for (DynamicObject empposorgrel : empposorgrels) {
            empposorgrelBoIds.add(empposorgrel.getLong("boid"));
            depempBoIds.add(empposorgrel.getLong("depemp.boid"));
            employeeBoIds.add(empposorgrel.getLong("employee.boid"));
            workroleBoIds.add(empposorgrel.getLong("position.workrole.id"));
            personToStartdateMap.put(empposorgrel.getLong("person.id"), empposorgrel.getDate("startdate"));
        }
        DynamicObject[] empPosAllDyns = EmpposorgrelallRepository.getInstance().queryCurrentVersionDataByDepemp(depempBoIds);
        List empPosAllBoIds = Arrays.asList(empPosAllDyns).stream().map(dyn -> dyn.getLong("boid")).collect(Collectors.toList());
        DynamicObject[] ermanfileDyns = ErmanfileRepository.getInstance().queryCurrentVersionDataByDepempIds(depempBoIds);
        List erManFileBoIds = Arrays.asList(ermanfileDyns).stream().map(dyn -> dyn.getLong("boid")).collect(Collectors.toList());
        Map<String, DynamicObject> personRoleRelDynMap = PersonRoleRelRepository.getInstance().getPersonRoleRelByDepEmpIdAndRoleId(employeeBoIds, workroleBoIds);
        for (DynamicObject empposorgrel : empposorgrels) {
            String personRoleRelKey = String.join((CharSequence)"_", empposorgrel.getString("employee.id"), empposorgrel.getString("position.workrole.id"));
            if (personRoleRelDynMap.get(personRoleRelKey) == null) continue;
            personRoleRelBoIds.add(personRoleRelDynMap.get(personRoleRelKey).getLong("boid"));
        }
        empposorgrelBoIdMap.put("boIdList", empposorgrelBoIds);
        depempBoIdMap.put("boIdList", depempBoIds);
        empPosAllBoIdMap.put("boIdList", empPosAllBoIds);
        erManFileBoIdMap.put("boIdList", erManFileBoIds);
        personRoleRelBoIdMap.put("boIdList", personRoleRelBoIds);
        datas.add(empposorgrelBoIdMap);
        datas.add(depempBoIdMap);
        datas.add(empPosAllBoIdMap);
        datas.add(erManFileBoIdMap);
        datas.add(personRoleRelBoIdMap);
        paramMap.put("data", datas);
        paramMap.put("caller", "hspm");
        Map result = this.attacheHandlerService.invokeDiscardBO(paramMap);
        if (((Boolean)result.get("success")).booleanValue()) {
            for (Map.Entry personToStartdate : personToStartdateMap.entrySet()) {
                StaffResponse syncStaffResult = (StaffResponse)HRMServiceHelper.invokeHRMPService((String)"haos", (String)"IHAOSStaffService", (String)"syncOnePersonStaff", (Object[])new Object[]{personToStartdate.getKey(), personToStartdate.getValue()});
                LOGGER.info(MessageFormat.format("invokeSaveEmpposorgrel,syncOnePersonStaff:[{0}]", syncStaffResult));
            }
            try {
                this.treatChargePersonForDelete(empposorgrels[0], result);
            }
            catch (Exception ex) {
                LOGGER.error("EmpposorgrelServiceImpl#treatChargePersonForNew error!", (Throwable)ex);
            }
            AttacheHandlerService.getInstance().sendChangeInfoSyncToSysUser(new ArrayList(personToStartdateMap.keySet()));
        }
        return HrpiServiceOperateResult.build((Map)result);
    }

    private void treatChargePersonForDelete(DynamicObject empposorgrel, Map<String, Object> result) {
        DynamicObject empPosOrgRelDyn = empposorgrel;
        long adminOrgBoId = empPosOrgRelDyn.getLong("adminorg.boid");
        Map chargeResultMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIChargeService", (String)"queryPastChargeByOrgId", (Object[])new Object[]{Collections.singletonList(adminOrgBoId), new Date()});
        LOGGER.info("saveBatchPersonAttach result:{}", result);
        List chargeList = (List)chargeResultMap.get(adminOrgBoId);
        Long changeType = 1040L;
        Long depEmpId = empPosOrgRelDyn.getLong("depemp.id");
        List chargeInfoList = chargeList.stream().filter(map -> !changeType.equals((Long)map.get("changesource.id"))).filter(map -> depEmpId.equals((Long)map.get("depemp"))).collect(Collectors.toList());
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(chargeInfoList)) {
            this.callDiscardChargeMethod(empPosOrgRelDyn);
        }
    }

    private DynamicObject buildDepEmpDy(DynamicObject empExp) {
        DynamicObject dy = (DynamicObject)depType.createInstance();
        dy.set("id", (Object)ORM.create().genLongId((IDataEntityType)depType));
        this.wrapSameFieldFromSourceForInit(dy, empExp);
        this.wrapCommonField(dy);
        return dy;
    }

    private DynamicObject buildErManFileDy(DynamicObject empExp) {
        DynamicObject dy = (DynamicObject)erManFileType.createInstance();
        this.wrapSameFieldFromSourceForInit(dy, empExp);
        dy.set("id", (Object)ORM.create().genLongId((IDataEntityType)erManFileType));
        Long adminOrgId = (Long)empExp.get("adminorg.id");
        Map<Long, Long> adminOrgBuRel = this.queryBuByAdminOrg(adminOrgId);
        if (adminOrgBuRel != null) {
            dy.set("org", (Object)adminOrgBuRel.get(adminOrgId));
        }
        dy.set("affiliateadminorg", empExp.get("adminorg"));
        dy.set("empgroup", (Object)1010L);
        dy.set("ismanaged", (Object)0);
        dy.set("dependency", empExp.get("workplace.country"));
        dy.set("dependencytype", (Object)1010L);
        dy.set("empposrel", empExp.get("id"));
        dy.set("number", (Object)empExp.getString("employee.empnumber"));
        DynamicObject empEnt = empExp.getDynamicObject("employee");
        Map<Long, Long> empEntRelMap = EmployeeRepository.getInstance().queryEmpEntRelMap(new HashSet<Long>(Collections.singletonList(empEnt.getLong("id"))));
        if (empEntRelMap != null) {
            dy.set("empentrel", (Object)empEntRelMap.get(empEnt.getLong("id")));
        }
        dy.set("name", empExp.get("person.name"));
        dy.set("hbsscmpemp", empExp.get("cmpemp"));
        Object status = empExp.get("businessstatus");
        if ("1".equals(status)) {
            dy.set("businessstatus", (Object)"1");
        } else {
            dy.set("businessstatus", (Object)"-1");
        }
        dy.set("issystem", (Object)true);
        String labAndPosTypeStr = String.join((CharSequence)"_", empEnt.getString("laborreltype.id"), empExp.getString("postype.id"));
        HashSet labAndPosTypes = Sets.newHashSetWithExpectedSize((int)16);
        labAndPosTypes.add(labAndPosTypeStr);
        Map<String, Long> fileTypeMaps = ErfiletypeRepository.getInstance().getFileTypeByLabAndPosType(labAndPosTypes);
        if (empEntRelMap != null) {
            dy.set("filetype", (Object)fileTypeMaps.get(labAndPosTypeStr));
        }
        this.wrapCommonField(dy);
        return dy;
    }

    private DynamicObject buildEmpExpAll(DynamicObject empExp) {
        DynamicObject dy = (DynamicObject)empPosAllType.createInstance();
        dy.set("id", (Object)ORM.create().genLongId((IDataEntityType)empPosAllType));
        for (String field : this.empExpAllProps) {
            try {
                dy.set(field, empExp.get(field));
            }
            catch (Exception ext) {
                LOGGER.error("InitValidateUtil_wrapPropsFromSourceToDy_eroor:", (Throwable)ext);
            }
        }
        dy.set("postype", empExp.get("postype.name"));
        dy.set("company", empExp.get("company.name"));
        dy.set("adminorg", empExp.get("adminorg.name"));
        dy.set("position", empExp.get("position.name"));
        dy.set("stdposition", empExp.get("stdposition.name"));
        Long stdPositionId = (Long)empExp.get("stdposition.id");
        if (stdPositionId != null) {
            dy.set("position", empExp.get("stdposition.name"));
        }
        dy.set("job", empExp.get("job.name"));
        this.wrapCommonField(dy);
        return dy;
    }

    private DynamicObject buildWorkRole(DynamicObject empExp) {
        DynamicObject dy = (DynamicObject)workRoleType.createInstance();
        this.wrapSameFieldFromSourceForInit(dy, empExp);
        dy.set("id", (Object)ORM.create().genLongId((IDataEntityType)empPosAllType));
        if (StringUtils.equals((CharSequence)empExp.getString("apositiontype"), (CharSequence)"1")) {
            dy.set("role", empExp.get("position.workrole"));
            dy.set("adminorg", empExp.get("position.adminorg"));
        }
        this.wrapCommonField(dy);
        return dy;
    }

    private Map<Long, Long> queryBuByAdminOrg(Long adminOrgId) {
        HashMap adminOrgBuRel = null;
        if (adminOrgId != null && adminOrgId != 0L) {
            HashMap orgId2BusinessType = Maps.newHashMapWithExpectedSize((int)16);
            HashSet businessTypeSet = Sets.newHashSetWithExpectedSize((int)1);
            businessTypeSet.add(103010L);
            orgId2BusinessType.put(adminOrgId, businessTypeSet);
            List buResult = (List)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSStrategyService", (String)"getHrBuByBusinessType", (Object[])new Object[]{orgId2BusinessType, 1010L});
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)buResult)) {
                adminOrgBuRel = Maps.newHashMapWithExpectedSize((int)buResult.size());
                for (Map bu : buResult) {
                    adminOrgBuRel.put(bu.get("adminOrgId"), bu.get("hrBuId"));
                }
            }
        }
        return adminOrgBuRel;
    }

    private void wrapSameFieldFromSourceForInit(DynamicObject target, DynamicObject source) {
        this.wrapSameFieldFromSource(target, source, new HashSet<String>(Arrays.asList("id", "multilanguagetext", "description", "initstatus", "creator", "creator_id", "modifier", "modifier_id", "createtime", "modifytime", "initdatasource", "boid", "iscurrentversion", "datastatus", "sourcevid", "ismodify", "hisversion", "changedescription")));
    }

    private void wrapSameFieldFromSource(DynamicObject target, DynamicObject source, HashSet<String> ignoreFields) {
        DataEntityPropertyCollection targetFields = target.getDynamicObjectType().getProperties();
        BillEntityType sourceType = (BillEntityType)source.getDynamicObjectType();
        targetFields.stream().filter(field -> {
            String fieldName = field.getName();
            return CollectionUtils.isEmpty((Collection)ignoreFields) || !ignoreFields.contains(fieldName);
        }).forEach(field -> {
            String fieldName = field.getName();
            IDataEntityProperty property = sourceType.findProperty(fieldName);
            if (property != null) {
                target.set(fieldName, source.get(fieldName));
            }
        });
    }

    private void wrapCommonField(DynamicObject dy) {
        long currUserId = RequestContext.get().getCurrUserId();
        dy.set("creator", (Object)currUserId);
        dy.set("modifier", (Object)currUserId);
        Date currentDate = new Date();
        dy.set("createtime", (Object)currentDate);
        dy.set("modifytime", (Object)currentDate);
        dy.set("initdatasource", (Object)"0");
        dy.set("initstatus", (Object)"2");
    }

    private void buildHisDynMap(DynamicObject dataEntity, List<Map<String, Object>> datas) {
        HashMap<String, DynamicObjectCollection> personGenericDataEntityMap = new HashMap<String, DynamicObjectCollection>(16);
        DynamicObjectCollection hisDyns = new DynamicObjectCollection();
        hisDyns.add((Object)dataEntity);
        personGenericDataEntityMap.put("hisDyns", hisDyns);
        datas.add(personGenericDataEntityMap);
    }

    private void handleRelationEntityCoreProp(DynamicObject dataEntity, DynamicObject[] relHisDyns, List<String> hasChangedCoreProps, Map<String, Map<String, DynamicObject>> relationDynMap) {
        for (DynamicObject relHisDyn : relHisDyns) {
            BillEntityType sourceType = (BillEntityType)relHisDyn.getDynamicObjectType();
            boolean flag = false;
            boolean positionChangeFlag = false;
            for (String hasChangedCoreProp : hasChangedCoreProps) {
                if (sourceType.equals((Object)erManFileType)) {
                    Date startdate = dataEntity.getDate("startdate");
                    Date enddate = dataEntity.getDate("enddate");
                    if (hasChangedCoreProp.equals("startdate") && relHisDyn.getLong("filetype.id") == 1050L) continue;
                    if (hasChangedCoreProp.equals("enddate") && relHisDyn.getLong("filetype.id") == 1050L) {
                        if (DateUtils.getIntervalDays((Date)startdate, (Date)enddate) == 0) {
                            relHisDyn.set("startdate", (Object)enddate);
                            flag = true;
                            continue;
                        }
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(enddate);
                        calendar.add(6, 1);
                        relHisDyn.set("startdate", (Object)calendar.getTime());
                        flag = true;
                        continue;
                    }
                }
                if (sourceType.findProperty(hasChangedCoreProp) != null && sourceType.findProperty(hasChangedCoreProp).getPropertyType().equals(((BillEntityType)dataEntity.getDataEntityType()).findProperty(hasChangedCoreProp).getPropertyType())) {
                    relHisDyn.set(hasChangedCoreProp, dataEntity.get(hasChangedCoreProp));
                    flag = true;
                }
                if (sourceType.equals((Object)depType) && hasChangedCoreProp.equals("isprimary")) {
                    relHisDyn.set("isprimary", dataEntity.get("isprimary"));
                    flag = true;
                }
                if (sourceType.equals((Object)workRoleType)) {
                    if (hasChangedCoreProp.equals("position") || hasChangedCoreProp.equals("positionvid")) {
                        relHisDyn.set("role", dataEntity.get("position.workrole.id"));
                        positionChangeFlag = true;
                        flag = true;
                    }
                    if (!positionChangeFlag && (hasChangedCoreProp.equals("job") || hasChangedCoreProp.equals("jobvid"))) {
                        relHisDyn.set("role", null);
                        flag = true;
                    }
                    if (!positionChangeFlag && (hasChangedCoreProp.equals("stdposition") || hasChangedCoreProp.equals("stdpositionvid"))) {
                        relHisDyn.set("role", null);
                        flag = true;
                    }
                }
                if (!sourceType.equals((Object)erManFileType)) continue;
                if (hasChangedCoreProp.equals("businessstatus")) {
                    Object status = dataEntity.get("businessstatus");
                    if ("1".equals(status)) {
                        relHisDyn.set("businessstatus", (Object)"1");
                    } else {
                        relHisDyn.set("businessstatus", (Object)"-1");
                    }
                    flag = true;
                }
                if (!hasChangedCoreProp.equals("postype")) continue;
                String labAndPosTypeStr = String.join((CharSequence)"_", dataEntity.getString("employee.laborreltype.id"), dataEntity.getString("postype.id"));
                HashSet labAndPosTypes = Sets.newHashSetWithExpectedSize((int)16);
                labAndPosTypes.add(labAndPosTypeStr);
                Map<String, Long> fileTypeMaps = ErfiletypeRepository.getInstance().getFileTypeByLabAndPosType(labAndPosTypes);
                relHisDyn.set("filetype", (Object)fileTypeMaps.get(labAndPosTypeStr));
                relHisDyn.set("filetype_id", (Object)fileTypeMaps.get(labAndPosTypeStr));
                flag = true;
            }
            if (!flag) continue;
            HashMap relationDyns = relationDynMap.get(sourceType.getName()) != null ? relationDynMap.get(sourceType.getName()) : Maps.newHashMapWithExpectedSize((int)16);
            relationDyns.put(relHisDyn.getString("id"), relHisDyn);
            relationDynMap.put(sourceType.getName(), relationDyns);
        }
    }

    private void handleRelationEntityNoCoreProp(DynamicObject dataEntity, DynamicObject[] relHisDyns, Map<String, Map<String, DynamicObject>> relationDynMap, List<String> hasChangedNoCoreProps) {
        if (relHisDyns != null && relHisDyns.length > 0) {
            DynamicObject relHisDyn = relHisDyns[0];
            Map<String, DynamicObject> depEmpHisDynMap = relationDynMap.get(relHisDyns[0].getDynamicObjectType().getName());
            if (depEmpHisDynMap != null && depEmpHisDynMap.get(relHisDyns[0].getString("id")) != null) {
                relHisDyn = depEmpHisDynMap.get(relHisDyns[0].getString("id"));
            }
            BillEntityType sourceType = (BillEntityType)relHisDyn.getDynamicObjectType();
            boolean flag = false;
            for (String hasChangedNoCoreProp : hasChangedNoCoreProps) {
                if (!ignoreProps.contains(hasChangedNoCoreProp) && sourceType.findProperty(hasChangedNoCoreProp) != null && sourceType.findProperty(hasChangedNoCoreProp).getPropertyType().equals(((BillEntityType)dataEntity.getDataEntityType()).findProperty(hasChangedNoCoreProp).getPropertyType())) {
                    relHisDyn.set(hasChangedNoCoreProp, dataEntity.get(hasChangedNoCoreProp));
                    flag = true;
                }
                if (!sourceType.equals((Object)workRoleType) || !hasChangedNoCoreProp.equals("position") && !hasChangedNoCoreProp.equals("positionvid")) continue;
                relHisDyn.set("role", dataEntity.get("position.workrole.id"));
                flag = true;
            }
            if (flag) {
                HashMap relationDyns = relationDynMap.get(sourceType.getName()) != null ? relationDynMap.get(sourceType.getName()) : Maps.newHashMapWithExpectedSize((int)16);
                relationDyns.put(relHisDyn.getString("id"), relHisDyn);
                relationDynMap.put(sourceType.getName(), relationDyns);
            }
        }
    }
}

