/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.business.helper;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hspm.business.domian.service.HSPMServiceFactory;
import kd.sdk.hr.hspm.business.helper.InfoGroupHelper;
import kd.sdk.hr.hspm.business.helper.ValueConvertHelper;
import kd.sdk.hr.hspm.common.model.FileRelationModel;
import kd.sdk.hr.hspm.common.utils.ComboItemUtil;
import kd.sdk.hr.hspm.common.utils.PersonModelUtil;
import kd.sdk.hr.hspm.common.utils.PropertyHelper;

public class FileHeadHelper {
    private static final Log LOGGER = LogFactory.getLog(FileHeadHelper.class);
    private static final String START_DATE = "startdate";
    private static final String SUPER_NAME = "supername";
    private static final String DEP_NAME = "depname";
    private static final String ORDER_BY = "startdate desc";

    public static Map<String, DynamicObject> queryDataFromDb(List<Map<String, Object>> headFieldList, FormShowParameter formShowParameter) {
        HashMap<String, DynamicObject> data = new HashMap<String, DynamicObject>(headFieldList == null ? 0 : headFieldList.size());
        if (headFieldList != null && !headFieldList.isEmpty() && formShowParameter != null) {
            Map<String, List<Map>> groupFields = headFieldList.stream().filter(val -> val.get("source") != null).filter(val -> !SUPER_NAME.equals(val.get("number")) && !DEP_NAME.equals(val.get("number"))).collect(Collectors.groupingBy(val -> (String)val.get("source")));
            for (Map.Entry<String, List<Map>> entry : groupFields.entrySet()) {
                DynamicObject[] dataArray;
                List selectProps = entry.getValue().stream().map(val -> (String)val.get("number")).collect(Collectors.toList());
                QFilter qFilter = FileHeadHelper.getQFilter(entry.getKey(), formShowParameter);
                if (qFilter == null) continue;
                qFilter.and("iscurrentversion", "=", (Object)Boolean.TRUE);
                FileHeadHelper.addtionalCondition(qFilter, entry.getKey());
                HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entry.getKey());
                if (serviceHelper.generateEmptyDynamicObject().getDataEntityType().getProperties().containsKey((Object)"initstatus")) {
                    qFilter.and("initstatus", "=", (Object)"2");
                }
                if ((dataArray = !InfoGroupHelper.isSingleRowTpl((String)entry.getKey()) && PropertyHelper.existProperty((String)entry.getKey(), (String)START_DATE) ? serviceHelper.query(String.join((CharSequence)",", selectProps), new QFilter[]{qFilter}, ORDER_BY) : serviceHelper.query(String.join((CharSequence)",", selectProps), new QFilter[]{qFilter})) == null || dataArray.length <= 0) continue;
                data.put(entry.getKey(), dataArray[0]);
            }
        }
        return data;
    }

    private static void addtionalCondition(QFilter qFilter, String entityName) {
        if ("hrpi_baselocation".equals(entityName)) {
            qFilter.and("businessstatus", "=", (Object)"1");
        }
    }

    private static QFilter getQFilter(String pageNumber, FormShowParameter formShowParameter) {
        if ("hspm_ermanfile".equals(pageNumber)) {
            Long erId = HRJSONUtils.getLongValOfCustomParam((Object)formShowParameter.getCustomParam("erfileid"));
            return new QFilter("id", "=", (Object)erId);
        }
        Map values = formShowParameter.getCustomParams();
        QFilter filter = PersonModelUtil.getQFilterForHeadArea((String)pageNumber, (Map)values);
        if (filter == null) {
            LOGGER.warn(MessageFormat.format("filter is null pageNumber:{0} values:{1}", pageNumber, JSON.toJSONString((Object)values)));
        }
        return filter;
    }

    public static String getData(Map<String, DynamicObject> data, Map<String, Object> headField) {
        DynamicObject dynamicObject;
        String number = (String)headField.get("number");
        String source = (String)headField.get("source");
        if (data != null && (dynamicObject = data.get(source)) != null && PropertyHelper.existProperty((DynamicObject)dynamicObject, (String)number)) {
            Object obj = dynamicObject.get(number);
            if (obj instanceof DynamicObject) {
                DynamicObject dy = (DynamicObject)obj;
                if (PropertyHelper.existProperty((DynamicObject)dy, (String)"name")) {
                    return dy.getString("name");
                }
                if (PropertyHelper.existProperty((DynamicObject)dy, (String)"number")) {
                    return dy.getString("number");
                }
            }
            if (obj instanceof DynamicObjectCollection) {
                String mulBaseData = ValueConvertHelper.handleMulBaseData((List)((List)obj));
                return "-".equals(mulBaseData) ? "" : mulBaseData;
            }
            if (obj != null) {
                if (obj instanceof String && "hspm_ermanfile".equals(source) && "businessstatus".equals(number)) {
                    List values = ComboItemUtil.getComboItem((String)source, (String)number);
                    if (!CollectionUtils.isEmpty((Collection)values)) {
                        for (ComboItem comboItem : values) {
                            if (!obj.toString().equals(comboItem.getValue()) || comboItem.getCaption() == null) continue;
                            return obj.toString() + ":" + comboItem.getCaption().getLocaleValue();
                        }
                    }
                } else if (obj instanceof BigDecimal) {
                    if ("servicelength".equals(number)) {
                        return ((BigDecimal)obj).setScale(1, 1).toString();
                    }
                    return ((BigDecimal)obj).setScale(1, 4).toString();
                }
                return obj.toString();
            }
        }
        return null;
    }

    public static FileRelationModel getFileRelationInfo(Long fileId) {
        FileRelationModel fileRelationModel = new FileRelationModel();
        List<Map<String, Object>> resultList = HSPMServiceFactory.ermanService.listErmanFileRelationInfos(Collections.singletonList(fileId));
        for (Map<String, Object> tmpMap : resultList) {
            fileRelationModel.setSuperList((List)tmpMap.get("superiorinfo"));
            fileRelationModel.setDepChargeInfoList((List)tmpMap.get("chargeinfo"));
        }
        return fileRelationModel;
    }
}

