/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.business.helper;

import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.hr.hspm.common.enums.FieldTypeEnum;
import kd.sdk.hr.hspm.common.utils.ComboItemUtil;
import kd.sdk.hr.hspm.common.utils.PropertyHelper;
import org.apache.commons.lang3.math.NumberUtils;

@Deprecated
public class ValueConvertHelper {
    private static final Log LOGGER = LogFactory.getLog(ValueConvertHelper.class);
    private static final String BASE_PROPS = "number,name";

    public static String showString(String entityName, String fieldName, String fieldType, String extraInfo, String value) {
        if (HRStringUtils.isEmpty((String)value)) {
            return value;
        }
        FieldTypeEnum fieldTypeEnum = FieldTypeEnum.geCodeByFieldType((String)fieldType);
        if (fieldTypeEnum != null) {
            switch (fieldTypeEnum) {
                case BILL_STATUS: 
                case COMBO: {
                    return ValueConvertHelper.handleCombo(entityName, fieldName, value);
                }
                case DATE: 
                case CREATE_DATE: 
                case MODIFY_DATE: {
                    return ValueConvertHelper.handleDate(value);
                }
                case DATE_TIME: {
                    return HRDateTimeUtils.format((Date)new Timestamp(Long.parseLong(value)), (String)"yyyy-MM-dd HH:mm:ss");
                }
                case BOOLEAN: {
                    return ValueConvertHelper.handleBoolean(value);
                }
                case BASE_DATA: 
                case CREATER: 
                case MODIFIER: 
                case USER: 
                case CITY: 
                case MAIN_ORG: 
                case Currency: 
                case ORGPROP: 
                case QueryProp: 
                case ADDRESSPROP: {
                    return ValueConvertHelper.handleBaseData(value, extraInfo);
                }
            }
        }
        return value;
    }

    private static String handleDate(String value) {
        Timestamp date = new Timestamp(Long.parseLong(value));
        return HRDateTimeUtils.format((Date)date, (String)"yyyy-MM-dd");
    }

    public static String handleCombo(String entityName, String fieldName, String value) {
        List items = ComboItemUtil.getComboItem((String)entityName, (String)fieldName);
        if (!CollectionUtils.isEmpty((Collection)items)) {
            for (ComboItem comboItem : items) {
                if (!value.equals(comboItem.getValue())) continue;
                return comboItem.getCaption().getLocaleValue();
            }
        }
        return value;
    }

    public static String handleBoolean(String value) {
        return Boolean.parseBoolean(value) ? ResManager.loadKDString((String)"\u662f", (String)"FieldShowHelper_0", (String)"hr-hspm-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"FieldShowHelper_1", (String)"hr-hspm-business", (Object[])new Object[0]);
    }

    private static String handleBaseData(String value, String extraInfo) {
        if (HRStringUtils.isNotEmpty((String)extraInfo)) {
            try {
                HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper(extraInfo);
                DynamicObject dynamicObject = baseServiceHelper.queryOne(BASE_PROPS, (Object)Long.valueOf(value));
                if (!HRObjectUtils.isEmpty((Object)dynamicObject)) {
                    if (PropertyHelper.existProperty((DynamicObject)dynamicObject, (String)"name")) {
                        return dynamicObject.getString("name");
                    }
                    if (PropertyHelper.existProperty((DynamicObject)dynamicObject, (String)"number")) {
                        return dynamicObject.getString("number");
                    }
                }
            }
            catch (Exception exception) {
                LOGGER.error(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u6570\u636e\u5f02\u5e38\u3002", (String)"FieldShowHelper_2", (String)"hr-hspm-business", (Object[])new Object[0]), (Throwable)exception);
            }
        }
        return value;
    }

    public static void setValue(DynamicObject updateDy, String fieldName, String fieldType, String value) {
        FieldTypeEnum fieldTypeEnum = NumberUtils.isCreatable((String)fieldType) ? FieldTypeEnum.geCodeByFieldType((String)fieldType) : FieldTypeEnum.getFieldTypeBySimpleCode((String)fieldType);
        if (fieldTypeEnum == null) {
            LOGGER.error(MessageFormat.format("cant not found the fieldtype[{0}]", fieldType));
            throw new KDBizException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u8be5\u6570\u636e\u7c7b\u578b\u3002", (String)"ValueConvertHelper_0", (String)"hr-hspm-business", (Object[])new Object[0]));
        }
        if (!PropertyHelper.existProperty((DynamicObject)updateDy, (String)fieldName)) {
            return;
        }
        if (HRStringUtils.isEmpty((String)value)) {
            updateDy.set(fieldName, null);
            return;
        }
        try {
            switch (fieldTypeEnum) {
                case MULILANG_TEXT: {
                    OrmLocaleValue ormLocaleValue = (OrmLocaleValue)updateDy.get(fieldName);
                    ormLocaleValue.setLocaleValue(value);
                    updateDy.set(fieldName, (Object)ormLocaleValue);
                    break;
                }
                case TEXT: {
                    updateDy.set(fieldName, (Object)value);
                    break;
                }
                case COMBO: {
                    updateDy.set(fieldName, (Object)value);
                    break;
                }
                case BOOLEAN: {
                    updateDy.set(fieldName, (Object)Boolean.parseBoolean(value));
                    break;
                }
                case DATE: {
                    updateDy.set(fieldName, (Object)new Timestamp(Long.parseLong(value)));
                    break;
                }
                case LONG: {
                    updateDy.set(fieldName, (Object)Long.parseLong(value));
                    break;
                }
                case INTEGER: 
                case BIG_INT: {
                    updateDy.set(fieldName, (Object)Integer.parseInt(value));
                    break;
                }
                case BASE_DATA: 
                case CREATER: 
                case MODIFIER: 
                case USER: 
                case CITY: 
                case MAIN_ORG: 
                case Currency: 
                case ORGPROP: 
                case QueryProp: 
                case ADDRESSPROP: {
                    BasedataProp prop = (BasedataProp)updateDy.getDynamicObjectType().getProperties().get((Object)fieldName);
                    HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(prop.getBaseEntityId());
                    DynamicObject data = hrBaseServiceHelper.queryOne(BASE_PROPS, (Object)Long.valueOf(value));
                    if (HRObjectUtils.isEmpty((Object)data)) {
                        updateDy.set(fieldName, (Object)Long.valueOf(value));
                        break;
                    }
                    updateDy.set(fieldName, (Object)data);
                    break;
                }
            }
        }
        catch (Exception exception) {
            throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u6570\u636e\u8f6c\u6362\u5931\u8d25 fieldName:{0}", (String)"ValueConvertHelper_1", (String)"hr-hspm-business", (Object[])new Object[0]), fieldName));
        }
    }
}

