/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.business.infogroup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sdk.hr.hspm.business.helper.InfoGroupHelper;

public class HeadFieldHelper {
    private static final HRBaseServiceHelper HEADFIELD_HEPLER = new HRBaseServiceHelper("hspm_headfield");
    private static final String SELECT_PROPERTIS = "source,number,name,configurable,istagshow";
    private static final Integer FIRST_SPLIT_INDEX = 10;
    private static final Integer TWO_SPLIT__INDEX = 91;
    private static final String KEY_INDEX = "index";

    public static void setDefaultHeadField(IFormView view) {
        QFilter filter = new QFilter("defaultfield", "=", (Object)Character.valueOf('1')).and("status", "=", (Object)"C").and("enable", "=", (Object)"1").and(InfoGroupHelper.getBusinessTypeFilter((IFormView)view));
        DynamicObject[] dyArray = HEADFIELD_HEPLER.query(SELECT_PROPERTIS, new QFilter[]{filter}, KEY_INDEX);
        if (dyArray != null && dyArray.length > 0) {
            HeadFieldHelper.appendHeadEntity(view.getModel(), dyArray);
        }
    }

    public static void setBaseProperty(IFormView view) {
        DynamicObjectCollection dynamicObjects = view.getModel().getEntryEntity("headentity");
        if (!CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            IDataModel dataModel = view.getModel();
            for (int index = 0; index < dynamicObjects.size(); ++index) {
                DynamicObject field = ((DynamicObject)dynamicObjects.get(index)).getDynamicObject("fieldname");
                if (field == null) continue;
                if (field.getBoolean("configurable")) {
                    dataModel.setValue("configurable", (Object)"1", index);
                }
                if (InfoGroupHelper.isEmployee((IDataModel)view.getModel()) || !field.getBoolean("istagshow")) continue;
                dataModel.setValue("istagshow", (Object)"1", index);
            }
        }
    }

    public static int getFirstGroupEndIndex(IFormView view) {
        int index;
        DynamicObjectCollection dynamicObjects = view.getModel().getEntryEntity("headentity");
        if (!CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            DynamicObject field;
            for (index = 0; index < dynamicObjects.size() && ((field = ((DynamicObject)dynamicObjects.get(index)).getDynamicObject("fieldname")) == null || field.getInt(KEY_INDEX) <= FIRST_SPLIT_INDEX); ++index) {
            }
        }
        return --index;
    }

    public static int getThirdGroupStartIndex(IFormView view) {
        DynamicObjectCollection dynamicObjects = view.getModel().getEntryEntity("headentity");
        if (!CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            DynamicObject field;
            int index;
            for (index = dynamicObjects.size() - 1; index > 0 && ((field = ((DynamicObject)dynamicObjects.get(index)).getDynamicObject("fieldname")) == null || field.getInt(KEY_INDEX) >= TWO_SPLIT__INDEX); --index) {
            }
            return index + 1;
        }
        return -1;
    }

    public static int getThirdGroupStartIndex(List<DynamicObject> dynamicObjects) {
        if (!CollectionUtils.isEmpty(dynamicObjects)) {
            DynamicObject field;
            int index;
            for (index = dynamicObjects.size() - 1; index > 0 && ((field = dynamicObjects.get(index).getDynamicObject("fieldname")) == null || field.getInt(KEY_INDEX) >= TWO_SPLIT__INDEX); --index) {
            }
            return index + 1;
        }
        return -1;
    }

    public static int appendHeadEntity(IDataModel dataModel, DynamicObject[] dys) {
        int entitySize;
        int oldEndIndex = entitySize = dataModel.getEntryEntity("headentity").size();
        dataModel.batchCreateNewEntryRow("headentity", dys.length);
        boolean employee = InfoGroupHelper.isEmployee((IDataModel)dataModel);
        for (DynamicObject dynamicObject : dys) {
            dataModel.setValue("fieldname", (Object)dynamicObject, entitySize);
            if (employee && "headsculpture".equals(dynamicObject.getString("number"))) {
                dataModel.setValue("headisedit", (Object)Boolean.TRUE, entitySize);
            }
            if (dynamicObject.getBoolean("configurable")) {
                dataModel.setValue("configurable", (Object)"1", entitySize);
            }
            if (!employee && dynamicObject.getBoolean("istagshow")) {
                dataModel.setValue("istagshow", (Object)"1", entitySize);
            }
            ++entitySize;
        }
        return oldEndIndex;
    }

    public static void addHeadFields(IFormView view, DynamicObjectCollection selectList) {
        DynamicObject[] dys = (DynamicObject[])selectList.stream().map(val -> val.getDynamicObject("fbasedataid")).toArray(DynamicObject[]::new);
        HeadFieldHelper.appendConfigurableField(view, dys);
    }

    public static void appendConfigurableField(IFormView view, DynamicObject[] dys) {
        if (InfoGroupHelper.isEmployee((IDataModel)view.getModel())) {
            for (DynamicObject dynamicObject : dys) {
                DynamicObjectCollection dynamicObjects = view.getModel().getEntryEntity("headentity");
                int oldEntitySize = HeadFieldHelper.appendHeadEntity(view.getModel(), new DynamicObject[]{dynamicObject});
                if (!CollectionUtils.isEmpty((Collection)dynamicObjects)) {
                    int index = dynamicObject.getInt(KEY_INDEX);
                    for (int i = 0; i < dynamicObjects.size(); ++i) {
                        DynamicObject field;
                        DynamicObject currentDy = (DynamicObject)dynamicObjects.get(i);
                        if (currentDy == null || currentDy.getDynamicObject("fieldname") == null || (field = currentDy.getDynamicObject("fieldname")).getInt(KEY_INDEX) <= index) continue;
                        HeadFieldHelper.moveEntryRowsDown(view, i, oldEntitySize, 1);
                        break;
                    }
                }
                view.getModel().updateCache();
            }
            return;
        }
        DynamicObjectCollection entryEntity = view.getModel().getEntryEntity("headentity");
        List<DynamicObject> dynamicObjects = entryEntity.stream().collect(Collectors.toList());
        int oldEntitySize = HeadFieldHelper.appendHeadEntity(view.getModel(), dys);
        int thirdGroupStartIndex = HeadFieldHelper.getThirdGroupStartIndex(dynamicObjects);
        if (thirdGroupStartIndex > -1) {
            HeadFieldHelper.moveEntryRowsDown(view, thirdGroupStartIndex, oldEntitySize, dys.length);
        }
    }

    private static void moveEntryRowsDown(IFormView view, int begin, int end, int count) {
        int i;
        int[] rows = new int[end - begin];
        for (i = 0; i < rows.length; ++i) {
            rows[i] = begin++;
        }
        for (i = 0; i < count; ++i) {
            view.getModel().moveEntryRowsDown("headentity", rows);
            if (i + 1 >= count) continue;
            int[] oldRows = rows;
            rows = new int[rows.length];
            for (int j = 0; j < oldRows.length; ++j) {
                rows[j] = oldRows[j] + 1;
            }
        }
    }

    public static void deleteEntryRows(IFormView view) {
        int thirdGroupStartIndex;
        EntryGrid entryGrid = (EntryGrid)view.getControl("headentity");
        int[] rows = entryGrid.getSelectRows();
        if (rows == null || rows.length == 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e\u3002", (String)"HeadFieldHelper_4", (String)"hr-hspm-business", (Object[])new Object[0]));
            return;
        }
        int firstGroupEndIndex = HeadFieldHelper.getFirstGroupEndIndex(view);
        int[] rowArray = HeadFieldHelper.filterNotConfigurable(firstGroupEndIndex, thirdGroupStartIndex = HeadFieldHelper.getThirdGroupStartIndex(view), rows);
        if (rowArray == null) {
            if (InfoGroupHelper.isEmployee((IDataModel)view.getModel())) {
                view.showTipNotification(ResManager.loadKDString((String)"\u201c\u5934\u50cf\u3001\u59d3\u540d\u3001\u5de5\u53f7\u201d\u4e0d\u53ef\u64cd\u4f5c\u5220\u9664\u3002", (String)"HeadFieldHelper_6", (String)"hr-hspm-business", (Object[])new Object[0]));
            } else {
                view.showTipNotification(ResManager.loadKDString((String)"\u201c\u5934\u50cf\u3001\u59d3\u540d\u3001\u5de5\u53f7\u3001\u6027\u522b\u3001\u76f4\u63a5\u4e0a\u7ea7\u3001\u90e8\u95e8\u8d1f\u8d23\u4eba\u3001\u6863\u6848\u72b6\u6001\u201d\u4e0d\u53ef\u64cd\u4f5c\u5220\u9664\u3002", (String)"HeadFieldHelper_5", (String)"hr-hspm-business", (Object[])new Object[0]));
            }
            return;
        }
        view.getModel().deleteEntryRows("headentity", rowArray);
        entryGrid.selectRows(-1);
    }

    public static void moveEntryRows(IFormView view, boolean isUp) {
        int thirdGroupStartIndex;
        EntryGrid entryGrid = (EntryGrid)view.getControl("headentity");
        int[] rows = entryGrid.getSelectRows();
        if (rows == null || rows.length == 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u79fb\u52a8\u7684\u6570\u636e\u3002", (String)"HeadFieldHelper_0", (String)"hr-hspm-business", (Object[])new Object[0]));
            return;
        }
        int firstGroupEndIndex = HeadFieldHelper.getFirstGroupEndIndex(view);
        int[] rowArray = HeadFieldHelper.filterNotConfigurable(firstGroupEndIndex, thirdGroupStartIndex = HeadFieldHelper.getThirdGroupStartIndex(view), rows);
        if (rowArray == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u201c\u5934\u50cf\u3001\u59d3\u540d\u3001\u5de5\u53f7\u3001\u6027\u522b\u3001\u76f4\u63a5\u4e0a\u7ea7\u3001\u90e8\u95e8\u8d1f\u8d23\u4eba\u3001\u6863\u6848\u72b6\u6001\u201d\u4e0d\u53ef\u64cd\u4f5c\u4e0a\u79fb\u6216\u4e0b\u79fb\u3002", (String)"HeadFieldHelper_1", (String)"hr-hspm-business", (Object[])new Object[0]));
            return;
        }
        if (isUp) {
            if (rowArray[0] - 1 <= firstGroupEndIndex) {
                view.showTipNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u4e0a\u79fb\u81f3\u4e0d\u53ef\u914d\u7f6e\u5b57\u6bb5\uff08\u5982\uff1a\u5934\u50cf\u3001\u59d3\u540d\u3001\u5de5\u53f7\u3001\u6027\u522b\uff09\u4e4b\u524d\u3002", (String)"HeadFieldHelper_2", (String)"hr-hspm-business", (Object[])new Object[0]));
                return;
            }
            view.getModel().moveEntryRowsUp("headentity", rowArray);
        } else {
            if (rowArray[rowArray.length - 1] + 1 >= thirdGroupStartIndex) {
                view.showTipNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u4e0b\u79fb\u81f3\u4e0d\u53ef\u914d\u7f6e\u5b57\u6bb5\uff08\u5982\uff1a\u76f4\u63a5\u4e0a\u7ea7\u3001\u90e8\u95e8\u8d1f\u8d23\u4eba\u3001\u6863\u6848\u72b6\u6001\uff09\u4e4b\u540e\u3002", (String)"HeadFieldHelper_3", (String)"hr-hspm-business", (Object[])new Object[0]));
                return;
            }
            view.getModel().moveEntryRowsDown("headentity", rowArray);
        }
    }

    private static int[] filterNotConfigurable(int firstGroupEndIndex, int thirdGroupStartIndex, int[] rows) {
        ArrayList<Integer> rowList = new ArrayList<Integer>(rows.length);
        for (int index = 0; index < rows.length; ++index) {
            if (rows[index] <= firstGroupEndIndex || rows[index] >= thirdGroupStartIndex) continue;
            rowList.add(rows[index]);
        }
        if (!CollectionUtils.isEmpty(rowList)) {
            int[] rowArray = new int[rowList.size()];
            for (int index = 0; index < rowList.size(); ++index) {
                rowArray[index] = (Integer)rowList.get(index);
            }
            return rowArray;
        }
        return null;
    }
}

