/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.business.infogroup;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hspm.business.infogroup.InfoGroupFieldHelper;
import kd.sdk.hr.hspm.business.helper.InfoGroupHelper;
import kd.sdk.hr.hspm.common.enums.ConfigAreaEnum;
import kd.sdk.hr.hspm.common.enums.InfoGroupFieldCategroyEnum;

public class InfoGroupSynAndValidatorHelper {
    public static Tuple<Boolean, String> synAndValidate(IFormView view) {
        DynamicObjectCollection dysDB = view.getModel().getEntryEntity("groupentity");
        dysDB.clear();
        Tuple<Boolean, String> mainResult = InfoGroupSynAndValidatorHelper.synAndValidate(view, true, dysDB);
        if (!((Boolean)mainResult.item1).booleanValue()) {
            return mainResult;
        }
        if (!InfoGroupHelper.isEmployee((IDataModel)view.getModel())) {
            Tuple<Boolean, String> sideResult = InfoGroupSynAndValidatorHelper.synAndValidate(view, false, dysDB);
            if (!((Boolean)sideResult.item1).booleanValue()) {
                return sideResult;
            }
        }
        view.getModel().updateEntryCache(dysDB);
        return Tuple.create((Object)Boolean.TRUE, null);
    }

    private static Tuple<Boolean, String> synAndValidate(IFormView view, boolean isMainArea, DynamicObjectCollection dysDB) {
        String entityKey = InfoGroupHelper.getCurrentEntityKey((boolean)isMainArea);
        DynamicObjectCollection dynamicObjects = view.getModel().getEntryEntity(entityKey);
        if (CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            return Tuple.create((Object)Boolean.FALSE, (Object)InfoGroupSynAndValidatorHelper.getErrorMessageWhenNotData(isMainArea));
        }
        Map<String, DynamicObject> eduMap = InfoGroupSynAndValidatorHelper.getEduGroup(view, isMainArea);
        List subEntryProps = InfoGroupHelper.getSubEntryProp((DataEntityPropertyCollection)dynamicObjects.getDynamicObjectType().getProperties());
        String prex = InfoGroupHelper.getConfigArea((boolean)isMainArea).getCode();
        String groupIdKey = prex + "groupid";
        int size = dynamicObjects.size();
        HashSet<String> groupSet = new HashSet<String>();
        for (int i = 0; i < size; ++i) {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(i);
            String groupId = dynamicObject.getString(groupIdKey);
            if ("root".equals(groupId) || groupSet.contains(groupId)) {
                if (size != 1) continue;
                return Tuple.create((Object)Boolean.FALSE, (Object)InfoGroupSynAndValidatorHelper.getErrorMessageWhenNotData(isMainArea));
            }
            groupSet.add(groupId);
            DynamicObject eduDy = eduMap.get(groupId);
            if (eduDy != null && "hrpi_pereduexpcert".equals(eduDy.getString("pageinfo.number"))) {
                String relationGroup = dynamicObject.getString(prex + "relation");
                boolean exist = false;
                if (HRStringUtils.isNotEmpty((String)relationGroup)) {
                    String[] relationGroupArray;
                    for (String relation : relationGroupArray = relationGroup.split(",")) {
                        eduDy = eduMap.get(relation);
                        if (eduDy == null || !"hrpi_pereduexp".equals(eduDy.getString("pageinfo.number"))) continue;
                        exist = true;
                        break;
                    }
                }
                if (!exist) {
                    return Tuple.create((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u4e0d\u53ef\u5355\u72ec\u914d\u7f6e\u201c\u6559\u80b2\u8bc1\u4ef6\u201d\u4fe1\u606f\u7ec4\uff0c\u8bf7\u5173\u8054\u201c\u6559\u80b2\u7ecf\u5386\u201d\u4fe1\u606f\u7ec4\u3002", (String)"InfoGroupSynAndValidatorHelper_7", (String)"hr-hspm-business", (Object[])new Object[0]));
                }
            }
            DynamicObject dyDB = dysDB.addNew();
            InfoGroupSynAndValidatorHelper.synGroup(dynamicObject, dyDB, isMainArea);
            if (!groupId.startsWith("sub_") && !CollectionUtils.isEmpty((Collection)InfoGroupHelper.getSubGroupIds((DynamicObjectCollection)dynamicObjects, (String)groupId))) continue;
            boolean has = false;
            for (SubEntryProp subEntryProp : subEntryProps) {
                DynamicObjectCollection fields = (DynamicObjectCollection)subEntryProp.getValue((Object)dynamicObject);
                if (InfoGroupHelper.existDefaultRow((DynamicObjectCollection)fields)) {
                    fields.remove(0);
                }
                if (CollectionUtils.isEmpty((Collection)fields)) continue;
                DynamicObjectCollection subDysDB = InfoGroupSynAndValidatorHelper.getSubDysDB(dyDB);
                InfoGroupSynAndValidatorHelper.synField(fields, subDysDB, isMainArea);
                has = true;
            }
            if (has) continue;
            return Tuple.create((Object)Boolean.FALSE, (Object)InfoGroupSynAndValidatorHelper.getErrorMessageWhenNotField(dynamicObject, prex));
        }
        return Tuple.create((Object)Boolean.TRUE, null);
    }

    private static Map<String, DynamicObject> getEduGroup(IFormView view, boolean isMainArea) {
        Long typeId = view.getModel().getDataEntity().getDynamicObject("erfiletype").getLong("id");
        DynamicObject[] availableGroupArray = InfoGroupFieldHelper.getAvailableGroup(typeId, InfoGroupHelper.getConfigArea((boolean)isMainArea).getValue(), InfoGroupHelper.isEmployee((IDataModel)view.getModel()), Arrays.asList("hrpi_pereduexp", "hrpi_pereduexpcert"));
        if (availableGroupArray != null && availableGroupArray.length > 0) {
            HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(availableGroupArray.length);
            for (DynamicObject dynamicObject : availableGroupArray) {
                String pageNumber = dynamicObject.getString("pageinfo.number");
                if (!"hrpi_pereduexp".equals(pageNumber) && !"hrpi_pereduexpcert".equals(pageNumber)) continue;
                map.put(dynamicObject.getString("id"), dynamicObject);
            }
            return map;
        }
        return new HashMap<String, DynamicObject>(0);
    }

    private static String getErrorMessageWhenNotData(boolean isMainArea) {
        return isMainArea ? ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u6863\u6848\u4e3b\u9875\u533a\u57df\u7684\u4fe1\u606f\u7ec4\u3002", (String)"InfoGroupSynAndValidatorHelper_0", (String)"hr-hspm-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u6863\u6848\u4fa7\u8fb9\u680f\u533a\u57df\u7684\u4fe1\u606f\u7ec4\u3002", (String)"InfoGroupSynAndValidatorHelper_1", (String)"hr-hspm-business", (Object[])new Object[0]);
    }

    private static String getErrorMessageWhenNotField(DynamicObject dynamicObject, String prex) {
        ILocaleString groupName = dynamicObject.getLocaleString(prex + "groupname");
        if (ConfigAreaEnum.MAIN.getCode().equals(prex)) {
            return String.format(ResManager.loadKDString((String)"\u6863\u6848\u4e3b\u9875\u533a\u57df\u7684\u201c%s\u201d\u4fe1\u606f\u7ec4\u6ca1\u6709\u914d\u7f6e\u5b57\u6bb5\u3002", (String)"InfoGroupSynAndValidatorHelper_2", (String)"hr-hspm-business", (Object[])new Object[0]), groupName.getLocaleValue());
        }
        return String.format(ResManager.loadKDString((String)"\u6863\u6848\u4fa7\u8fb9\u680f\u533a\u57df\u7684\u201c%s\u201d\u4fe1\u606f\u7ec4\u6ca1\u6709\u914d\u7f6e\u5b57\u6bb5\u3002", (String)"InfoGroupSynAndValidatorHelper_3", (String)"hr-hspm-business", (Object[])new Object[0]), groupName.getLocaleValue());
    }

    private static DynamicObjectCollection getSubDysDB(DynamicObject dyDB) {
        DataEntityPropertyCollection properties = dyDB.getDynamicObjectType().getProperties();
        List list = InfoGroupHelper.getSubEntryProp((DataEntityPropertyCollection)properties);
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new KDBizException("error");
        }
        return (DynamicObjectCollection)((SubEntryProp)list.get(0)).getValue((Object)dyDB);
    }

    private static void synField(DynamicObjectCollection from, DynamicObjectCollection to, boolean isMainArea) {
        ConfigAreaEnum configAreaEnum = InfoGroupHelper.getConfigArea((boolean)isMainArea);
        String prex = configAreaEnum.getCode();
        InfoGroupFieldCategroyEnum fieldCategroyEnum = InfoGroupFieldCategroyEnum.getByFuzzyCode((String)from.getDynamicObjectType().getName());
        String category = fieldCategroyEnum.getCode();
        String categoryValue = fieldCategroyEnum.getValue();
        int seq = 1;
        for (DynamicObject field : from) {
            DynamicObject newDy = to.addNew();
            newDy.set("field", field.get(prex + "fieldname" + category));
            newDy.set("isedit", field.get(prex + "isedit" + category));
            newDy.set("isrequired", field.get(prex + "isrequired" + category));
            newDy.set("isaudit", field.get(prex + "isaudit" + category));
            newDy.set("displayname", field.get(prex + "displayname" + category));
            if (InfoGroupFieldCategroyEnum.ATTACH == fieldCategroyEnum) {
                newDy.set("shownum", field.get(prex + "shownumattach"));
            } else if (InfoGroupFieldCategroyEnum.IMG == fieldCategroyEnum) {
                newDy.set("shownum", field.get(prex + "shownumimg"));
            }
            newDy.set("fieldtype", (Object)categoryValue);
            newDy.set("seq", (Object)seq++);
        }
    }

    private static void synGroup(DynamicObject from, DynamicObject to, boolean isMainArea) {
        ConfigAreaEnum configAreaEnum = InfoGroupHelper.getConfigArea((boolean)isMainArea);
        String prex = configAreaEnum.getCode();
        to.set("groupid", from.get(prex + "groupid"));
        to.set("parentgroupid", from.get(prex + "parentgroupid"));
        to.set("groupname", from.get(prex + "groupname"));
        to.set("relation", from.get(prex + "relation"));
        to.set("allisedit", from.get(prex + "allisedit"));
        to.set("allisrequired", from.get(prex + "allisrequired"));
        to.set("isallowadd", from.get(prex + "isallowadd"));
        to.set("allisaudit", from.get(prex + "allisaudit"));
        if (isMainArea && HRStringUtils.isNotEmpty((String)from.getString("mainconfigarea"))) {
            to.set("configarea", (Object)from.getString("mainconfigarea"));
        } else {
            to.set("configarea", (Object)configAreaEnum.getValue());
        }
    }

    public static void synFromDbEntity(IFormView view) {
        DynamicObjectCollection dysDB = view.getModel().getEntryEntity("groupentity");
        if (CollectionUtils.isEmpty((Collection)dysDB)) {
            return;
        }
        InfoGroupSynAndValidatorHelper.synFromDbEntity(view, true, dysDB);
        if (!InfoGroupHelper.isEmployee((IDataModel)view.getModel())) {
            InfoGroupSynAndValidatorHelper.synFromDbEntity(view, false, dysDB);
        }
    }

    private static void synFromDbEntity(IFormView view, boolean isMainArea, DynamicObjectCollection dysDB) {
        ConfigAreaEnum configAreaEnum = InfoGroupHelper.getConfigArea((boolean)isMainArea);
        String entityKey = InfoGroupHelper.getCurrentEntityKey((boolean)isMainArea);
        DynamicObjectCollection dynamicObjects = view.getModel().getEntryEntity(entityKey);
        dynamicObjects.clear();
        view.getPageCache().put("root" + configAreaEnum.getCode(), null);
        DataEntityPropertyCollection properties = dynamicObjects.getDynamicObjectType().getProperties();
        Map subEntryPropMap = InfoGroupHelper.changeToSubEntryPropsMap((List)InfoGroupHelper.getSubEntryProp((DataEntityPropertyCollection)properties));
        for (DynamicObject dyDB : dysDB) {
            String configArea = dyDB.getString("configarea");
            boolean suitArea = configAreaEnum.getValue().equals(configArea) || isMainArea && ConfigAreaEnum.COMMON.getValue().equals(configArea);
            if (!suitArea) continue;
            DynamicObject newDy = dynamicObjects.addNew();
            InfoGroupSynAndValidatorHelper.synGroupFromDbEntity(dyDB, newDy, isMainArea);
            DynamicObjectCollection subDysDB = InfoGroupSynAndValidatorHelper.getSubDysDB(dyDB);
            for (DynamicObject dynamicObject : subDysDB) {
                String fieldType = dynamicObject.getString("fieldtype");
                SubEntryProp subEntryProp = (SubEntryProp)subEntryPropMap.get(fieldType);
                if (subEntryProp == null) continue;
                DynamicObjectCollection fields = (DynamicObjectCollection)subEntryProp.getValue((Object)newDy);
                InfoGroupSynAndValidatorHelper.synFieldFromDbEntity(dynamicObject, fields, isMainArea);
            }
        }
    }

    private static void synGroupFromDbEntity(DynamicObject from, DynamicObject to, boolean isMainArea) {
        ConfigAreaEnum configAreaEnum = InfoGroupHelper.getConfigArea((boolean)isMainArea);
        String prex = configAreaEnum.getCode();
        to.set(prex + "groupid", from.get("groupid"));
        to.set(prex + "parentgroupid", from.get("parentgroupid"));
        to.set(prex + "groupname", from.get("groupname"));
        to.set(prex + "relation", from.get("relation"));
        to.set(prex + "allisedit", from.get("allisedit"));
        to.set(prex + "isallowadd", from.get("isallowadd"));
        to.set(prex + "allisrequired", from.get("allisrequired"));
        to.set(prex + "allisaudit", from.get("allisaudit"));
        if (isMainArea) {
            to.set("mainconfigarea", from.get("configarea"));
        }
    }

    private static void synFieldFromDbEntity(DynamicObject from, DynamicObjectCollection to, boolean isMainArea) {
        ConfigAreaEnum configAreaEnum = InfoGroupHelper.getConfigArea((boolean)isMainArea);
        String prex = configAreaEnum.getCode();
        InfoGroupFieldCategroyEnum fieldCategroyEnum = InfoGroupFieldCategroyEnum.getByFuzzyCode((String)to.getDynamicObjectType().getName());
        String category = fieldCategroyEnum.getCode();
        DynamicObject newDy = to.addNew();
        newDy.set(prex + "fieldname" + category, from.get("field"));
        newDy.set(prex + "isedit" + category, from.get("isedit"));
        newDy.set(prex + "isrequired" + category, from.get("isrequired"));
        newDy.set(prex + "isaudit" + category, from.get("isaudit"));
        newDy.set(prex + "displayname" + category, from.get("displayname"));
        if (InfoGroupFieldCategroyEnum.ATTACH == fieldCategroyEnum) {
            newDy.set(prex + "shownumattach", from.get("shownum"));
        } else if (InfoGroupFieldCategroyEnum.IMG == fieldCategroyEnum) {
            newDy.set(prex + "shownumimg", from.get("shownum"));
        }
    }
}

