/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.business.mobile;

import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.PictureField;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.hr.hbp.common.control.HRFlexPanelAp;
import kd.hr.hbp.common.control.HRLabelAp;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.sdk.hr.hspm.common.dto.ChangeDto;
import kd.sdk.hr.hspm.common.enums.FieldTypeEnum;

public class ChangeRecordDrawHelper {
    private static final String BEFORE = "before";
    private static final String AFTER = "after";
    private static final String TITLE = "title";
    private static final String CHANGLABEL_ROW = "changlabelrow";
    private static final String CHANGLABEL = "changlabel";
    private static final String ROW = "row";
    private static final String CONTENT = "content";
    private static final Log LOGGER = LogFactory.getLog(ChangeRecordDrawHelper.class);

    public static FlexPanelAp createContainer(String contentFlexKey) {
        return new HRFlexPanelAp.Builder(contentFlexKey).setName(contentFlexKey).setShrink(1).setGrow(1).setWidth("100%").setWrap(false).setDirection("column").build();
    }

    public static FlexPanelAp createCardContainer(String key) {
        return new HRFlexPanelAp.Builder(key).setName(key).setGrow(0).setShrink(1).setWidth("100%").setWrap(false).setDirection("column").build();
    }

    public static FlexPanelAp createTitleContainer(String key, Map<String, Object> changeMap) {
        FlexPanelAp titleContainer = new HRFlexPanelAp.Builder(key).setName(key).setGrow(0).setShrink(1).setDirection(ROW).setWrap(true).setHeight("44px").setWidth("100%").build();
        Date modifytime = (Date)changeMap.get("modifytime");
        String modifytimeStr = modifytime != null ? HRDateTimeUtils.formatDate((Date)modifytime) : "";
        String modifyTimeContent = MessageFormat.format(ResManager.loadKDString((String)"\u53d8\u66f4\u751f\u6548\u65e5\u671f\uff1a{0}", (String)"ChangeRecordDrawHelper_2", (String)"hr-hspm-business", (Object[])new Object[0]), modifytimeStr);
        titleContainer.getItems().add(ChangeRecordDrawHelper.createTitleLabel(key + "modifytime", modifyTimeContent, true));
        String modifier = (String)changeMap.get("modifier");
        String modifierContent = MessageFormat.format(ResManager.loadKDString((String)"\u53d8\u66f4\u4eba\uff1a{0}", (String)"ChangeRecordDrawHelper_3", (String)"hr-hspm-business", (Object[])new Object[0]), modifier);
        titleContainer.getItems().add(ChangeRecordDrawHelper.createTitleLabel(key + "modifier", modifierContent, false));
        return titleContainer;
    }

    private static LabelAp createTitleLabel(String key, String content, boolean first) {
        LabelAp titleLabelAp = new LabelAp();
        titleLabelAp.setId(key);
        titleLabelAp.setKey(key);
        titleLabelAp.setShrink(1);
        titleLabelAp.setGrow(0);
        titleLabelAp.setFontSize(12);
        titleLabelAp.setForeColor("#666666");
        titleLabelAp.setLineHeight("18px");
        titleLabelAp.setName(new LocaleString(content));
        Style style = new Style();
        Margin margin = new Margin();
        margin.setLeft("12px");
        margin.setTop("18px");
        margin.setBottom("8px");
        style.setMargin(margin);
        titleLabelAp.setStyle(style);
        return titleLabelAp;
    }

    public static FlexPanelAp createCardContentContainer(String key, Map<String, Object> changeMap, IFormView formView) {
        FlexPanelAp flex = ((HRFlexPanelAp.Builder)((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder(key).setName(key).setGrow(0).setShrink(1).setWrap(false).setDirection("column").setWidth("100%").setPaddingLeft("12px")).setPaddingRight("12px")).build();
        String keyBefore = key + BEFORE;
        FlexPanelAp beforeFlex = ChangeRecordDrawHelper.getChangeShowFlex(key, true);
        String keyAfter = key + AFTER;
        FlexPanelAp afterFlex = ChangeRecordDrawHelper.getChangeShowFlex(key, false);
        List changeList = (List)changeMap.get("value");
        long num = 1L;
        for (ChangeDto changeDto : changeList) {
            beforeFlex.getItems().add(ChangeRecordDrawHelper.createRowData(true, changeDto, keyBefore, num, formView));
            afterFlex.getItems().add(ChangeRecordDrawHelper.createRowData(false, changeDto, keyAfter, num, formView));
            ++num;
        }
        flex.getItems().add(beforeFlex);
        flex.getItems().add(afterFlex);
        return flex;
    }

    private static FlexPanelAp getChangeShowFlex(String preKey, boolean isBefore) {
        String key = preKey + TITLE;
        String LableName = isBefore ? ResManager.loadKDString((String)"\u53d8\u66f4\u524d", (String)"ChangeRecordDrawHelper_0", (String)"hr-hspm-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u53d8\u66f4\u540e", (String)"ChangeRecordDrawHelper_1", (String)"hr-hspm-business", (Object[])new Object[0]);
        HRFlexPanelAp.Builder builder = new HRFlexPanelAp.Builder(key).setName(key).setGrow(0).setShrink(0).setWrap(false).setDirection("column").setAlignItems("stretch").setWidth("100%").setRadius("8px").setBackColor("#ffffff");
        if (!isBefore) {
            builder.setMarginTop("12px");
        }
        FlexPanelAp changeShowFlex = builder.build();
        FlexPanelAp rowFlex = ((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder(key + CHANGLABEL_ROW).setGrow(1).setShrink(1).setWrap(false).setDirection(ROW).setAlignItems("stretch").setMarginBottom("12px")).build();
        String backColor = isBefore ? "#47C3D1" : "#276FF5";
        String border = isBefore ? "1px_solid_#47C3D1" : "1px_solid_#276FF5";
        LabelAp content = ((HRLabelAp.Builder)((HRLabelAp.Builder)((HRLabelAp.Builder)((HRLabelAp.Builder)((HRLabelAp.Builder)((HRLabelAp.Builder)((HRLabelAp.Builder)((HRLabelAp.Builder)new HRLabelAp.Builder(CHANGLABEL).setShrink(1).setGrow(0).setFontSize(12).setAutoTextWrap(true).setBorderLeft(border)).setBorderTop(border)).setBorderRight(border)).setBorderBottom(border)).setBackColor(backColor).setForeColor("#ffffff").setPaddingLeft("12px")).setPaddingRight("12px")).setPaddingTop("2px")).setPaddingBottom("2px")).setName(LableName).setHeight(new LocaleString("22px")).build();
        rowFlex.getItems().add(content);
        changeShowFlex.getItems().add(rowFlex);
        return changeShowFlex;
    }

    private static FlexPanelAp createRowData(boolean isBefore, ChangeDto changeDto, String key, long num, IFormView formView) {
        String value;
        FlexPanelAp rowFlex = ((HRFlexPanelAp.Builder)((HRFlexPanelAp.Builder)((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder(key + changeDto.getFieldName() + ROW).setName(key + changeDto.getFieldName() + ROW + num).setGrow(1).setShrink(1).setWrap(false).setDirection(ROW).setAlignItems("stretch").setMarginBottom("12px")).setPaddingLeft("12px")).setPaddingRight("12px")).build();
        LabelAp titleLab = new LabelAp();
        titleLab.setId(key + changeDto.getFieldName() + num);
        titleLab.setKey(key + changeDto.getFieldName() + num);
        titleLab.setShrink(0);
        titleLab.setGrow(0);
        titleLab.setWidth(new LocaleString("80px"));
        titleLab.setFontSize(14);
        titleLab.setForeColor("#666666");
        titleLab.setFontWeight("400");
        titleLab.setName(new LocaleString(changeDto.getFieldName()));
        titleLab.setAutoTextWrap(true);
        rowFlex.getItems().add(titleLab);
        String string = value = isBefore ? changeDto.getBeforeValue() : changeDto.getAfterValue();
        if (changeDto.getFieldType() == FieldTypeEnum.PICTURE) {
            FieldAp fieldAp = new FieldAp();
            String fieldKey = key + changeDto.getFieldKey() + CONTENT + num;
            fieldAp.setId(fieldKey);
            fieldAp.setKey(key + changeDto.getFieldKey() + CONTENT + num);
            fieldAp.setName(new LocaleString(value));
            fieldAp.setLock("view,edit,new,submit,audit");
            fieldAp.setShrink(1);
            fieldAp.setGrow(0);
            Style style = new Style();
            Margin margin = new Margin();
            margin.setLeft("16px");
            style.setMargin(margin);
            fieldAp.setStyle(style);
            fieldAp.setAutoTextWrap(true);
            PictureField pictureField = new PictureField();
            LOGGER.info("createRowData.pictureField.key={},value={}", (Object)(key + changeDto.getFieldName() + CONTENT + num), (Object)value);
            pictureField.setKey(key + changeDto.getFieldKey() + CONTENT + num);
            pictureField.setName(new LocaleString(value));
            fieldAp.setField((Field)pictureField);
            IClientViewProxy proxy = (IClientViewProxy)formView.getService(IClientViewProxy.class);
            proxy.setFieldProperty(fieldKey, "v", (Object)value);
            rowFlex.getItems().add(fieldAp);
        } else {
            LabelAp contentLab = new LabelAp();
            contentLab.setId(changeDto.getFieldKey() + CONTENT + num);
            contentLab.setKey(changeDto.getFieldKey() + CONTENT + num);
            contentLab.setShrink(1);
            contentLab.setGrow(0);
            contentLab.setFontSize(14);
            contentLab.setForeColor("#212121");
            Style style = new Style();
            Margin margin = new Margin();
            margin.setLeft("16px");
            style.setMargin(margin);
            contentLab.setStyle(style);
            contentLab.setName(new LocaleString(value));
            contentLab.setAutoTextWrap(true);
            rowFlex.getItems().add(contentLab);
        }
        return rowFlex;
    }
}

