/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.business.mq.consumer;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.message.HRMessageConsumer;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRProducerServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hspm.business.domian.service.infoclassify.IPersoninfoService;
import kd.sdk.hr.hspm.business.helper.BasedataHelper;
import org.apache.commons.collections.MapUtils;

public class PerChgResultConsumer
extends HRMessageConsumer {
    private static final Log LOGGER = LogFactory.getLog(PerChgResultConsumer.class);
    private IPersoninfoService personinfoService = IPersoninfoService.getInstance();
    private HRBaseServiceHelper chgLogHelper = new HRBaseServiceHelper("hpfs_chglog");

    public void consumeMessage(Object message, String messageId, boolean resend, MessageAcker acker) {
        LOGGER.info(MessageFormat.format("{0} message is {1}", "hspm_chgexternalrecord_result_queue", message));
        try {
            Map result = (Map)SerializationUtils.fromJsonString((String)((String)message), Map.class);
            Boolean success = MapUtils.getBoolean((Map)result, (Object)"success");
            if (!success.booleanValue()) {
                LOGGER.info(MessageFormat.format("{0} msg is {1}", "hspm_chgexternalrecord_result_queue", MapUtils.getBoolean((Map)result, (Object)"msg")));
                return;
            }
            Map dataMap = MapUtils.getMap((Map)result, (Object)"data");
            Long recordId = MapUtils.getLong((Map)dataMap, (Object)"recordId");
            Map<String, Object> messageContent = this.getMessageContent(recordId);
            String msgTitle = this.parseMsgTitle(MapUtils.getLong((Map)dataMap, (Object)"personId"));
            this.sendToHRMP(messageContent, recordId, msgTitle);
            this.sendToHRMP4Integration(recordId, msgTitle);
        }
        catch (Exception exception) {
            LOGGER.error((Throwable)exception);
        }
    }

    private String parseMsgTitle(Long personId) {
        String name = this.personinfoService.getNameByPersonId(personId);
        DynamicObject hpfsChgactionDy = BasedataHelper.getBasedataById((String)"hpfs_chgaction", (long)1240L);
        if (!HRObjectUtils.isEmpty((Object)hpfsChgactionDy)) {
            String hpfsChgactionName = hpfsChgactionDy.getString("name");
            name = name + hpfsChgactionName;
        }
        return name;
    }

    private void sendToHRMP(Map<String, Object> messageContent, Long recordId, String msgTitle) {
        HashMap<String, Object> messageParams = new HashMap<String, Object>(16);
        messageParams.put("msgNumber", String.format("%1$s_%2$s", recordId, System.nanoTime()));
        messageParams.put("msgPubNo", "MP20220617000759");
        messageParams.put("msgTitle", msgTitle);
        messageParams.put("actionId", 101240L);
        messageParams.put("senderId", RequestContext.get().getCurrUserId());
        messageParams.put("sendTime", new Date());
        messageParams.put("params", SerializationUtils.serializeToBase64(messageContent));
        LOGGER.info(String.format("PersonChangeCallBack------sendToHRMP----messageParams:%s", JSONObject.toJSONString(messageParams)));
        HRProducerServiceHelper.publishAction(messageParams);
    }

    private void sendToHRMP4Integration(Long recordId, String msgTitle) {
        DynamicObject[] chgLog = this.chgLogHelper.query("params", new QFilter[]{new QFilter("chgrecord", "=", (Object)recordId)});
        if (chgLog.length == 1) {
            String params = chgLog[0].getString("params");
            JSONObject jsonObject = JSONObject.parseObject((String)params);
            JSONArray dataRowArray = jsonObject.getJSONArray("dataRow");
            HashMap resultMap = Maps.newHashMapWithExpectedSize((int)dataRowArray.size());
            long actionId = 0L;
            for (int i = 0; i < dataRowArray.size(); ++i) {
                JSONObject dataRowObject = dataRowArray.getJSONObject(i);
                for (String key : dataRowObject.keySet()) {
                    JSONArray dataArray = dataRowObject.getJSONArray(key);
                    ArrayList<Long> idList = new ArrayList<Long>(dataArray.size());
                    for (int j = 0; j < dataArray.size(); ++j) {
                        long id;
                        JSONObject dataObject = dataArray.getJSONObject(j);
                        String chgMode = dataObject.getString("chgMode");
                        if ("3".equals(chgMode)) {
                            id = dataObject.getLong("idBefore");
                            actionId = actionId == 0L ? 111020L : actionId;
                        } else {
                            id = dataObject.getLong("idAfter");
                            actionId = actionId == 0L ? 111010L : actionId;
                        }
                        idList.add(id);
                    }
                    resultMap.put(key, idList);
                }
            }
            HashMap param = Maps.newHashMap();
            param.put("caller", "hpfs");
            param.put("data", resultMap);
            param.put("variationtype", "101240_S");
            HashMap<String, Object> messageParams = new HashMap<String, Object>(16);
            messageParams.put("msgNumber", "integration" + System.nanoTime());
            messageParams.put("msgPubNo", actionId == 111010L ? "MP20230814001099" : "MP20230816001100");
            messageParams.put("msgTitle", "integration : " + msgTitle);
            messageParams.put("actionId", actionId);
            messageParams.put("senderId", RequestContext.get().getCurrUserId());
            messageParams.put("sendTime", new Date());
            messageParams.put("params", SerializationUtils.serializeToBase64((Object)param));
            HRProducerServiceHelper.publishAction(messageParams);
            LOGGER.info(String.format("Listen HPFS callback , get param from chgLog and send to HRMP when callback , the message : %s", JSONObject.toJSONString(messageParams)));
        }
    }

    private Map<String, Object> getMessageContent(Long recordId) {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("affactionId", 1240L);
        params.put("chgcategoryId", 1240L);
        params.put("recordId", recordId);
        return params;
    }
}

