/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.business.revise.helper;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.MutexHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hspm.business.domian.handler.CalServiceLengthHandler;
import kd.sdk.hr.hspm.common.constants.PersonReviseConstants;
import kd.sdk.hr.hspm.common.utils.BusinessUtils;

public class PersonReviseHelper
implements PersonReviseConstants {
    public static String doMutex(BeforeDoOperationEventArgs args, Long personId, String entityName) {
        StringBuilder errMsg = new StringBuilder();
        if (!MutexHelper.require((String)entityName, (Object)("per-" + personId), (String)"revise", (boolean)true, (StringBuilder)errMsg)) {
            args.setCancel(true);
            return errMsg.toString();
        }
        return "";
    }

    public static void releaseMutex(String entityName, Long personId) {
        MutexHelper.release((String)entityName, (String)"revise", (String)("per-" + personId));
    }

    public static void putNewBoFlagCacheToParentView(IFormView view) {
        view.getParentView().getPageCache().put("fromOperation", "revisenewbo");
    }

    public static void removeNewBoFlagCacheToParentView(IFormView view) {
        view.getParentView().getPageCache().remove("fromOperation");
    }

    public static void saveReviseRecordDyn(OperateOption option) {
        Long reviseRecordId = Long.valueOf(option.getVariableValue("reviserecordid"));
        Long personId = Long.valueOf(option.getVariableValue("personid"));
        String entityName = option.getVariableValue("entityname");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrpi_reviserecord");
        DynamicObject reviseRecordDyn = serviceHelper.loadDynamicObject(new QFilter("id", "=", (Object)reviseRecordId));
        Date date = new Date();
        if (Objects.isNull(reviseRecordDyn)) {
            DynamicObject newDyn = serviceHelper.generateEmptyDynamicObject();
            newDyn.set("id", (Object)reviseRecordId);
            newDyn.set("creator", (Object)RequestContext.get().getCurrUserId());
            newDyn.set("createtime", (Object)date);
            newDyn.set("modifier", (Object)RequestContext.get().getCurrUserId());
            newDyn.set("modifytime", (Object)date);
            newDyn.set("modifytime", (Object)date);
            newDyn.set("revisenumber", (Object)entityName);
            newDyn.set("recorddate", (Object)date);
            newDyn.set("issend", (Object)false);
            newDyn.set("person", (Object)personId);
            serviceHelper.save(new DynamicObject[]{newDyn});
        } else {
            reviseRecordDyn.set("modifier", (Object)RequestContext.get().getCurrUserId());
            reviseRecordDyn.set("modifytime", (Object)date);
            serviceHelper.save(new DynamicObject[]{reviseRecordDyn});
        }
    }

    public static String getDisplayValueByProp(DynamicObject dyn, IDataEntityProperty prop) {
        if (prop == null) {
            return null;
        }
        String propName = prop.getName();
        if (prop instanceof MuliLangTextProp) {
            ILocaleString val = dyn.getLocaleString(propName);
            HashSet<String> allStr = new HashSet<String>(4);
            HashSet mulLangType = new HashSet(4);
            mulLangType.addAll(val.keySet());
            for (String type : mulLangType) {
                if (StringUtils.equals((CharSequence)"GLang", (CharSequence)type)) continue;
                String subVal = (String)val.getOrDefault((Object)type, (Object)"");
                allStr.add(subVal + "(" + type + ")");
            }
            return StringUtils.join((Object[])allStr.toArray(), (String)",");
        }
        if (prop instanceof ComboProp) {
            ComboProp comboProp = (ComboProp)prop;
            if (dyn != null) {
                return comboProp.getItemByName(dyn.getString(propName));
            }
        } else if (prop instanceof BasedataProp) {
            DynamicObject propValue;
            BasedataProp basedataProp = (BasedataProp)prop;
            if (dyn != null && (propValue = dyn.getDynamicObject(propName)) != null) {
                return propValue.getString(basedataProp.getDisplayProp());
            }
        } else {
            if (prop instanceof MulBasedataProp) {
                return dyn.getDynamicObjectCollection(prop).stream().map(dy -> dy.getString("fbasedataid.name")).collect(Collectors.joining(","));
            }
            if (prop instanceof DateProp) {
                if (dyn != null) {
                    if (dyn.getDate(propName) == null) {
                        return null;
                    }
                    return HRInteDateTimeUtil.formatDateByFieldProp((DateTimeProp)((DateProp)prop), (Date)dyn.getDate(propName), (Long)0L);
                }
            } else if (prop instanceof DateTimeProp) {
                if (dyn != null) {
                    if (dyn.getDate(propName) == null) {
                        return null;
                    }
                    return HRInteDateTimeUtil.formatDateByFieldProp((DateTimeProp)((DateTimeProp)prop), (Date)dyn.getDate(propName), (Long)0L);
                }
            } else if (prop instanceof IntegerProp) {
                if (dyn != null) {
                    return dyn.getString(propName);
                }
            } else if (prop instanceof BooleanProp) {
                String flag = dyn.getString(propName);
                if (HRStringUtils.equals((String)"true", (String)flag)) {
                    return ResManager.loadKDString((String)"\u662f", (String)"PersonReviseHelper_0", (String)"hr-hspm-business", (Object[])new Object[0]);
                }
                if (HRStringUtils.equals((String)"false", (String)flag)) {
                    return ResManager.loadKDString((String)"\u5426", (String)"PersonReviseHelper_1", (String)"hr-hspm-business", (Object[])new Object[0]);
                }
            } else if (prop instanceof DecimalProp && dyn != null) {
                if ("servicelength".equals(prop.getName())) {
                    BigDecimal serviceLength = PersonReviseHelper.setServiceLength(dyn);
                    if (serviceLength != null) {
                        return String.valueOf(serviceLength).substring(0, dyn.getString(propName).lastIndexOf(".") + 2);
                    }
                } else {
                    return dyn.getString(propName).substring(0, dyn.getString(propName).lastIndexOf(".") + 2);
                }
            }
        }
        if (dyn != null) {
            return dyn.getString(propName);
        }
        return null;
    }

    private static BigDecimal setServiceLength(DynamicObject dyn) {
        BigDecimal adjustLength = dyn.getBigDecimal("adjustlength");
        Date startDate = dyn.getDate("startdate");
        String scheme = dyn.getString("serviceagescheme");
        if ("2".equals(scheme)) {
            Map<Long, BigDecimal> serLenMap = CalServiceLengthHandler.calcEmpentrelContinuation(Collections.singletonList(dyn), "0", "1");
            BigDecimal serLen = serLenMap.get(dyn.getLong("employee.mid"));
            if (serLen != null) {
                BigDecimal serAdd = serLen.add(adjustLength);
                return serAdd;
            }
            return new BigDecimal("");
        }
        Date endDate = new Date();
        long statusPro = dyn.getLong("labrelstatusprd.id");
        if (statusPro == 1020L) {
            endDate = dyn.getDate("enddate");
        }
        BigDecimal serLength = BusinessUtils.calcYearsDiff((Date)endDate, (Date)new Date(startDate.getTime())).add(adjustLength);
        return serLength;
    }

    public static Map<Long, String> queryAbstractByIdList(String reviseLogEntityNum, List<Long> reviseLogIdList) {
        return (Map)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hrpi", (String)"IHRPIReviseLogService", (String)"queryAbstractByIdList", (Object[])new Object[]{reviseLogEntityNum, reviseLogIdList});
    }

    public static DynamicObject generateLogDetailDyn(String logEntityName, Long reviseLogId) {
        return (DynamicObject)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hrpi", (String)"IHRPIReviseLogService", (String)"generateLogDetailDynByEntityAndLogId", (Object[])new Object[]{logEntityName, reviseLogId});
    }

    public static DynamicObject[] analyzeReviseNewResultData(Map<String, Object> result, String targetEntityNumber) {
        Object data = result.get("data");
        if (Objects.nonNull(data)) {
            for (Map datMap : (List)data) {
                Object versionChangeRespDataList;
                Object dataResult = datMap.get("data");
                if (!Objects.nonNull(dataResult) || !Objects.nonNull(versionChangeRespDataList = ((Map)dataResult).get("versionChangeRespDataList"))) continue;
                for (Map versionChangeRespData : (List)versionChangeRespDataList) {
                    String entityNumber = (String)versionChangeRespData.get("entitynumber");
                    if (!targetEntityNumber.equals(entityNumber)) continue;
                    return (DynamicObject[])versionChangeRespData.get("newDynamicObjects");
                }
            }
        }
        return new DynamicObject[0];
    }

    public static DynamicObject[] analyzeReviseResultData(Map<String, Object> result, String targetEntityNumber) {
        Object data = result.get("data");
        if (Objects.nonNull(data)) {
            for (Map datMap : (List)data) {
                Object hisVersionReviseDyns;
                String entityNumber;
                Object dataResult = datMap.get("data");
                if (!Objects.nonNull(dataResult) || !targetEntityNumber.equals(entityNumber = (String)((Map)dataResult).get("entitynumber")) || !Objects.nonNull(hisVersionReviseDyns = ((Map)dataResult).get("hisVersionReviseDyns"))) continue;
                return (DynamicObject[])hisVersionReviseDyns;
            }
        }
        return new DynamicObject[0];
    }
}

