/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.business.task;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sdk.hr.hspm.common.utils.HspmDateUtils;
import org.apache.commons.lang.time.StopWatch;

public class AgeDataRefreshTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(AgeDataRefreshTask.class);
    private static final HRBaseServiceHelper PERNONTSPROP_HELPER = new HRBaseServiceHelper("hrpi_pernontsprop");
    private static final int ENTITY_TOP = 10000;
    private static final int ID_TOP = 1000000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.info("AgeDataRefreshTask#execute_start");
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            this.ageStart();
            stopWatch.split();
            LOGGER.info("AgeDataRefreshTask#execute_ageStart time is: {} ms.", (Object)stopWatch.getSplitTime());
        }
        finally {
            stopWatch.stop();
            LOGGER.info("AgeDataRefreshTask#execute_end time is: {} ms.", (Object)stopWatch.getTime());
        }
    }

    private void ageStart() {
        long maxId = 0L;
        Date currentDay = new Date();
        try {
            int idsSize;
            do {
                List<Long> ids = AgeDataRefreshTask.queryIds(maxId);
                idsSize = ids.size();
                LOGGER.info("id size:{}", (Object)idsSize);
                for (int startIndex = 0; startIndex < idsSize; startIndex += 10000) {
                    Object[] dyArray = AgeDataRefreshTask.queryPernontsprop(ids, startIndex);
                    if (!ArrayUtils.isEmpty((Object[])dyArray)) {
                        DynamicObjectCollection dynamicObjectCollection = this.addDataToCollection((DynamicObject[])dyArray, currentDay);
                        PERNONTSPROP_HELPER.save(dynamicObjectCollection);
                    }
                    maxId = dyArray[dyArray.length - 1].getLong("id");
                    LOGGER.info("maxId:{}", (Object)maxId);
                }
            } while (idsSize >= 1000000);
        }
        catch (Exception ex) {
            LOGGER.error("handle_agedata_ex", (Throwable)ex);
        }
    }

    private DynamicObjectCollection addDataToCollection(DynamicObject[] dyArray, Date currentDay) {
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
        for (DynamicObject object : dyArray) {
            long yearDiff;
            Date birthday = object.getDate("birthday");
            int age = object.getInt("age");
            if (birthday == null || (yearDiff = HspmDateUtils.dateDiff((String)"yyyy", (Date)birthday, (Date)currentDay)) == (long)age) continue;
            dynamicObjectCollection.add((Object)object);
            object.set("age", (Object)yearDiff);
        }
        return dynamicObjectCollection;
    }

    private static DynamicObject[] queryPernontsprop(List<Long> ids, int startIndex) {
        int endIndex = startIndex + 10000;
        int idsSize = ids.size();
        if (endIndex > idsSize) {
            endIndex = idsSize - 1;
        }
        List<Long> idList = ids.subList(startIndex, endIndex);
        return PERNONTSPROP_HELPER.query("id,person,boid,birthday,age", new QFilter[]{new QFilter("id", "in", idList)});
    }

    private static List<Long> queryIds(long id) {
        QFilter statusFilter = new QFilter("datastatus", "=", (Object)"1");
        QFilter[] qFilters = new QFilter[]{new QFilter("id", ">", (Object)id), statusFilter};
        DataSet ids = PERNONTSPROP_HELPER.queryDataSet(PERNONTSPROP_HELPER.getEntityName() + ".queryId", "id", qFilters, "id", 1000000);
        ArrayList<Long> idList = new ArrayList<Long>();
        ids.forEach(data -> idList.add(data.getLong("id")));
        return idList;
    }
}

