/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.business.task;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.hr.hspm.business.domian.repository.inforevise.EmpposorgrelRepository;
import kd.hr.hspm.business.domian.service.impl.inforevise.EmpposorgrelServiceImpl;
import kd.sdk.hr.hspm.business.repository.CommonQueryRepository;

public class EmpPosOrgRelChargePersonTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(EmpPosOrgRelChargePersonTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        long startTime = System.currentTimeMillis();
        LOGGER.info("\u6570\u636e\u5347\u7ea7\u4efb\u52a1 \u5f00\u59cb\u6267\u884c:");
        try (TXHandle required = TX.required();){
            try {
                this.executeUpgrade(map);
            }
            catch (Exception ex) {
                required.markRollback();
            }
        }
        this.disableTask();
        LOGGER.info("\u6570\u636e\u5347\u7ea7\u4efb\u52a1: \u6267\u884c\u5b8c\uff0c\u5171\u8017\u65f6 {} \u6beb\u79d2", (Object)(System.currentTimeMillis() - startTime));
    }

    public void executeUpgrade(Map<String, Object> map) {
        QFilter entityNumberFilter = new QFilter("revisenumber", "=", (Object)"hrpi_empposorgrel");
        DynamicObject[] reviseLogDynArr = CommonQueryRepository.getInstance().queryColsInfoByFilter("hspm_revempposlog", (Set)Sets.newHashSet((Object[])new String[]{"id", "revisebo", "revisetype", "revisedate"}), entityNumberFilter);
        List<Long> empPosOrgRelBoIdList = Arrays.stream(reviseLogDynArr).map(dyn -> dyn.getLong("revisebo.id")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(empPosOrgRelBoIdList)) {
            LOGGER.info("empPosOrgRelBoIdList is empty!");
            return;
        }
        DynamicObject[] empPosOrgRelDynArr = EmpposorgrelRepository.getInstance().queryEffectiveHisDataByBoIds(empPosOrgRelBoIdList);
        if (empPosOrgRelDynArr == null || empPosOrgRelDynArr.length == 0) {
            LOGGER.info("revisebo is empty!");
            return;
        }
        Map<Long, DynamicObject> boIdVsEmpPosOrgRelDynMap = Arrays.stream(empPosOrgRelDynArr).collect(Collectors.toMap(dyn -> dyn.getLong("boid"), dyn -> dyn, (o1, o2) -> o1));
        Map<Long, List<DynamicObject>> boIdVsLogDynArrMap = Arrays.stream(reviseLogDynArr).collect(Collectors.groupingBy(dyn -> dyn.getLong("revisebo.id")));
        Set<Map.Entry<Long, List<DynamicObject>>> entries = boIdVsLogDynArrMap.entrySet();
        ArrayList discardChargePersonDynList = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList addChargePersonDynList = Lists.newArrayListWithExpectedSize((int)16);
        EmpposorgrelServiceImpl empPosOrgRelService = new EmpposorgrelServiceImpl();
        for (Map.Entry<Long, List<DynamicObject>> entry : entries) {
            boolean isLeaderPosition;
            Long boId = entry.getKey();
            List logDynList = entry.getValue().stream().sorted(Comparator.comparing(dyn -> dyn.getDate("revisedate"))).collect(Collectors.toList());
            List reviseTypeList = logDynList.stream().map(dyn -> dyn.getString("revisetype")).collect(Collectors.toList());
            DynamicObject empPosOrgRelDyn = boIdVsEmpPosOrgRelDynMap.get(boId);
            if (Objects.isNull(empPosOrgRelDyn)) continue;
            if (reviseTypeList.contains("1")) {
                discardChargePersonDynList.add(empPosOrgRelDyn);
                continue;
            }
            if (reviseTypeList.contains("0")) {
                isLeaderPosition = empPosOrgRelService.isLeaderPositionForHis(empPosOrgRelDyn);
                if (!isLeaderPosition) continue;
                addChargePersonDynList.add(empPosOrgRelDyn);
                continue;
            }
            discardChargePersonDynList.add(empPosOrgRelDyn);
            isLeaderPosition = empPosOrgRelService.isLeaderPositionForHis(empPosOrgRelDyn);
            if (!isLeaderPosition) continue;
            addChargePersonDynList.add(empPosOrgRelDyn);
        }
        if (!CollectionUtils.isEmpty((Collection)discardChargePersonDynList)) {
            empPosOrgRelService.callBatchDiscardChargeMethod(discardChargePersonDynList);
        }
        if (!CollectionUtils.isEmpty((Collection)addChargePersonDynList)) {
            empPosOrgRelService.callBatchNewChargeMethod(addChargePersonDynList);
        }
    }

    private void disableTask() {
        ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        scheduleManager.disableJob("49D86+5UJ3QQ");
        scheduleManager.disableSchedule("49D8KPX98QJ0");
    }
}

