/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.business.task;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sdk.hr.hspm.business.helper.CachedLoadReferenceObjectManagerHelper;

public class InfoapprovalFieldUpgradeTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(InfoapprovalFieldUpgradeTask.class);
    private static final int TOP = 100;
    private static final HRBaseServiceHelper INFOAPPROVAL_HELPER = new HRBaseServiceHelper("hspm_infoapproval");
    private static final HRBaseServiceHelper ERMANFILE_HELPER = new HRBaseServiceHelper("hspm_ermanfile");
    private static final HRBaseServiceHelper EMPPOSORGREL_HELPER = new HRBaseServiceHelper("hrpi_empposorgrel");

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        DynamicObject[] dyArray;
        LOGGER.info("InfoapprovalFieldUpgradeTask#execute_start");
        long id = 0L;
        while ((dyArray = InfoapprovalFieldUpgradeTask.queryApproval(id)) != null && dyArray.length > 0) {
            ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(dyArray.length);
            for (DynamicObject approvalDy : dyArray) {
                try {
                    DynamicObject[] empposorgrels;
                    QFilter[] empposorgrelFilter;
                    DynamicObject[] ermanFiles;
                    QFilter[] ermanfileFilter = this.getErmanfileFilter(approvalDy);
                    if (ermanfileFilter == null || (ermanFiles = (DynamicObject[])CachedLoadReferenceObjectManagerHelper.disabledCache(() -> ERMANFILE_HELPER.query("depemp,affiliateadminorg,org", ermanfileFilter, "createtime desc"))) == null || ermanFiles.length == 0 || (empposorgrelFilter = this.getEmpposorgrelFilter(ermanFiles, approvalDy)) == null || (empposorgrels = EMPPOSORGREL_HELPER.query("adminorg", empposorgrelFilter, "createtime desc")) == null || empposorgrels.length == 0) continue;
                    approvalDy.set("affiliateadminorg", ermanFiles[0].get("affiliateadminorg"));
                    approvalDy.set("org", ermanFiles[0].get("org"));
                    approvalDy.set("adminorg", empposorgrels[0].get("adminorg"));
                    updateList.add(approvalDy);
                }
                catch (Exception ex) {
                    LOGGER.warn("InfoapprovalFieldUpgradeTask_ex", (Throwable)ex);
                }
            }
            if (updateList.size() > 0) {
                INFOAPPROVAL_HELPER.update(updateList.toArray(new DynamicObject[updateList.size()]));
            }
            if (dyArray.length < 100) break;
            id = dyArray[dyArray.length - 1].getLong("id");
        }
        ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        scheduleManager.disableJob("3C4PC/LUY5/2");
        scheduleManager.disableSchedule("3C4PWNEHVVU5");
        LOGGER.info("InfoapprovalFieldUpgradeTask#execute_end");
    }

    private QFilter[] getErmanfileFilter(DynamicObject approvalDy) {
        long personId = approvalDy.getLong("person.id");
        if (personId == 0L) {
            return null;
        }
        Date createTime = approvalDy.getDate("createtime");
        return new QFilter[]{new QFilter("person", "=", (Object)personId), new QFilter("businessstatus", "=", (Object)"1"), new QFilter("startdate", "<=", (Object)createTime), new QFilter("enddate", ">=", (Object)createTime), new QFilter("createtime", "<=", (Object)createTime)};
    }

    private QFilter[] getEmpposorgrelFilter(DynamicObject[] ermanFiles, DynamicObject approvalDy) {
        Set deps = Stream.of(ermanFiles).filter(val -> val.getLong("depemp.id") != 0L).map(val -> val.getLong("depemp.id")).collect(Collectors.toSet());
        if (deps.size() == 0) {
            return null;
        }
        Date createTime = approvalDy.getDate("createtime");
        return new QFilter[]{new QFilter("depemp", "in", deps), new QFilter("isprimary", "=", (Object)"1"), new QFilter("businessstatus", "=", (Object)"1"), new QFilter("startdate", "<=", (Object)createTime), new QFilter("enddate", ">=", (Object)createTime), new QFilter("createtime", "<=", (Object)createTime)};
    }

    private static DynamicObject[] queryApproval(long id) {
        QFilter[] qFArray = new QFilter[]{new QFilter("id", ">", (Object)id), new QFilter("affiliateadminorg", "=", (Object)0L), new QFilter("org", "=", (Object)0L), new QFilter("adminorg", "=", (Object)0L)};
        return INFOAPPROVAL_HELPER.query("person,affiliateadminorg,org,adminorg,createtime", qFArray, "id", 100);
    }
}

