/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.business.util;

import java.text.MessageFormat;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class UniquenessCheckUtil {
    private static final HRBaseServiceHelper PERCONTACT_HELPER = new HRBaseServiceHelper("hrpi_percontact");
    private static final HRBaseServiceHelper PERCRE_HELPER = new HRBaseServiceHelper("hrpi_percre");
    protected static final HRBaseServiceHelper EMPLOYEE_HELPER = new HRBaseServiceHelper("hrpi_employee");
    public static final int TYPE_PHONE = 1;
    public static final int TYPE_CARDNO = 2;
    public static final int TYPE_PEREMAIL = 3;

    public static Tuple<Boolean, String> checkPhone(long personId, String phone, boolean detail) {
        Object[] employeeArray;
        Set<Long> personIds;
        QFilter phoneFilter;
        QFilter qFilter;
        Object[] percontactDys;
        if (personId > 0L && HRStringUtils.isNotEmpty((String)phone) && ArrayUtils.isNotEmpty((Object[])(percontactDys = PERCONTACT_HELPER.query("person,phone", new QFilter[]{qFilter = new QFilter("iscurrentversion", "=", (Object)"1").and("datastatus", "=", (Object)"1"), phoneFilter = new QFilter("phone", "=", (Object)phone)}))) && !(personIds = Stream.of(percontactDys).map(val -> val.getLong("person.id")).collect(Collectors.toSet())).contains(personId) && ArrayUtils.isNotEmpty((Object[])(employeeArray = UniquenessCheckUtil.getOnBoardEmployee(personIds)))) {
            DynamicObject person = employeeArray[0].getDynamicObject("person");
            return Tuple.create((Object)false, (Object)UniquenessCheckUtil.getExTip(person, 1, detail));
        }
        return Tuple.create((Object)true, (Object)"success");
    }

    public static Tuple<Boolean, String> checkPerEmail(long personId, String perEmail, boolean detail) {
        Object[] employeeArray;
        Set<Long> personIds;
        QFilter perEmailFilter;
        QFilter qFilter;
        DynamicObject[] percontactDys;
        if (personId > 0L && HRStringUtils.isNotEmpty((String)perEmail) && (percontactDys = PERCONTACT_HELPER.query("person,peremail", new QFilter[]{qFilter = new QFilter("iscurrentversion", "=", (Object)"1").and("datastatus", "=", (Object)"1"), perEmailFilter = new QFilter("peremail", "=", (Object)perEmail)})) != null && percontactDys.length > 0 && !(personIds = Stream.of(percontactDys).map(val -> val.getLong("person.id")).collect(Collectors.toSet())).contains(personId) && ArrayUtils.isNotEmpty((Object[])(employeeArray = UniquenessCheckUtil.getOnBoardEmployee(personIds)))) {
            DynamicObject person = employeeArray[0].getDynamicObject("person");
            return Tuple.create((Object)false, (Object)UniquenessCheckUtil.getExTip(person, 3, detail));
        }
        return Tuple.create((Object)true, (Object)"success");
    }

    public static DynamicObject[] getOnBoardEmployee(Set<Long> personIds) {
        return UniquenessCheckUtil.getOnBoardByField("person.id", personIds);
    }

    public static DynamicObject[] getOnBoardPersonByEmpId(Set<Long> personIds) {
        return UniquenessCheckUtil.getOnBoardByField("id", personIds);
    }

    private static DynamicObject[] getOnBoardByField(String field, Set<Long> personIds) {
        QFilter qFilter = new QFilter("laborrelstatus.labrelstatusprd", "=", (Object)1010L);
        QFilter personFilter = new QFilter(field, "in", personIds);
        QFilter businessStatus = new QFilter("businessstatus", "=", (Object)"1");
        QFilter dataStatusF = new QFilter("datastatus", "=", (Object)"1");
        QFilter curVersion = new QFilter("iscurrentversion", "=", (Object)"1");
        return EMPLOYEE_HELPER.query("person", new QFilter[]{personFilter, qFilter, businessStatus, curVersion, dataStatusF});
    }

    public static Tuple<Boolean, String> checkCardNo(Long percreId, Long typeId, String cardNo, boolean detail) {
        Set<Long> personIds;
        Object[] employeeArray;
        Optional<DynamicObject> opt;
        Object[] percreDys;
        QFilter filter = new QFilter("number", "=", (Object)cardNo).and("datastatus", "=", (Object)"1").and("iscurrentversion", "=", (Object)"1");
        if (typeId != null && typeId > 0L) {
            filter.and("credentialstype", "=", (Object)typeId);
        }
        if (ArrayUtils.isNotEmpty((Object[])(percreDys = PERCRE_HELPER.query("number,person", new QFilter[]{filter}))) && !(opt = Stream.of(percreDys).filter(val -> val.getLong("id") == percreId.longValue()).findAny()).isPresent() && ArrayUtils.isNotEmpty((Object[])(employeeArray = UniquenessCheckUtil.getOnBoardEmployee(personIds = Stream.of(percreDys).map(val -> val.getLong("person.id")).collect(Collectors.toSet()))))) {
            DynamicObject person = employeeArray[0].getDynamicObject("person");
            return Tuple.create((Object)false, (Object)UniquenessCheckUtil.getExTip(person, 2, detail));
        }
        return Tuple.create((Object)true, (Object)"success");
    }

    private static String getExTip(DynamicObject person, int type, boolean detail) {
        String repeatNumber = person.getString("number");
        String repeatName = person.getString("name");
        switch (type) {
            case 1: {
                return detail ? ResManager.loadKDString((String)MessageFormat.format("\u624b\u673a\u53f7\u7801\u4e0e\u5458\u5de5\uff08\u59d3\u540d\uff1a{0}\uff0c\u5de5\u53f7\uff1a{1}\uff09\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", repeatNumber, repeatName), (String)"UniquenessCheckUtil_0", (String)"hr-hspm-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u201c\u624b\u673a\u53f7\u7801\u201d\u4e0e\u5728\u804c\u5458\u5de5\u6570\u636e\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"UniquenessCheckUtil_1", (String)"hr-hspm-business", (Object[])new Object[0]);
            }
            case 2: {
                return detail ? ResManager.loadKDString((String)MessageFormat.format("\u8bc1\u4ef6\u53f7\u7801\u4e0e\u5458\u5de5\uff08\u59d3\u540d\uff1a{0}\uff0c\u5de5\u53f7\uff1a{1}\uff09\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", repeatNumber, repeatName), (String)"UniquenessCheckUtil_2", (String)"hr-hspm-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u201c\u8bc1\u4ef6\u53f7\u7801\u201d\u4e0e\u5728\u804c\u5458\u5de5\u6570\u636e\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"UniquenessCheckUtil_3", (String)"hr-hspm-business", (Object[])new Object[0]);
            }
            case 3: {
                return detail ? ResManager.loadKDString((String)MessageFormat.format("\u4e2a\u4eba\u7535\u5b50\u90ae\u7bb1\u4e0e\u5458\u5de5\uff08\u59d3\u540d\uff1a{0}\uff0c\u5de5\u53f7\uff1a{1}\uff09\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", repeatNumber, repeatName), (String)"UniquenessCheckUtil_4", (String)"hr-hspm-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u201c\u4e2a\u4eba\u7535\u5b50\u90ae\u7bb1\u201d\u4e0e\u5728\u804c\u4eba\u5458\u6570\u636e\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"UniquenessCheckUtil_5", (String)"hr-hspm-business", (Object[])new Object[0]);
            }
        }
        return null;
    }
}

