/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.mservice;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.hr.haos.business.domain.repository.structproject.StructProjectRepository;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynKey;
import kd.hr.haos.business.service.adminorg.AdminOrgInitOpService;
import kd.hr.haos.business.service.adminorg.AdminOrgUnitSyncService;
import kd.hr.haos.business.service.adminorg.businessfile.AdminOrgBusinessFileService;
import kd.hr.haos.business.service.adminorg.strategy.OrgStrategyService;
import kd.hr.haos.business.service.orgchangetransaction.service.TransactionModelService;
import kd.hr.haos.business.servicehelper.AdminOrgInitServiceHelper;
import kd.hr.haos.business.servicehelper.AdminOrgInitValidateServiceHelper;
import kd.hr.haos.business.servicehelper.model.upgrade.InitDataHolder;
import kd.hr.haos.business.util.TimeLogger;
import kd.hr.haos.common.constants.changetransaction.ChangeTransactionConstants;
import kd.hr.haos.common.constants.structproject.StructProjectConstants;
import kd.hr.haos.common.util.PlatformRootUtils;
import kd.hr.hbp.business.domain.model.newhismodel.BatchVersionChangeRespData;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.VersionChangeRespData;
import kd.hr.hbp.business.init.AbstractInitDomainDataService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.init.InitInParam;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;

public class HAOSBatchAdminOrgInitService
extends AbstractInitDomainDataService {
    private static final Log LOG = LogFactory.getLog(HAOSBatchAdminOrgInitService.class);

    public void validate() {
        Map<Long, DynamicObject> initKeyAdminOrgMap = this.getInitDynamicObjectMap();
        if (!CollectionUtils.isEmpty(initKeyAdminOrgMap)) {
            this.validateInfo(initKeyAdminOrgMap);
        }
    }

    public Map<Long, List<String>> validateInfo(Map<Long, DynamicObject> initKeyAdminOrgMap) {
        Map map = this.getInfoWithMap();
        List mapResult = (List)map.get("data");
        HashMap<Long, List<String>> validateResult = new HashMap<Long, List<String>>();
        AdminOrgInitValidateServiceHelper.validateIsEmpty(initKeyAdminOrgMap, validateResult, (List)mapResult);
        AdminOrgInitValidateServiceHelper.validateUniqueNumber(initKeyAdminOrgMap, validateResult, (boolean)false);
        AdminOrgInitValidateServiceHelper.validateName(initKeyAdminOrgMap, validateResult);
        AdminOrgInitValidateServiceHelper.validateLength(initKeyAdminOrgMap, validateResult);
        AdminOrgInitValidateServiceHelper.validateParentOrg(initKeyAdminOrgMap, validateResult);
        AdminOrgInitValidateServiceHelper.validateDate(initKeyAdminOrgMap, validateResult);
        AdminOrgInitValidateServiceHelper.validateLevel4Model(initKeyAdminOrgMap, validateResult);
        AdminOrgInitValidateServiceHelper.validateAdminorgType(initKeyAdminOrgMap, validateResult, (boolean)false);
        AdminOrgInitValidateServiceHelper.validateDataEffective(initKeyAdminOrgMap, validateResult);
        AdminOrgInitValidateServiceHelper.validateDatabaseEnable(initKeyAdminOrgMap, validateResult, (List)mapResult);
        AdminOrgInitValidateServiceHelper.validateDatabaseUseRange(initKeyAdminOrgMap, validateResult);
        AdminOrgInitValidateServiceHelper.validateOrg(initKeyAdminOrgMap, validateResult);
        AdminOrgInitValidateServiceHelper.validateParentOrgInfo(initKeyAdminOrgMap, validateResult);
        LOG.info("validateInfo" + ((Object)validateResult).toString());
        HashSet<Long> allInitKeys = new HashSet<Long>(initKeyAdminOrgMap.keySet());
        if (!CollectionUtils.isEmpty(validateResult)) {
            validateResult.forEach((initKey, errorInfos) -> {
                this.getInitOutParam().addErrorMsg(initKey, String.join((CharSequence)";", errorInfos));
                allInitKeys.remove(initKey);
            });
        }
        allInitKeys.forEach(initKey -> this.getInitOutParam().addSuccessMsg(initKey, null, null));
        return validateResult;
    }

    protected Map<Long, DynamicObject> getInitDynamicObjectMap() {
        Map map = this.getInfoWithMap();
        List result = (List)this.getInfoWithDynamicObject().get("data");
        List result2 = (List)map.get("data");
        return AdminOrgInitServiceHelper.toAdminOrgDynamicObject((List)result, (List)result2, (Long)this.getInitInParam().getBatchNumber());
    }

    protected InitDataHolder getInitInitDataHolder() {
        Map map = this.getInfoWithMap();
        List result = (List)this.getInfoWithDynamicObject().get("data");
        List result2 = (List)map.get("data");
        return AdminOrgInitServiceHelper.toAdminOrgDynamicObjectWithParent((List)result, (List)result2, (Long)this.getInitInParam().getBatchNumber());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        LOG.info("begin do init org save");
        Long execTaskId = this.getInitInParam().getExecTaskId();
        if (execTaskId != null && !execTaskId.equals(0L)) {
            DLock reentrant = DLock.createReentrant((String)("adminOrgInitSave::" + execTaskId));
            reentrant.lock();
            LOG.info("locked success [{}]", (Object)execTaskId);
            try {
                InitDataHolder initInitDataHolder = this.getInitInitDataHolder();
                Map initKeyAdminOrgMap = initInitDataHolder.getInitKeyAdminOrgMap();
                ArrayList allNumber = new ArrayList();
                if (!CollectionUtils.isEmpty((Map)initKeyAdminOrgMap)) {
                    initKeyAdminOrgMap.forEach((key, dy) -> {
                        String number = dy.getString("number");
                        if (HRStringUtils.isNotEmpty((String)number)) {
                            allNumber.add(number);
                        }
                    });
                    QFilter numberFilter = new QFilter("number", "in", allNumber);
                    QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"0");
                    HRBaseServiceHelper helper = new HRBaseServiceHelper("haos_adminorgdetail");
                    DynamicObject[] ids = helper.query("id", new QFilter[]{numberFilter, initStatusFilter});
                    if (ids == null || ids.length == 0) {
                        Map<Object, Object> validateResult = new HashMap(16);
                        if (!this.shouldSkipBizValidate()) {
                            LOG.info("not skip validate before save");
                            validateResult = this.validateInfo(initKeyAdminOrgMap);
                        }
                        if (CollectionUtils.isEmpty(validateResult)) {
                            this.saveInfoWithInvalidHis(initInitDataHolder);
                        } else {
                            HashMap newInitKeyAdminOrgMap = new HashMap();
                            Set<Object> errorInitKeys = validateResult.keySet();
                            initKeyAdminOrgMap.forEach((initKey, org) -> {
                                if (!errorInitKeys.contains(initKey)) {
                                    newInitKeyAdminOrgMap.put(initKey, org);
                                }
                            });
                            this.saveInfoWithInvalidHis(initInitDataHolder);
                        }
                    }
                }
            }
            finally {
                reentrant.unlock();
            }
        }
    }

    public boolean shouldSkipBizValidate() {
        InitInParam initInParam = this.getInitInParam();
        if (initInParam == null) {
            LOG.info("shouldSkipBizValidate initInParam is null");
            return false;
        }
        Map other = initInParam.getOther();
        if (other == null) {
            LOG.info("shouldSkipBizValidate other is null");
            return false;
        }
        Object skipValidate = other.get("common$skip.biz.validate");
        if (skipValidate instanceof Boolean) {
            LOG.info("shouldSkipBizValidate common$skip.biz.validate is {}", skipValidate);
            return (Boolean)skipValidate;
        }
        LOG.info("shouldSkipBizValidate common$skip.biz.validate is null");
        return false;
    }

    public void saveInfoWithInvalidHis(InitDataHolder initDataHolder) {
        long start = System.currentTimeMillis();
        DynamicObject[] dynamicObjects = initDataHolder.getInitKeyAdminOrgMap().values().toArray(new DynamicObject[0]);
        this.resetOrgId(dynamicObjects);
        HisResponse changeRespDataHisResponse = AdminOrgInitOpService.getInstance().saveNewWithInvalidHis(dynamicObjects, Long.valueOf(0L), this.getInitInParam().getBatchNumber(), initDataHolder.getInitHisData());
        AdminOrgInitServiceHelper.setInitDefaultValue((DynamicObject[])dynamicObjects, (long)this.getInitInParam().getBatchNumber());
        AdminOrgBusinessFileService.getInstance().saveNew(dynamicObjects, Long.valueOf(0L));
        DynamicObject[] newDynamicObjects = ((VersionChangeRespData)((BatchVersionChangeRespData)changeRespDataHisResponse.getData()).getVersionChangeRespDataList().get(0)).getNewDynamicObjects();
        List<DynamicObject> hisAdminOrgs = Stream.of(newDynamicObjects).filter(dy -> !dy.getBoolean("iscurrentversion")).collect(Collectors.toList());
        TransactionModelService opService = new TransactionModelService();
        opService.changeTransactionSave(Long.valueOf(1010L), ((BatchVersionChangeRespData)changeRespDataHisResponse.getData()).getEventId(), true, hisAdminOrgs.toArray(new DynamicObject[0]), null);
        this.saveAdminChgDetail(hisAdminOrgs);
        this.buildSaveSuccessInfo(initDataHolder.getInitKeyAdminOrgMap());
        long end = System.currentTimeMillis();
        LOG.info("kd.hr.haos.mservice.HAOSBatchAdminOrgInitService.save is end. cast={}ms", (Object)(end - start));
    }

    public void saveInfo(Map<Long, DynamicObject> initKeyAdminOrgMap) {
        long start = System.currentTimeMillis();
        DynamicObject[] dynamicObjects = initKeyAdminOrgMap.values().toArray(new DynamicObject[0]);
        this.resetOrgId(dynamicObjects);
        HisResponse changeRespDataHisResponse = AdminOrgInitOpService.getInstance().saveNew(dynamicObjects, Long.valueOf(0L), this.getInitInParam().getBatchNumber());
        AdminOrgInitServiceHelper.setInitDefaultValue((DynamicObject[])dynamicObjects, (long)this.getInitInParam().getBatchNumber());
        AdminOrgBusinessFileService.getInstance().saveNew(dynamicObjects, Long.valueOf(0L));
        DynamicObject[] newDynamicObjects = ((VersionChangeRespData)((BatchVersionChangeRespData)changeRespDataHisResponse.getData()).getVersionChangeRespDataList().get(0)).getNewDynamicObjects();
        List<DynamicObject> hisAdminOrgs = Stream.of(newDynamicObjects).filter(dy -> !dy.getBoolean("iscurrentversion")).collect(Collectors.toList());
        TransactionModelService opService = new TransactionModelService();
        opService.changeTransactionSave(Long.valueOf(1010L), ((BatchVersionChangeRespData)changeRespDataHisResponse.getData()).getEventId(), true, hisAdminOrgs.toArray(new DynamicObject[0]), null);
        this.saveAdminChgDetail(hisAdminOrgs);
        this.buildSaveSuccessInfo(initKeyAdminOrgMap);
        long end = System.currentTimeMillis();
        this.updateAdminStructProjectRootId();
        LOG.info("kd.hr.haos.mservice.HAOSBatchAdminOrgInitService.save is end. cast={}ms", (Object)(end - start));
    }

    private void updateAdminStructProjectRootId() {
        LOG.info("query AdminOrgStruct 1010");
        DynamicObject[] structs = StructProjectRepository.getInstance().loadByIds(Collections.singleton(1010L));
        if (structs == null || structs.length == 0) {
            LOG.info("can not find 1010 AdminOrgStruct");
            return;
        }
        MainEntityType dynamicObjectType = EntityMetadataCache.getDataEntityType((String)"haos_adminorgdetail");
        DynamicObject rootOrg = new DynamicObject((DynamicObjectType)dynamicObjectType);
        rootOrg.set("id", (Object)PlatformRootUtils.getLongRootIdOfPlatform());
        for (DynamicObject dyn : structs) {
            dyn.set("rootorg", (Object)rootOrg);
        }
        StructProjectRepository.getInstance().save(structs);
        LOG.info("query AdminOrgStruct 1010 end");
    }

    private void saveAdminChgDetail(List<DynamicObject> dynamicObjects) {
        ArrayList detailList = Lists.newArrayListWithCapacity((int)dynamicObjects.size());
        for (DynamicObject dyn : dynamicObjects) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("adminorg", dyn.getLong("boid"));
            map.put("initbatch", this.getInitInParam().getBatchNumber());
            map.put("initdatasource", "1");
            map.put("initstatus", "0");
            HashMap<String, Comparable<Date>> orgchgentryMap = new HashMap<String, Comparable<Date>>();
            orgchgentryMap.put("chgeffecttime", dyn.getDate("establishmentdate"));
            if (dyn.getBoolean("enable")) {
                orgchgentryMap.put("changescene", ChangeTransactionConstants.CHANGE_SCENE_NEW);
                orgchgentryMap.put("changetype", ChangeTransactionConstants.CHANGE_OPERATE_NEW);
            } else {
                orgchgentryMap.put("changescene", ChangeTransactionConstants.CHANGE_SCENE_DISABLE);
                orgchgentryMap.put("changetype", ChangeTransactionConstants.CHANGE_OPERATE_DISABLE);
            }
            orgchgentryMap.put("operator", Long.valueOf(RequestContext.get().getCurrUserId()));
            orgchgentryMap.put("operationtime", new Date());
            orgchgentryMap.put("afterchgorg", Long.valueOf(dyn.getLong("id")));
            map.put("orgchgentry", orgchgentryMap);
            detailList.add(map);
        }
        Map result = (Map)HRMServiceHelper.invokeODCService((String)"homs", (String)"IHOMSAdminChgDetailService", (String)"saveAdminChgDetail", (Object[])new Object[]{detailList});
        LOG.info("remote invoke odc-homs-IHOMSAdminChgDetailService-saveAdminChgDetail result [{}]", (Object)result);
    }

    private void resetOrgId(DynamicObject[] dynamicObjects) {
        HashMap<Long, Long> oldParentIdNewParentIdMap = new HashMap<Long, Long>();
        HashSet numbers = new HashSet();
        HashSet names = new HashSet();
        Stream.of(dynamicObjects).forEach(dy -> {
            numbers.add(dy.getString("number"));
            names.add(dy.getString("name"));
        });
        Map numberBaseOrgMap = AdminOrgInitServiceHelper.getBaseOrgInfoMap(numbers, (boolean)false);
        Map nameBaseOrgMap = AdminOrgInitServiceHelper.getBaseOrgInfoMapByName(names);
        for (DynamicObject dy2 : dynamicObjects) {
            boolean numberFlag;
            String number = dy2.getString("number");
            DynamicObject baseOrg = (DynamicObject)numberBaseOrgMap.get(number);
            if (baseOrg != null && baseOrg.getDataStorage() != null && (numberFlag = AdminOrgInitValidateServiceHelper.checkNumber((DynamicObject)dy2, (DynamicObject)baseOrg))) {
                oldParentIdNewParentIdMap.put(dy2.getLong("id"), baseOrg.getLong("org.id"));
                dy2.set("id", (Object)baseOrg.getLong("org.id"));
                continue;
            }
            String name = dy2.getString("name");
            List baseOrgInfos = (List)nameBaseOrgMap.get(name);
            DynamicObject baseOrgInfo = HAOSBatchAdminOrgInitService.findNameAndParentEqual(baseOrgInfos, dy2);
            if (baseOrgInfo == null) continue;
            oldParentIdNewParentIdMap.put(dy2.getLong("id"), baseOrgInfo.getLong("org.id"));
            dy2.set("id", (Object)baseOrgInfo.getLong("org.id"));
        }
        Set oldParentIds = oldParentIdNewParentIdMap.keySet();
        Stream.of(dynamicObjects).forEach(dy -> {
            long parentorg_Id = dy.getLong("parentorg_id");
            if (parentorg_Id > 0L && oldParentIds.contains(parentorg_Id)) {
                dy.set("parentorg_id", oldParentIdNewParentIdMap.get(parentorg_Id));
            }
        });
    }

    private static DynamicObject findNameAndParentEqual(List<DynamicObject> baseOrgInfos, DynamicObject dy) {
        if (CollectionUtils.isEmpty(baseOrgInfos)) {
            return null;
        }
        for (DynamicObject baseOrgInfo : baseOrgInfos) {
            if (baseOrgInfo.get("parent") == null || StringUtils.isEmpty((CharSequence)"parent.number") || !baseOrgInfo.getString("parent.number").equals(dy.getString("parentorg.number"))) continue;
            return baseOrgInfo;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeStatus() {
        TimeLogger timeLogger = TimeLogger.create();
        timeLogger.start();
        HRBaseServiceHelper orgDetailServiceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        long start = System.currentTimeMillis();
        TXHandle txHandle = TX.requiresNew();
        try {
            int pageSize = this.getPageSize();
            int orgInitSync = this.getOrgInitSync();
            List<String> entityNumbers = Arrays.asList("haos_adminorgdetail", "haos_adminorggroup", "haos_adminorgcompany", "haos_adminorgdepartment", "haos_adminorgstruct", "haos_orgsortcode", "haos_orgteamcooprel", "haos_adminorgteam", "haos_adminorgstructure", "haos_orgbusinessfile", "homs_orgchgrecord");
            this.changeStatusBySql(entityNumbers, timeLogger);
            if ("2".equals(this.getTargetStatus())) {
                QFilter[] filters = new QFilter[]{new QFilter("initbatch", "=", (Object)this.getInitInParam().getBatchNumber()), new QFilter("iscurrentversion", "=", (Object)"1"), new QFilter("enable", "=", (Object)"1")};
                int count = orgDetailServiceHelper.count("haos_adminorgdetail", filters);
                int pageCount = (int)Math.ceil((double)count / (double)pageSize);
                DynamicObject[] dynamicObjects = null;
                for (int pageIndex = 0; pageIndex < pageCount; ++pageIndex) {
                    dynamicObjects = BusinessDataServiceHelper.load((String)"haos_adminorgdetail", (String)"description,adminorgtype,parentorg,name,nameparentorg.id,boid,enable", (QFilter[])filters, (String)"id", (int)pageIndex, (int)pageSize);
                    if (1 == orgInitSync) {
                        timeLogger.check("sync platform");
                        HashSet orgIds = new HashSet();
                        Stream.of(dynamicObjects).forEach(dynamicObject -> {
                            dynamicObject.set("id", (Object)dynamicObject.getLong("boid"));
                            orgIds.add(dynamicObject.getLong("boid"));
                        });
                        Set baseOrgIds = AdminOrgInitServiceHelper.getBaseOrgInfoMapById(orgIds);
                        timeLogger.check("AdminOrgInitServiceHelper.getBaseOrgInfoMapById(orgIds)");
                        List<DynamicObject> afterFilterOrgs = Stream.of(dynamicObjects).filter(dy -> !baseOrgIds.contains(dy.getLong("boid"))).collect(Collectors.toList());
                        AdminOrgUnitSyncService.getInstance().syncAddBaseOrgMultiThread(afterFilterOrgs.toArray(new DynamicObject[0]));
                        timeLogger.check("syncAddBaseOrgMultiThread");
                    } else {
                        LOG.info("sync bos org param is {}", (Object)orgInitSync);
                    }
                    this.updateParentStructIsLeaf(dynamicObjects);
                    timeLogger.check("updateParentStructIsLeaf");
                    LOG.info("\u975e\u6839\u8282\u70b9\u6279\u6b21\u53f7: {}, \u521d\u59cb\u72b6\u6001: {}, \u76ee\u6807\u72b6\u6001 {}, \u5171\u5904\u7406\u6570\u636e\u91cf{}", new Object[]{this.getInitInParam().getBatchNumber(), "0", "2", count});
                }
                dynamicObjects = null;
            }
        }
        catch (Exception e) {
            LOG.error("kd.hr.haos.mservice.HAOSBatchAdminOrgInitService.changeStatus Exception ", (Throwable)e);
            txHandle.markRollback();
        }
        finally {
            txHandle.close();
            long end = System.currentTimeMillis();
            String logInfo = "kd.hr.haos.mservice.HAOSBatchAdminOrgInitService.changeStatus is end. cast=" + (end - start) + "ms";
            LOG.info(logInfo);
        }
        if ("2".equals(this.getTargetStatus())) {
            this.sortAdminOrgByLevelAndAddStrategy(orgDetailServiceHelper);
            timeLogger.check("sortAdminOrgByLevelAndAddStrategy");
            this.changeStrategyIfNeed(orgDetailServiceHelper);
            timeLogger.check("changeStrategyIfNeed");
        }
    }

    private int getPageSize() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_odcconfigparam");
        DynamicObject dynamicObject = serviceHelper.queryOne("value", new QFilter[]{new QFilter("number", "=", (Object)"OrgInitPageSIze")});
        return Integer.parseInt(dynamicObject.getString("value"));
    }

    private int getOrgInitSync() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_odcconfigparam");
        DynamicObject dynamicObject = serviceHelper.queryOne("value", new QFilter[]{new QFilter("number", "=", (Object)"OrgInitSync")});
        if (dynamicObject == null) {
            return 1;
        }
        return Integer.parseInt(dynamicObject.getString("value"));
    }

    private void changeStrategyIfNeed(HRBaseServiceHelper orgDetailServiceHelper) {
        DynamicObject[] dynamicObjects = orgDetailServiceHelper.query("boid", new QFilter[]{new QFilter("initbatch", "=", (Object)this.getInitInParam().getBatchNumber()), new QFilter("iscurrentversion", "=", (Object)"1"), new QFilter("enable", "=", (Object)"0")});
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return;
        }
        List orgList = Arrays.stream(dynamicObjects).map(dyn -> dyn.getLong("boid")).collect(Collectors.toList());
        OrgStrategyService.getInstance().disableOrgStrategy(orgList);
    }

    private void sortAdminOrgByLevelAndAddStrategy(HRBaseServiceHelper orgDetailServiceHelper) {
        DynamicObject[] dynamicObjects = orgDetailServiceHelper.query("id,parentorg,boid", new QFilter[]{new QFilter("initbatch", "=", (Object)this.getInitInParam().getBatchNumber()), new QFilter("iscurrentversion", "=", (Object)"1")});
        HashMap orgIdOrgMap = new HashMap(16);
        List<DynamicObject> enableDynList = Stream.of(dynamicObjects).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(enableDynList)) {
            return;
        }
        enableDynList.forEach(dy -> orgIdOrgMap.put(dy.getLong("id"), dy));
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey());
        QFilter filter = new QFilter("adminorg", "in", orgIdOrgMap.keySet()).and("iscurrentversion", "=", (Object)"1").and((QFilter)StructProjectConstants.ORG_STRUCT_FILTER.get());
        DynamicObjectCollection dynamicObjectCollection = serviceHelper.queryOriginalCollection("adminorg.id,level", new QFilter[]{filter}, "level asc");
        TreeMap<Long, Set> levelOrgIdsMap = new TreeMap<Long, Set>();
        dynamicObjectCollection.forEach(dy -> {
            long level = dy.getLong("level");
            Set orgIds = levelOrgIdsMap.getOrDefault(level, new TreeSet());
            orgIds.add(dy.getLong("adminorg.id"));
            levelOrgIdsMap.put(level, orgIds);
        });
        ArrayList orgList = new ArrayList();
        levelOrgIdsMap.forEach((level, orgIds) -> orgIds.forEach(orgId -> orgList.add(orgIdOrgMap.get(orgId))));
        OrgStrategyService.getInstance().addStrategy4Init(orgList);
    }

    private void updateParentStructIsLeaf(DynamicObject[] dynamicObjects) {
        if (!ArrayUtils.isEmpty((Object[])dynamicObjects)) {
            HashSet<Long> parentOrgIds = new HashSet<Long>();
            Stream.of(dynamicObjects).forEach(dy -> {
                long parentOrgId = dy.getLong("parentorg.id");
                if (parentOrgId > 0L) {
                    parentOrgIds.add(parentOrgId);
                }
            });
            this.updateParentOrgStructInfo(parentOrgIds);
            this.updateParentOrgTeamStructInfo(parentOrgIds);
        }
    }

    private void updateParentOrgTeamStructInfo(Set<Long> parentOrgIds) {
        QFilter boIdFilter = new QFilter("orgteam.boid", "in", parentOrgIds);
        QFilter isLeafFilter = new QFilter("isleaf", "=", (Object)"1");
        boIdFilter.and(isLeafFilter);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgstructure");
        DynamicObject[] orgTeamStructArray = serviceHelper.query("isleaf", new QFilter[]{boIdFilter});
        Stream.of(orgTeamStructArray).forEach(dy -> dy.set("isleaf", (Object)"0"));
        serviceHelper.update(orgTeamStructArray);
    }

    private void updateParentOrgStructInfo(Set<Long> parentOrgIds) {
        QFilter adminOrgFilter = new QFilter("adminorg", "in", parentOrgIds);
        QFilter isLeafFilter = new QFilter("isleaf", "=", (Object)"1");
        adminOrgFilter.and(isLeafFilter);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey());
        DynamicObject[] adminOrgStructArray = serviceHelper.loadDynamicObjectArray(new QFilter[]{adminOrgFilter, (QFilter)StructProjectConstants.ORG_STRUCT_FILTER.get()});
        Stream.of(adminOrgStructArray).forEach(dy -> dy.set("isleaf", (Object)"0"));
        serviceHelper.update(adminOrgStructArray);
    }

    public void rollback() {
        ArrayList<Long> orgIdList = new ArrayList<Long>();
        String openNewTX = System.getProperty("openNewTX", "false");
        LOG.info("HAOSBatchAdminOrgInitService rollback openNexTX : {}", (Object)openNewTX);
        if ("true".equals(openNewTX)) {
            this.deleteSyncDataWithSingleTX(orgIdList, this.getInitInParam().getBatchNumber());
        } else {
            this.deleteSyncData(orgIdList, this.getInitInParam().getBatchNumber());
        }
        OrgStrategyService.getInstance().disableOrgStrategy(orgIdList);
    }

    public void deleteSyncDataWithSingleTX(List<Long> orgIdList, Long batchNumber) {
        TimeLogger timeLogger = TimeLogger.create();
        timeLogger.start();
        TXHandle required = TX.required();
        Object object = null;
        try {
            try {
                this.orgUnitDelete(orgIdList, batchNumber);
            }
            catch (Throwable ex) {
                LOG.error("orgUnitDelete error ", ex);
                required.markRollback();
            }
        }
        catch (Throwable ex) {
            object = ex;
            throw ex;
        }
        finally {
            if (required != null) {
                if (object != null) {
                    try {
                        required.close();
                    }
                    catch (Throwable ex) {
                        ((Throwable)object).addSuppressed(ex);
                    }
                } else {
                    required.close();
                }
            }
        }
        timeLogger.check("orgUnitDelete");
        required = TX.required();
        object = null;
        try {
            try {
                this.deleteChangeTranDetail(orgIdList);
            }
            catch (Throwable ex) {
                LOG.error("deleteChangeTranDetail error ", ex);
                required.markRollback();
            }
        }
        catch (Throwable ex) {
            object = ex;
            throw ex;
        }
        finally {
            if (required != null) {
                if (object != null) {
                    try {
                        required.close();
                    }
                    catch (Throwable ex) {
                        ((Throwable)object).addSuppressed(ex);
                    }
                } else {
                    required.close();
                }
            }
        }
        timeLogger.check("deleteChangeTranDetail");
        List<String> entityNumbers = Arrays.asList("haos_adminorgdetail", "haos_adminorggroup", "haos_adminorgcompany", "haos_adminorgdepartment", "haos_adminorgstruct", "haos_orgsortcode", "haos_orgteamcooprel", "haos_adminorgteam", "haos_adminorgstructure", "haos_orgbusinessfile");
        for (String entityNumber : entityNumbers) {
            TXHandle required2 = TX.required();
            Throwable throwable = null;
            try {
                try {
                    int effectRow = this.deleteDataByFormId(entityNumber);
                    timeLogger.check("deleteDataByFormId formId: " + entityNumber + "  effected row: " + effectRow);
                }
                catch (Throwable ex) {
                    LOG.error("deleteDataByFormId {} error ", (Object)entityNumber, (Object)ex);
                    required2.markRollback();
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (required2 == null) continue;
                if (throwable != null) {
                    try {
                        required2.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                required2.close();
            }
        }
        try {
            Map result = (Map)DispatchServiceHelper.invokeBizService((String)"odc", (String)"homs", (String)"IHOMSAdminChgDetailService", (String)"deleteAdminChgByInitBatch", (Object[])new Object[]{this.getInitInParam().getBatchNumber()});
            LOG.info("remote invoke odc-homs-IHOMSAdminChgDetailService-deleteAdminChgByInitBatch result [{}]", (Object)result);
        }
        catch (Exception ex) {
            LOG.error("IHOMSAdminChgDetailService deleteAdminChgByInitBatch error ", (Throwable)ex);
        }
        timeLogger.check("IHOMSAdminChgDetailService deleteAdminChgByInitBatch");
    }

    private void orgUnitDelete(List<Long> orgIdList, Long batchNumber) {
        HRBaseServiceHelper orgDetailServiceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        DynamicObject[] dynamicObjects = orgDetailServiceHelper.query("id,name,number,parentorg,description", new QFilter[]{new QFilter("initbatch", "=", (Object)batchNumber)});
        List orgParamList = AdminOrgInitServiceHelper.assembleOrgParamByAdminOrg((DynamicObject[])dynamicObjects);
        Stream.of(dynamicObjects).forEach(dy -> orgIdList.add(dy.getLong("id")));
        OrgUnitServiceHelper.delete((List)orgParamList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSyncData(List<Long> orgIdList, Long batchNumber) {
        long start = System.currentTimeMillis();
        TXHandle txHandle = TX.requiresNew();
        try {
            HRBaseServiceHelper orgDetailServiceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
            DynamicObject[] dynamicObjects = orgDetailServiceHelper.loadDynamicObjectArray("haos_adminorgdetail", new QFilter[]{new QFilter("initbatch", "=", (Object)batchNumber)});
            List orgParamList = AdminOrgInitServiceHelper.assembleOrgParamByAdminOrg((DynamicObject[])dynamicObjects);
            Stream.of(dynamicObjects).forEach(dy -> orgIdList.add(dy.getLong("id")));
            OrgUnitServiceHelper.delete((List)orgParamList);
            this.deleteChangeTranDetail(orgIdList);
            this.deleteDataByFormId("haos_adminorgdetail");
            this.deleteDataByFormId("haos_adminorggroup");
            this.deleteDataByFormId("haos_adminorgcompany");
            this.deleteDataByFormId("haos_adminorgdepartment");
            this.deleteDataByFormId("haos_adminorgstruct");
            this.deleteDataByFormId("haos_orgsortcode");
            this.deleteDataByFormId("haos_orgteamcooprel");
            this.deleteDataByFormId("haos_adminorgteam");
            this.deleteDataByFormId("haos_adminorgstructure");
            this.deleteDataByFormId("haos_orgbusinessfile");
            Map result = (Map)DispatchServiceHelper.invokeBizService((String)"odc", (String)"homs", (String)"IHOMSAdminChgDetailService", (String)"deleteAdminChgByInitBatch", (Object[])new Object[]{this.getInitInParam().getBatchNumber()});
            LOG.info("remote invoke odc-homs-IHOMSAdminChgDetailService-deleteAdminChgByInitBatch result [{}]", (Object)result);
        }
        catch (Exception e) {
            LOG.error("kd.hr.haos.mservice.HAOSBatchAdminOrgInitService.rollback Exception ", (Throwable)e);
            txHandle.markRollback();
        }
        finally {
            txHandle.close();
            long end = System.currentTimeMillis();
            String logInfo = "kd.hr.haos.mservice.HAOSBatchAdminOrgInitService.rollback is end. cast=" + (end - start) + "ms";
            LOG.info(logInfo);
        }
    }

    private void deleteChangeTranDetail(List<Long> orgIdList) {
        HRBaseServiceHelper operateDetailHelper = new HRBaseServiceHelper("haos_changeoperdetail");
        HRBaseServiceHelper transactionDetailHelper = new HRBaseServiceHelper("haos_changetrandetail");
        HRBaseServiceHelper transactionSumHelper = new HRBaseServiceHelper("haos_changetransum");
        QFilter[] qFilters = new QFilter[]{new QFilter("afterorg", "in", orgIdList)};
        operateDetailHelper.deleteByFilter(qFilters);
        transactionDetailHelper.deleteByFilter(qFilters);
        transactionSumHelper.deleteByFilter(qFilters);
    }

    private int deleteDataByFormId(String formId) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(formId);
        QFilter[] qFilters = new QFilter[]{new QFilter("initbatch", "=", (Object)this.getInitInParam().getBatchNumber()), new QFilter("initstatus", "!=", (Object)"2")};
        return hrBaseServiceHelper.deleteByFilter(qFilters);
    }

    protected void buildSaveSuccessInfo(Map<Long, DynamicObject> initKeyAdminOrgMap) {
        HRBaseServiceHelper orgDetailServiceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        DynamicObject[] dynamicObjects = orgDetailServiceHelper.query("id,boid,initstatus", new QFilter[]{new QFilter("initbatch", "=", (Object)this.getInitInParam().getBatchNumber()), new QFilter("initstatus", "=", (Object)Character.valueOf('0'))});
        Map<Long, Long> orgIdBoIdMap = Stream.of(dynamicObjects).collect(Collectors.toMap(dy -> dy.getLong("id"), dy1 -> dy1.getLong("boid")));
        initKeyAdminOrgMap.forEach((initKey, dy) -> {
            long boId = (Long)orgIdBoIdMap.get(dy.getLong("id"));
            if (boId > 0L) {
                this.getInitOutParam().addSuccessMsg(initKey, String.valueOf(boId), null);
            }
        });
    }

    protected DynamicObject[] queryDataByServiceHelper(HRBaseServiceHelper hrBaseServiceHelper) {
        DynamicObject[] dynamicObjects;
        for (DynamicObject dynamicObject : dynamicObjects = hrBaseServiceHelper.query("initstatus", new QFilter[]{new QFilter("initbatch", "=", (Object)this.getInitInParam().getBatchNumber()), new QFilter("initstatus", "!=", (Object)"2")})) {
            dynamicObject.set("initstatus", (Object)this.getTargetStatus());
        }
        Stream.of(dynamicObjects).forEach(it -> this.getInitOutParam().getHandleIdSet().add(it.getLong("id")));
        return dynamicObjects;
    }

    protected void queryDataByServiceHelperWithUpdate(HRBaseServiceHelper hrBaseServiceHelper, String entityName, int pageSize) {
        QFilter[] filters = new QFilter[]{new QFilter("initbatch", "=", (Object)this.getInitInParam().getBatchNumber()), new QFilter("initstatus", "!=", (Object)this.getTargetStatus())};
        int count = hrBaseServiceHelper.count(entityName, filters);
        int pageCount = (int)Math.ceil((double)count / (double)pageSize);
        DynamicObject[] dynamicObjects = null;
        for (int pageIndex = 0; pageIndex < pageCount; ++pageIndex) {
            for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)entityName, (String)"initstatus", (QFilter[])filters, (String)"id", (int)0, (int)pageSize)) {
                dynamicObject.set("initstatus", (Object)this.getTargetStatus());
            }
            hrBaseServiceHelper.update(dynamicObjects);
            Stream.of(dynamicObjects).forEach(it -> this.getInitOutParam().getHandleIdSet().add(it.getLong("id")));
            dynamicObjects = null;
        }
    }

    public void changeStatusBySql(List<String> entityNumber, TimeLogger timeLogger) {
        for (String number : entityNumber) {
            StringBuilder sb = new StringBuilder();
            sb.append("update ");
            String alias = MetadataServiceHelper.getDataEntityType((String)number).getAlias();
            sb.append(alias);
            sb.append(" ");
            sb.append("set finitstatus = ? where finitbatch = ?");
            int effectedCount = HRDBUtil.update((DBRoute)new DBRoute("haos"), (String)sb.toString(), (Object[])new Object[]{this.getTargetStatus(), this.getInitInParam().getBatchNumber()});
            timeLogger.check(String.format("HRDBUtil update table %s , initstatus %s, initbatch %s, effectdeCount %s", alias, this.getTargetStatus(), this.getInitInParam().getBatchNumber(), effectedCount));
            sb.setLength(0);
        }
    }
}

