/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.mservice;

import com.google.common.collect.Maps;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.haos.business.domain.repository.adorg.AdOrgRepository;
import kd.hr.haos.mservice.api.IHAOSBatchAdminOrgOperateService;
import kd.hr.haos.mservice.webapi.api.utils.AdminOrgOperateUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.lang3.StringUtils;

public class HAOSBatchAdminOrgOperateService
implements IHAOSBatchAdminOrgOperateService {
    public Map<String, Object> addNew(ArrayList<DynamicObject> dynObjList) {
        DynamicObject[] adminOrgDynObjs;
        Map<Object, Object> resultMap = new HashMap();
        resultMap = AdminOrgOperateUtils.dataSizeCheck(dynObjList.size());
        if (HRObjectUtils.isEmpty(resultMap)) {
            return resultMap;
        }
        ArrayList resultList = new ArrayList();
        ArrayList<Object> successNumberList = new ArrayList<Object>();
        HashMap<String, String> errorMap = new HashMap<String, String>(dynObjList.size());
        HashMap<String, Long> sucessMap = new HashMap<String, Long>(dynObjList.size());
        HashMap<String, Object> parentMap = AdminOrgOperateUtils.getParentDynObj(dynObjList, "parentorg");
        DynamicObject dynamicObject = null;
        for (int i = 0; i < dynObjList.size(); ++i) {
            dynamicObject = dynObjList.get(i);
            this.setParentDynWhenAdd(dynamicObject, parentMap);
            String checkInfo = AdminOrgOperateUtils.dataCheck(dynamicObject, 1);
            if (!checkInfo.equals("")) {
                errorMap.put((String)dynamicObject.get("number"), checkInfo);
                continue;
            }
            dynamicObject = this.setPropWhenAdd(dynamicObject, parentMap);
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"homs_orgfastchgadd", (DynamicObject[])new DynamicObject[]{dynamicObject}, (OperateOption)this.createOperateOption());
            if (operationResult == null) continue;
            if (operationResult.isSuccess()) {
                successNumberList.add(dynamicObject.get("number"));
                continue;
            }
            errorMap.put((String)dynamicObject.get("number"), AdminOrgOperateUtils.getErrorInfoToString(operationResult));
        }
        QFilter idFilter = new QFilter("number", "in", successNumberList);
        for (DynamicObject dynObj : adminOrgDynObjs = AdOrgRepository.queryAdminHisInfo((String)"boid,number", (QFilter)idFilter, (Date)new Date())) {
            sucessMap.put((String)dynObj.get("number"), (Long)dynObj.get("boid"));
        }
        resultList.add(errorMap);
        resultList.add(sucessMap);
        if (errorMap.size() != 0) {
            resultMap.put("errorCode", false);
            resultMap.put("data", resultList);
        } else {
            resultMap.put("errorCode", true);
            resultMap.put("data", resultList);
        }
        return resultMap;
    }

    private void setParentDynWhenAdd(DynamicObject dynamicObject, HashMap parentMap) {
        Object parentOrgId = dynamicObject.get("parentorg.boid");
        if (parentOrgId == null) {
            dynamicObject.set("parentorg", null);
        } else {
            DynamicObject parentDynObj;
            if (!parentMap.containsKey(parentOrgId) && (parentDynObj = AdminOrgOperateUtils.getParentDynObj(dynamicObject, "parentorg")) != null) {
                parentMap.put(parentOrgId, parentDynObj);
            }
            dynamicObject.set("parentorg", parentMap.get(parentOrgId));
        }
    }

    private DynamicObject setPropWhenAdd(DynamicObject dynamicObject, HashMap parentMap) {
        dynamicObject.set("establishmentdate", dynamicObject.get("effdt"));
        dynamicObject.set("changescene", (Object)AdminOrgOperateUtils.getBaseInfoDynObj("haos_changescene", 1010L, null));
        dynamicObject.set("changetype", (Object)AdminOrgOperateUtils.getBaseInfoDynObj("haos_orgchangetype", 1010L, null));
        return AdminOrgOperateUtils.setDynamicObject(dynamicObject, parentMap);
    }

    public Map<String, Object> changeAction(ArrayList<DynamicObject> dynObjList, int type) {
        Map<Object, Object> resultMap = new HashMap();
        DynamicObject dynamicObject = null;
        resultMap = AdminOrgOperateUtils.dataSizeCheck(dynObjList.size());
        if (HRObjectUtils.isEmpty(resultMap)) {
            return resultMap;
        }
        HashMap<String, Object> oldAdminOrgMap = AdminOrgOperateUtils.getParentDynObj(dynObjList, "adminorg");
        HashMap<String, Object> parentDynObjMap = AdminOrgOperateUtils.getParentDynObj(dynObjList, "parentorg");
        HashMap<String, String> errorMap = new HashMap<String, String>();
        for (int i = 0; i < dynObjList.size(); ++i) {
            dynamicObject = dynObjList.get(i);
            dynamicObject.set("parentorg", parentDynObjMap.get(dynamicObject.get("parentorg.boid")));
            String checkInfo = AdminOrgOperateUtils.dataCheck(dynamicObject, type);
            if (!checkInfo.equals("")) {
                errorMap.put((String)dynamicObject.get("number"), checkInfo);
                continue;
            }
            DynamicObject oldOrgDynObj = (DynamicObject)oldAdminOrgMap.get(dynamicObject.get("adminorg.boid"));
            if (type == 2) {
                if (oldOrgDynObj.get("parentorg.boid").equals(dynamicObject.get("parentorg.boid"))) {
                    errorMap.put((String)dynamicObject.get("number"), "parent org no change");
                    continue;
                }
                dynamicObject.set("changescene", (Object)AdminOrgOperateUtils.getBaseInfoDynObj("haos_changescene", 1020L, null));
                dynamicObject.set("changetype", (Object)AdminOrgOperateUtils.getBaseInfoDynObj("haos_orgchangetype", 1020L, null));
            } else if (type == 3) {
                if (!oldOrgDynObj.get("parentorg.boid").equals(dynamicObject.get("parentorg.boid"))) {
                    errorMap.put((String)dynamicObject.get("number"), "parent org can not change");
                    continue;
                }
                dynamicObject.set("changescene", (Object)AdminOrgOperateUtils.getBaseInfoDynObj("haos_changescene", 1030L, null));
                dynamicObject.set("changetype", (Object)AdminOrgOperateUtils.getBaseInfoDynObj("haos_orgchangetype", 1030L, null));
            }
            dynamicObject = AdminOrgOperateUtils.setDynamicObject(dynamicObject, parentDynObjMap);
            dynamicObject.set("establishmentdate", oldOrgDynObj.get("establishmentdate"));
            dynamicObject.set("parentorgold", oldOrgDynObj.get("parentorg"));
            dynamicObject.set("nameold", (Object)"");
            if (dynamicObject.get("org") == null) {
                dynamicObject.set("org", oldOrgDynObj.get("org"));
            }
            dynamicObject.set("openapiflag", (Object)"1");
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)(type == 2 ? "homs_orgfastchgparent" : "homs_orgfastchginfo"), (DynamicObject[])new DynamicObject[]{dynamicObject}, (OperateOption)this.createOperateOption());
            if (operationResult == null || operationResult.isSuccess()) continue;
            errorMap.put((String)dynamicObject.get("number"), AdminOrgOperateUtils.getErrorInfoToString(operationResult));
        }
        if (errorMap.size() != 0) {
            resultMap.put("errorCode", false);
            resultMap.put("data", errorMap);
        } else {
            resultMap.put("errorCode", true);
        }
        return resultMap;
    }

    private Map<String, Object> disableAndEnableAction(List<Long> idList, Long buId, Date effectDate, int type, String entityName) {
        HashMap<String, Object> resultMap = new HashMap();
        DynamicObject dynObj = new DynamicObject();
        if (effectDate == null) {
            effectDate = new Date();
        }
        if (HRObjectUtils.isEmpty(resultMap = AdminOrgOperateUtils.dataSizeCheck(idList.size()))) {
            return resultMap;
        }
        if (idList.size() > 0 && idList.get(0) == null) {
            resultMap.put("message", "ids is empty");
            resultMap.put("errorCode", false);
            return resultMap;
        }
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityName);
        dynObj = new DynamicObject((DynamicObjectType)dataEntityType);
        if (type == 4) {
            dynObj.set("billchangescene", (Object)AdminOrgOperateUtils.getBaseInfoDynObj("haos_changescene", 1070L, null));
            dynObj.set("billchangetype", (Object)AdminOrgOperateUtils.getBaseInfoDynObj("haos_orgchangetype", 1030L, null));
        } else if (type == 5) {
            dynObj.set("billchangescene", (Object)AdminOrgOperateUtils.getBaseInfoDynObj("haos_changescene", 1040L, null));
            dynObj.set("billchangetype", (Object)AdminOrgOperateUtils.getBaseInfoDynObj("haos_orgchangetype", 1040L, null));
        }
        dynObj.set("billtype", (Object)"1");
        dynObj.set("billstatus", (Object)"C");
        dynObj.set("auditstatus", (Object)"C");
        QFilter idFilter = new QFilter("boid", "in", idList);
        DynamicObject[] adminOrgDynObjs = AdOrgRepository.queryAdminHisInfo((QFilter)idFilter, (Date)new Date());
        HashMap<Object, DynamicObject> orgDynObjMaps = new HashMap<Object, DynamicObject>();
        for (DynamicObject dynamicObject : adminOrgDynObjs) {
            orgDynObjMaps.put(dynamicObject.get("boid"), dynamicObject);
        }
        Set<Object> disableOrgInTheBillSet = new HashSet();
        if (type == 4) {
            disableOrgInTheBillSet = AdminOrgOperateUtils.getOrgByBillEntry(1040L);
        }
        if (adminOrgDynObjs.length != idList.size()) {
            resultMap.put("message", "Some org don't exist");
            resultMap.put("errorCode", false);
            return resultMap;
        }
        if (!AdminOrgOperateUtils.isValidDate(AdminOrgOperateUtils.dateToString(effectDate))) {
            resultMap.put("message", "The date format is incorrect");
            resultMap.put("errorCode", false);
            return resultMap;
        }
        if (HRDateTimeUtils.dayBefore((Date)new Date(), (Date)effectDate)) {
            resultMap.put("message", "The effdt cannot be in the future");
            resultMap.put("errorCode", false);
            return resultMap;
        }
        HashMap<String, String> errorMap = new HashMap<String, String>();
        DynamicObjectCollection entryEntity = dynObj.getDynamicObjectCollection("entryEntity");
        for (int i = 0; i < idList.size(); ++i) {
            Long adminOrgId = idList.get(i);
            DynamicObject dynamicObject = (DynamicObject)orgDynObjMaps.get(adminOrgId);
            DynamicObject entryDynObj = new DynamicObject(entryEntity.getDynamicObjectType());
            if (!HRObjectUtils.isEmpty(disableOrgInTheBillSet) && disableOrgInTheBillSet.contains(dynamicObject.get("parentorg.boid"))) {
                errorMap.put((String)dynamicObject.get("number"), "parentorg will be disable in the bill");
                continue;
            }
            if (type == 4 && AdminOrgOperateUtils.checkSameNameInTheBill((Long)dynamicObject.get("boid"), (Long)dynamicObject.get("parentorg.boid"), dynamicObject.get("name").toString())) {
                errorMap.put((String)dynamicObject.get("number"), "exists on the bill under the same parentorg with the same name");
                continue;
            }
            entryDynObj.set("adminorg", (Object)dynamicObject);
            entryDynObj.set("parentorg", dynamicObject.get("parentorg"));
            entryDynObj.set("adminorgtype", dynamicObject.get("adminorgtype"));
            entryDynObj.set("entry_org", dynamicObject.get("org"));
            entryDynObj.set("changetype", dynObj.get("billchangetype"));
            entryEntity.add(0, entryDynObj);
            dynObj.set("org", dynamicObject.get("org"));
            dynObj.set("effdt", (Object)effectDate);
            dynObj.set("entryentity", (Object)entryEntity);
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)entityName, (DynamicObject[])new DynamicObject[]{dynObj}, (OperateOption)this.createOperateOption());
            if (operationResult != null && !operationResult.isSuccess()) {
                errorMap.put((String)dynamicObject.get("number"), AdminOrgOperateUtils.getErrorInfoToString(operationResult));
            }
            entryEntity.remove(0);
        }
        if (errorMap.size() > 0) {
            resultMap.put("errorCode", false);
            resultMap.put("data", errorMap);
        } else {
            resultMap.put("errorCode", true);
        }
        return resultMap;
    }

    public Map<String, Object> changeParent(ArrayList<DynamicObject> dynObjList) {
        return this.changeAction(dynObjList, 2);
    }

    public Map<String, Object> change(ArrayList<DynamicObject> dynObjList) {
        return this.changeAction(dynObjList, 3);
    }

    public Map<String, Object> enable(List<Long> idList, Long buId, Date effectDate) {
        return this.disableAndEnableAction(idList, buId, effectDate, 4, "homs_orgfastchgenable");
    }

    public Map<String, Object> disable(List<Long> idList, Long buId, Date effectDate) {
        return this.disableAndEnableAction(idList, buId, effectDate, 5, "homs_orgfastchgdisable");
    }

    private OperateOption createOperateOption() {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ishasright", "true");
        return operateOption;
    }

    public Map<String, Object> addNewWithEnableStatus(ArrayList<DynamicObject> dynObjList) {
        Map<String, Object> resultMap = AdminOrgOperateUtils.dataSizeCheck(dynObjList.size());
        if (resultMap.size() > 0) {
            return resultMap;
        }
        HashMap dataMap = new HashMap();
        HashMap<String, String> errorMap = new HashMap<String, String>(dynObjList.size());
        HashMap<String, Long> sucessMap = new HashMap<String, Long>(dynObjList.size());
        HashMap<String, Object> parentMap = AdminOrgOperateUtils.getParentDynObj(dynObjList, "parentorg");
        List paramOrgIdList = dynObjList.stream().filter(dyn -> dyn.getLong("orgid") > 0L).map(dyn -> dyn.getLong("orgid")).collect(Collectors.toList());
        List existIds = AdOrgRepository.getInstance().queryExistIds(paramOrgIdList);
        List noOrgIdDynList = dynObjList.stream().filter(dyn -> dyn.getLong("orgid") == 0L).collect(Collectors.toList());
        long[] ids = ORM.create().genLongIds("haos_adminorgdetail", noOrgIdDynList.size());
        int index = 0;
        for (DynamicObject dynamicObject : dynObjList) {
            OperationResult operationResult;
            if (HRStringUtils.isEmpty((String)dynamicObject.getString("billenable"))) {
                dynamicObject.set("billenable", (Object)"1");
            }
            this.setParentDynWhenAdd(dynamicObject, parentMap);
            String checkInfo = AdminOrgOperateUtils.dataCheck(dynamicObject, 1);
            if (!checkInfo.equals("")) {
                errorMap.put((String)dynamicObject.get("number"), checkInfo);
                continue;
            }
            long orgid = (dynamicObject = this.setPropWhenAdd(dynamicObject, parentMap)).getLong("orgid");
            if (orgid < 0L) {
                errorMap.put((String)dynamicObject.get("number"), "parameter orgid is wrong");
                continue;
            }
            if (existIds.contains(orgid)) {
                errorMap.put((String)dynamicObject.get("number"), "orgid exist");
                continue;
            }
            if (this.setOrgId(dynamicObject, ids, index)) {
                ++index;
            }
            OperateOption operateOption = this.createOperateOption();
            String billenable = dynamicObject.getString("billenable");
            if (HRStringUtils.equals((String)billenable, (String)"0")) {
                operateOption.setVariableValue("isDisable", "true");
            }
            if ((operationResult = OperationServiceHelper.executeOperate((String)"mservice_save", (String)"homs_orgfastchgadd", (DynamicObject[])new DynamicObject[]{dynamicObject}, (OperateOption)operateOption)) == null) continue;
            if (operationResult.isSuccess()) {
                sucessMap.put(dynamicObject.getString("number"), dynamicObject.getLong("orgid"));
                continue;
            }
            errorMap.put((String)dynamicObject.get("number"), AdminOrgOperateUtils.getErrorInfoToString(operationResult));
        }
        dataMap.put("success", sucessMap);
        dataMap.put("fail", errorMap);
        resultMap.put("data", dataMap);
        resultMap.put("errorCode", Boolean.TRUE);
        if (errorMap.size() > 0) {
            resultMap.put("errorCode", Boolean.FALSE);
        }
        return resultMap;
    }

    public Map<String, Object> changeWithEnableStatus(ArrayList<DynamicObject> dynObjList) {
        return this.changeActionWithEanbleStatus(dynObjList, 3);
    }

    public Map<String, Object> changeParentWithEnableStatus(ArrayList<DynamicObject> dynObjList) {
        return this.changeActionWithEanbleStatus(dynObjList, 2);
    }

    private Map<String, Object> changeActionWithEanbleStatus(ArrayList<DynamicObject> dynObjList, int type) {
        Map<Object, Object> resultMap = new HashMap();
        DynamicObject dynamicObject = null;
        resultMap = AdminOrgOperateUtils.dataSizeCheck(dynObjList.size());
        if (resultMap.size() > 0) {
            return resultMap;
        }
        HashMap<String, Object> oldAdminOrgMap = AdminOrgOperateUtils.getParentDynObj(dynObjList, "adminorg");
        HashMap<String, Object> parentDynObjMap = AdminOrgOperateUtils.getParentDynObj(dynObjList, "parentorg");
        HashMap<String, String> errorMap = new HashMap<String, String>();
        for (int i = 0; i < dynObjList.size(); ++i) {
            dynamicObject = dynObjList.get(i);
            if (HRStringUtils.isEmpty((String)dynamicObject.getString("billenable"))) {
                errorMap.put((String)dynamicObject.get("number"), "billenable must not be blank");
                continue;
            }
            dynamicObject.set("parentorg", parentDynObjMap.get(dynamicObject.get("parentorg.boid")));
            String checkInfo = AdminOrgOperateUtils.dataCheck(dynamicObject, type);
            if (!checkInfo.equals("")) {
                errorMap.put((String)dynamicObject.get("number"), checkInfo);
                continue;
            }
            DynamicObject oldOrgDynObj = (DynamicObject)oldAdminOrgMap.get(dynamicObject.get("adminorg.boid"));
            if (oldOrgDynObj == null) {
                errorMap.put((String)dynamicObject.get("number"), "cannot find org by boid");
                continue;
            }
            dynamicObject.set("adminorg", (Object)oldOrgDynObj);
            String disableCheckInfo = this.disableCheck(oldOrgDynObj, dynamicObject);
            if (!disableCheckInfo.equals("")) {
                errorMap.put((String)dynamicObject.get("number"), disableCheckInfo);
                continue;
            }
            if (type == 2) {
                if (oldOrgDynObj.get("parentorg.boid").equals(dynamicObject.get("parentorg.boid"))) {
                    errorMap.put((String)dynamicObject.get("number"), "parent org no change");
                    continue;
                }
                dynamicObject.set("changescene", (Object)AdminOrgOperateUtils.getBaseInfoDynObj("haos_changescene", 1020L, null));
                dynamicObject.set("changetype", (Object)AdminOrgOperateUtils.getBaseInfoDynObj("haos_orgchangetype", 1020L, null));
            } else if (type == 3) {
                if (!oldOrgDynObj.get("parentorg.boid").equals(dynamicObject.get("parentorg.boid"))) {
                    errorMap.put((String)dynamicObject.get("number"), "parent org can not change");
                    continue;
                }
                dynamicObject.set("changescene", (Object)AdminOrgOperateUtils.getBaseInfoDynObj("haos_changescene", 1030L, null));
                dynamicObject.set("changetype", (Object)AdminOrgOperateUtils.getBaseInfoDynObj("haos_orgchangetype", 1030L, null));
            }
            dynamicObject = AdminOrgOperateUtils.setDynamicObject(dynamicObject, parentDynObjMap);
            dynamicObject.set("establishmentdate", oldOrgDynObj.get("establishmentdate"));
            dynamicObject.set("parentorgold", oldOrgDynObj.get("parentorg"));
            dynamicObject.set("nameold", (Object)"");
            if (dynamicObject.get("org") == null) {
                dynamicObject.set("org", oldOrgDynObj.get("org"));
            }
            dynamicObject.set("openapiflag", (Object)"1");
            OperateOption operateOption = this.createOperateOption();
            String enableStatusChangeType = this.getEnableStatusChangeType(oldOrgDynObj, dynamicObject);
            operateOption.setVariableValue("enableStatusChangeType", enableStatusChangeType);
            OperationResult operationResult = type == 3 ? OperationServiceHelper.executeOperate((String)"mservice_save", (String)"homs_orgfastchginfo", (DynamicObject[])new DynamicObject[]{dynamicObject}, (OperateOption)operateOption) : OperationServiceHelper.executeOperate((String)"mservice_save", (String)"homs_orgfastchgparent", (DynamicObject[])new DynamicObject[]{dynamicObject}, (OperateOption)operateOption);
            if (operationResult == null || operationResult.isSuccess()) continue;
            errorMap.put((String)dynamicObject.get("number"), AdminOrgOperateUtils.getErrorInfoToString(operationResult));
        }
        if (errorMap.size() != 0) {
            resultMap.put("errorCode", Boolean.FALSE);
            resultMap.put("data", errorMap);
        } else {
            resultMap.put("errorCode", Boolean.TRUE);
        }
        return resultMap;
    }

    public Map<String, Object> disableNew(Map<String, Object> disableParams) {
        String entityName = "homs_orgfastchgdisable";
        Map<Object, Object> resultMap = Maps.newHashMapWithExpectedSize((int)16);
        DynamicObject dynObj = new DynamicObject();
        Object orgIds = disableParams.get("orgIds");
        if (orgIds == null) {
            resultMap.put("message", "The orgIds must not be null");
            resultMap.put("errorCode", false);
            return resultMap;
        }
        ArrayList idList = new ArrayList();
        if (orgIds instanceof List) {
            List idStringList = (List)orgIds;
            idStringList.stream().forEach(idString -> idList.add(Long.parseLong(idString)));
        }
        Object changeSceneObject = disableParams.get("changeScene");
        DynamicObject changeSceneDyn = null;
        DynamicObject changeReasonDyn = null;
        if (changeSceneObject != null) {
            Long changeSceneId = Long.parseLong((String)changeSceneObject);
            changeSceneDyn = AdminOrgOperateUtils.getBaseInfoDynObj("haos_changescene", changeSceneId, null);
            if (changeSceneDyn == null) {
                resultMap.put("message", "The changeScene is not in db,please check your changeScene ");
                resultMap.put("errorCode", false);
                return resultMap;
            }
            long changeTypeId = changeSceneDyn.getLong("orgchangetype.id");
            if (changeTypeId != 1040L) {
                resultMap.put("message", "The changeType of changeScene is not correct (eg. 1040L) ");
                resultMap.put("errorCode", false);
                return resultMap;
            }
            DynamicObjectCollection changeReasonCollection = changeSceneDyn.getDynamicObjectCollection("changereason");
            HashSet changeReasonIdSet = new HashSet(changeReasonCollection.size());
            changeReasonCollection.forEach(dyn -> changeReasonIdSet.add(dyn.getLong("fbasedataid.id")));
            Object changeReasonObject = disableParams.get("changeReason");
            if (changeReasonObject instanceof String) {
                DynamicObject[] changeReasonId = Long.valueOf(Long.parseLong((String)changeReasonObject));
                if (!changeReasonIdSet.contains(changeReasonId)) {
                    resultMap.put("message", "The changeReason is not in changeScene");
                    resultMap.put("errorCode", false);
                    return resultMap;
                }
                changeReasonDyn = AdminOrgOperateUtils.getBaseInfoDynObj("haos_orgchangereason", (Long)changeReasonId, null);
            }
        }
        Date effectDate = null;
        Object effectDateObject = disableParams.get("effectDate");
        if (effectDateObject == null) {
            effectDate = new Date();
        } else {
            try {
                effectDate = HRDateTimeUtils.parseDate((String)((String)effectDateObject));
            }
            catch (ParseException e) {
                resultMap.put("message", "effectDate must be YYYY-MM-dd");
                resultMap.put("errorCode", false);
                return resultMap;
            }
        }
        resultMap = AdminOrgOperateUtils.dataSizeCheck(idList.size());
        if (HRObjectUtils.isEmpty((Object)resultMap)) {
            return resultMap;
        }
        if (idList.size() > 0 && idList.get(0) == null) {
            resultMap.put("message", "The orgIds is empty");
            resultMap.put("errorCode", false);
            return resultMap;
        }
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityName);
        dynObj = new DynamicObject((DynamicObjectType)dataEntityType);
        dynObj.set("billchangescene", (Object)(changeSceneDyn != null ? changeSceneDyn : AdminOrgOperateUtils.getBaseInfoDynObj("haos_changescene", 1040L, null)));
        dynObj.set("billchangereason", changeReasonDyn);
        dynObj.set("billchangetype", (Object)AdminOrgOperateUtils.getBaseInfoDynObj("haos_orgchangetype", 1040L, null));
        dynObj.set("billchangedescription", disableParams.get("changeDescription"));
        dynObj.set("billtype", (Object)"1");
        dynObj.set("billstatus", (Object)"C");
        dynObj.set("auditstatus", (Object)"C");
        QFilter idFilter = new QFilter("boid", "in", idList);
        DynamicObject[] adminOrgDynObjs = AdOrgRepository.queryAdminHisInfo((QFilter)idFilter, (Date)new Date());
        HashMap<Object, DynamicObject> orgDynObjMaps = new HashMap<Object, DynamicObject>();
        for (DynamicObject dynamicObject : adminOrgDynObjs) {
            orgDynObjMaps.put(dynamicObject.get("boid"), dynamicObject);
        }
        Set<Long> disableOrgInTheBillSet = AdminOrgOperateUtils.getOrgByBillEntry(1040L);
        if (adminOrgDynObjs.length != idList.size()) {
            resultMap.put("message", "Some org don't exist");
            resultMap.put("errorCode", false);
            return resultMap;
        }
        if (!AdminOrgOperateUtils.isValidDate(AdminOrgOperateUtils.dateToString(effectDate))) {
            resultMap.put("message", "The effectDate format is incorrect");
            resultMap.put("errorCode", false);
            return resultMap;
        }
        if (HRDateTimeUtils.dayBefore((Date)new Date(), (Date)effectDate)) {
            resultMap.put("message", "The effectDate cannot be in the future");
            resultMap.put("errorCode", false);
            return resultMap;
        }
        HashMap<String, String> errorMap = new HashMap<String, String>();
        DynamicObjectCollection entryEntity = dynObj.getDynamicObjectCollection("entryEntity");
        for (int i = 0; i < idList.size(); ++i) {
            Long adminOrgId = (Long)idList.get(i);
            DynamicObject dynamicObject = (DynamicObject)orgDynObjMaps.get(adminOrgId);
            DynamicObject entryDynObj = new DynamicObject(entryEntity.getDynamicObjectType());
            if (!HRObjectUtils.isEmpty(disableOrgInTheBillSet) && disableOrgInTheBillSet.contains(dynamicObject.get("parentorg.boid"))) {
                errorMap.put((String)dynamicObject.get("number"), "parentorg will be disable in the bill");
                continue;
            }
            entryDynObj.set("adminorg", (Object)dynamicObject);
            entryDynObj.set("parentorg", dynamicObject.get("parentorg"));
            entryDynObj.set("adminorgtype", dynamicObject.get("adminorgtype"));
            entryDynObj.set("entry_org", dynamicObject.get("org"));
            entryDynObj.set("changetype", dynObj.get("billchangetype"));
            entryEntity.add(0, entryDynObj);
            dynObj.set("org", dynamicObject.get("org"));
            dynObj.set("effdt", (Object)effectDate);
            dynObj.set("entryentity", (Object)entryEntity);
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)entityName, (DynamicObject[])new DynamicObject[]{dynObj}, (OperateOption)this.createOperateOption());
            if (operationResult != null && !operationResult.isSuccess()) {
                errorMap.put((String)dynamicObject.get("number"), AdminOrgOperateUtils.getErrorInfoToString(operationResult));
            }
            entryEntity.remove(0);
        }
        if (errorMap.size() > 0) {
            resultMap.put("errorCode", false);
            resultMap.put("data", errorMap);
        } else {
            resultMap.put("errorCode", true);
        }
        return resultMap;
    }

    private boolean setOrgId(DynamicObject dyn, long[] ids, int index) {
        if (dyn.getLong("orgid") == 0L) {
            dyn.set("orgid", (Object)ids[index]);
            return true;
        }
        return false;
    }

    private String disableCheck(DynamicObject oldOrgDynObj, DynamicObject dynObj) {
        String oldEnable = oldOrgDynObj.getString("enable");
        String newEnable = dynObj.getString("billenable");
        if (HRStringUtils.equals((String)oldEnable, (String)"1") && HRStringUtils.equals((String)newEnable, (String)"0")) {
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"homs_orgfastchgdisable");
            DynamicObject dynObjDisable = new DynamicObject((DynamicObjectType)dataEntityType);
            dynObjDisable.set("billchangescene", (Object)AdminOrgOperateUtils.getBaseInfoDynObj("haos_changescene", 1040L, null));
            dynObjDisable.set("billchangetype", (Object)AdminOrgOperateUtils.getBaseInfoDynObj("haos_orgchangetype", 1040L, null));
            dynObjDisable.set("billtype", (Object)"1");
            dynObjDisable.set("billstatus", (Object)"C");
            dynObjDisable.set("auditstatus", (Object)"C");
            dynObjDisable.set("org", dynObj.get("org"));
            dynObjDisable.set("effdt", dynObj.get("effdt"));
            DynamicObjectCollection entryEntity = dynObjDisable.getDynamicObjectCollection("entryEntity");
            DynamicObject entryDynObj = new DynamicObject(entryEntity.getDynamicObjectType());
            entryDynObj.set("adminorg", (Object)dynObj.getDynamicObject("adminorg"));
            entryDynObj.set("parentorg", dynObj.get("parentorg"));
            entryDynObj.set("adminorgtype", dynObj.get("adminorgtype"));
            entryDynObj.set("entry_org", dynObj.get("org"));
            entryDynObj.set("changetype", dynObjDisable.get("billchangetype"));
            entryEntity.add(0, entryDynObj);
            dynObjDisable.set("entryentity", (Object)entryEntity);
            OperateOption operateOption = this.createOperateOption();
            operateOption.setVariableValue("isOnlyValidator", "true");
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"homs_orgfastchgdisable", (DynamicObject[])new DynamicObject[]{dynObjDisable}, (OperateOption)operateOption);
            ValidateResultCollection validateResult = operationResult.getValidateResult();
            ArrayList errInfo = new ArrayList();
            if (validateResult != null && !CollectionUtils.isEmpty((Collection)validateResult.getValidateErrors())) {
                List validateErrors = validateResult.getValidateErrors();
                for (ValidateResult validateError : validateErrors) {
                    validateError.getAllErrorInfo().forEach(err -> errInfo.add(err.getMessage()));
                }
            }
            if (errInfo.size() == 0) {
                return "";
            }
            return StringUtils.join(errInfo, (String)";");
        }
        return "";
    }

    private String getEnableStatusChangeType(DynamicObject oldOrgDynObj, DynamicObject dynObj) {
        String newEnable;
        String oldEnable = oldOrgDynObj.getString("enable");
        if (HRStringUtils.equals((String)oldEnable, (String)(newEnable = dynObj.getString("billenable")))) {
            if (HRStringUtils.equals((String)"1", (String)oldEnable)) {
                return "1";
            }
            if (HRStringUtils.equals((String)"0", (String)oldEnable)) {
                return "2";
            }
        } else {
            if (HRStringUtils.equals((String)"0", (String)newEnable)) {
                return "3";
            }
            if (HRStringUtils.equals((String)"1", (String)newEnable)) {
                return "4";
            }
        }
        return "";
    }
}

