/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.mservice;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.haos.business.domain.repository.customstruct.CustomOrgTeamRepository;
import kd.hr.haos.business.domain.repository.customstruct.CustomStructHelper;
import kd.hr.haos.business.domain.repository.customstruct.NumberPrefixRepository;
import kd.hr.haos.mservice.api.IHAOSCustomOrgTeamService;
import kd.hr.haos.mservice.util.ApiResultUtil;
import kd.hr.hbp.common.api.HrApiResponse;
import kd.hr.hbp.common.util.HRObjectUtils;

public class HAOSCustomOrgTeamService
implements IHAOSCustomOrgTeamService {
    private static final Log LOGGER = LogFactory.getLog(HAOSCustomOrgTeamService.class);

    public HrApiResponse<String> add(List<DynamicObject> orgTeams) {
        if (CollectionUtils.isEmpty(orgTeams)) {
            return HrApiResponse.fail((String)"500", (String)"orgTeams is required");
        }
        String entityNumber = orgTeams.get(0).getDataEntityType().getName();
        LOGGER.info("add entityNumber\uff1a{}", (Object)entityNumber);
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"ot_his_newsave", (String)entityNumber, (DynamicObject[])orgTeams.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        LOGGER.info("add result:{}", (Object)operationResult);
        return ApiResultUtil.handleOperationResult(operationResult);
    }

    public HrApiResponse<String> change(List<DynamicObject> orgTeams) {
        if (CollectionUtils.isEmpty(orgTeams)) {
            return HrApiResponse.fail((String)"500", (String)"orgTeams is required");
        }
        String entityNumber = orgTeams.get(0).getDataEntityType().getName();
        LOGGER.info("change entityNumber\uff1a{}", (Object)entityNumber);
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"donothing_ot_confirm_change", (String)entityNumber, (DynamicObject[])orgTeams.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        LOGGER.info("change result:{}", (Object)operationResult);
        return ApiResultUtil.handleOperationResult(operationResult);
    }

    public HrApiResponse<String> enable(List<Long> orgTeamBoIds) {
        if (CollectionUtils.isEmpty(orgTeamBoIds)) {
            return HrApiResponse.fail((String)"500", (String)"orgTeamBoIds is required");
        }
        LOGGER.info("enable orgTeamBoIds:{}", orgTeamBoIds);
        CustomOrgTeamRepository repository = CustomOrgTeamRepository.getRepository();
        Map orgTeamMap = repository.queryByIds(orgTeamBoIds, String.join((CharSequence)",", "parent", "boid", "level", "otclassify.id"));
        if (orgTeamMap.isEmpty()) {
            return HrApiResponse.fail((String)"500", (String)"data does not exist");
        }
        long otClassifyId = ((DynamicObject)orgTeamMap.values().iterator().next()).getLong("otclassify.id");
        String numberPrefix = NumberPrefixRepository.getRepository().getNumberPrefixById(Long.valueOf(otClassifyId));
        String entityNumber = CustomStructHelper.getCustomOrgTeamEntityName((String)numberPrefix);
        LOGGER.info("enable entityNumber\uff1a{}", (Object)entityNumber);
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"enable", (String)entityNumber, (DynamicObject[])orgTeamMap.values().toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        LOGGER.info("enable result:{}", (Object)operationResult);
        return ApiResultUtil.handleOperationResult(operationResult);
    }

    public HrApiResponse<String> disable(List<Long> orgTeamBoIds) {
        if (CollectionUtils.isEmpty(orgTeamBoIds)) {
            return HrApiResponse.fail((String)"500", (String)"orgTeamBoIds is required");
        }
        LOGGER.info("disable orgTeamBoIds:{}", orgTeamBoIds);
        CustomOrgTeamRepository repository = CustomOrgTeamRepository.getRepository();
        Map orgTeamMap = repository.queryByIds(orgTeamBoIds, String.join((CharSequence)",", "parent", "status", "enable", "boid", "bsed", "datastatus", "level", "otclassify.id"));
        if (orgTeamMap.isEmpty()) {
            return HrApiResponse.fail((String)"500", (String)"data does not exist");
        }
        long otClassifyId = ((DynamicObject)orgTeamMap.values().iterator().next()).getLong("otclassify.id");
        String numberPrefix = NumberPrefixRepository.getRepository().getNumberPrefixById(Long.valueOf(otClassifyId));
        String entityNumber = CustomStructHelper.getCustomOrgTeamEntityName((String)numberPrefix);
        LOGGER.info("disable entityNumber\uff1a{}", (Object)entityNumber);
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"his_disable", (String)entityNumber, (DynamicObject[])orgTeamMap.values().toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        LOGGER.info("disable result:{}", (Object)operationResult);
        return ApiResultUtil.handleOperationResult(operationResult);
    }

    public HrApiResponse<DynamicObject> queryById(long id) {
        if (id == 0L) {
            return HrApiResponse.fail((String)"500", (String)"id is required");
        }
        LOGGER.info("queryById id:{}", (Object)id);
        CustomOrgTeamRepository repository = CustomOrgTeamRepository.getRepository();
        DynamicObject orgTeam = repository.queryOne((Object)id);
        if (HRObjectUtils.isEmpty((Object)orgTeam)) {
            return HrApiResponse.fail((String)"500", (String)"data does not exist");
        }
        return HrApiResponse.success((Object)orgTeam);
    }

    public HrApiResponse<List<DynamicObject>> queryByIds(List<Long> ids, String selectProperties) {
        if (CollectionUtils.isEmpty(ids)) {
            return HrApiResponse.fail((String)"500", (String)"ids is required");
        }
        LOGGER.info("queryByIds ids:{}", ids);
        CustomOrgTeamRepository repository = CustomOrgTeamRepository.getRepository();
        Map orgTeamMap = repository.queryByIds(ids, selectProperties);
        if (orgTeamMap.isEmpty()) {
            return HrApiResponse.fail((String)"500", (String)"data does not exist");
        }
        return HrApiResponse.success(new ArrayList(orgTeamMap.values()));
    }
}

