/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.mservice;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.common.invoke.CommonDtxResponse;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.kdtx.sdk.api.TCCAdapterService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.staff.OrgUseStaffDetailRepository;
import kd.hr.haos.business.service.staff.bean.StaffBillDataBO;
import kd.hr.haos.business.service.staff.occupy.impl.StaffOccupyServiceImpl;
import kd.hr.haos.business.service.staff.service.impl.PersonStaffServiceImpl;
import kd.hr.haos.business.util.StaffActivityHelper;
import kd.hr.hbp.common.model.org.staff.StaffQueryInParam;
import kd.hr.hbp.common.model.org.staff.StaffQueryOutParam;
import kd.hr.hbp.common.model.org.staff.StaffQueryOutParamMap;
import kd.hr.hbp.common.model.org.staff.StaffUseInParam;
import kd.hr.hbp.common.model.org.staff.StaffUseParam;
import kd.hr.hbp.common.util.HRStringUtils;

public class HAOSStaffUseService
extends TCCAdapterService {
    private static final Log logger = LogFactory.getLog(HAOSStaffUseService.class);
    private static final String dataSign = "billValidateFail";

    public void Try(Object params) throws Exception {
        logger.info("staff_use_TCC_try param is {}", params);
        StaffUseParam staffUseParam = this.transStaffUseParam(params);
        ArrayList<StaffUseInParam> data = new ArrayList<StaffUseInParam>(staffUseParam.getStaffUseInParamList().size());
        ArrayList<StaffUseInParam> staffOutData = new ArrayList<StaffUseInParam>(staffUseParam.getStaffUseInParamList().size());
        this.validateParam(staffUseParam, data, staffOutData);
        List billIdList = data.stream().map(StaffUseInParam::getBizBillId).collect(Collectors.toList());
        StaffBillDataBO staffBillDataBO = new StaffBillDataBO(billIdList, new ArrayList(), false, true, false);
        this.validateLastConfirm(staffBillDataBO);
        this.validateResubmit(data, staffBillDataBO);
        this.validateMsgCompleted(staffOutData);
        if (!data.isEmpty()) {
            this.tryHandleData(data);
        }
    }

    private void validateMsgCompleted(List<StaffUseInParam> staffOutData) {
        if (staffOutData.size() < 1) {
            return;
        }
        ArrayList<StaffQueryInParam> newQueryDataList = new ArrayList<StaffQueryInParam>(staffOutData.size());
        for (StaffUseInParam staffUseInParam : staffOutData) {
            Object changeEventNumbers;
            StaffQueryInParam staffQueryInParam = this.useInParamTransQueryParam(staffUseInParam, (List<String>)(changeEventNumbers = Arrays.asList("1030_S", "1070_S")));
            if (staffQueryInParam == null) continue;
            newQueryDataList.add(staffQueryInParam);
        }
        HashSet<Long> staffOutDepEmpIds = new HashSet<Long>(16);
        StaffQueryOutParamMap staffQueryOutParamMap = new StaffOccupyServiceImpl(newQueryDataList).queryStaffOccupyInfo();
        for (Map.Entry staffQueryOutParamEntry : staffQueryOutParamMap.entrySet()) {
            if (!((StaffQueryOutParam)staffQueryOutParamEntry.getValue()).isControl() || ((StaffQueryOutParam)staffQueryOutParamEntry.getValue()).isSpecialRule()) continue;
            staffOutDepEmpIds.add(((StaffQueryOutParam)staffQueryOutParamEntry.getValue()).getDepEmpId());
        }
        int orgUseStaffDetailSize = OrgUseStaffDetailRepository.getInstance().countOrgUseStaffByDepEmpId(new ArrayList(staffOutDepEmpIds));
        if (orgUseStaffDetailSize < staffOutDepEmpIds.size()) {
            this.saveData(dataSign);
            throw new KDBizException(new ErrorCode("hrmp.haos.wrongProcess", "the bill can not be submit, because the employee without staff record"), new Object[0]);
        }
    }

    private void validateResubmit(List<StaffUseInParam> data, StaffBillDataBO staffBillDataBO) {
        Map<Long, Boolean> billIdToIsUpdateMap = data.stream().collect(Collectors.toMap(StaffUseInParam::getBizBillId, StaffUseInParam::isUpdate, (k1, k2) -> k1));
        Map<Long, StaffUseInParam> billIdToParamMap = data.stream().filter(param -> !"1050_S".equals(param.getChangeEventNumber()) && !"1070_S".equals(param.getChangeEventNumber())).collect(Collectors.toMap(StaffUseInParam::getBizBillId, param -> param, (k1, k2) -> k1));
        List effectChangeEventIdList = staffBillDataBO.getEffectChangeEventIdList();
        if (effectChangeEventIdList.size() > 0) {
            for (Long eventId : effectChangeEventIdList) {
                DynamicObject event = (DynamicObject)staffBillDataBO.getEventIdToEventMap().get(eventId);
                if (event == null) continue;
                Long billId = event.getLong("perevent");
                if (!billIdToIsUpdateMap.getOrDefault(billId, true).booleanValue()) {
                    logger.info("staff_use_TCC_try_repeatsubmit billid is {}", (Object)billId);
                    this.saveData(dataSign);
                    throw new KDBizException(new ErrorCode("hrmp.haos.wrongProcess", "the bill can not be submit twice"), new Object[0]);
                }
                String eventNumber = event.getDynamicObject("changeevent").getString("number");
                StaffUseInParam param2 = billIdToParamMap.get(billId);
                if (param2 == null) continue;
                param2.setChangeEventNumber(eventNumber);
            }
        }
    }

    private void validateLastConfirm(StaffBillDataBO staffBillDataBO) {
        List schedulEffectChangeEventIdList = staffBillDataBO.getSchedulEffectChangeEventIdList();
        if (schedulEffectChangeEventIdList.size() > 0) {
            logger.info("staff_use_TCC_try_last confirm failed billid is {}", (Object)JSONObject.toJSONString((Object)schedulEffectChangeEventIdList));
            this.saveData(dataSign);
            throw new KDBizException(new ErrorCode("hrmp.haos.wrongProcess", "the bill last confirm is failed"), new Object[0]);
        }
    }

    private void tryHandleData(List<StaffUseInParam> data) throws Exception {
        List<StaffUseInParam> tryData = this.handleStaffUseInParam(data);
        logger.info("staff_use_TCC_try_handled param is {}", (Object)JSONObject.toJSONString(tryData));
        PersonStaffServiceImpl personStaffService = new PersonStaffServiceImpl();
        personStaffService.staffTry(tryData);
    }

    public DtxResponse confirm(Object params, Object o1) throws Exception {
        logger.info("staff_use_TCC_comfirm param is {}", params);
        StaffUseParam staffUseParam = this.transStaffUseParam(params);
        if (staffUseParam == null || CollectionUtils.isEmpty((Collection)staffUseParam.getStaffUseInParamList())) {
            return null;
        }
        logger.info("staff_use_TCC_comfirm trans_param is {}", (Object)staffUseParam);
        this.confirmHandleData(staffUseParam.getStaffUseInParamList());
        return new CommonDtxResponse();
    }

    private void confirmHandleData(List<StaffUseInParam> data) throws Exception {
        PersonStaffServiceImpl personStaffService = new PersonStaffServiceImpl();
        personStaffService.staffConfirm(data);
    }

    public void cancel(Object params) throws Exception {
        Set dataSet = this.loadData();
        if (dataSet != null && dataSet.contains(dataSign)) {
            return;
        }
        logger.info("staff_use_TCC_cancel param is {}", params);
        StaffUseParam staffUseParam = this.transStaffUseParam(params);
        if (staffUseParam == null || CollectionUtils.isEmpty((Collection)staffUseParam.getStaffUseInParamList())) {
            return;
        }
        logger.info("staff_use_TCC_cancel trans_param is {}", (Object)staffUseParam);
        List<Long> billIdList = staffUseParam.getStaffUseInParamList().stream().map(StaffUseInParam::getBizBillId).collect(Collectors.toList());
        this.cancelHandleData(billIdList);
    }

    private void cancelHandleData(List<Long> data) throws Exception {
        PersonStaffServiceImpl personStaffService = new PersonStaffServiceImpl();
        personStaffService.staffRollback(data);
    }

    private void validateParam(StaffUseParam staffUseParam, List<StaffUseInParam> data, List<StaffUseInParam> staffOutData) {
        Map staffActivityMap = StaffActivityHelper.getStaffActivityMap();
        for (StaffUseInParam staffUseInParam : staffUseParam.getStaffUseInParamList()) {
            if (staffUseInParam.isUpdate() && staffUseInParam.getBeforeChange() != null && staffUseInParam.getBeforeChange().booleanValue()) continue;
            if (this.isEmptyOfLong(staffUseInParam.getDepEmpId()) && this.isEmptyOfLong(staffUseInParam.getCandidateId())) {
                throw new KDBizException(new ErrorCode("hrmp.haos.wrongParams", "candidateId and depEmpId cannot be both empty"), new Object[0]);
            }
            if (!this.isEmptyOfLong(staffUseInParam.getDepEmpId()) && !this.isEmptyOfLong(staffUseInParam.getCandidateId())) {
                throw new KDBizException(new ErrorCode("hrmp.haos.wrongParams", "candidateId and depEmpId cannot both have value"), new Object[0]);
            }
            if (HRStringUtils.isEmpty((String)staffUseInParam.getChangeEventNumber())) {
                throw new KDBizException(new ErrorCode("hrmp.haos.wrongParams", "changeEventNumber cannot be empty"), new Object[0]);
            }
            if (!staffActivityMap.containsKey(staffUseInParam.getChangeEventNumber())) {
                throw new KDBizException(new ErrorCode("hrmp.haos.wrongParams", "changeEventNumber is error"), new Object[0]);
            }
            if (this.isEmptyOfLong(staffUseInParam.getBizBillId())) {
                throw new KDBizException(new ErrorCode("hrmp.haos.wrongParams", "bizBillId cannot be empty"), new Object[0]);
            }
            if (staffUseInParam.getEffDate() == null) {
                throw new KDBizException(new ErrorCode("hrmp.haos.wrongParams", "effDate cannot be empty"), new Object[0]);
            }
            if (this.isEmptyOfLong(staffUseInParam.getOrgTeamId())) {
                throw new KDBizException(new ErrorCode("hrmp.haos.wrongParams", "orgTeamId cannot be empty"), new Object[0]);
            }
            if (!staffUseInParam.isUpdate() && ("1030_S".equals(staffUseInParam.getChangeEventNumber()) || "1070_S".equals(staffUseInParam.getChangeEventNumber()))) {
                staffOutData.add(staffUseInParam);
            }
            data.add(staffUseInParam);
        }
    }

    private List<StaffUseInParam> handleStaffUseInParam(List<StaffUseInParam> data) {
        ArrayList<StaffQueryInParam> newQueryDataList = new ArrayList<StaffQueryInParam>(data.size());
        Map<Long, String> depEmpIdVsEventNumberMap = data.stream().collect(Collectors.toMap(StaffUseInParam::getDepEmpId, StaffUseInParam::getChangeEventNumber, (o1, o2) -> o1));
        for (StaffUseInParam staffUseInParam : data) {
            List<String> changeEventNumbers = Arrays.asList("1010_S", "1050_S", "1030_S", "1090_S");
            StaffQueryInParam staffQueryInParam = this.useInParamTransQueryParam(staffUseInParam, changeEventNumbers);
            if (staffQueryInParam == null) continue;
            newQueryDataList.add(staffQueryInParam);
        }
        HashMap<String, StaffQueryOutParam> noStaffInCandidateIdMap = new HashMap<String, StaffQueryOutParam>(16);
        HashMap<String, StaffQueryOutParam> noStaffInDepEmpIdMap = new HashMap<String, StaffQueryOutParam>(16);
        StaffQueryOutParamMap staffQueryOutParamMap = new StaffOccupyServiceImpl(newQueryDataList).queryStaffOccupyInfo();
        for (Map.Entry staffQueryOutParamEntry : staffQueryOutParamMap.entrySet()) {
            if (!((StaffQueryOutParam)staffQueryOutParamEntry.getValue()).isSpecialRule()) continue;
            this.noStaffDataGroup(noStaffInCandidateIdMap, noStaffInDepEmpIdMap, staffQueryOutParamEntry);
        }
        ArrayList<StaffUseInParam> tryData = new ArrayList<StaffUseInParam>();
        for (StaffUseInParam staffUseInParam : data) {
            String key;
            Long candidateId = staffUseInParam.getCandidateId();
            Long depEmpId = staffUseInParam.getDepEmpId();
            Long orgTeamId = staffUseInParam.getOrgTeamId();
            if (!this.isEmptyOfLong(candidateId)) {
                key = candidateId + "|" + orgTeamId;
                if (noStaffInCandidateIdMap.containsKey(key)) {
                    staffUseInParam.getOther().put("haos_noWriteStaffData", Boolean.TRUE);
                }
                tryData.add(staffUseInParam);
                continue;
            }
            if (this.isEmptyOfLong(depEmpId)) continue;
            key = depEmpId + "|" + orgTeamId;
            if (noStaffInDepEmpIdMap.containsKey(key)) {
                staffUseInParam.getOther().put("haos_noWriteStaffData", Boolean.TRUE);
            }
            tryData.add(staffUseInParam);
        }
        return tryData;
    }

    private StaffQueryInParam useInParamTransQueryParam(StaffUseInParam staffUseInParam, List<String> changeEventNumbers) {
        if (changeEventNumbers.contains(staffUseInParam.getChangeEventNumber())) {
            StaffQueryInParam staffQueryInParam = new StaffQueryInParam();
            staffQueryInParam.setCandidateId(staffUseInParam.getCandidateId());
            staffQueryInParam.setDepEmpId(staffUseInParam.getDepEmpId());
            staffQueryInParam.setPersonId(staffUseInParam.getPersonId());
            staffQueryInParam.setOrgTeamId(staffUseInParam.getOrgTeamId());
            staffQueryInParam.setDutyWorkRoleId(staffUseInParam.getDutyWorkRoleId());
            staffQueryInParam.setJobId(staffUseInParam.getJobId());
            staffQueryInParam.setJobLevelId(staffUseInParam.getJobLevelId());
            staffQueryInParam.setEffDate(staffUseInParam.getEffDate());
            staffQueryInParam.setLaborRelTypeId(staffUseInParam.getLaborRelTypeId());
            staffQueryInParam.setUpdate(staffUseInParam.isUpdate());
            staffQueryInParam.setOther(staffUseInParam.getOther());
            return staffQueryInParam;
        }
        return null;
    }

    private void noStaffDataGroup(Map<String, StaffQueryOutParam> noStaffInCandidateIdMap, Map<String, StaffQueryOutParam> noStaffInDepEmpIdMap, Map.Entry<String, StaffQueryOutParam> staffQueryOutParamEntry) {
        if (!this.isEmptyOfLong(staffQueryOutParamEntry.getValue().getCandidateId())) {
            String key = staffQueryOutParamEntry.getValue().getCandidateId() + "|" + staffQueryOutParamEntry.getValue().getOrgTeamId();
            noStaffInCandidateIdMap.put(key, staffQueryOutParamEntry.getValue());
        } else if (!this.isEmptyOfLong(staffQueryOutParamEntry.getValue().getDepEmpId())) {
            String key = staffQueryOutParamEntry.getValue().getDepEmpId() + "|" + staffQueryOutParamEntry.getValue().getOrgTeamId();
            noStaffInDepEmpIdMap.put(key, staffQueryOutParamEntry.getValue());
        }
    }

    private StaffUseParam transStaffUseParam(Object params) {
        StaffUseParam staffUseParam = null;
        try {
            staffUseParam = (StaffUseParam)params;
        }
        catch (Exception exception) {
            throw new KDBizException(new ErrorCode("hrmp.haos.wrongParams", "Data structure conversion error"), new Object[0]);
        }
        return staffUseParam;
    }

    private boolean isEmptyOfLong(Long value) {
        return value == null || value == 0L;
    }
}

