/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.mservice.ot;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.haos.business.domain.repository.orgteam.OTQueryRepository;
import kd.hr.haos.business.domain.service.impl.orgteam.OrgTeamServiceImpl;
import kd.hr.haos.common.model.DyMapModel;
import kd.hr.haos.common.model.prj.CheckResult;
import kd.hr.haos.common.util.CheckChainUtils;
import kd.hr.haos.common.util.dyconverter.Map2Dy;
import kd.hr.haos.mservice.ot.AbstractDataService;
import kd.hr.haos.mservice.ot.valid.AbstractBizValidator;
import kd.hr.haos.mservice.ot.valid.DisableBizValidator;
import kd.hr.haos.mservice.util.ParamCheckUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;

public class DisableDataService
extends AbstractDataService {
    private static final Set<String> enabledKeySet = new HashSet<String>(Arrays.asList("id", "boid", "bsed"));

    @Override
    protected Collection<String> getEnabledKeySet() {
        return enabledKeySet;
    }

    @Override
    protected void beforeParamCheck(Map<String, Object> param) {
        List data = (List)param.get("data");
        this.setIdIfNull(data);
        this.setStructProjectId4OtExist(param);
    }

    @Override
    protected CheckResult<String> paramCheck(Map<String, Object> param) {
        List data = (List)param.get("data");
        Supplier<CheckResult> boidMustInputCheck = () -> ParamCheckUtils.mustInputCheck(data, Collections.singleton("boid"));
        Supplier<CheckResult> boidKeyDuplicatedCheck = () -> ParamCheckUtils.keyDuplicatedCheck(data, "boid");
        Supplier<CheckResult> boidExistCheck = () -> this.boidNotExistCheck(data);
        Supplier<CheckResult> idMustInputCheck = () -> ParamCheckUtils.mustInputCheck(data, Collections.singleton("id"));
        Supplier<CheckResult> idKeyDuplicatedCheck = () -> ParamCheckUtils.keyDuplicatedCheck(data, "id");
        Supplier<CheckResult> unionBsedCheck = () -> ParamCheckUtils.unionValueCheck(data, "bsed");
        Supplier<CheckResult> structProjectExistCheck = () -> ParamCheckUtils.getStructProjectExistCheck(param);
        Supplier<CheckResult> structProjectNonSysTypeCheck = () -> ParamCheckUtils.getStructProjectNonSysTypeCheck(param);
        List<Supplier> checkList = Arrays.asList(boidMustInputCheck, boidKeyDuplicatedCheck, boidExistCheck, idMustInputCheck, idKeyDuplicatedCheck, unionBsedCheck, structProjectExistCheck, structProjectNonSysTypeCheck);
        return (CheckResult)CheckChainUtils.check(checkList, CheckResult::isSuccess, ParamCheckUtils.getFastFailCheckContext());
    }

    @Override
    protected List<DynamicObject> convert(Map<String, Object> param) {
        this.structProjectId = this.initStructProject(param);
        List data = (List)param.get("data");
        DyMapModel dyMapModel = new DyMapModel();
        dyMapModel.setData(data);
        dyMapModel.setMetadata("haos_adminorgteam");
        dyMapModel.setOriginalKey("boid");
        Map2Dy map2Dy = new Map2Dy();
        dyMapModel.setIgnoreKeySet(new HashSet<String>(Arrays.asList("structnumber", "otclassify", "name", "number", "parent")));
        return map2Dy.map2DynamicObject(dyMapModel);
    }

    @Override
    protected void removeSucceeded(List<DynamicObject> otList) {
        Set boidList = otList.stream().map(ot -> ot.getLong("boid")).collect(Collectors.toSet());
        DynamicObject[] dbOts = OTQueryRepository.getInstance().queryOriginalArrById("id, boid, enable", boidList);
        Map<Long, Boolean> boidVsIsDisabled = Arrays.stream(dbOts).collect(Collectors.toMap(ot -> ot.getLong("boid"), ot -> ot.getString("enable").equals("0")));
        otList.removeIf(ot -> (Boolean)boidVsIsDisabled.get(ot.getLong("boid")));
    }

    @Override
    protected void beforeCheck(List<DynamicObject> otList) {
        otList.forEach(ot -> {
            ot.set("bsed", (Object)HRDateTimeUtils.truncateDate((Date)ot.getDate("bsed")));
            ot.set("enable", (Object)"0");
        });
    }

    @Override
    protected CheckResult<String> bizCheck(List<DynamicObject> otList) {
        DisableBizValidator validator = new DisableBizValidator(otList);
        ((AbstractBizValidator)validator).valid();
        return this.createCheckResult(validator.getResult());
    }

    @Override
    protected void beforeSave(List<DynamicObject> otList) {
    }

    @Override
    protected void process(List<DynamicObject> otList) {
        OrgTeamServiceImpl.getInstance().disable(otList, this.structProjectId);
    }
}

