/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.mservice.pjt;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.haos.business.domain.repository.orgteam.OTQueryRepository;
import kd.hr.haos.business.domain.repository.prjorg.PRJOrgRepository;
import kd.hr.haos.business.service.projectgroup.service.ProjStrategyService;
import kd.hr.haos.business.service.projectgroup.service.ProjectGroupAddService;
import kd.hr.haos.business.service.projectgroup.service.ProjectGroupRoleService;
import kd.hr.haos.common.constants.projectgroup.ProjectGroupMDConstants;
import kd.hr.haos.common.model.DyMapModel;
import kd.hr.haos.common.model.prj.CheckResult;
import kd.hr.haos.common.util.HRDyObjectUtils;
import kd.hr.haos.common.util.dyconverter.Map2Dy;
import kd.hr.haos.common.util.tree.Tree;
import kd.hr.haos.mservice.pjt.AbstractDataBatchService;
import kd.hr.haos.mservice.pjt.valid.AddCheckHelper;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisEffDateCommonService;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;

public class AddBatchService
extends AbstractDataBatchService<List<DynamicObject>> {
    public AddBatchService() {
        this.setCheckBoIdExist(true);
    }

    @Override
    protected Set<String> getMustInputFieldSet() {
        return new HashSet<String>(Collections.singletonList("boid"));
    }

    @Override
    protected List<DynamicObject> map2T(Map<String, Object> param) {
        List data = (List)param.get("data");
        DyMapModel dyMapModel = new DyMapModel();
        dyMapModel.setData(data);
        dyMapModel.setMetadata("haos_projectgroupbase");
        dyMapModel.setIgnoreKeySet(new HashSet<String>(Arrays.asList("bsed", "bsled", "projectteam", "parentprojectteam", "belongadminorg", "rootprojectteam", "projectidentify", "structnumber", "org", "opreatetype", "changetype", "modifier", "creator", "modifytime", "createtime", "status", "enable", "initbatch", "initdatasource", "initstatus")));
        HashMap<String, BiConsumer<DynamicObject, Object>> keyVsValueSetter = new HashMap<String, BiConsumer<DynamicObject, Object>>();
        keyVsValueSetter.put("parentorg", this.getParentOrgSetter(data));
        dyMapModel.setKeyVsValueSetter(keyVsValueSetter);
        Map2Dy map2Dy = new Map2Dy();
        return map2Dy.map2DynamicObject(dyMapModel);
    }

    @Override
    protected void beforeCheck(List<DynamicObject> pjtList) {
        this.setDefaultValue(pjtList);
    }

    @Override
    protected void save(List<DynamicObject> pjtList) {
        Map<Long, Long> boIdVsId = pjtList.stream().filter(dy -> dy.getLong("id") != 0L).collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> dy.getLong("id")));
        ProjectGroupAddService projectGroupAddService = new ProjectGroupAddService();
        projectGroupAddService.setBoIdVsId(boIdVsId);
        projectGroupAddService.setPjtOrgList(pjtList);
        projectGroupAddService.save();
    }

    @Override
    protected void afterSave(List<DynamicObject> pjtList) {
        pjtList.forEach(dy -> dy.set("id", dy.get("boid")));
        List projectRoleList = ProjectGroupRoleService.getInstance().buildAddNewHisParam(pjtList.toArray(new DynamicObject[0]));
        if (!CollectionUtils.isEmpty((Collection)projectRoleList)) {
            HRMServiceHelper.invokeHRMPService((String)"hbpm", (String)"IProjectRoleService", (String)"addProjectRole", (Object[])new Object[]{projectRoleList});
        }
        List boIdList = pjtList.stream().map(dy -> dy.getLong("boid")).collect(Collectors.toList());
        ProjStrategyService.INSTANCE.addStrategy(boIdList);
    }

    private BiConsumer<DynamicObject, Object> getParentOrgSetter(List<Map<String, Object>> data) {
        MainEntityType pjtDyType = MetadataServiceHelper.getDataEntityType((String)"haos_projteambaseinfo");
        DynamicObjectType parentOrgDyType = HRDyObjectUtils.createDyTypeFromTargetType((DynamicObjectType)pjtDyType, (String)"parentorg");
        DynamicObject prjClassifyDy = this.newPrjClassifyDy(parentOrgDyType);
        Map<Long, Object> curBatchNewIdVsParentVal = data.stream().filter(map -> map.get("parentorg") != null).collect(Collectors.toMap(map -> Long.parseLong(map.get("boid").toString()), map -> map.get("parentorg")));
        DynamicObject[] parentOrgDys = BusinessDataServiceHelper.load((Object[])curBatchNewIdVsParentVal.values().toArray(), (DynamicObjectType)parentOrgDyType);
        Map<String, DynamicObject> existIdVsDy = Arrays.stream(parentOrgDys).collect(Collectors.toMap(dy -> dy.getString("id"), dy -> dy));
        return (dy, value) -> {
            if (value == null) {
                dy.set("parentorg", null);
            } else {
                DynamicObject parentOt = null;
                String valString = value.toString();
                if (existIdVsDy.containsKey(value.toString())) {
                    parentOt = (DynamicObject)existIdVsDy.get(valString);
                } else if (curBatchNewIdVsParentVal.containsKey(Long.parseLong(value.toString()))) {
                    parentOt = OTQueryRepository.getInstance().genEmptyDy(Arrays.asList("id", "otclassify", "org"));
                    parentOt.set("id", value);
                    parentOt.set("otclassify", (Object)prjClassifyDy);
                }
                if (parentOt != null) {
                    dy.set("parentorg", (Object)parentOt);
                } else {
                    dy.set("parentorg", value);
                    dy.set("parentorg_id", value);
                }
            }
        };
    }

    private void setDefaultValue(List<DynamicObject> dynamicObjectList) {
        this.setBu(dynamicObjectList);
        String[] structNumbersOrProjectIdentify = ORM.create().genStringIds("haos_projteambaseinfo", dynamicObjectList.size() * 2);
        ArrayDeque<String> structNumbersOrProjectIdentifyQueue = new ArrayDeque<String>(Arrays.asList(structNumbersOrProjectIdentify));
        Date date2999 = new HisEffDateCommonService().getDate2999(null);
        DynamicObject newChangeOperateDy = BusinessDataServiceHelper.loadSingle((Object)ProjectGroupMDConstants.CHANGE_OPERATE_NEW, (String)"haos_projchangeoperate");
        DynamicObject newChangeTypeDy = BusinessDataServiceHelper.loadSingle((Object)ProjectGroupMDConstants.CHANGE_TYPE_NEW, (String)"haos_projchangetype");
        dynamicObjectList.forEach(dy -> {
            Date now = new Date();
            dy.set("establishmentdate", (Object)HRDateTimeUtils.truncateDate((Date)dy.getDate("establishmentdate")));
            dy.set("bsed", dy.get("establishmentdate"));
            dy.set("bsled", (Object)date2999);
            DynamicObject rootProjectTeam = PRJOrgRepository.getInstance().genEmptyDy(Collections.singletonList("id"));
            rootProjectTeam.set("id", (Object)dy.getLong("boid"));
            dy.set("rootprojectteam", (Object)rootProjectTeam);
            if (dy.getLong("parentorg.otclassify.id") == 1010L) {
                dy.set("projectidentify", structNumbersOrProjectIdentifyQueue.poll());
            }
            dy.set("structnumber", structNumbersOrProjectIdentifyQueue.poll());
            dy.set("initstatus", (Object)"2");
            dy.set("initbatch", (Object)0L);
            dy.set("initdatasource", (Object)"0");
            dy.set("createtime", (Object)this.getOrIfNullVal(dy.getDate("createtime"), () -> now));
            dy.set("modifytime", (Object)this.getOrIfNullVal(dy.getDate("modifytime"), () -> now));
            dy.set("enable", (Object)"1");
            dy.set("status", (Object)"C");
            dy.set("changeoperate", (Object)newChangeOperateDy);
            dy.set("changetype", (Object)newChangeTypeDy);
        });
    }

    private void setBu(List<DynamicObject> dynamicObjectList) {
        Map<Long, Long> boIdVsPId = dynamicObjectList.stream().collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> dy.getLong("parentorg.id")));
        Tree tree = new Tree(boIdVsPId);
        List levelIdList = tree.levelTraverse();
        Map<Long, DynamicObject> boIdVsDy = dynamicObjectList.stream().collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> dy));
        levelIdList.forEach(boId -> {
            DynamicObject dy = (DynamicObject)boIdVsDy.get(boId);
            DynamicObject parentDy = (DynamicObject)boIdVsDy.get(dy.getLong("parentorg.id"));
            if (parentDy != null) {
                dy.set("org", parentDy.get("org"));
            } else {
                dy.set("org", (Object)this.newBuDy(dy));
            }
        });
    }

    private DynamicObject newPrjClassifyDy(DynamicObjectType pjtDyType) {
        DynamicObjectType classifyDyType = HRDyObjectUtils.createDyTypeFromTargetType((DynamicObjectType)pjtDyType, (String)"otclassify");
        DynamicObject classifyDy = new DynamicObject(classifyDyType);
        classifyDy.set("id", (Object)1020L);
        return classifyDy;
    }

    private DynamicObject newBuDy(DynamicObject dy) {
        DynamicObjectType buType = HRDyObjectUtils.createDyTypeFromTargetType((DynamicObjectType)dy.getDynamicObjectType(), (String)"org");
        DynamicObject buDy = new DynamicObject(buType);
        buDy.set("id", (Object)dy.getLong("parentorg.org.id"));
        return buDy;
    }

    @Override
    protected CheckResult<String> check(List<DynamicObject> dynamicObjectList) {
        AddCheckHelper addCheckHelper = new AddCheckHelper();
        addCheckHelper.init(dynamicObjectList);
        Map<String, List<String>> result = addCheckHelper.check();
        return this.createCheckResult(result);
    }
}

