/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.mservice.pjt;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.haos.business.domain.repository.prjorg.PRJOrgRepository;
import kd.hr.haos.business.domain.service.impl.teamcoop.TeamCoopRelServiceImpl;
import kd.hr.haos.business.service.adminorg.bean.TeamCoopRelBO;
import kd.hr.haos.business.service.projectgroup.service.IProjectInfoService;
import kd.hr.haos.business.service.projectgroup.service.ProTeamMsgService;
import kd.hr.haos.business.service.projectgroup.service.ProjChangeEventService;
import kd.hr.haos.business.service.projectgroup.service.ProjStrategyService;
import kd.hr.haos.business.service.projectgroup.service.ProjectGroupChangeService;
import kd.hr.haos.business.service.projectgroup.service.ProjectInfoService;
import kd.hr.haos.common.constants.projectgroup.ProjectGroupMDConstants;
import kd.hr.haos.common.model.DyMapModel;
import kd.hr.haos.common.model.prj.CheckResult;
import kd.hr.haos.common.model.prj.OpParam;
import kd.hr.haos.common.util.HRDyObjectUtils;
import kd.hr.haos.common.util.dyconverter.Map2Dy;
import kd.hr.haos.mservice.pjt.AbstractDataBatchService;
import kd.hr.haos.mservice.pjt.valid.ChangeCheckHelper;
import kd.hr.hbp.business.domain.model.newhismodel.BatchVersionChangeRespData;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisEffDateCommonService;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;

public class ChangeParentBatchService
extends AbstractDataBatchService<List<DynamicObject>> {
    HisResponse<BatchVersionChangeRespData> hisResponse;

    public ChangeParentBatchService() {
        this.setCheckBoIdNotExist(true);
    }

    @Override
    protected Set<String> getMustInputFieldSet() {
        return new HashSet<String>(Collections.singletonList("boid"));
    }

    @Override
    protected List<DynamicObject> map2T(Map<String, Object> param) {
        List data = (List)param.get("data");
        DyMapModel dyMapModel = new DyMapModel();
        dyMapModel.setData(data);
        dyMapModel.setMetadata("haos_projectgroupbase");
        dyMapModel.setIgnoreKeySet(new HashSet<String>(Arrays.asList("number", "establishmentdate", "bsled", "projectteam", "parentprojectteam", "belongadminorg", "rootprojectteam", "projectidentify", "structnumber", "org", "entryentity")));
        dyMapModel.setOriginalKey("boid");
        Map2Dy map2Dy = new Map2Dy();
        return map2Dy.map2DynamicObject(dyMapModel);
    }

    @Override
    protected CheckResult<String> check(List<DynamicObject> pjtList) {
        ChangeCheckHelper changeCheckHelper = new ChangeCheckHelper(true);
        changeCheckHelper.init(pjtList);
        Map<String, List<String>> result = changeCheckHelper.check();
        return this.createCheckResult(result);
    }

    @Override
    protected void beforeCheck(List<DynamicObject> pjtList) {
        this.setDefaultValue(pjtList);
    }

    @Override
    protected void save(List<DynamicObject> pjtList) {
        OpParam opParam = new OpParam();
        opParam.setOpType("donothing_confirmchangeparent");
        ProjectGroupChangeService changeService = new ProjectGroupChangeService(opParam);
        changeService.setEventId(Long.valueOf(ORM.create().genLongId("haos_projectgroupbase")));
        changeService.setPrjOrgs(pjtList.toArray(new DynamicObject[0]));
        changeService.init();
        this.hisResponse = changeService.change();
        this.changeAdCoopRel(pjtList, changeService.getEventId());
        ProjChangeEventService.handleChangeEventHis(this.hisResponse, (String)"haos_projteambaseinfo", (Boolean)true);
    }

    private void changeAdCoopRel(List<DynamicObject> pjtList, Long eventId) {
        Map<Long, List<TeamCoopRelBO>> orgIdVsBo = pjtList.stream().map(dy -> {
            long boId = dy.getLong("boid");
            long parentId = dy.getLong("parentorg.id");
            TeamCoopRelBO teamCoopRelBO = new TeamCoopRelBO(Long.valueOf(boId), Long.valueOf(1010L), Long.valueOf(parentId), 0);
            teamCoopRelBO.setEffDate(dy.getDate("bsed"));
            return teamCoopRelBO;
        }).collect(Collectors.groupingBy(TeamCoopRelBO::getOrgTeamId));
        TeamCoopRelServiceImpl.getInstance().batchChangeOnlyAd(orgIdVsBo, null, eventId);
    }

    @Override
    protected void afterSave(List<DynamicObject> pjtList) {
        List strategyInParam = pjtList.stream().map(dy -> {
            HashMap<String, Long> map = new HashMap<String, Long>();
            map.put("projId", dy.getLong("boid"));
            map.put("projParentId", dy.getLong("parentorg.id"));
            return map;
        }).collect(Collectors.toList());
        ProjStrategyService.INSTANCE.updateStrategy(strategyInParam);
        List pjrInParam = pjtList.stream().map(dy -> {
            HashMap<String, Long> map = new HashMap<String, Long>();
            map.put("projectId", dy.getLong("boid"));
            map.put("newParentId", dy.getLong("parentorg.id"));
            return map;
        }).collect(Collectors.toList());
        HRMServiceHelper.invokeHRMPService((String)"hbpm", (String)"IProjectRoleService", (String)"changeParentRole", (Object[])new Object[]{pjrInParam});
        ProTeamMsgService.getInstance().sendProTeamChgMsg(this.hisResponse);
    }

    private void setDefaultValue(List<DynamicObject> dynamicObjectList) {
        DynamicObject changeParentChangeOperateDy = BusinessDataServiceHelper.loadSingle((Object)ProjectGroupMDConstants.CHANGE_OPERATE_CHANGE_PARENT, (String)"haos_projchangeoperate");
        DynamicObject changeParentChangeTypeDy = BusinessDataServiceHelper.loadSingle((Object)ProjectGroupMDConstants.CHANGETYPE_CHANGEPARENT, (String)"haos_projchangetype");
        Set pjtBoSet = dynamicObjectList.stream().map(dy -> dy.getLong("boid")).collect(Collectors.toSet());
        DynamicObject[] pjtDys = PRJOrgRepository.getInstance().queryByPks("parentorg, boid, projectname, projectnumber, description", pjtBoSet);
        Map<Long, DynamicObject> boVsCurrentData = Arrays.stream(pjtDys).collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> dy));
        String[] projectIdentify = ORM.create().genStringIds("haos_projteambaseinfo", dynamicObjectList.size());
        ArrayDeque<String> projectIdentifyQueue = new ArrayDeque<String>(Arrays.asList(projectIdentify));
        Date date2999 = new HisEffDateCommonService().getDate2999(null);
        Date now = new Date();
        ProjectInfoService projectInfoService = new ProjectInfoService();
        dynamicObjectList.forEach(arg_0 -> this.lambda$setDefaultValue$8(boVsCurrentData, (IProjectInfoService)projectInfoService, projectIdentifyQueue, date2999, now, changeParentChangeOperateDy, changeParentChangeTypeDy, arg_0));
    }

    private /* synthetic */ void lambda$setDefaultValue$8(Map boVsCurrentData, IProjectInfoService projectInfoService, Deque projectIdentifyQueue, Date date2999, Date now, DynamicObject changeParentChangeOperateDy, DynamicObject changeParentChangeTypeDy, DynamicObject pjt) {
        long curBoId = pjt.getLong("boid");
        DynamicObject dbCurrentData = (DynamicObject)boVsCurrentData.get(curBoId);
        boolean beforeSub = !projectInfoService.isRootProjectTeam(dbCurrentData);
        boolean afterRoot = projectInfoService.isRootProjectTeam(pjt);
        if (beforeSub && afterRoot) {
            pjt.set("projectidentify", projectIdentifyQueue.poll());
            DynamicObjectType rootProjectTeamDyType = HRDyObjectUtils.createDyTypeFromTargetType((DynamicObjectType)pjt.getDynamicObjectType(), (String)"rootprojectteam");
            DynamicObject rootProjectTeamDy = new DynamicObject(rootProjectTeamDyType);
            HRDynamicObjectUtils.copy((DynamicObject)pjt, (DynamicObject)rootProjectTeamDy);
            rootProjectTeamDy.set("id", (Object)curBoId);
            pjt.set("rootprojectteam", (Object)rootProjectTeamDy);
        } else {
            pjt.set("projectnumber", dbCurrentData.get("projectnumber"));
            pjt.set("projectname", dbCurrentData.get("projectname"));
            pjt.set("description", dbCurrentData.get("description"));
        }
        pjt.set("bsed", (Object)HRDateTimeUtils.truncateDate((Date)pjt.getDate("bsed")));
        pjt.set("bsled", (Object)date2999);
        pjt.set("createtime", (Object)this.getOrIfNullVal(pjt.getDate("createtime"), () -> now));
        pjt.set("modifytime", (Object)this.getOrIfNullVal(pjt.getDate("modifytime"), () -> now));
        pjt.set("changeoperate", (Object)changeParentChangeOperateDy);
        pjt.set("changetype", (Object)changeParentChangeTypeDy);
    }
}

