/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.mservice.pjt;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.haos.business.domain.repository.orgteam.OTStructRepository;
import kd.hr.haos.business.domain.repository.prjorg.PRJOrgRepository;
import kd.hr.haos.business.service.projectgroup.service.ProjStrategyService;
import kd.hr.haos.business.service.projectgroup.service.ProjectGroupDisableService;
import kd.hr.haos.business.servicehelper.ProjectGroupServiceHelper;
import kd.hr.haos.common.constants.projectgroup.ProjectGroupMDConstants;
import kd.hr.haos.common.model.DyMapModel;
import kd.hr.haos.common.model.prj.CheckResult;
import kd.hr.haos.common.util.dyconverter.Map2Dy;
import kd.hr.haos.mservice.pjt.AbstractDataBatchService;
import kd.hr.haos.mservice.pjt.model.DisableModel;
import kd.hr.haos.mservice.pjt.valid.DisableCheckHelper;

public class DisableBatchService
extends AbstractDataBatchService<List<DynamicObject>> {
    DisableModel disableModel;

    public DisableBatchService() {
        this.setCheckBoIdNotExist(true);
    }

    @Override
    protected Set<String> getMustInputFieldSet() {
        return new HashSet<String>(Collections.singletonList("boid"));
    }

    @Override
    protected List<DynamicObject> map2T(Map<String, Object> param) {
        List data = (List)param.get("data");
        DyMapModel dyMapModel = new DyMapModel();
        dyMapModel.setData(data);
        dyMapModel.setMetadata("haos_projectgroupbase");
        dyMapModel.setIgnoreKeySet(new HashSet<String>(Arrays.asList("number", "establishmentdate", "parentorg", "bsled", "projectteam", "parentprojectteam", "belongadminorg", "rootprojectteam", "projectidentify", "structnumber", "org", "entryentity", "opreatetype", "changetype", "modifier", "creator", "modifytime", "createtime", "enable", "status", "initbatch", "initdatasource", "initstatus")));
        dyMapModel.setOriginalKey("boid");
        Map2Dy map2Dy = new Map2Dy();
        List dynamicObjects = map2Dy.map2DynamicObject(dyMapModel);
        if (dynamicObjects.size() != 0) {
            this.disableModel = new DisableModel();
            this.disableModel.setIdList(dynamicObjects.stream().map(dy -> dy.getLong("boid")).collect(Collectors.toList()));
            this.disableModel.setEffectDate(((DynamicObject)dynamicObjects.get(0)).getDate("bsed"));
        }
        return dynamicObjects;
    }

    @Override
    protected void beforeCheck(List<DynamicObject> pjtList) {
        this.setDefaultValue(pjtList);
    }

    @Override
    protected CheckResult<String> check(List<DynamicObject> pjtList) {
        DisableCheckHelper disableCheckHelper = new DisableCheckHelper();
        disableCheckHelper.init(pjtList);
        Map<String, List<String>> result = disableCheckHelper.check();
        return this.createCheckResult(result);
    }

    @Override
    protected void beforeSave(List<DynamicObject> pjtList) {
        Set boList = pjtList.stream().map(pjt -> pjt.getLong("boid")).collect(Collectors.toSet());
        DynamicObject[] structDys = OTStructRepository.getInstance().queryOriginal4Sub("orgteam.id", boList, false);
        Set subOtBoSetWithoutCurBatch = Arrays.stream(structDys).map(struct -> struct.getLong("orgteam.id")).filter(otBoId -> !boList.contains(otBoId)).collect(Collectors.toSet());
        DynamicObject[] subPjtWithoutCurBatch = PRJOrgRepository.getInstance().loadByIds(subOtBoSetWithoutCurBatch);
        List<DynamicObject> enabledSubPjtListWithoutCurBatch = Arrays.stream(subPjtWithoutCurBatch).filter(pjt -> "1".equals(pjt.getString("enable"))).collect(Collectors.toList());
        enabledSubPjtListWithoutCurBatch.forEach(dy -> dy.set("bsed", (Object)this.disableModel.getEffectDate()));
        this.setDefaultValue(enabledSubPjtListWithoutCurBatch);
        pjtList.addAll(enabledSubPjtListWithoutCurBatch);
        super.beforeSave(pjtList);
        Date now = new Date();
        pjtList.forEach(pjt -> {
            pjt.set("disabledate", (Object)now);
            pjt.set("enable", (Object)"0");
        });
    }

    @Override
    protected void save(List<DynamicObject> pjtList) {
        ProjectGroupDisableService projectGroupDisableService = new ProjectGroupDisableService();
        projectGroupDisableService.setPjtList(pjtList);
        projectGroupDisableService.disable();
    }

    @Override
    protected void afterSave(List<DynamicObject> pjtList) {
        List disableId = pjtList.stream().map(dy -> dy.getLong("boid")).collect(Collectors.toList());
        DynamicObject[] projectRoles = ProjectGroupServiceHelper.queryProjectRoleByProjectTeam(disableId);
        ProjectGroupServiceHelper.disableProjectRole((DynamicObject[])projectRoles, (Date)this.disableModel.getEffectDate());
        ProjStrategyService.INSTANCE.disableStrategy(disableId);
    }

    private void setDefaultValue(List<DynamicObject> pjtList) {
        DynamicObject disableChangeOperateDy = BusinessDataServiceHelper.loadSingle((Object)ProjectGroupMDConstants.CHANGE_OPERATE_DISABLE, (String)"haos_projchangeoperate");
        DynamicObject disableChangeTypeDy = BusinessDataServiceHelper.loadSingle((Object)ProjectGroupMDConstants.CHANGETYPE_DISABLE_ID, (String)"haos_projchangetype");
        pjtList.forEach(pjt -> {
            pjt.set("changeoperate", (Object)disableChangeOperateDy);
            pjt.set("changetype", (Object)disableChangeTypeDy);
        });
    }
}

