/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.mservice.pjt.valid;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.KDBizException;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.api.IInteService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.haos.business.domain.repository.orgteam.OTQueryRepository;
import kd.hr.haos.business.domain.repository.prjorg.PRJOrgRepository;
import kd.hr.haos.business.service.projectgroup.service.IProjectInfoService;
import kd.hr.haos.business.service.projectgroup.service.LocaleStringComparator;
import kd.hr.haos.business.service.projectgroup.service.ProjectInfoService;
import kd.hr.haos.business.service.projectgroup.valid.ProjectGroupValidHelper;
import kd.hr.haos.business.util.LocalDateRangeUtils;
import kd.hr.haos.business.util.PatternUtil;
import kd.hr.haos.business.util.TimeConvertUtil;
import kd.hr.haos.common.model.cascade.CycleCheckResult;
import kd.hr.haos.common.model.cascade.CycleCheckResultWithType;
import kd.hr.hbp.common.util.HRDateTimeUtils;

public class AbstractCheckHelper {
    Map<Long, List<DynamicObject>> boVsRootPjtUnderSameAdOrgHisDataList;
    Map<Long, Date> boVsOtFirstEffDate;
    Map<String, List<String>> result;
    List<DynamicObject> pjtList;
    IProjectInfoService projectInfoService;
    DynamicObject newChangeOperateDy;
    Map<Long, String> coopRelTypeIdVsName;

    protected void init(List<DynamicObject> pjtList) {
        this.pjtList = pjtList;
        this.projectInfoService = new ProjectInfoService();
        this.result = new HashMap<String, List<String>>();
    }

    void initChangeTypeDy(long id) {
        this.newChangeOperateDy = BusinessDataServiceHelper.loadSingle((Object)id, (String)"haos_projchangetype");
    }

    protected List<String> getMustInputCheckList() {
        return Collections.emptyList();
    }

    public void checkMustInput(DynamicObject pjt) {
        this.getMustInputCheckList().forEach(field -> {
            DynamicProperty property = pjt.getDynamicObjectType().getProperty(field);
            if (property instanceof DynamicComplexProperty) {
                return;
            }
            Object value = pjt.get(field);
            if (value == null) {
                this.addMsg(pjt, String.format(this.getMustInputMessage(), property.getDisplayName()));
            } else if (property instanceof TextProp) {
                if (property instanceof MuliLangTextProp) {
                    LocaleStringComparator localeStringComparator;
                    if (value instanceof ILocaleString && (localeStringComparator = new LocaleStringComparator()).isBizEmpty((ILocaleString)value)) {
                        this.addMsg(pjt, String.format(this.getMustInputMessage(), property.getDisplayName()));
                    }
                } else if (StringUtils.isEmpty((CharSequence)((String)value))) {
                    this.addMsg(pjt, String.format(this.getMustInputMessage(), property.getDisplayName()));
                }
            }
        });
    }

    private String getMustInputMessage() {
        return ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a", (String)"AbstractCheckHelper_15", (String)"hrmp-haos-mservice", (Object[])new Object[0]);
    }

    public void checkBdValid(DynamicObject pjt) {
        List complexProperties = pjt.getDynamicObjectType().getProperties().getComplexProperties(true);
        complexProperties.stream().map(IMetadata::getName).forEach(this.doCheckBdValid(pjt));
    }

    public void checkBdValid(DynamicObject pjt, List<String> fieldList) {
        fieldList.forEach(this.doCheckBdValid(pjt));
    }

    private Consumer<String> doCheckBdValid(DynamicObject pjt) {
        return bdKey -> {
            DynamicProperty property = pjt.getDynamicObjectType().getProperty(bdKey);
            Object value = pjt.get(bdKey);
            if (value == null) {
                if (this.getMustInputCheckList().contains(bdKey)) {
                    this.addMsg(pjt, String.format(this.getMustInputMessage(), property.getDisplayName()));
                }
            } else if (!(value instanceof DynamicObject)) {
                String message = ResManager.loadKDString((String)"%s\u4e0d\u5b58\u5728", (String)"AbstractCheckHelper_16", (String)"hrmp-haos-mservice", (Object[])new Object[0]);
                this.addMsg(pjt, String.format(message, property.getDisplayName()));
            }
        };
    }

    public void batchCheckCoopRelIsRinged() {
        List<CycleCheckResultWithType> cycleCheckResults = this.doBatchCheckCoopRelIsRinged();
        cycleCheckResults.stream().filter(CycleCheckResult::isCycled).forEach(cycleCheckResult -> {
            if (cycleCheckResult.getRelTypeId() == 1010L) {
                String msg = ResManager.loadKDString((String)"\u4e0d\u80fd\u9009\u62e9\u81ea\u5df1\u7684\u4e0b\u7ea7\u4f5c\u4e3a\u4e0a\u7ea7\u7ec4\u7ec7\u3002", (String)"AbstractCheckHelper_17", (String)"hrmp-haos-mservice", (Object[])new Object[0]);
                this.addMsg(cycleCheckResult.getStartBo(), msg);
            } else {
                long relTypeId = cycleCheckResult.getRelTypeId();
                String relTypeName = this.getCoopRelTypeIdVsName().getOrDefault(relTypeId, "");
                String multiLangMsg = ResManager.loadKDString((String)"\u201c%s\u201d\u534f\u4f5c\u5173\u7cfb\u51fa\u73b0\u534f\u4f5c\u5faa\u73af\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AbstractCheckHelper_13", (String)"hrmp-haos-mservice", (Object[])new Object[0]);
                String msg = String.format(multiLangMsg, relTypeName);
                this.addMsg(cycleCheckResult.getStartBo(), msg);
            }
        });
    }

    protected List<CycleCheckResultWithType> doBatchCheckCoopRelIsRinged() {
        throw new RuntimeException("doBatchCheckCoopRelIsRinged is not defined");
    }

    public void checkFutureBsed(DynamicObject pjt) {
        Date curEffDtOrSayEstDate = pjt.getDate("bsed");
        if (curEffDtOrSayEstDate == null) {
            return;
        }
        if (ProjectGroupValidHelper.checkDateLater((Date)curEffDtOrSayEstDate, (Date)TimeConvertUtil.getNowDate())) {
            String msg = ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u5fc5\u987b\u662f\u4eca\u5929\u6216\u4eca\u5929\u4ee5\u524d\u7684\u65e5\u671f\u3002", (String)"AbstractCheckHelper_12", (String)"hrmp-haos-mservice", (Object[])new Object[0]);
            this.addMsg(pjt, msg);
        }
    }

    public void checkFutureEstablishmentDate(DynamicObject pjt) {
        Date curEffDtOrSayEstDate = pjt.getDate("establishmentdate");
        if (curEffDtOrSayEstDate == null) {
            return;
        }
        if (ProjectGroupValidHelper.checkDateLater((Date)curEffDtOrSayEstDate, (Date)TimeConvertUtil.getNowDate())) {
            String msg = ResManager.loadKDString((String)"\u6210\u7acb\u65e5\u671f\u5fc5\u987b\u662f\u4eca\u5929\u6216\u4eca\u5929\u4ee5\u524d\u7684\u65e5\u671f\u3002", (String)"AbstractCheckHelper_14", (String)"hrmp-haos-mservice", (Object[])new Object[0]);
            this.addMsg(pjt, msg);
        }
    }

    public void checkCoopOrg(DynamicObject pjt) {
        Date effectDate = pjt.getDate("bsed");
        if (effectDate == null) {
            return;
        }
        DynamicObjectCollection coopRelEntry = pjt.getDynamicObjectCollection("entryentity");
        Map<Long, Date> boVsOtFirstEffDate = this.getBoVsOtFirstEffDate();
        for (int i = 0; i < coopRelEntry.size(); ++i) {
            Date otFirstEffDate;
            DynamicObject coopRelRow = (DynamicObject)coopRelEntry.get(i);
            long coopOtId = coopRelRow.getLong("cooporgteam.id");
            if (coopOtId == 0L || !ProjectGroupValidHelper.checkDateEarlier((Date)effectDate, (Date)(otFirstEffDate = boVsOtFirstEffDate.get(coopOtId)))) continue;
            String message = String.format(this.getCheckCoopOrgMessage(), i + 1, HRDateTimeUtils.formatDate((Date)otFirstEffDate));
            this.addMsg(pjt, message);
        }
    }

    protected String getCheckCoopOrgMessage() {
        throw new KDBizException("undefined message: getCheckCoopOrgMessage");
    }

    public void checkCoopRelType(DynamicObject pjt) {
        DynamicObjectCollection coopRelEntry = pjt.getDynamicObjectCollection("entryentity");
        Optional<Map.Entry> repeatRelTypeCountOpt = coopRelEntry.stream().filter(coopRelRow -> coopRelRow.getLong("coopreltype.id") != 0L).collect(Collectors.groupingBy(coopRelRow -> coopRelRow.getLong("coopreltype.id"), Collectors.counting())).entrySet().stream().filter(relTypeIdVsCount -> (Long)relTypeIdVsCount.getValue() > 1L).findAny();
        if (repeatRelTypeCountOpt.isPresent()) {
            long relTypeId = (Long)repeatRelTypeCountOpt.get().getKey();
            String relTypeName = this.getCoopRelTypeIdVsName().getOrDefault(relTypeId, "");
            String msg = ResManager.loadKDString((String)"\u201c%s\u201d\u534f\u4f5c\u5173\u7cfb\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AbstractCheckHelper_10", (String)"hrmp-haos-mservice", (Object[])new Object[0]);
            this.addMsg(pjt, String.format(msg, relTypeName));
        }
    }

    public void checkEntryMustInput(DynamicObject pjt) {
        DynamicObjectCollection coopRelEntry = pjt.getDynamicObjectCollection("entryentity");
        for (int i = 0; i < coopRelEntry.size(); ++i) {
            String msg;
            DynamicObject coopRelRow = (DynamicObject)coopRelEntry.get(i);
            long relTypeId = coopRelRow.getLong("coopreltype.id");
            long coopOtId = coopRelRow.getLong("cooporgteam.id");
            if (relTypeId == 0L) {
                msg = ResManager.loadKDString((String)"\u534f\u4f5c\u5173\u7cfb\u5206\u5f55\u7b2c%s\u884c\uff1a\u201c\u534f\u4f5c\u7c7b\u578b\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractCheckHelper_8", (String)"hrmp-haos-mservice", (Object[])new Object[0]);
                this.addMsg(pjt, String.format(msg, i + 1));
            }
            if (coopOtId != 0L) continue;
            msg = ResManager.loadKDString((String)"\u534f\u4f5c\u5173\u7cfb\u5206\u5f55\u7b2c%s\u884c\uff1a\u201c\u534f\u4f5c\u7ec4\u7ec7\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractCheckHelper_9", (String)"hrmp-haos-mservice", (Object[])new Object[0]);
            this.addMsg(pjt, String.format(msg, i + 1));
        }
    }

    protected void checkChangeSceneAndChangeReason(DynamicObject pjt) {
        boolean nonMatch;
        if (pjt.getLong("changescene.id") == 0L) {
            return;
        }
        if (pjt.getLong("changescene.changetype.id") != this.newChangeOperateDy.getLong("id")) {
            String message = ResManager.loadKDString((String)"\u53d8\u52a8\u573a\u666f\u5bf9\u5e94\u7684\u53d8\u52a8\u7c7b\u578b\u5fc5\u987b\u662f\u201c%s\u201d\u3002", (String)"AbstractCheckHelper_1", (String)"hrmp-haos-mservice", (Object[])new Object[0]);
            this.addMsg(pjt, String.format(message, this.newChangeOperateDy.getString("name")));
            return;
        }
        DynamicObjectCollection changeReasonFromChangeScene = pjt.getDynamicObjectCollection("changescene.changereason");
        long changeReasonId = pjt.getLong("changereason.id");
        if (changeReasonId != 0L && (nonMatch = changeReasonFromChangeScene.stream().map(dy -> dy.getLong("fbasedataid_id")).noneMatch(id -> id == changeReasonId))) {
            String message = ResManager.loadKDString((String)"\u53d8\u52a8\u539f\u56e0\u4e0d\u5c5e\u4e8e\u5f53\u524d\u53d8\u52a8\u573a\u666f\u3002", (String)"AbstractCheckHelper_2", (String)"hrmp-haos-mservice", (Object[])new Object[0]);
            this.addMsg(pjt, message);
        }
    }

    public void batchCheckSameBsed() {
        List bsedList = this.pjtList.stream().map(dy -> dy.getDate("bsed")).distinct().filter(Objects::nonNull).collect(Collectors.toList());
        if (bsedList.size() > 1) {
            String msg = ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u5fc5\u987b\u4e00\u81f4\u3002", (String)"AbstractCheckHelper_7", (String)"hrmp-haos-mservice", (Object[])new Object[0]);
            this.pjtList.forEach(pjt -> this.addMsg((DynamicObject)pjt, msg));
        }
    }

    public void checkEnable(DynamicObject pjt) {
        String enable = pjt.getString("enable");
        if (!"1".equals(enable)) {
            String msg = this.getCheckEnableMessage();
            this.addMsg(pjt, msg);
        }
    }

    protected String getCheckEnableMessage() {
        throw new RuntimeException("getCheckEnableMessage is not defined");
    }

    protected void checkName(DynamicObject pjt) {
        LocaleStringComparator localeStringComparator = new LocaleStringComparator();
        ILocaleString name = pjt.getLocaleString("name");
        if (localeStringComparator.isBizEmpty(name)) {
            return;
        }
        IInteService service = (IInteService)ServiceFactory.getService(IInteService.class);
        List enabledLangList = service.getEnabledLang();
        for (EnabledLang enabledLang : enabledLangList) {
            String number = enabledLang.getNumber();
            String projectGroupNameVal = (String)name.get((Object)number);
            if (StringUtils.isEmpty((CharSequence)projectGroupNameVal) || !PatternUtil.valideName((String)projectGroupNameVal)) continue;
            String message = ResManager.loadKDString((String)"\u9879\u76ee\u56e2\u961f\u540d\u79f0\u4e0d\u5141\u8bb8\u6709\u7279\u6b8a\u7684\u5206\u9694\u7b26\uff08!_/\\\uff09\u3002", (String)"AbstractCheckHelper_4", (String)"hrmp-haos-mservice", (Object[])new Object[0]);
            this.addMsg(pjt, message);
            break;
        }
    }

    protected void checkProjectName(DynamicObject pjt) {
        ILocaleString curProjectName;
        LocaleStringComparator localeStringComparator;
        if (this.projectInfoService.isRootProjectTeam(pjt) && (localeStringComparator = new LocaleStringComparator()).isBizEmpty(curProjectName = pjt.getLocaleString("projectname"))) {
            String msg = ResManager.loadKDString((String)"\u201c\u9879\u76ee\u540d\u79f0\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractCheckHelper_5", (String)"hrmp-haos-mservice", (Object[])new Object[0]);
            this.addMsg(pjt, msg);
        }
    }

    private Map<Long, Date> getBoVsOtFirstEffDate() {
        if (this.boVsOtFirstEffDate == null) {
            Set otIdSet = this.pjtList.stream().map(pjt -> pjt.getDynamicObjectCollection("entryentity")).flatMap(Collection::stream).map(coopRelRow -> coopRelRow.getLong("cooporgteam.id")).filter(coopOtId -> coopOtId != 0L).collect(Collectors.toSet());
            DynamicObject[] otDys = OTQueryRepository.getInstance().queryOriginalByPks("firstbsed, boid, id", otIdSet);
            this.boVsOtFirstEffDate = Arrays.stream(otDys).collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> dy.getDate("firstbsed")));
        }
        return this.boVsOtFirstEffDate;
    }

    private List<DynamicObject> getRootPjtUnderSameAdOrgHisDataList(long aLong) {
        if (this.boVsRootPjtUnderSameAdOrgHisDataList == null) {
            Date minDate = LocalDateRangeUtils.getMinDate(this.pjtList.stream().map(dy -> dy.getDate("bsed")).collect(Collectors.toList()));
            Set adOrgBoList = this.pjtList.stream().filter(dy -> this.projectInfoService.isRootProjectTeam(dy)).map(dy -> dy.getLong("parentorg.id")).collect(Collectors.toSet());
            DynamicObject[] dynamicObjects = PRJOrgRepository.getInstance().queryRootProjectTeamWithSameAdOrg("boid, parentorg, projectname, projectnumber, bsed, bsled", adOrgBoList, minDate);
            this.boVsRootPjtUnderSameAdOrgHisDataList = Stream.concat(Arrays.stream(dynamicObjects), this.pjtList.stream()).collect(Collectors.groupingBy(dy -> dy.getLong("parentorg.id")));
        }
        return this.boVsRootPjtUnderSameAdOrgHisDataList.getOrDefault(aLong, Collections.emptyList());
    }

    public Map<Long, String> getCoopRelTypeIdVsName() {
        if (this.coopRelTypeIdVsName == null) {
            this.coopRelTypeIdVsName = this.pjtList.stream().map(dy -> dy.getDynamicObjectCollection("entryentity")).flatMap(Collection::stream).filter(row -> row.get("coopreltype") instanceof DynamicObject).collect(Collectors.toMap(row -> row.getLong("coopreltype.id"), row -> row.getString("coopreltype.name"), (val, val2) -> val));
        }
        return this.coopRelTypeIdVsName;
    }

    protected final void addMsg(DynamicObject pjt, String msg) {
        this.result.computeIfAbsent(pjt.getString("boid"), key -> new ArrayList()).add(msg);
    }

    protected final void addMsg(long bo, String msg) {
        this.result.computeIfAbsent(String.valueOf(bo), key -> new ArrayList()).add(msg);
    }

    public boolean isCoopEntryCheck() {
        return this.result.isEmpty();
    }
}

