/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.mservice.pjt.valid;

import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.hr.haos.business.domain.repository.adorg.AdOrgRepository;
import kd.hr.haos.business.domain.repository.prjorg.PRJOrgRepository;
import kd.hr.haos.business.service.projectgroup.valid.ProjectGroupValidHelper;
import kd.hr.haos.common.constants.projectgroup.ProjectGroupMDConstants;
import kd.hr.haos.common.model.cascade.CycleCheckResultWithType;
import kd.hr.haos.mservice.pjt.valid.AbstractCheckHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;

public class AddCheckHelper
extends AbstractCheckHelper {
    Map<Long, DynamicObject> boVsCurrentVersionOrg;
    Map<String, List<Long>> numberVsBoList;

    @Override
    public void init(List<DynamicObject> pjtList) {
        super.init(pjtList);
        super.initChangeTypeDy(ProjectGroupMDConstants.CHANGE_TYPE_NEW);
    }

    public Map<String, List<String>> check() {
        this.pjtList.forEach(pjt -> {
            super.checkChangeSceneAndChangeReason((DynamicObject)pjt);
            super.checkFutureEstablishmentDate((DynamicObject)pjt);
            this.checkBsed((DynamicObject)pjt);
            this.checkNumber((DynamicObject)pjt);
            super.checkProjectName((DynamicObject)pjt);
            super.checkEntryMustInput((DynamicObject)pjt);
            super.checkCoopRelType((DynamicObject)pjt);
            super.checkName((DynamicObject)pjt);
            super.checkCoopOrg((DynamicObject)pjt);
            super.checkMustInput((DynamicObject)pjt);
            super.checkBdValid((DynamicObject)pjt, Arrays.asList("changescene", "parentorg"));
        });
        if (this.isCoopEntryCheck()) {
            super.batchCheckCoopRelIsRinged();
        }
        return this.result;
    }

    @Override
    protected List<String> getMustInputCheckList() {
        return Arrays.asList("establishmentdate", "changescene", "number", "name", "parentorg");
    }

    @Override
    protected String getCheckCoopOrgMessage() {
        return ResManager.loadKDString((String)"\u534f\u4f5c\u5173\u7cfb\u5206\u5f55\u7b2c%1$s\u884c\uff1a\u6210\u7acb\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u534f\u4f5c\u7ec4\u7ec7\u7684\u6700\u65e9\u751f\u6548\u65e5\u671f(%2$s)\u3002", (String)"AddCheckHelper_3", (String)"hrmp-haos-mservice", (Object[])new Object[0]);
    }

    private void checkBsed(DynamicObject pjt) {
        Date curEffDtOrSayEstDate = pjt.getDate("bsed");
        long parentBoId = pjt.getLong("parentorg.id");
        DynamicObject parentDy = this.getBoVsCurrentVersionOrg().get(parentBoId);
        if (curEffDtOrSayEstDate == null || parentDy == null) {
            return;
        }
        Date parentEstDate = parentDy.getDate("establishmentdate");
        if (ProjectGroupValidHelper.checkDateEarlier((Date)curEffDtOrSayEstDate, (Date)parentEstDate)) {
            String msg = ResManager.loadKDString((String)"\u6210\u7acb\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u4e0a\u7ea7\u7684\u6210\u7acb\u65e5\u671f\uff08%s\uff09\u3002", (String)"AddCheckHelper_0", (String)"hrmp-haos-mservice", (Object[])new Object[0]);
            this.addMsg(pjt, String.format(msg, HRDateTimeUtils.formatDate((Date)parentEstDate)));
        }
    }

    @Override
    protected List<CycleCheckResultWithType> doBatchCheckCoopRelIsRinged() {
        return ProjectGroupValidHelper.checkCoopRel4New((List)this.pjtList);
    }

    private void checkNumber(DynamicObject pjt) {
        String number = pjt.getString("number");
        List boList = this.getNumberVsBoList().getOrDefault(number, Collections.emptyList());
        if (boList.size() > 1) {
            String msg = ResManager.loadKDString((String)"\u7f16\u7801\u5fc5\u987b\u552f\u4e00", (String)"AddCheckHelper_2", (String)"hrmp-haos-mservice", (Object[])new Object[0]);
            this.addMsg(pjt, msg);
        }
    }

    private Map<Long, DynamicObject> getBoVsCurrentVersionOrg() {
        if (this.boVsCurrentVersionOrg == null) {
            Set parentBoIdSet = this.pjtList.stream().map(dy -> dy.getLong("parentorg.id")).collect(Collectors.toSet());
            DynamicObject[] parentPjts = PRJOrgRepository.getInstance().queryOriginalByPks("boid, establishmentdate", parentBoIdSet);
            DynamicObject[] parentAdOrgs = AdOrgRepository.getInstance().queryOrgInfoByBoId("boid, establishmentdate", new ArrayList(parentBoIdSet));
            this.boVsCurrentVersionOrg = Stream.of(Arrays.stream(parentPjts), this.pjtList.stream(), Arrays.stream(parentAdOrgs)).flatMap(xva$0 -> Streams.concat((Stream[])new Stream[]{xva$0})).collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> dy));
        }
        return this.boVsCurrentVersionOrg;
    }

    private Map<String, List<Long>> getNumberVsBoList() {
        if (this.numberVsBoList == null) {
            Set numberSet = this.pjtList.stream().map(dy -> dy.getString("number")).collect(Collectors.toSet());
            DynamicObject[] dbPjtList = PRJOrgRepository.getInstance().queryOriginalArrayCurrentDataByNumber("boid, number", numberSet);
            this.numberVsBoList = Stream.concat(Arrays.stream(dbPjtList), this.pjtList.stream()).collect(Collectors.groupingBy(dy -> dy.getString("number"), Collectors.mapping(dy -> dy.getLong("boid"), Collectors.toList())));
        }
        return this.numberVsBoList;
    }
}

