/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.mservice.pjt.valid;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.hr.haos.business.domain.repository.adorg.AdOrgRepository;
import kd.hr.haos.business.domain.repository.prjorg.PRJOrgRepository;
import kd.hr.haos.business.service.projectgroup.valid.ProjectGroupValidHelper;
import kd.hr.haos.common.constants.projectgroup.ProjectGroupMDConstants;
import kd.hr.haos.common.model.cascade.CycleCheckResultWithType;
import kd.hr.haos.mservice.pjt.valid.AbstractCheckHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;

public class ChangeCheckHelper
extends AbstractCheckHelper {
    Map<Long, DynamicObject> boVsCurrentVersionOrg;
    boolean parentChange;

    public ChangeCheckHelper(boolean parentChange) {
        this.parentChange = parentChange;
    }

    @Override
    public void init(List<DynamicObject> pjtList) {
        super.init(pjtList);
        super.initChangeTypeDy(this.isParentChange() ? ProjectGroupMDConstants.CHANGETYPE_CHANGEPARENT : ProjectGroupMDConstants.CHANGETYPE_CHANGEPINFO);
    }

    public Map<String, List<String>> check() {
        this.pjtList.forEach(pjt -> {
            this.checkParentChange((DynamicObject)pjt);
            this.checkBsed((DynamicObject)pjt);
            super.checkFutureBsed((DynamicObject)pjt);
            super.checkChangeSceneAndChangeReason((DynamicObject)pjt);
            super.checkName((DynamicObject)pjt);
            super.checkProjectName((DynamicObject)pjt);
            super.checkEnable((DynamicObject)pjt);
            super.checkMustInput((DynamicObject)pjt);
            if (this.isParentChange()) {
                this.checkParentBu((DynamicObject)pjt);
                super.checkBdValid((DynamicObject)pjt, Arrays.asList("changescene", "parentorg"));
            } else {
                super.checkBdValid((DynamicObject)pjt, Collections.singletonList("changescene"));
            }
        });
        if (this.isCoopEntryCheck()) {
            this.batchCheckCoopRelIsRinged();
        }
        return this.result;
    }

    private void checkParentBu(DynamicObject pjt) {
        long parentBuId = pjt.getLong("parentorg.org.id");
        if (parentBuId == 0L) {
            return;
        }
        long curBuId = pjt.getLong("org.id");
        if (parentBuId != curBuId) {
            String msg = ResManager.loadKDString((String)"\u4e0d\u80fd\u9009\u62e9\u4e0d\u540c\u4e1a\u52a1\u5355\u5143\u7684\u7ec4\u7ec7\u4f5c\u4e3a\u4e0a\u7ea7\u3002", (String)"ChangeCheckHelper_6", (String)"hrmp-haos-mservice", (Object[])new Object[0]);
            this.addMsg(pjt, msg);
        }
    }

    @Override
    protected List<String> getMustInputCheckList() {
        if (this.isParentChange()) {
            return Arrays.asList("number", "name", "parentorg", "bsed", "changescene");
        }
        return Arrays.asList("number", "name", "bsed", "changescene");
    }

    @Override
    protected String getCheckEnableMessage() {
        return ResManager.loadKDString((String)"\u53ea\u6709\u542f\u7528\u7684\u6570\u636e\u624d\u80fd\u64cd\u4f5c\u201c\u53d8\u66f4\u201d\u3002", (String)"ChangeCheckHelper_5", (String)"hrmp-haos-mservice", (Object[])new Object[0]);
    }

    private void checkParentChange(DynamicObject pjt) {
        if (this.isParentChange()) {
            DynamicObject curDbData = this.getBoVsCurrentVersionOrg().get(pjt.getLong("boid"));
            if (pjt.getLong("parentorg.id") != 0L && curDbData.getLong("parentorg.id") == pjt.getLong("parentorg.id")) {
                String msg = ResManager.loadKDString((String)"\u8c03\u6574\u4e0a\u7ea7\u5fc5\u987b\u53d8\u66f4\u4e0a\u7ea7\u3002", (String)"ChangeCheckHelper_4", (String)"hrmp-haos-mservice", (Object[])new Object[0]);
                this.addMsg(pjt, msg);
            }
        }
    }

    private void checkBsed(DynamicObject pjt) {
        DynamicObject curDBDy;
        Date curHisEffDt;
        String msg;
        Date parentEstDate;
        DynamicObject parentDy;
        Date curEffDt = pjt.getDate("bsed");
        if (curEffDt == null) {
            return;
        }
        long parentBoId = pjt.getLong("parentorg.id");
        if (this.isParentChange() && (parentDy = this.getBoVsCurrentVersionOrg().get(parentBoId)) != null && ProjectGroupValidHelper.checkDateEarlier((Date)curEffDt, (Date)(parentEstDate = parentDy.getDate("establishmentdate")))) {
            msg = ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u4e0a\u7ea7\u6700\u65e9\u751f\u6548\u65e5\u671f\u201c%s\u201d\u3002", (String)"ChangeCheckHelper_0", (String)"hrmp-haos-mservice", (Object[])new Object[0]);
            this.addMsg(pjt, String.format(msg, HRDateTimeUtils.formatDate((Date)parentEstDate)));
        }
        if (ProjectGroupValidHelper.checkDateEarlier((Date)curEffDt, (Date)(curHisEffDt = (curDBDy = this.getBoVsCurrentVersionOrg().get(pjt.getLong("boid"))).getDate("bsed")))) {
            msg = ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u5f53\u524d\u751f\u6548\u65e5\u671f\u201c%s\u201d\u3002", (String)"ChangeCheckHelper_1", (String)"hrmp-haos-mservice", (Object[])new Object[0]);
            this.addMsg(pjt, String.format(msg, HRDateTimeUtils.formatDate((Date)curHisEffDt)));
        }
    }

    @Override
    public void batchCheckCoopRelIsRinged() {
        if (this.isParentChange()) {
            super.batchCheckCoopRelIsRinged();
        }
    }

    @Override
    protected List<CycleCheckResultWithType> doBatchCheckCoopRelIsRinged() {
        return ProjectGroupValidHelper.checkCoopRel4ParentChange((List)this.pjtList);
    }

    private Map<Long, DynamicObject> getBoVsCurrentVersionOrg() {
        if (this.boVsCurrentVersionOrg == null) {
            Set parentBoIdSet = this.pjtList.stream().map(dy -> {
                ArrayList<Long> result = new ArrayList<Long>();
                result.add(dy.getLong("parentorg.id"));
                result.add(dy.getLong("boid"));
                return result;
            }).flatMap(Collection::stream).collect(Collectors.toSet());
            DynamicObject[] pjts = PRJOrgRepository.getInstance().queryOriginalByPks("boid, bsed, parentorg.id, establishmentdate", parentBoIdSet);
            DynamicObject[] adOrgs = AdOrgRepository.getInstance().queryOrgInfoByBoId("boid, bsed, establishmentdate", new ArrayList(parentBoIdSet));
            this.boVsCurrentVersionOrg = Stream.concat(Arrays.stream(pjts), Arrays.stream(adOrgs)).collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> dy));
        }
        return this.boVsCurrentVersionOrg;
    }

    private boolean isParentChange() {
        return this.parentChange;
    }

    private boolean isInfoChange() {
        return !this.parentChange;
    }
}

