/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.mservice.pjt.valid;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.hr.haos.business.domain.repository.prjorg.PRJOrgRepository;
import kd.hr.haos.business.domain.repository.teamcoop.TeamCoopRelRepository;
import kd.hr.haos.business.service.projectgroup.valid.ProjectGroupValidHelper;
import kd.hr.haos.common.constants.projectgroup.ProjectGroupMDConstants;
import kd.hr.haos.mservice.pjt.valid.AbstractCheckHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;

public class DisableCheckHelper
extends AbstractCheckHelper {
    Map<Long, DynamicObject> boVsCurrentVersionOrg;
    Map<Long, Date> boVsCurrentVersionRel;

    @Override
    public void init(List<DynamicObject> pjtList) {
        super.init(pjtList);
        super.initChangeTypeDy(ProjectGroupMDConstants.CHANGETYPE_DISABLE_ID);
    }

    public Map<String, List<String>> check() {
        super.batchCheckSameBsed();
        this.pjtList.forEach(pjt -> {
            this.checkBsed((DynamicObject)pjt);
            super.checkFutureBsed((DynamicObject)pjt);
            super.checkChangeSceneAndChangeReason((DynamicObject)pjt);
            super.checkMustInput((DynamicObject)pjt);
            super.checkEnable((DynamicObject)pjt);
            super.checkBdValid((DynamicObject)pjt, Collections.singletonList("changescene"));
        });
        return this.result;
    }

    @Override
    protected String getCheckEnableMessage() {
        return ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u542f\u7528\u7684\u6570\u636e\u624d\u80fd\u64cd\u4f5c\u201c\u7981\u7528\u201d\u3002", (String)"DisableCheckHelper_1", (String)"hrmp-haos-mservice", (Object[])new Object[0]);
    }

    @Override
    protected List<String> getMustInputCheckList() {
        return Arrays.asList("changescene", "bsed");
    }

    private void checkBsed(DynamicObject pjt) {
        Date curEffDt = pjt.getDate("bsed");
        if (curEffDt == null) {
            return;
        }
        DynamicObject curDBDy = this.getBoVsCurrentVersionOrg().get(pjt.getLong("boid"));
        Date curHisEffDt = curDBDy.getDate("bsed");
        Date relEffDt = this.getBoVsCurrentVersionRelEarliestBsed().get(pjt.getLong("boid"));
        Date minEffectDate = relEffDt != null ? (relEffDt.after(curHisEffDt) ? relEffDt : curHisEffDt) : curHisEffDt;
        if (ProjectGroupValidHelper.checkDateEarlier((Date)curEffDt, (Date)minEffectDate)) {
            String msg = ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u5f53\u524d\u751f\u6548\u65e5\u671f\u201c%s\u201d\u3002", (String)"ChangeCheckHelper_1", (String)"hrmp-haos-mservice", (Object[])new Object[0]);
            this.addMsg(pjt, String.format(msg, HRDateTimeUtils.formatDate((Date)minEffectDate)));
        }
    }

    private Map<Long, DynamicObject> getBoVsCurrentVersionOrg() {
        if (this.boVsCurrentVersionOrg == null) {
            Set boIdSet = this.pjtList.stream().map(dy -> {
                ArrayList<Long> result = new ArrayList<Long>();
                result.add(dy.getLong("boid"));
                return result;
            }).flatMap(Collection::stream).collect(Collectors.toSet());
            DynamicObject[] pjts = PRJOrgRepository.getInstance().queryOriginalByPks("boid, bsed", boIdSet);
            this.boVsCurrentVersionOrg = Arrays.stream(pjts).collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> dy));
        }
        return this.boVsCurrentVersionOrg;
    }

    private Map<Long, Date> getBoVsCurrentVersionRelEarliestBsed() {
        if (this.boVsCurrentVersionRel == null) {
            Set boIdSet = this.pjtList.stream().map(dy -> {
                ArrayList<Long> result = new ArrayList<Long>();
                result.add(dy.getLong("boid"));
                return result;
            }).flatMap(Collection::stream).collect(Collectors.toSet());
            DynamicObject[] coopRel = TeamCoopRelRepository.getInstance().queryOriginalArray4EnabledCurrentVersionByOt("org.id, bsed, coopreltype.id", boIdSet);
            this.boVsCurrentVersionRel = Arrays.stream(coopRel).filter(dy -> dy.getLong("coopreltype.id") != 1010L).collect(Collectors.toMap(dy -> dy.getLong("org.id"), dy -> dy.getDate("bsed"), (bsed, bsed2) -> bsed.after((Date)bsed2) ? bsed : bsed2));
        }
        return this.boVsCurrentVersionRel;
    }
}

