/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.mservice.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.hr.haos.business.domain.repository.structproject.StructProjectRepository;
import kd.hr.haos.common.model.prj.CheckResult;
import kd.hr.haos.common.util.CheckChainUtils;

public class ParamCheckUtils {
    public static boolean checkLongOrIntegerType(Object value) {
        return value instanceof Long || value instanceof Integer;
    }

    public static CheckResult<String> mustInputCheck(List<Map<String, Object>> data, Set<String> mustInputFieldSet) {
        HashMap result = new HashMap();
        String msg = ResManager.loadKDString((String)"\u672a\u586b\u5199", (String)"ParamCheckUtils_0", (String)"hrmp-haos-mservice", (Object[])new Object[0]);
        for (int i = 0; i < data.size(); ++i) {
            Map<String, Object> dataMap = data.get(i);
            List msgList = mustInputFieldSet.stream().filter(fieldKey -> dataMap.get(fieldKey) == null).map(fieldKey -> fieldKey + msg).collect(Collectors.toList());
            if (msgList.size() == 0) continue;
            result.put(String.valueOf(i), msgList);
        }
        CheckResult mustInputCheckResult = new CheckResult();
        if (result.size() == 0) {
            mustInputCheckResult.setSuccess(true);
        } else {
            mustInputCheckResult.setSuccess(false);
            mustInputCheckResult.setKeyVsMsg(result);
        }
        return mustInputCheckResult;
    }

    public static CheckResult<String> keyDuplicatedCheck(List<Map<String, Object>> data, String fieldKey) {
        Map<Long, Integer> boidVsCount = data.stream().map(dataMap -> Long.valueOf(dataMap.get(fieldKey).toString())).collect(Collectors.toMap(boId -> boId, boId -> 1, Integer::sum));
        List duplicatedBoId = boidVsCount.entrySet().stream().filter(entry -> (Integer)entry.getValue() > 1).map(Map.Entry::getKey).collect(Collectors.toList());
        CheckResult mustInputCheckResult = new CheckResult();
        if (duplicatedBoId.size() > 0) {
            mustInputCheckResult.setSuccess(false);
            String message = ResManager.loadKDString((String)"\u5728\u672c\u6279\u6b21\u4e2d\u5b58\u5728\u91cd\u590d\u201c%1$s\u201d\uff1a%2$s\u3002", (String)"ParamCheckUtils_1", (String)"hrmp-haos-mservice", (Object[])new Object[0]);
            String msg = String.format(message, fieldKey, duplicatedBoId.stream().map(String::valueOf).collect(Collectors.joining(",")));
            mustInputCheckResult.setKeyVsMsg(new HashMap());
            mustInputCheckResult.getKeyVsMsg().put("0", Collections.singletonList(msg));
        } else {
            mustInputCheckResult.setSuccess(true);
        }
        return mustInputCheckResult;
    }

    public static CheckResult<String> unionValueCheck(List<Map<String, Object>> data, String fieldKey) {
        long count = data.stream().map(dataMap -> dataMap.get(fieldKey)).filter(Objects::nonNull).distinct().count();
        CheckResult mustInputCheckResult = new CheckResult();
        if (count > 1L) {
            mustInputCheckResult.setSuccess(false);
            String message = ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u5fc5\u987b\u76f8\u540c\u3002", (String)"ParamCheckUtils_4", (String)"hrmp-haos-mservice", (Object[])new Object[0]);
            mustInputCheckResult.setKeyVsMsg(new HashMap());
            mustInputCheckResult.getKeyVsMsg().put("0", Collections.singletonList(message));
        } else {
            mustInputCheckResult.setSuccess(true);
        }
        return mustInputCheckResult;
    }

    public static CheckResult<String> boidExistCheck(List<Map<String, Object>> data, Function<Set<Long>, DynamicObject[]> queryFunction) {
        Set boidSet = data.stream().map(dataMap -> Long.valueOf(dataMap.get("boid").toString())).collect(Collectors.toSet());
        DynamicObject[] dys = queryFunction.apply(boidSet);
        List boList = Arrays.stream(dys).map(dy -> dy.getLong("boid")).collect(Collectors.toList());
        CheckResult checkResult = new CheckResult();
        checkResult.setSuccess(true);
        if (boList.size() > 0) {
            checkResult.setSuccess(false);
            checkResult.setKeyVsMsg(new HashMap());
            String message = ResManager.loadKDString((String)"\u5728\u672c\u6279\u6b21\u4e2d\u6709\u5df2\u5b58\u5728BOID\uff1a%s\u3002", (String)"ParamCheckUtils_2", (String)"hrmp-haos-mservice", (Object[])new Object[0]);
            checkResult.getKeyVsMsg().put("0", Collections.singletonList(String.format(message, boList)));
        }
        return checkResult;
    }

    public static CheckResult<String> boidNotExistCheck(List<Map<String, Object>> data, Function<Set<Long>, DynamicObject[]> queryFunction) {
        Set boidSet = data.stream().map(dataMap -> Long.valueOf(dataMap.get("boid").toString())).collect(Collectors.toSet());
        DynamicObject[] dys = queryFunction.apply(boidSet);
        List boList = Arrays.stream(dys).map(dy -> dy.getLong("boid")).collect(Collectors.toList());
        CheckResult checkResult = new CheckResult();
        checkResult.setSuccess(true);
        if (boList.size() != boidSet.size()) {
            boidSet.removeAll(boList);
            checkResult.setSuccess(false);
            checkResult.setKeyVsMsg(new HashMap());
            String message = ResManager.loadKDString((String)"\u5728\u672c\u6279\u6b21\u4e2d\u6709\u4e0d\u5b58\u5728BOID\uff1a%s\u3002", (String)"ParamCheckUtils_3", (String)"hrmp-haos-mservice", (Object[])new Object[0]);
            checkResult.getKeyVsMsg().put("0", Collections.singletonList(String.format(message, boidSet)));
        }
        return checkResult;
    }

    public static CheckResult<String> getStructProjectExistCheck(Map<String, Object> param) {
        HashMap errorMap = new HashMap();
        Object structProject = param.get("structproject");
        if (structProject == null) {
            ArrayList<String> msgList = new ArrayList<String>();
            String msg = ResManager.loadKDString((String)"\u7ec4\u7ec7\u67b6\u6784\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ParamCheckUtils_5", (String)"hrmp-haos-mservice", (Object[])new Object[0]);
            msgList.add(msg);
            errorMap.put("0", msgList);
        } else {
            DynamicObject structProjectDy = StructProjectRepository.getInstance().queryByPk("id", structProject);
            if (structProjectDy == null) {
                ArrayList<String> msgList = new ArrayList<String>();
                String msg = ResManager.loadKDString((String)"\u7ec4\u7ec7\u67b6\u6784\u201c%s\u201d\u4e0d\u5b58\u5728\u3002", (String)"ParamCheckUtils_6", (String)"hrmp-haos-mservice", (Object[])new Object[0]);
                msgList.add(String.format(msg, structProject.toString()));
                errorMap.put("0", msgList);
            }
        }
        CheckResult checkResult = new CheckResult();
        if (errorMap.size() == 0) {
            checkResult.setSuccess(true);
        } else {
            checkResult.setSuccess(false);
            checkResult.setKeyVsMsg(errorMap);
        }
        return checkResult;
    }

    public static CheckResult<String> getStructProjectNonSysTypeCheck(Map<String, Object> param) {
        String structProjectId;
        HashMap errorMap = new HashMap();
        Object structProject = param.get("structproject");
        if (structProject != null && ("1010".equals(structProjectId = structProject.toString()) || "1020".equals(structProjectId) || "1030".equals(structProjectId))) {
            ArrayList<String> msgList = new ArrayList<String>();
            String msg = ResManager.loadKDString((String)"\u7ec4\u7ec7\u67b6\u6784\u4e0d\u80fd\u9009\u62e9\u9884\u7f6e\u7684\u56e2\u961f\u5206\u7c7b\u3002", (String)"ParamCheckUtils_7", (String)"hrmp-haos-mservice", (Object[])new Object[0]);
            msgList.add(msg);
            errorMap.put("0", msgList);
        }
        CheckResult checkResult = new CheckResult();
        if (errorMap.size() == 0) {
            checkResult.setSuccess(true);
        } else {
            checkResult.setSuccess(false);
            checkResult.setKeyVsMsg(errorMap);
        }
        return checkResult;
    }

    public static CheckChainUtils.Context<CheckResult<String>> getFastFailCheckContext() {
        return new CheckChainUtils.Context<CheckResult<String>>(){
            CheckResult<String> checkResult;

            public void init() {
                this.checkResult = new CheckResult();
                this.checkResult.setSuccess(true);
            }

            public void compute(CheckResult<String> result) {
                this.checkResult = result;
            }

            public CheckResult<String> get() {
                return this.checkResult;
            }
        };
    }
}

