/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.mservice.webapi.api.controller.adminorg;

import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.hr.haos.business.servicehelper.AdminOrgQueryServiceHelper;
import kd.hr.haos.mservice.webapi.api.constants.WebApiErrorCode;
import kd.hr.haos.mservice.webapi.api.model.adminorg.AdminOrgStructResultModel;
import kd.hr.haos.mservice.webapi.api.utils.AdminOrgWebApiUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;

@ApiController(value="odc", desc="adminOrgStructSearch")
@ApiMapping(value="/openapi/adminorgstructsearch")
public class AdminOrgStructSearchController
implements Serializable {
    private static final int MAX_COUNTS = 500;
    private static final long serialVersionUID = 7049298993549764783L;

    @ApiPostMapping(value="getAdminOrgStructInfo")
    public CustomApiResult<List<AdminOrgStructResultModel>> getAdminOrgStructInfo(@ApiParam(value="\u65e5\u671f\uff08\u6587\u672c\uff09", required=true, example="2022-08-08") @ApiParam(value="\u65e5\u671f\uff08\u6587\u672c\uff09", required=true, example="2022-08-08") String dateString, @ApiParam(value="\u7f16\u7801\u96c6\u5408", required=false) @ApiParam(value="\u7f16\u7801\u96c6\u5408", required=false) List<String> numberList, @ApiParam(value="\u7ec4\u7ec7ID\u96c6\u5408", required=false) @ApiParam(value="\u7ec4\u7ec7ID\u96c6\u5408", required=false) List<Long> idList, @ApiParam(value="\u662f\u5426\u9700\u8981\u957f\u540d\u79f0", required=true) @ApiParam(value="\u662f\u5426\u9700\u8981\u957f\u540d\u79f0", required=true) Boolean isNeedLongName) throws ParseException {
        if (numberList.size() > 500 || idList.size() > 500) {
            throw new OpenApiException(String.valueOf((Object)WebApiErrorCode.MAX_COUNTS_EXCEED_500));
        }
        if (numberList.size() == 0 && idList.size() == 0) {
            throw new OpenApiException(String.valueOf((Object)WebApiErrorCode.NUMBER_AND_ID_EMPTY));
        }
        Date date = HRDateTimeUtils.parseDate((String)dateString, (String)"yyyy-MM-dd");
        if (idList.size() == 0) {
            idList = AdminOrgWebApiUtils.getAdminOrgIdByNumber(numberList, date);
        }
        ArrayList<AdminOrgStructResultModel> resultList = new ArrayList<AdminOrgStructResultModel>(idList.size() == 0 ? numberList.size() : idList.size());
        AdminOrgStructResultModel model = new AdminOrgStructResultModel();
        Map orgStructsMap = AdminOrgQueryServiceHelper.queryAdminOrgStruct(idList, (Date)date, (boolean)isNeedLongName);
        HashMap infoMap = new HashMap(20);
        for (Map.Entry entry : orgStructsMap.entrySet()) {
            infoMap = (HashMap)orgStructsMap.get(entry.getKey());
            model = new AdminOrgStructResultModel();
            model.setName((String)infoMap.get("name"));
            model.setNumber((String)infoMap.get("number"));
            model.setBoid((Long)infoMap.get("boid"));
            model.setId((Long)infoMap.get("id"));
            model.setParentId((Long)infoMap.get("parentorg"));
            model.setStructNumber((String)infoMap.get("structnumber"));
            if (isNeedLongName.booleanValue()) {
                model.setStructLongNumber((String)infoMap.get("longnumber"));
                model.setStructLongName((String)infoMap.get("longname"));
                model.setStructVid((Long)infoMap.get("adminorgstructvid"));
            }
            resultList.add(model);
        }
        return CustomApiResult.success(resultList);
    }
}

