/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.mservice.webapi.api.controller.adminorg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynKey;
import kd.hr.haos.common.constants.masterdata.AdminOrgType;
import kd.hr.haos.mservice.webapi.api.constants.WebApiErrorCode;
import kd.hr.haos.mservice.webapi.api.constants.WebApiServiceHelperConstants;
import kd.hr.haos.mservice.webapi.api.model.adminorg.FullCompanyInfoPageModel;
import kd.hr.haos.mservice.webapi.api.model.adminorg.FullCompanyInfoResultModel;
import kd.hr.haos.mservice.webapi.api.utils.AdminOrgWebApiUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;

@ApiController(value="odc", desc="fullCompanyInfoSearch")
@ApiMapping(value="/openapi/query")
public class FullCompanyInfoSearchController {
    @ApiPostMapping(value="getFullCompanyInfo")
    public CustomApiResult<FullCompanyInfoPageModel> getFullCompanyInfo(@ApiParam(value="\u9875\u7801", required=false, example="1") @ApiParam(value="\u9875\u7801", required=false, example="1") int pageNo, @ApiParam(value="\u6761\u6570", required=false, example="1000") @ApiParam(value="\u6761\u6570", required=false, example="1000") int pageSize) {
        if (pageSize > 5000) {
            throw new OpenApiException(String.valueOf((Object)WebApiErrorCode.MAX_COUNTS_EXCEED_5000));
        }
        FullCompanyInfoPageModel model = new FullCompanyInfoPageModel(pageNo, pageSize);
        boolean lastPage = false;
        String entityName = AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey();
        int count = this.getEntityCount(entityName);
        if (model.getPageNo() * model.getPageSize() >= count) {
            lastPage = true;
        }
        String selectProperties = "adminorg";
        DynamicObject[] array = BusinessDataServiceHelper.load((String)entityName, (String)selectProperties, (QFilter[])this.getQFilters(), (String)"level", (int)(model.getPageNo() - 1), (int)model.getPageSize());
        List<Long> idList = Arrays.stream(array).map(dy -> dy.getLong("adminorg.id")).collect(Collectors.toList());
        ArrayList<FullCompanyInfoResultModel> resultList = new ArrayList<FullCompanyInfoResultModel>(model.getPageSize());
        model.setRows(resultList);
        model.setLastPage(lastPage);
        if (CollectionUtils.isEmpty(idList)) {
            model.setLastPage(true);
            return CustomApiResult.success((Object)((Object)model));
        }
        Map<Long, DynamicObject> companyMap = AdminOrgWebApiUtils.getCurrentBasicDataInfo(WebApiServiceHelperConstants.COMPANY_SERVICEHELPER, idList, "adminorg.id,companytype,industrytype");
        Map<Long, DynamicObject> groupMap = AdminOrgWebApiUtils.getCurrentBasicDataInfo(WebApiServiceHelperConstants.GROUP_SERVICEHELPER, idList, "adminorg.id,groupvision,groupmission");
        for (DynamicObject dy2 : array) {
            Long boId = dy2.getLong("adminorg.boid");
            resultList.add(this.buildRows(dy2, companyMap.get(boId), groupMap.get(boId)));
        }
        return CustomApiResult.success((Object)((Object)model));
    }

    private FullCompanyInfoResultModel buildRows(DynamicObject dy, DynamicObject companyDynObj, DynamicObject groupDynObj) {
        FullCompanyInfoResultModel model = new FullCompanyInfoResultModel();
        model.setBoId(dy.getLong("adminorg.boid"));
        model.setNumber(dy.getString("adminorg.number"));
        model.setName(dy.getString("adminorg.name"));
        model.setAdminOrgTypeId(dy.getLong("adminorg.adminorgtype.id"));
        model.setAdminOrgTypeName(dy.getString("adminorg.adminorgtype.name"));
        model.setParentBoId(dy.getLong("adminorg.parentorg.id"));
        model.setEstablishmentDate(dy.getDate("adminorg.establishmentdate"));
        model.setBsed(dy.getDate("adminorg.bsed"));
        model.setEnable(dy.getString("adminorg.enable"));
        if (!HRObjectUtils.isEmpty((Object)companyDynObj)) {
            model.setCompanyTypeId(companyDynObj.getLong("companytype.id"));
            model.setCompanyTypeName(companyDynObj.getString("companytype.name"));
            model.setIndustryTypeId(companyDynObj.getLong("industrytype.id"));
            model.setIndustryTypeName(companyDynObj.getString("industrytype.name"));
        }
        if (!HRObjectUtils.isEmpty((Object)groupDynObj)) {
            model.setGroupMission(groupDynObj.getString("groupmission"));
            model.setGroupVision(groupDynObj.getString("groupvision"));
        }
        return model;
    }

    private int getEntityCount(String entityName) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityName);
        return helper.count(entityName, this.getQFilters());
    }

    private QFilter[] getQFilters() {
        QFilter qFilter = new QFilter("adminorg.adminorgtype.adminorgtypestd", "in", Arrays.asList(AdminOrgType.GROUP.getId(), AdminOrgType.COMPANY.getId()));
        qFilter.and("iscurrentversion", "=", (Object)Character.valueOf('1'));
        qFilter.and("initstatus", "=", (Object)"2");
        qFilter.and("datastatus", "in", Arrays.asList("1", "2"));
        return new QFilter[]{qFilter};
    }
}

