/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.mservice.webapi.api.controller.customorg;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.business.domain.repository.QFilterHelper;
import kd.hr.haos.business.domain.repository.customstruct.CustomOrgTeamStructRepository;
import kd.hr.haos.business.domain.repository.customstruct.CustomStructHelper;
import kd.hr.haos.business.domain.repository.customstruct.CustomStructProjectRepository;
import kd.hr.haos.business.domain.repository.customstruct.NumberPrefixRepository;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

@ApiController(value="odc", desc="customOrgInfoSearchController")
@ApiMapping(value="/openapi/customOrgInfoSearchController")
public class CustomOrgInfoSearchController
implements Serializable {
    private static final Log logger = LogFactory.getLog(CustomOrgInfoSearchController.class);
    private static final int MAX_COUNTS = 500;
    private static final long serialVersionUID = -286317816804076424L;

    @ApiPostMapping(value="getCusOrgInfoByStructproject")
    public CustomApiResult<Map<String, Object>> getCusOrgInfoByStructproject(@ApiParam(value="\u67b6\u6784\u65b9\u6848id", required=false) @ApiParam(value="\u67b6\u6784\u65b9\u6848id", required=false) Long structProjectId, @ApiParam(value="\u67b6\u6784\u65b9\u6848number", required=false) @ApiParam(value="\u67b6\u6784\u65b9\u6848number", required=false) String structProjectNumber, @ApiParam(value="\u7ec4\u7ec7ids", required=false) @ApiParam(value="\u7ec4\u7ec7ids", required=false) List<Long> orgIds, @ApiParam(value="\u7ec4\u7ec7\u7f16\u7801", required=false) @ApiParam(value="\u7ec4\u7ec7\u7f16\u7801", required=false) List<String> orgNumbers, @ApiParam(value="\u662f\u5426\u5305\u542b\u4e0b\u7ea7", required=false) @ApiParam(value="\u662f\u5426\u5305\u542b\u4e0b\u7ea7", required=false) Boolean isHasSub, @ApiParam(value="\u751f\u6548\u65e5\u671f", required=false, example="2024-01-01") @ApiParam(value="\u751f\u6548\u65e5\u671f", required=false, example="2024-01-01") Date queryDate) throws ParseException {
        List<Map<String, Object>> orgList;
        QFilter filter;
        logger.info("getCusOrgInfoByStructproject structProjectId\uff1a{},structProjectNumber:{}, orgIds:{},orgNumbers:{}, isHasSub:{}, queryDate{}", new Object[]{structProjectId, structProjectNumber, JSON.toJSONString(orgIds), JSON.toJSONString(orgNumbers), isHasSub, queryDate});
        if (HRObjectUtils.isEmpty((Object)structProjectId) && HRStringUtils.isEmpty((String)structProjectNumber)) {
            return CustomApiResult.fail((String)"809", (String)"The structproject id and number cannot both be empty.");
        }
        if (HRObjectUtils.isEmpty(orgIds) && HRObjectUtils.isEmpty(orgNumbers)) {
            return CustomApiResult.fail((String)"810", (String)"The org id and number cannot both be empty.");
        }
        if (!HRObjectUtils.isEmpty(orgIds) && orgIds.size() > 500) {
            return CustomApiResult.fail((String)"801", (String)"The org ids or numbers of queries cannot exceed 500.");
        }
        if (!HRObjectUtils.isEmpty(orgNumbers) && orgNumbers.size() > 500) {
            return CustomApiResult.fail((String)"801", (String)"The org ids or numbers of queries cannot exceed 500.");
        }
        if (queryDate == null) {
            queryDate = HRDateTimeUtils.getNowDate();
        } else if (HRDateTimeUtils.dayAfter((Date)queryDate, (Date)new Date())) {
            return CustomApiResult.fail((String)"901", (String)"The effective date cannot be in the future.");
        }
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        DynamicObject[] structProjectDys = CustomStructProjectRepository.getRepository().queryByStructProjectIdORNumber(structProjectId, structProjectNumber, "id,number,name,otclassify.id");
        if (structProjectDys.length == 0) {
            logger.info("The structProject Info query result is empty by id or number.");
            return CustomApiResult.fail((String)"902", (String)"The query result is empty by structProjectId or structProjectNumber.");
        }
        Long structProjectRealId = structProjectDys[0].getLong("id");
        String structProjectRealNumber = structProjectDys[0].getString("number");
        String structProjectRealName = structProjectDys[0].getString("name");
        result.put("structprojectid", structProjectRealId);
        result.put("structprojectnumber", structProjectRealNumber);
        result.put("structprojectname", structProjectRealName);
        Long classifyId = structProjectDys[0].getLong("otclassify.id");
        if (!HRObjectUtils.isEmpty(orgIds)) {
            filter = new QFilter("orgteam.id", "in", orgIds);
        } else {
            Map prefixNumberMap = NumberPrefixRepository.getRepository().getNumberPrefixByIds((List)Lists.newArrayList((Object[])new Long[]{classifyId}));
            orgNumbers = orgNumbers.stream().map(orgnumber -> CustomStructHelper.showNumberToRealNumber((String)orgnumber, (String)((String)prefixNumberMap.get(classifyId)))).collect(Collectors.toList());
            filter = new QFilter("orgteam.number", "in", orgNumbers);
        }
        QFilter dateFilter = QFilterHelper.createValidHisVersionFilterByOnePoint((Date)queryDate);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        filter.and(dateFilter).and(new QFilter("structproject", "=", (Object)structProjectRealId)).and(enableFilter);
        DynamicObjectCollection structCol = CustomOrgTeamStructRepository.getRepository().queryOriginalCollection("orgteamhisid,orgteam.id, orgteam.number, structlongnumber,level", new QFilter[]{filter});
        if (ObjectUtils.isEmpty((Object)structCol)) {
            logger.info("The haos_customotstruct Info query result is empty by id or number.");
            return CustomApiResult.fail((String)"903", (String)"The query result is empty by orgIds or orgNumbers.");
        }
        if (isHasSub == null) {
            isHasSub = false;
        }
        if (!isHasSub.booleanValue()) {
            orgList = this.queryOrg(structCol.stream().collect(Collectors.toMap(dy -> dy.getLong("orgteamhisid"), dy -> dy.getString("structlongnumber"))), classifyId);
        } else {
            List<String> structLongNumberList = structCol.stream().map(dy -> dy.getString("structlongnumber")).collect(Collectors.toList());
            logger.info(String.format(Locale.ROOT, "Before filter structlongnumbers are: %s", structLongNumberList));
            List<String> filteredStructLongNumberList = this.filterUnNecessaryStructLongNumber(structLongNumberList);
            logger.info(String.format(Locale.ROOT, "After filter structlongnumbers are: %s", filteredStructLongNumberList));
            QFilter structLongNumberFilter = new QFilter("structlongnumber", "like", (Object)(filteredStructLongNumberList.get(0) + "%"));
            for (int i = 1; i < filteredStructLongNumberList.size(); ++i) {
                structLongNumberFilter.or("structlongnumber", "like", (Object)(filteredStructLongNumberList.get(i) + "%"));
            }
            DynamicObjectCollection subCol = CustomOrgTeamStructRepository.getRepository().queryOriginalCollection("orgteamhisid,orgteam.id,level,structlongnumber", new QFilter[]{structLongNumberFilter, dateFilter, enableFilter});
            orgList = this.queryOrg(subCol.stream().collect(Collectors.toMap(dy -> dy.getLong("orgteamhisid"), dy -> dy.getString("structlongnumber"))), classifyId);
        }
        result.put("orglist", orgList);
        return CustomApiResult.success(result);
    }

    private List<Map<String, Object>> queryOrg(Map<Long, String> structMap, Long otClassifyId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_orgteamquery");
        DynamicObjectCollection col = serviceHelper.queryOriginalCollection("boid,name, number, index,enable,id,sortcode,org.number,org.name,parent.id,parent.number,parent.name,bsed,firstbsed", new QFilter[]{new QFilter("id", "in", structMap.keySet())});
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(col.size());
        String numberPrefix = NumberPrefixRepository.getRepository().getNumberPrefixById(otClassifyId);
        for (DynamicObject dy : col) {
            result.add(this.getSubResultMap(dy, structMap, numberPrefix));
        }
        return result;
    }

    private Map<String, Object> getSubResultMap(DynamicObject dy, Map<Long, String> structMap, String numberPrefix) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("id", dy.getLong("id"));
        Long orgId = dy.getLong("boid");
        map.put("orgId", orgId);
        map.put("orgNumber", HRObjectUtils.isEmpty((Object)dy.getString("number")) ? dy.getString("number") : dy.getString("number").replaceFirst(numberPrefix + "_", ""));
        map.put("orgName", dy.getString("name"));
        map.put("parentid", dy.getLong("parent.id"));
        map.put("parentnumber", HRObjectUtils.isEmpty((Object)dy.getString("parent.number")) ? dy.getString("parent.number") : dy.getString("parent.number").replaceFirst(numberPrefix + "_", ""));
        map.put("parentname", dy.getString("parent.name"));
        map.put("effectdate", dy.getDate("bsed"));
        map.put("index", dy.getInt("index"));
        return map;
    }

    private List<String> filterUnNecessaryStructLongNumber(List<String> structLongNumberList) {
        structLongNumberList.sort(Comparator.comparing(String::length));
        ArrayList<String> filteredStructLongNumber = new ArrayList<String>(structLongNumberList.size());
        this.filterStructLongNumber(structLongNumberList, filteredStructLongNumber);
        return filteredStructLongNumber;
    }

    private void filterStructLongNumber(List<String> structLongNumberList, List<String> filteredStructLongNumber) {
        String leastLengthStructLongNumber = structLongNumberList.get(0);
        filteredStructLongNumber.add(leastLengthStructLongNumber);
        List<String> collect = structLongNumberList.stream().filter(strcNum -> !strcNum.contains(leastLengthStructLongNumber)).collect(Collectors.toList());
        if (collect.size() == 0) {
            return;
        }
        this.filterStructLongNumber(collect, filteredStructLongNumber);
    }
}

