/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.mservice.webapi.api.external.staff.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.operation.OperationServiceImpl;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.haos.business.domain.repository.adorg.AdOrgRepository;
import kd.hr.haos.business.domain.repository.adorg.AdminOrgStructRepository;
import kd.hr.haos.business.domain.repository.staff.StaffCycleRepository;
import kd.hr.haos.business.domain.repository.staff.StaffDimensionRepository;
import kd.hr.haos.business.domain.repository.staff.StaffRepository;
import kd.hr.haos.business.service.staff.externalInterface.bean.StaffBo;
import kd.hr.haos.business.service.staff.externalInterface.bean.StaffControlBo;
import kd.hr.haos.business.service.staff.externalInterface.bean.StaffCountBo;
import kd.hr.haos.business.service.staff.externalInterface.bean.StaffDimensionBaseBo;
import kd.hr.haos.business.service.staff.externalInterface.bean.StaffMultiDimensionBo;
import kd.hr.haos.business.service.staff.externalInterface.bean.StaffUseOrgBo;
import kd.hr.haos.business.service.staff.helper.StaffEntryHelperEnum;
import kd.hr.haos.business.service.staff.service.StaffCommonService;
import kd.hr.haos.business.servicehelper.SystemParamHelper;
import kd.hr.haos.business.util.ConcurrentIdCreator;
import kd.hr.haos.common.constants.staff.DynamicDimensionEnum;
import kd.hr.haos.common.constants.staff.OrgStaffConstants;
import kd.hr.haos.mservice.webapi.api.external.staff.IStaffExternalService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.mservice.HRMServiceResult;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class StaffExternalServiceImpl
implements IStaffExternalService,
OrgStaffConstants {
    private static final Log logger = LogFactory.getLog(StaffExternalServiceImpl.class);
    private static final Integer YEAR_STAFF_COUNT = 13;
    private static final ConcurrentIdCreator idCreator = new ConcurrentIdCreator();
    private static Map<Long, DynamicObject> staffCycleIdVsDynMap;
    private static Map<Long, DynamicObject> staffDimensionIdVsDynMap;
    private static Map<String, String> enableVsNameMap;
    private Map<Integer, Function<StaffCountBo, Integer>> monthVsGetStaffMap = Maps.newHashMapWithExpectedSize((int)2);
    private final List<String> CONTROL_STRATEGY_RANGE = Arrays.asList("1", "2", "3", "4");
    private final List<String> MULTI_CONTROL_STRATEGY_RANGE = Arrays.asList("1", "2", "3");
    private final List<String> ELASTIC_CONTROL_LIST = Arrays.asList("1", "2");
    private Integer negative;

    public StaffExternalServiceImpl() {
        this.monthVsGetStaffMap.put(1, StaffCountBo::getMonthStaff1);
        this.monthVsGetStaffMap.put(2, StaffCountBo::getMonthStaff2);
        this.monthVsGetStaffMap.put(3, StaffCountBo::getMonthStaff3);
        this.monthVsGetStaffMap.put(4, StaffCountBo::getMonthStaff4);
        this.monthVsGetStaffMap.put(5, StaffCountBo::getMonthStaff5);
        this.monthVsGetStaffMap.put(6, StaffCountBo::getMonthStaff6);
        this.monthVsGetStaffMap.put(7, StaffCountBo::getMonthStaff7);
        this.monthVsGetStaffMap.put(8, StaffCountBo::getMonthStaff8);
        this.monthVsGetStaffMap.put(9, StaffCountBo::getMonthStaff9);
        this.monthVsGetStaffMap.put(10, StaffCountBo::getMonthStaff10);
        this.monthVsGetStaffMap.put(11, StaffCountBo::getMonthStaff11);
        this.monthVsGetStaffMap.put(12, StaffCountBo::getMonthStaff12);
        this.monthVsGetStaffMap.put(YEAR_STAFF_COUNT, StaffCountBo::getYearStaff);
        enableVsNameMap.put("1", ResManager.loadKDString((String)"\u542f\u7528", (String)"DutyOrgOccupyChain_1", (String)"hrmp-haos-mservice", (Object[])new Object[0]));
        enableVsNameMap.put("0", ResManager.loadKDString((String)"\u7981\u7528", (String)"DutyOrgOccupyChain_1", (String)"hrmp-haos-mservice", (Object[])new Object[0]));
        this.negative = -1;
        DynamicObject[] staffCycleDynArr = StaffCycleRepository.getInstance().loadAllDynamicObjectArray();
        staffCycleIdVsDynMap = Arrays.stream(staffCycleDynArr).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn));
        DynamicObject[] staffDimensionDynArr = StaffDimensionRepository.getInstance().loadAllDynamicObjectArray();
        staffDimensionIdVsDynMap = Arrays.stream(staffDimensionDynArr).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn));
    }

    @Override
    public HRMServiceResult queryStaffById(Long staffId) {
        StaffCommonService.STAFF_INTERFACE_STAFF_ID.set(staffId);
        DynamicObject staffDyn = StaffRepository.getInstance().loadDynamicObject(staffId);
        StaffBo staffBo = this.getStaffBo(staffDyn);
        if (Objects.isNull(staffBo)) {
            return HRMServiceResult.fail((String)ResManager.loadKDString((String)"staffid\u586b\u5199\u6709\u8bef\uff0c\u6ca1\u6709\u6b64\u7f16\u5236\u4fe1\u606f\uff1b", (String)"StaffExternalServiceImpl_0", (String)"hrmp-haos-mservice", (Object[])new Object[0]));
        }
        if (HRStringUtils.equals((String)"0", (String)staffBo.getEnable())) {
            return HRMServiceResult.fail((String)ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u67e5\u8be2\u7981\u7528\u7684\u7f16\u5236\u4fe1\u606f\uff1b", (String)"StaffExternalServiceImpl_1", (String)"hrmp-haos-mservice", (Object[])new Object[0]));
        }
        return HRMServiceResult.success((Object)staffBo);
    }

    private StaffBo getStaffBo(DynamicObject staffDyn) {
        if (Objects.isNull(staffDyn)) {
            return null;
        }
        StaffBo staffBo = new StaffBo();
        staffBo.setStaffId(Long.valueOf(staffDyn.getLong("id")));
        staffBo.setName(staffDyn.getString("name"));
        staffBo.setNumber(staffDyn.getString("number"));
        staffBo.setOrgId(Long.valueOf(staffDyn.getLong("org.id")));
        staffBo.setStaffCycleId(Long.valueOf(staffDyn.getLong("staffcycle.id")));
        staffBo.setStaffProjectId(Long.valueOf(staffDyn.getLong("staffproject.id")));
        Date year = staffDyn.getDate("year");
        staffBo.setYear(staffDyn.getDate("year"));
        String enable = staffDyn.getString("enable");
        staffBo.setEnable(enable);
        if (!HRStringUtils.equals((String)enable, (String)"10")) {
            staffBo.setStaffStatus(this.isUsing(year) ? "1" : "0");
        }
        this.setStaffDimension(staffDyn, (StaffDimensionBaseBo)staffBo);
        this.setStaffControl(staffDyn, "staff", (StaffControlBo)staffBo);
        List<StaffUseOrgBo> staffUseOrgBoList = this.assembleStaffUseOrgBoList(staffDyn);
        staffBo.setUseOrgEntryBoList(staffUseOrgBoList);
        return staffBo;
    }

    private boolean isUsing(Date staffYear) {
        return HRDateTimeUtils.getYear((Date)staffYear) >= HRDateTimeUtils.getYear((Date)new Date());
    }

    private List<StaffUseOrgBo> assembleStaffUseOrgBoList(DynamicObject staffDyn) {
        long staffId = staffDyn.getLong("id");
        long orgId = staffDyn.getLong("org.id");
        ArrayList staffUseOrgBoList = Lists.newArrayListWithExpectedSize((int)16);
        DynamicObject[] dutyOrgInfoArr = StaffCommonService.queryStaffTempAndEffectData((String)"haos_dutyorgdetail", (Long)staffId, (String)"dutyorg, staffcount");
        Map<Long, DynamicObject> dutyOrgIdInfoMap = Arrays.stream(dutyOrgInfoArr).collect(Collectors.toMap(dyn -> dyn.getLong("dutyorg.id"), dyn -> dyn));
        DynamicObject[] useOrgInfoArr = StaffCommonService.queryStaffTempAndEffectData((String)"haos_useorgdetail", (Long)staffId, (String)"id, useorg.id, useorg.enable, useorg, useorgbo, dutyorg.id, sequence, pid,staffdimension.fbasedataid, controlstrategy, elasticcontrol, elasticcount, yearstaff, halfyearstaff1, halfyearstaff2, quarterstaff1, quarterstaff2, quarterstaff3, quarterstaff4, monthstaff1, monthstaff2, monthstaff3, monthstaff4, monthstaff5, monthstaff6, monthstaff7, monthstaff8, monthstaff9, monthstaff10, monthstaff11, monthstaff12");
        Map<Long, DynamicObject> useOrgBoIdInfoMap = Arrays.stream(useOrgInfoArr).collect(Collectors.toMap(dyn -> dyn.getLong("useorgbo"), dyn -> dyn));
        StringBuilder sql = StaffCommonService.buildSqlWithPerm(null, (boolean)false);
        logger.info("StaffExternalServiceImpl#queryStaffById.sql={}", (Object)sql);
        Date date = new Date();
        Object[] param = new Object[]{date, date, date, date, date, date, orgId, orgId};
        ORM orm = ORM.create();
        try (DataSet dataSet = HRDBUtil.queryDataSet((String)"haos_adminOrgHisSearch", (DBRoute)new DBRoute("hr"), (String)sql.toString(), (Object[])param);){
            DynamicObjectCollection retDynCol = orm.toPlainDynamicObjectCollection(dataSet);
            for (DynamicObject rowDyn : retDynCol) {
                StaffUseOrgBo staffUseOrgBo = this.buildUseOrgBo(staffDyn, dutyOrgIdInfoMap, useOrgBoIdInfoMap, rowDyn);
                staffUseOrgBoList.add(staffUseOrgBo);
            }
        }
        this.setParentEntryId(staffUseOrgBoList);
        this.assembleMultiDimensionBo(staffId, staffUseOrgBoList);
        return staffUseOrgBoList;
    }

    private StaffUseOrgBo buildUseOrgBo(DynamicObject staffDyn, Map<Long, DynamicObject> dutyOrgIdInfoMap, Map<Long, DynamicObject> useOrgBoIdInfoMap, DynamicObject rowDyn) {
        StaffUseOrgBo staffUseOrgBo = new StaffUseOrgBo();
        long adminOrgId = rowDyn.getLong("id");
        long boId = rowDyn.getLong("boid");
        long parentOrgBoId = rowDyn.getLong("parentorg");
        staffUseOrgBo.setAdminOrgId(Long.valueOf(adminOrgId));
        staffUseOrgBo.setAdminOrgBoId(Long.valueOf(boId));
        staffUseOrgBo.setParentOrgBoId(Long.valueOf(parentOrgBoId));
        DynamicObject useOrgInfo = useOrgBoIdInfoMap.get(boId);
        if (useOrgInfo == null) {
            staffUseOrgBo.setEntryId(Long.valueOf(idCreator.getId()));
            this.setStaffDimension(staffDyn, (StaffDimensionBaseBo)staffUseOrgBo);
            this.setStaffControl(staffDyn, "staff", (StaffControlBo)staffUseOrgBo);
        } else {
            staffUseOrgBo.setEntryId(Long.valueOf(useOrgInfo.getLong("id")));
            this.setStaffDimension(useOrgInfo, (StaffDimensionBaseBo)staffUseOrgBo);
            this.setStaffControl(useOrgInfo, "", (StaffControlBo)staffUseOrgBo);
            DynamicObject dutyOrgInfo = dutyOrgIdInfoMap.get(adminOrgId);
            if (dutyOrgInfo != null) {
                staffUseOrgBo.setYearStaffNumWithSub(Integer.valueOf(dutyOrgInfo.getInt("staffcount")));
            }
            this.setStaffCount(useOrgInfo, (StaffCountBo)staffUseOrgBo);
        }
        return staffUseOrgBo;
    }

    private void setStaffDimension(DynamicObject staffDyn, StaffDimensionBaseBo bo) {
        DynamicObjectCollection dimensionDynCol = staffDyn.getDynamicObjectCollection("staffdimension");
        List<Object> useOrgDimensionIdList = Lists.newArrayListWithExpectedSize((int)16);
        if (!CollectionUtils.isEmpty((Collection)dimensionDynCol)) {
            useOrgDimensionIdList = dimensionDynCol.stream().map(dyn -> dyn.getLong("fbasedataid.id")).collect(Collectors.toList());
        }
        bo.setStaffDimensionIdList((List)useOrgDimensionIdList);
    }

    private void setParentEntryId(List<StaffUseOrgBo> staffUseOrgBoList) {
        Map<Long, Long> adminOrgBoIdVsEntryIdMap = staffUseOrgBoList.stream().collect(Collectors.toMap(StaffUseOrgBo::getAdminOrgBoId, StaffUseOrgBo::getEntryId));
        Map<Long, StaffUseOrgBo> adminOrgBoIdVsBoMap = staffUseOrgBoList.stream().collect(Collectors.toMap(StaffUseOrgBo::getAdminOrgBoId, bo -> bo));
        for (StaffUseOrgBo staffUseOrgBo : staffUseOrgBoList) {
            Long parentOrgBoId = staffUseOrgBo.getParentOrgBoId();
            if (parentOrgBoId == null) {
                staffUseOrgBo.setParentEntryId(Long.valueOf(0L));
                continue;
            }
            Long entryId = adminOrgBoIdVsEntryIdMap.get(parentOrgBoId);
            staffUseOrgBo.setParentEntryId(entryId);
            StaffUseOrgBo parentStaffUseOrgBo = adminOrgBoIdVsBoMap.get(parentOrgBoId);
            if (parentStaffUseOrgBo == null) continue;
            parentStaffUseOrgBo.setHasSub(Boolean.TRUE);
        }
    }

    private void assembleMultiDimensionBo(Long staffId, List<StaffUseOrgBo> staffUseOrgBoList) {
        DynamicObject[] dimensionInfoArr = StaffCommonService.queryStaffTempAndEffectData((String)"haos_muldimendetail", (Long)staffId, (String)"id, useorg.id, useorg.enable, useorg.boid, orgteam, dutyworkrole, job,basicdata1,basicdata2,basicdata3,basicdata4,basicdata5, laborreltype, sequence, controlstrategy, elasticcontrol, elasticcount, yearstaff, halfyearstaff1, halfyearstaff2, quarterstaff1, quarterstaff2, quarterstaff3, quarterstaff4, monthstaff1, monthstaff2, monthstaff3, monthstaff4, monthstaff5, monthstaff6, monthstaff7, monthstaff8, monthstaff9, monthstaff10, monthstaff11, monthstaff12");
        if (dimensionInfoArr == null || dimensionInfoArr.length == 0) {
            return;
        }
        Map<Long, List<DynamicObject>> dimensionInfoMap = Arrays.stream(dimensionInfoArr).collect(Collectors.groupingBy(dyn -> dyn.getLong("useorg.boid")));
        for (StaffUseOrgBo staffUseOrgBo : staffUseOrgBoList) {
            Long adminOrgBoId = staffUseOrgBo.getAdminOrgBoId();
            List<DynamicObject> dimensionDynList = dimensionInfoMap.get(adminOrgBoId);
            if (CollectionUtils.isEmpty(dimensionDynList)) continue;
            for (DynamicObject multiDimensionDyn : dimensionDynList) {
                Map.Entry<Long, DynamicObject> entry;
                DynamicObject dimensionDyn;
                Iterator<Map.Entry<Long, DynamicObject>> iterator = staffDimensionIdVsDynMap.entrySet().iterator();
                while (iterator.hasNext() && !this.buildMultiDimensionBo(staffUseOrgBo, multiDimensionDyn, dimensionDyn = (entry = iterator.next()).getValue())) {
                }
            }
        }
        this.synPositionDimension(staffUseOrgBoList);
    }

    private void synPositionDimension(List<StaffUseOrgBo> staffUseOrgBoList) {
        List adminOrgBOIdList = staffUseOrgBoList.stream().filter(staffUseOrgBo -> {
            String controlStrategy = staffUseOrgBo.getStaffControlStrategy();
            HashSet dimensionIds = new HashSet(staffUseOrgBo.getStaffDimensionIdList());
            return dimensionIds.contains(1010L) && !"4".equals(controlStrategy);
        }).map(StaffUseOrgBo::getAdminOrgBoId).collect(Collectors.toList());
        Map positionAndJobIds = StaffCommonService.getPositionAndJobIds(adminOrgBOIdList);
        for (StaffUseOrgBo staffUseOrgBo2 : staffUseOrgBoList) {
            List staffDimensionIdList = staffUseOrgBo2.getStaffDimensionIdList();
            if (!staffDimensionIdList.contains(1010L)) continue;
            Long adminOrgBoId = staffUseOrgBo2.getAdminOrgBoId();
            List existPositionIdList = staffUseOrgBo2.getPositionDimensionBoList().stream().map(StaffMultiDimensionBo::getKeyFieldId).collect(Collectors.toList());
            HashSet[] positionIdAndJobIdSet = (HashSet[])positionAndJobIds.get(adminOrgBoId);
            if (positionIdAndJobIdSet == null) continue;
            HashSet positionIdAll = ((HashSet[])positionAndJobIds.get(adminOrgBoId))[0];
            positionIdAll.removeAll(existPositionIdList);
            for (Long positionId : positionIdAll) {
                staffUseOrgBo2.getPositionDimensionBoList().add(this.buildNewPositionDimensionBo(staffUseOrgBo2, positionId));
            }
        }
    }

    private StaffMultiDimensionBo buildNewPositionDimensionBo(StaffUseOrgBo staffUseOrgBo, Long positionId) {
        StaffMultiDimensionBo staffMultiDimensionBo = new StaffMultiDimensionBo();
        staffMultiDimensionBo.setEntryId(Long.valueOf(idCreator.getId()));
        staffMultiDimensionBo.setAdminOrgBoId(staffUseOrgBo.getAdminOrgBoId());
        staffMultiDimensionBo.setKeyFieldId(positionId);
        staffMultiDimensionBo.setStaffControlStrategy(staffUseOrgBo.getStaffControlStrategy());
        staffMultiDimensionBo.setStaffElasticControl(staffUseOrgBo.getStaffElasticControl());
        staffMultiDimensionBo.setStaffElasticCount(staffUseOrgBo.getStaffElasticCount());
        return staffMultiDimensionBo;
    }

    private boolean buildMultiDimensionBo(StaffUseOrgBo staffUseOrgBo, DynamicObject multiDimensionInfo, DynamicObject dimensionInfo) {
        String keyFieldName = dimensionInfo.getString("staffdimension");
        long dimensionId = dimensionInfo.getLong("id");
        if (multiDimensionInfo.get(keyFieldName) != null) {
            Object baseDataEnable = multiDimensionInfo.get(keyFieldName + ".enable");
            if (baseDataEnable instanceof String && "1".equals(baseDataEnable) || baseDataEnable instanceof Boolean && ((Boolean)baseDataEnable).booleanValue()) {
                StaffMultiDimensionBo staffMultiDimensionBo = new StaffMultiDimensionBo();
                long useOrgBoId = multiDimensionInfo.getLong("useorg.boid");
                staffMultiDimensionBo.setDimensionId(Long.valueOf(dimensionId));
                staffMultiDimensionBo.setEntryId(Long.valueOf(multiDimensionInfo.getLong("id")));
                DynamicObject baseDataDyn = multiDimensionInfo.getDynamicObject(keyFieldName);
                staffMultiDimensionBo.setKeyFieldId(baseDataDyn != null ? Long.valueOf(baseDataDyn.getLong("id")) : null);
                staffMultiDimensionBo.setAdminOrgBoId(Long.valueOf(useOrgBoId));
                staffMultiDimensionBo.setStaffControlStrategy(multiDimensionInfo.getString("controlstrategy"));
                staffMultiDimensionBo.setStaffElasticControl(multiDimensionInfo.getString("elasticcontrol"));
                staffMultiDimensionBo.setStaffElasticCount(Integer.valueOf(multiDimensionInfo.getInt("elasticcount")));
                this.setStaffCount(multiDimensionInfo, (StaffCountBo)staffMultiDimensionBo);
                if ("dutyworkrole".equals(keyFieldName)) {
                    staffUseOrgBo.getPositionDimensionBoList().add(staffMultiDimensionBo);
                } else if ("job".equals(keyFieldName)) {
                    staffUseOrgBo.getJobDimensionBoList().add(staffMultiDimensionBo);
                } else if ("laborreltype".equals(keyFieldName)) {
                    staffUseOrgBo.getLaborDimensionBoList().add(staffMultiDimensionBo);
                } else {
                    Map multiDimensionMap = staffUseOrgBo.getMultiDimensionMap();
                    List otherMultiDimensionList = multiDimensionMap.getOrDefault(dimensionId, new ArrayList());
                    otherMultiDimensionList.add(staffMultiDimensionBo);
                    multiDimensionMap.put(dimensionId, otherMultiDimensionList);
                }
            }
            return true;
        }
        return false;
    }

    private void setStaffControl(DynamicObject sourceDyn, String prefix, StaffControlBo staffControlBo) {
        staffControlBo.setStaffControlStrategy(sourceDyn.getString(prefix + "controlstrategy"));
        staffControlBo.setStaffElasticControl(sourceDyn.getString(prefix + "elasticcontrol"));
        staffControlBo.setStaffElasticCount(Integer.valueOf(sourceDyn.getInt(prefix + "elasticcount")));
    }

    private void setStaffCount(DynamicObject sourceDyn, StaffCountBo staffCountBo) {
        staffCountBo.setYearStaff((Integer)sourceDyn.get("yearstaff"));
        staffCountBo.setMonthStaff1((Integer)sourceDyn.get("monthstaff1"));
        staffCountBo.setMonthStaff2((Integer)sourceDyn.get("monthstaff2"));
        staffCountBo.setMonthStaff3((Integer)sourceDyn.get("monthstaff3"));
        staffCountBo.setMonthStaff4((Integer)sourceDyn.get("monthstaff4"));
        staffCountBo.setMonthStaff5((Integer)sourceDyn.get("monthstaff5"));
        staffCountBo.setMonthStaff6((Integer)sourceDyn.get("monthstaff6"));
        staffCountBo.setMonthStaff7((Integer)sourceDyn.get("monthstaff7"));
        staffCountBo.setMonthStaff8((Integer)sourceDyn.get("monthstaff8"));
        staffCountBo.setMonthStaff9((Integer)sourceDyn.get("monthstaff9"));
        staffCountBo.setMonthStaff10((Integer)sourceDyn.get("monthstaff10"));
        staffCountBo.setMonthStaff11((Integer)sourceDyn.get("monthstaff11"));
        staffCountBo.setMonthStaff12((Integer)sourceDyn.get("monthstaff12"));
    }

    @Override
    public HRMServiceResult validateStaff(StaffBo staffBoIn) {
        return this.validateAndCallOp(staffBoIn, "onlyValidate");
    }

    private String mustInputValidate(StaffBo staffBoIn, Long staffId) {
        List useOrgEntryBoList;
        StringBuilder msgSb = new StringBuilder();
        if (this.longIsNullOrZero(staffId)) {
            msgSb.append(ResManager.loadKDString((String)"staffid \u672a\u586b\u5199\uff1b", (String)"StaffExternalServiceImpl_2", (String)"hrmp-haos-mservice", (Object[])new Object[0]));
        }
        if (!CollectionUtils.isEmpty((Collection)(useOrgEntryBoList = staffBoIn.getUseOrgEntryBoList()))) {
            for (StaffUseOrgBo staffUseOrgBo : useOrgEntryBoList) {
                List laborDimensionBoList;
                List jobDimensionBoList;
                List positionDimensionBoList;
                Long adminOrgBoId = staffUseOrgBo.getAdminOrgBoId();
                if (this.longIsNullOrZero(adminOrgBoId)) {
                    msgSb.append(ResManager.loadKDString((String)"\u5b58\u5728\u4f7f\u7528\u7ec4\u7ec7adminOrgBoId\u672a\u586b\u5199\uff1b", (String)"StaffExternalServiceImpl_3", (String)"hrmp-haos-mservice", (Object[])new Object[0]));
                }
                if (!CollectionUtils.isEmpty((Collection)(positionDimensionBoList = staffUseOrgBo.getPositionDimensionBoList()))) {
                    for (StaffMultiDimensionBo positionDimensionBo : positionDimensionBoList) {
                        Long positionId = positionDimensionBo.getKeyFieldId();
                        if (!this.longIsNullOrZero(positionId)) continue;
                        msgSb.append(ResManager.loadKDString((String)"\u5b58\u5728\u5c97\u4f4d\u5206\u5f55keyFieldId\u672a\u586b\u5199\uff1b", (String)"StaffExternalServiceImpl_4", (String)"hrmp-haos-mservice", (Object[])new Object[0]));
                    }
                }
                if (!CollectionUtils.isEmpty((Collection)(jobDimensionBoList = staffUseOrgBo.getJobDimensionBoList()))) {
                    StaffMultiDimensionBo positionDimensionBo;
                    positionDimensionBo = jobDimensionBoList.iterator();
                    while (positionDimensionBo.hasNext()) {
                        StaffMultiDimensionBo jobDimensionBo = (StaffMultiDimensionBo)positionDimensionBo.next();
                        Long jobId = jobDimensionBo.getKeyFieldId();
                        if (!this.longIsNullOrZero(jobId)) continue;
                        msgSb.append(ResManager.loadKDString((String)"\u5b58\u5728\u804c\u4f4d\u5206\u5f55keyFieldId\u672a\u586b\u5199\uff1b", (String)"StaffExternalServiceImpl_5", (String)"hrmp-haos-mservice", (Object[])new Object[0]));
                    }
                }
                if (CollectionUtils.isEmpty((Collection)(laborDimensionBoList = staffUseOrgBo.getLaborDimensionBoList()))) continue;
                for (StaffMultiDimensionBo laborDimensionBo : laborDimensionBoList) {
                    Long laborId = laborDimensionBo.getKeyFieldId();
                    if (!this.longIsNullOrZero(laborId)) continue;
                    msgSb.append(ResManager.loadKDString((String)"\u5b58\u5728\u7528\u5de5\u5173\u7cfb\u7c7b\u578b\u5206\u5f55keyFieldId\u672a\u586b\u5199\uff1b", (String)"StaffExternalServiceImpl_6", (String)"hrmp-haos-mservice", (Object[])new Object[0]));
                }
            }
        }
        return msgSb.toString();
    }

    private String packageErrorMsg(OperationResult operationResult) {
        List errorMsgList = operationResult.getAllErrorOrValidateInfo().stream().map(IOperateInfo::getMessage).collect(Collectors.toList());
        StringBuilder sb = new StringBuilder();
        for (String errorMsg : errorMsgList) {
            sb.append(errorMsg).append(";");
        }
        return sb.toString();
    }

    private String beforeValidateInBoParameter(StaffBo staffBoIn, StaffBo staffBo, DynamicObject staffDyn) {
        StringBuilder errMsg = new StringBuilder();
        Map<String, StaffCountBo> groupIdVsBoMap = this.getGroupIdVsBoMap(staffBo);
        this.validateKeyFieldRange(staffBo, errMsg, groupIdVsBoMap);
        if (HRStringUtils.isNotEmpty((String)errMsg.toString())) {
            return errMsg.toString();
        }
        this.cantModify(errMsg, staffBoIn, staffDyn);
        this.baseDataValidate(errMsg, staffBoIn);
        this.baseDataEntryValidate(errMsg, staffBoIn, staffDyn);
        this.pastYearMonthValidate(staffBoIn, staffBo, errMsg, groupIdVsBoMap);
        this.yearStaffNumWithSubValidate(staffBoIn, errMsg);
        return errMsg.toString();
    }

    private void staffDimensionRangeValidate(StringBuilder errMsg, StaffCountBo staffDimensionBO) {
        Set<Long> staffDimensionIdSet = staffDimensionIdVsDynMap.keySet();
        if (this.validateStaffDimension((StaffDimensionBaseBo)staffDimensionBO, staffDimensionIdSet)) {
            errMsg.append(ResManager.loadKDString((String)"\u4e0d\u80fd\u586b\u5199\u53ef\u586b\u8303\u56f4\u5916\u7684\u7f16\u5236\u7ef4\u5ea6\uff1b", (String)"StaffExternalServiceImpl_7", (String)"hrmp-haos-mservice", (Object[])new Object[0]));
        }
    }

    private boolean validateStaffDimension(StaffDimensionBaseBo staffDimensionBaseBo, Set<Long> staffDimensionIdSet) {
        List staffDimensionIdList = staffDimensionBaseBo.getStaffDimensionIdList();
        if (CollectionUtils.isEmpty((Collection)staffDimensionIdList)) {
            return false;
        }
        for (Long staffDimensionId : staffDimensionIdList) {
            if (staffDimensionIdSet.contains(staffDimensionId)) continue;
            return true;
        }
        return false;
    }

    private void elasticControlRangeValidate(StringBuilder errMsg, StaffCountBo staffDimensionBO) {
        if (this.validateElasticControl((StaffControlBo)staffDimensionBO)) {
            errMsg.append(ResManager.loadKDString((String)"\u4e0d\u80fd\u586b\u5199\u53ef\u586b\u8303\u56f4\u5916\u7684\u5f39\u6027\u65b9\u5f0f\uff1b", (String)"StaffExternalServiceImpl_8", (String)"hrmp-haos-mservice", (Object[])new Object[0]));
        }
    }

    private void controlStrategyStringValidate(StringBuilder errMsg, StaffCountBo staffEntryBo) {
        if (this.validateStringControlStrategy((StaffControlBo)staffEntryBo)) {
            errMsg.append(ResManager.loadKDString((String)"\u63a7\u7f16\u65b9\u5f0f\u4e3a\u5f39\u6027\u65b9\u5f0f\u65f6\uff0c\u5f39\u6027\u65b9\u5f0f\u548c\u5f39\u6027\u989d\u5ea6\u5fc5\u586b\uff1b", (String)"StaffExternalServiceImpl_9", (String)"hrmp-haos-mservice", (Object[])new Object[0]));
        }
    }

    private boolean validateStringControlStrategy(StaffControlBo staffControlBo) {
        String staffControlStrategy = staffControlBo.getStaffControlStrategy();
        if (HRStringUtils.equals((String)staffControlStrategy, (String)"3")) {
            String staffElasticControl = staffControlBo.getStaffElasticControl();
            Integer staffElasticCount = staffControlBo.getStaffElasticCount();
            return HRStringUtils.isEmpty((String)staffElasticControl) || Objects.isNull(staffElasticCount);
        }
        return false;
    }

    private boolean validateElasticControl(StaffControlBo staffControlBo) {
        String staffControlStrategy = staffControlBo.getStaffControlStrategy();
        if (HRStringUtils.equals((String)staffControlStrategy, (String)"3")) {
            String staffElasticControl = staffControlBo.getStaffElasticControl();
            return HRStringUtils.isNotEmpty((String)staffElasticControl) && !this.ELASTIC_CONTROL_LIST.contains(staffElasticControl);
        }
        return false;
    }

    private void baseDataValidate(StringBuilder errMsg, StaffBo staffBoIn) {
        Set<Long> staffDimensionIdSet;
        String staffControlStrategy = staffBoIn.getStaffControlStrategy();
        if (HRStringUtils.isNotEmpty((String)staffControlStrategy) && !this.MULTI_CONTROL_STRATEGY_RANGE.contains(staffControlStrategy)) {
            errMsg.append(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f\u4e2d\u63a7\u7f16\u65b9\u5f0f\u586b\u5199\u7684\u503c\u8d85\u51fa\u53ef\u586b\u8303\u56f4\uff1b", (String)"StaffExternalServiceImpl_10", (String)"hrmp-haos-mservice", (Object[])new Object[0]));
        }
        if (this.validateElasticControl((StaffControlBo)staffBoIn)) {
            errMsg.append(ResManager.loadKDString((String)"\u4e0d\u80fd\u586b\u5199\u53ef\u586b\u8303\u56f4\u5916\u7684\u5f39\u6027\u65b9\u5f0f\uff1b", (String)"StaffExternalServiceImpl_8", (String)"hrmp-haos-mservice", (Object[])new Object[0]));
        }
        if (this.validateStaffDimension((StaffDimensionBaseBo)staffBoIn, staffDimensionIdSet = staffDimensionIdVsDynMap.keySet())) {
            errMsg.append(ResManager.loadKDString((String)"\u4e0d\u80fd\u586b\u5199\u53ef\u586b\u8303\u56f4\u5916\u7684\u7f16\u5236\u7ef4\u5ea6\uff1b", (String)"StaffExternalServiceImpl_7", (String)"hrmp-haos-mservice", (Object[])new Object[0]));
        }
        if (this.validateStringControlStrategy((StaffControlBo)staffBoIn)) {
            errMsg.append(ResManager.loadKDString((String)"\u63a7\u7f16\u65b9\u5f0f\u4e3a\u5f39\u6027\u65b9\u5f0f\u65f6\uff0c\u5f39\u6027\u65b9\u5f0f\u548c\u5f39\u6027\u989d\u5ea6\u5fc5\u586b\uff1b", (String)"StaffExternalServiceImpl_9", (String)"hrmp-haos-mservice", (Object[])new Object[0]));
        }
    }

    private void baseDataEntryValidate(StringBuilder errMsg, StaffBo staffBoIn, DynamicObject staffDyn) {
        List useOrgEntryBoList = staffBoIn.getUseOrgEntryBoList();
        for (StaffUseOrgBo staffUseOrgBo : useOrgEntryBoList) {
            this.controlStrategyRangeValidate(errMsg, (StaffCountBo)staffUseOrgBo);
            this.elasticControlRangeValidate(errMsg, (StaffCountBo)staffUseOrgBo);
            this.staffDimensionRangeValidate(errMsg, (StaffCountBo)staffUseOrgBo);
            this.controlStrategyStringValidate(errMsg, (StaffCountBo)staffUseOrgBo);
            this.staffCountValidate(errMsg, (StaffCountBo)staffUseOrgBo);
            List<StaffMultiDimensionBo> multiDimensionList = this.getAllMultiDimensionBos(staffUseOrgBo);
            for (StaffMultiDimensionBo multiDimension : multiDimensionList) {
                this.controlStrategyRangeValidate(errMsg, (StaffCountBo)multiDimension);
                this.elasticControlRangeValidate(errMsg, (StaffCountBo)multiDimension);
                this.staffDimensionRangeValidate(errMsg, (StaffCountBo)multiDimension);
                this.controlStrategyStringValidate(errMsg, (StaffCountBo)multiDimension);
            }
            List<StaffMultiDimensionBo> multiDimensionBosExcludePos = this.getMultiDimensionBosExcludePos(staffUseOrgBo);
            for (StaffMultiDimensionBo multiDimension : multiDimensionBosExcludePos) {
                this.multiEntryDeleteValidate(errMsg, multiDimension, staffDyn);
            }
        }
    }

    private List<StaffMultiDimensionBo> getAllMultiDimensionBos(StaffUseOrgBo staffUseOrgBo) {
        ArrayList multiDimensionList = Lists.newArrayListWithExpectedSize((int)16);
        multiDimensionList.addAll(staffUseOrgBo.getPositionDimensionBoList());
        multiDimensionList.addAll(this.getMultiDimensionBosExcludePos(staffUseOrgBo));
        return multiDimensionList;
    }

    private List<StaffMultiDimensionBo> getMultiDimensionBosExcludePos(StaffUseOrgBo staffUseOrgBo) {
        ArrayList multiDimensionList = Lists.newArrayListWithExpectedSize((int)16);
        multiDimensionList.addAll(staffUseOrgBo.getJobDimensionBoList());
        multiDimensionList.addAll(staffUseOrgBo.getLaborDimensionBoList());
        Map otherMultiDimensionMap = staffUseOrgBo.getMultiDimensionMap();
        otherMultiDimensionMap.forEach((dimensionId, otherStaffMultiDimensionBO) -> multiDimensionList.addAll(otherStaffMultiDimensionBO));
        return multiDimensionList;
    }

    private void controlStrategyRangeValidate(StringBuilder errMsg, StaffCountBo staffDimensionBO) {
        List<String> controlStrategyRange;
        String staffControlStrategy = staffDimensionBO.getStaffControlStrategy();
        List<String> list = controlStrategyRange = staffDimensionBO instanceof StaffUseOrgBo ? this.CONTROL_STRATEGY_RANGE : this.MULTI_CONTROL_STRATEGY_RANGE;
        if (HRStringUtils.isNotEmpty((String)staffControlStrategy) && !controlStrategyRange.contains(staffControlStrategy)) {
            if (staffDimensionBO instanceof StaffUseOrgBo) {
                errMsg.append(ResManager.loadKDString((String)"\u4f7f\u7528\u7ec4\u7ec7\u4e2d\u7684\u63a7\u7f16\u65b9\u5f0f\u586b\u5199\u7684\u503c\u8d85\u51fa\u53ef\u586b\u8303\u56f4\uff1b", (String)"StaffExternalServiceImpl_31", (String)"hrmp-haos-mservice", (Object[])new Object[0]));
            } else {
                errMsg.append(ResManager.loadKDString((String)"\u591a\u7ef4\u5206\u5f55\u4e2d\u7684\u63a7\u7f16\u65b9\u5f0f\u586b\u5199\u7684\u503c\u8d85\u51fa\u53ef\u586b\u8303\u56f4\uff1b", (String)"StaffExternalServiceImpl_32", (String)"hrmp-haos-mservice", (Object[])new Object[0]));
            }
        }
    }

    private void staffCountValidate(StringBuilder errMsg, StaffCountBo staffEntryBo) {
        for (int i = 1; i < 13; ++i) {
            Integer count = this.monthVsGetStaffMap.get(i).apply(staffEntryBo);
            if (this.validateIntegerRange(count)) continue;
            errMsg.append(ResManager.loadKDString((String)"\u7f16\u5236\u6570\u8303\u56f4\u4e3a[0, 100000000],\u8bf7\u4fee\u6539\uff1b", (String)"StaffExternalServiceImpl_11", (String)"hrmp-haos-mservice", (Object[])new Object[0]));
            return;
        }
    }

    private boolean validateIntegerRange(Integer count) {
        return count == null || count <= 100000000 && count >= -1;
    }

    private void multiEntryDeleteValidate(StringBuilder errMsg, StaffMultiDimensionBo multiDimension, DynamicObject staffDyn) {
        String enable = staffDyn.getString("enable");
        if (HRStringUtils.equals((String)enable, (String)"10")) {
            return;
        }
        String changeType = multiDimension.getChangeType();
        if (HRStringUtils.equals((String)changeType, (String)"2")) {
            errMsg.append(String.format(ResManager.loadKDString((String)"\u5df2%s\u7684\u7f16\u5236\u4fe1\u606f\u4e0d\u5141\u8bb8\u5220\u9664\u591a\u7ef4\u5206\u5f55\uff1b", (String)"StaffExternalServiceImpl_12", (String)"hrmp-haos-mservice", (Object[])new Object[0]), enableVsNameMap.get(enable)));
        }
    }

    private void yearStaffNumWithSubValidate(StaffBo staffBoIn, StringBuilder errMsg) {
        Map<Long, StaffUseOrgBo> adminOrgBoIdVsBoMap = staffBoIn.getUseOrgEntryBoList().stream().collect(Collectors.toMap(StaffUseOrgBo::getAdminOrgBoId, bo -> bo));
        for (StaffUseOrgBo inUseOrgEntryBo : staffBoIn.getUseOrgEntryBoList()) {
            Long adminOrgBoId = inUseOrgEntryBo.getAdminOrgBoId();
            StaffUseOrgBo useOrgEntryBo = adminOrgBoIdVsBoMap.get(adminOrgBoId);
            Boolean hasSub = useOrgEntryBo.getHasSub();
            Integer yearStaffNumWithSub = inUseOrgEntryBo.getYearStaffNumWithSub();
            if (hasSub.booleanValue() || yearStaffNumWithSub == null || !yearStaffNumWithSub.equals(useOrgEntryBo.getYearStaffNumWithSub())) continue;
            errMsg.append(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u6ca1\u6709\u4e0b\u7ea7\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u5e74\u5ea6\u7f16\u5236\u603b\u989d\uff1b", (String)"StaffExternalServiceImpl_13", (String)"hrmp-haos-mservice", (Object[])new Object[0]));
        }
    }

    private void validateKeyFieldRange(StaffBo staffBo, StringBuilder errMsg, Map<String, StaffCountBo> groupIdVsBoMap) {
        List useOrgEntryBoList = staffBo.getUseOrgEntryBoList();
        for (StaffUseOrgBo useOrgEntryBo : useOrgEntryBoList) {
            Object positionDimensionBo2;
            Long adminOrgBoId = useOrgEntryBo.getAdminOrgBoId();
            if (Objects.isNull(groupIdVsBoMap.get("" + adminOrgBoId))) {
                errMsg.append(String.format(ResManager.loadKDString((String)"\u7f16\u5236\u4fe1\u606f\u5185\u4e0d\u5b58\u5728adminOrgBoId\u4e3a[%s]\u7684\u7ec4\u7ec7\uff1b", (String)"StaffExternalServiceImpl_14", (String)"hrmp-haos-mservice", (Object[])new Object[0]), adminOrgBoId));
            }
            List positionDimensionBoList = useOrgEntryBo.getPositionDimensionBoList();
            for (Object positionDimensionBo2 : positionDimensionBoList) {
                String groupId = "" + adminOrgBoId + positionDimensionBo2.getKeyFieldId();
                if (!Objects.isNull(groupIdVsBoMap.get(groupId))) continue;
                errMsg.append(String.format(ResManager.loadKDString((String)"\u7f16\u5236\u4fe1\u606f\u5185\u4e0d\u5b58\u5728keyfieldId\u4e3a[%s]\u7684\u5c97\u4f4d\uff1b", (String)"StaffExternalServiceImpl_15", (String)"hrmp-haos-mservice", (Object[])new Object[0]), positionDimensionBo2.getKeyFieldId()));
            }
            List jobDimensionBoList = useOrgEntryBo.getJobDimensionBoList();
            positionDimensionBo2 = jobDimensionBoList.iterator();
            while (positionDimensionBo2.hasNext()) {
                StaffMultiDimensionBo jobDimensionBo = (StaffMultiDimensionBo)positionDimensionBo2.next();
                String groupId = "" + adminOrgBoId + jobDimensionBo.getKeyFieldId();
                if (!HRStringUtils.equals((String)jobDimensionBo.getChangeType(), (String)"1") || !Objects.isNull(groupIdVsBoMap.get(groupId))) continue;
                errMsg.append(String.format(ResManager.loadKDString((String)"\u7f16\u5236\u4fe1\u606f\u5185\u4e0d\u5b58\u5728keyfieldId\u4e3a[%s]\u7684\u804c\u4f4d\uff1b", (String)"StaffExternalServiceImpl_16", (String)"hrmp-haos-mservice", (Object[])new Object[0]), jobDimensionBo.getKeyFieldId()));
            }
            List laborDimensionBoList = useOrgEntryBo.getLaborDimensionBoList();
            for (StaffMultiDimensionBo laborDimensionBo : laborDimensionBoList) {
                String groupId = "" + adminOrgBoId + laborDimensionBo.getKeyFieldId();
                if (!HRStringUtils.equals((String)laborDimensionBo.getChangeType(), (String)"1") || !Objects.isNull(groupIdVsBoMap.get(groupId))) continue;
                errMsg.append(String.format(ResManager.loadKDString((String)"\u7f16\u5236\u4fe1\u606f\u5185\u4e0d\u5b58\u5728keyfieldId\u4e3a[%s]\u7684\u7528\u5de5\u5173\u7cfb\u7c7b\u578b\uff1b", (String)"StaffExternalServiceImpl_17", (String)"hrmp-haos-mservice", (Object[])new Object[0]), laborDimensionBo.getKeyFieldId()));
            }
        }
    }

    private void unityStaffDimensionValidate(StaffBo staffBoIn, StaffBo staffBo, StringBuilder errMsg, DynamicObject staffProjectDyn) {
        boolean unityStaffDimension = staffProjectDyn.getBoolean("unitystaffdimension");
        if (unityStaffDimension) {
            this.validateSameDimension((StaffDimensionBaseBo)staffBoIn, (StaffDimensionBaseBo)staffBo, errMsg);
            List useOrgEntryBoList = staffBo.getUseOrgEntryBoList();
            Map<Long, StaffUseOrgBo> adminOrgBoIdVsBoMap = useOrgEntryBoList.stream().collect(Collectors.toMap(bo -> bo.getAdminOrgBoId(), bo -> bo));
            List inUseOrgEntryBoList = staffBoIn.getUseOrgEntryBoList();
            for (StaffUseOrgBo inStaffUseOrgBo : inUseOrgEntryBoList) {
                Long adminOrgBoId = inStaffUseOrgBo.getAdminOrgBoId();
                StaffUseOrgBo staffUseOrgBo = adminOrgBoIdVsBoMap.get(adminOrgBoId);
                if (Objects.isNull(staffUseOrgBo)) continue;
                this.validateSameDimension((StaffDimensionBaseBo)inStaffUseOrgBo, (StaffDimensionBaseBo)staffUseOrgBo, errMsg);
            }
        }
    }

    private void unityControlModeValidate(StaffBo staffBoIn, StaffBo staffBo, StringBuilder errMsg, DynamicObject staffProjectDyn) {
        boolean unityControlMode = staffProjectDyn.getBoolean("unitycontrolmode");
        if (unityControlMode) {
            this.validateSameStaffControl((StaffControlBo)staffBoIn, (StaffControlBo)staffBo, errMsg);
            List inUseOrgEntryBoList = staffBoIn.getUseOrgEntryBoList();
            List useOrgEntryBoList = staffBo.getUseOrgEntryBoList();
            Map<Long, StaffUseOrgBo> adminOrgBoIdVsBoMap = useOrgEntryBoList.stream().collect(Collectors.toMap(StaffUseOrgBo::getAdminOrgBoId, bo -> bo));
            for (StaffUseOrgBo inStaffUseOrgBo : inUseOrgEntryBoList) {
                Long adminOrgBoId = inStaffUseOrgBo.getAdminOrgBoId();
                StaffUseOrgBo staffUseOrgBo = adminOrgBoIdVsBoMap.get(adminOrgBoId);
                if (Objects.isNull(staffUseOrgBo)) continue;
                this.validateSameStaffControl((StaffControlBo)inStaffUseOrgBo, (StaffControlBo)staffUseOrgBo, errMsg);
                List positionDimensionBoList = staffUseOrgBo.getPositionDimensionBoList();
                Map<Long, StaffMultiDimensionBo> positionIdVsBoMap = positionDimensionBoList.stream().collect(Collectors.toMap(StaffMultiDimensionBo::getKeyFieldId, bo -> bo));
                List inPositionDimensionBoList = inStaffUseOrgBo.getPositionDimensionBoList();
                for (StaffMultiDimensionBo inPositionDimensionBo : inPositionDimensionBoList) {
                    Long positionId = inPositionDimensionBo.getKeyFieldId();
                    StaffMultiDimensionBo positionDimensionBo = positionIdVsBoMap.get(positionId);
                    this.validateSameStaffControl((StaffControlBo)inPositionDimensionBo, (StaffControlBo)positionDimensionBo, errMsg);
                }
                List jobDimensionBoList = staffUseOrgBo.getJobDimensionBoList();
                Map<Long, StaffMultiDimensionBo> jobIdVsBoMap = jobDimensionBoList.stream().collect(Collectors.toMap(StaffMultiDimensionBo::getKeyFieldId, bo -> bo));
                List inJobDimensionBoList = inStaffUseOrgBo.getJobDimensionBoList();
                for (StaffMultiDimensionBo inJobDimensionBo : inJobDimensionBoList) {
                    Long jobId = inJobDimensionBo.getKeyFieldId();
                    StaffMultiDimensionBo jobDimensionBo = jobIdVsBoMap.get(jobId);
                    if (!Objects.nonNull(jobDimensionBo)) continue;
                    this.validateSameStaffControl((StaffControlBo)inJobDimensionBo, (StaffControlBo)jobDimensionBo, errMsg);
                }
                List laborDimensionBoList = staffUseOrgBo.getLaborDimensionBoList();
                Map<Long, StaffMultiDimensionBo> laborIdVsBoMap = laborDimensionBoList.stream().collect(Collectors.toMap(StaffMultiDimensionBo::getKeyFieldId, bo -> bo));
                List inLaborDimensionBoList = inStaffUseOrgBo.getLaborDimensionBoList();
                for (StaffMultiDimensionBo inLaborDimensionBo : inLaborDimensionBoList) {
                    Long laborId = inLaborDimensionBo.getKeyFieldId();
                    StaffMultiDimensionBo laborDimensionBo = laborIdVsBoMap.get(laborId);
                    if (!Objects.nonNull(laborDimensionBo)) continue;
                    this.validateSameStaffControl((StaffControlBo)inLaborDimensionBo, (StaffControlBo)laborDimensionBo, errMsg);
                }
            }
        }
    }

    private Map<String, StaffCountBo> getGroupIdVsBoMap(StaffBo staffBo) {
        List useOrgEntryBoList = staffBo.getUseOrgEntryBoList();
        Map<String, StaffCountBo> groupIdVsBoMap = useOrgEntryBoList.stream().collect(Collectors.toMap(bo -> "" + bo.getAdminOrgBoId(), bo -> bo));
        for (StaffUseOrgBo staffUseOrgBo : useOrgEntryBoList) {
            List<StaffMultiDimensionBo> multiDimensionList = this.getAllMultiDimensionBos(staffUseOrgBo);
            multiDimensionList.forEach(bo -> {
                StaffCountBo cfr_ignored_0 = (StaffCountBo)groupIdVsBoMap.put("" + staffUseOrgBo.getAdminOrgBoId() + bo.getKeyFieldId(), (StaffCountBo)bo);
            });
        }
        return groupIdVsBoMap;
    }

    private void pastYearMonthValidate(StaffBo staffBoIn, StaffBo staffBo, StringBuilder errMsg, Map<String, StaffCountBo> groupIdVsBoMap) {
        block8: {
            int curYear;
            int year;
            Date date;
            Long staffCycleId;
            block9: {
                Long orgId = staffBo.getOrgId();
                Boolean enableModify = SystemParamHelper.getStaffPastMonthModifyParameter((Long)orgId);
                String enable = staffBo.getEnable();
                if (enableModify.booleanValue() || HRStringUtils.equals((String)enable, (String)"10")) break block8;
                staffCycleId = staffBo.getStaffCycleId();
                Date yearFromDyn = staffBo.getYear();
                date = new Date();
                year = HRDateTimeUtils.getYear((Date)yearFromDyn);
                curYear = HRDateTimeUtils.getYear((Date)date);
                if (!staffCycleId.equals(STAFF_CYCLE_YEAR)) break block9;
                if (year >= curYear) break block8;
                List inUseOrgEntryBoList = staffBoIn.getUseOrgEntryBoList();
                for (StaffUseOrgBo inUseOrgEntryBo : inUseOrgEntryBoList) {
                    Integer inYearStaff = this.monthVsGetStaffMap.get(YEAR_STAFF_COUNT).apply((StaffCountBo)inUseOrgEntryBo);
                    Long adminOrgBoId = inUseOrgEntryBo.getAdminOrgBoId();
                    StaffCountBo staffCountBo = groupIdVsBoMap.get("" + adminOrgBoId);
                    if (Objects.isNull(staffCountBo)) continue;
                    Integer yearStaff = this.monthVsGetStaffMap.get(YEAR_STAFF_COUNT).apply(staffCountBo);
                    if (inYearStaff != null && !inYearStaff.equals(yearStaff)) {
                        errMsg.append(ResManager.loadKDString((String)"\u4e0d\u80fd\u4fee\u6539\u8fc7\u5f80\u5e74\u4efd\u7f16\u5236\u6570\uff1b", (String)"StaffExternalServiceImpl_18", (String)"hrmp-haos-mservice", (Object[])new Object[0]));
                    }
                    List<StaffMultiDimensionBo> allMultiDimensionBos = this.getAllMultiDimensionBos(inUseOrgEntryBo);
                    this.pastYearValidateForMul(errMsg, groupIdVsBoMap, allMultiDimensionBos, YEAR_STAFF_COUNT, staffCycleId);
                }
                break block8;
            }
            int validateMonthRange = 0;
            if (year < curYear) {
                validateMonthRange = 12;
            } else if (year == curYear) {
                validateMonthRange = HRDateTimeUtils.getMonth((Date)date);
            }
            for (int i = 1; i < validateMonthRange; ++i) {
                List inUseOrgEntryBoList = staffBoIn.getUseOrgEntryBoList();
                for (StaffUseOrgBo inStaffUseOrgBo : inUseOrgEntryBoList) {
                    Integer inMonthStaff = this.monthVsGetStaffMap.get(i).apply((StaffCountBo)inStaffUseOrgBo);
                    Long adminOrgBoId = inStaffUseOrgBo.getAdminOrgBoId();
                    StaffCountBo staffCountBo = groupIdVsBoMap.get("" + adminOrgBoId);
                    if (Objects.isNull(staffCountBo)) continue;
                    Integer monthStaff = this.monthVsGetStaffMap.get(i).apply(staffCountBo);
                    if (inMonthStaff != null && !inMonthStaff.equals(monthStaff)) {
                        errMsg.append(ResManager.loadKDString((String)"\u4e0d\u80fd\u4fee\u6539\u8fc7\u5f80\u6708\u4efd\u7f16\u5236\u6570\uff1b", (String)"StaffExternalServiceImpl_19", (String)"hrmp-haos-mservice", (Object[])new Object[0]));
                    }
                    List<StaffMultiDimensionBo> allMultiDimensionBos = this.getAllMultiDimensionBos(inStaffUseOrgBo);
                    this.pastYearValidateForMul(errMsg, groupIdVsBoMap, allMultiDimensionBos, i, staffCycleId);
                }
            }
        }
    }

    private void pastYearValidateForMul(StringBuilder errMsg, Map<String, StaffCountBo> groupIdVsBoMap, List<StaffMultiDimensionBo> multiDimensionBoList, int month, Long staffCycleId) {
        for (StaffMultiDimensionBo multiDimensionBo : multiDimensionBoList) {
            String groupId = "" + multiDimensionBo.getAdminOrgBoId() + multiDimensionBo.getKeyFieldId();
            Integer inMultiMonthStaff = this.monthVsGetStaffMap.get(month).apply((StaffCountBo)multiDimensionBo);
            if (Objects.isNull(groupIdVsBoMap.get(groupId))) {
                if (inMultiMonthStaff == null) continue;
                if (staffCycleId.equals(STAFF_CYCLE_YEAR)) {
                    errMsg.append(ResManager.loadKDString((String)"\u4e0d\u80fd\u4fee\u6539\u8fc7\u5f80\u5e74\u4efd\u7f16\u5236\u6570\uff1b", (String)"StaffExternalServiceImpl_18", (String)"hrmp-haos-mservice", (Object[])new Object[0]));
                    continue;
                }
                errMsg.append(ResManager.loadKDString((String)"\u4e0d\u80fd\u4fee\u6539\u8fc7\u5f80\u6708\u4efd\u7f16\u5236\u6570\uff1b", (String)"StaffExternalServiceImpl_19", (String)"hrmp-haos-mservice", (Object[])new Object[0]));
                continue;
            }
            Integer multiMonthStaff = this.monthVsGetStaffMap.get(month).apply(groupIdVsBoMap.get(groupId));
            if (inMultiMonthStaff == null || inMultiMonthStaff.equals(multiMonthStaff)) continue;
            if (staffCycleId.equals(STAFF_CYCLE_YEAR)) {
                errMsg.append(ResManager.loadKDString((String)"\u4e0d\u80fd\u4fee\u6539\u8fc7\u5f80\u5e74\u4efd\u7f16\u5236\u6570\uff1b", (String)"StaffExternalServiceImpl_18", (String)"hrmp-haos-mservice", (Object[])new Object[0]));
                continue;
            }
            errMsg.append(ResManager.loadKDString((String)"\u4e0d\u80fd\u4fee\u6539\u8fc7\u5f80\u6708\u4efd\u7f16\u5236\u6570\uff1b", (String)"StaffExternalServiceImpl_19", (String)"hrmp-haos-mservice", (Object[])new Object[0]));
        }
    }

    private void validateSameStaffControl(StaffControlBo staffBoIn, StaffControlBo staffBo, StringBuilder errMsg) {
        String inStaffControlStrategy = staffBoIn.getStaffControlStrategy();
        String staffControlStrategy = staffBo.getStaffControlStrategy();
        if (HRStringUtils.isNotEmpty((String)inStaffControlStrategy) && !HRStringUtils.equals((String)inStaffControlStrategy, (String)staffControlStrategy)) {
            errMsg.append(ResManager.loadKDString((String)"\u7edf\u4e00\u63a7\u7f16\u65b9\u5f0f\u65f6\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u63a7\u7f16\u65b9\u5f0f\uff1b", (String)"StaffExternalServiceImpl_20", (String)"hrmp-haos-mservice", (Object[])new Object[0]));
        }
        String inStaffElasticControl = staffBoIn.getStaffElasticControl();
        String staffElasticControl = staffBo.getStaffControlStrategy();
        if (HRStringUtils.isNotEmpty((String)inStaffElasticControl) && !HRStringUtils.equals((String)inStaffElasticControl, (String)staffElasticControl)) {
            errMsg.append(ResManager.loadKDString((String)"\u7edf\u4e00\u63a7\u7f16\u65b9\u5f0f\u65f6\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u5f39\u6027\u65b9\u5f0f\uff1b", (String)"StaffExternalServiceImpl_21", (String)"hrmp-haos-mservice", (Object[])new Object[0]));
        }
        Integer inStaffElasticCount = staffBoIn.getStaffElasticCount();
        Integer staffElasticCount = staffBo.getStaffElasticCount();
        if (inStaffElasticCount != null && !inStaffElasticCount.equals(staffElasticCount)) {
            errMsg.append(ResManager.loadKDString((String)"\u7edf\u4e00\u63a7\u7f16\u65b9\u5f0f\u65f6\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u5f39\u6027\u989d\u5ea6\uff1b", (String)"StaffExternalServiceImpl_22", (String)"hrmp-haos-mservice", (Object[])new Object[0]));
        }
    }

    private void validateSameDimension(StaffDimensionBaseBo staffBoIn, StaffDimensionBaseBo staffBo, StringBuilder errMsg) {
        List inStaffDimensionIdList = staffBoIn.getStaffDimensionIdList();
        if (Objects.isNull(inStaffDimensionIdList)) {
            return;
        }
        List staffIdDimensionIdList = staffBo.getStaffDimensionIdList();
        if (inStaffDimensionIdList.size() != staffIdDimensionIdList.size() || !inStaffDimensionIdList.containsAll(staffIdDimensionIdList)) {
            errMsg.append(ResManager.loadKDString((String)"\u7edf\u4e00\u7f16\u5236\u7ef4\u5ea6\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u7f16\u5236\u7ef4\u5ea6\uff1b", (String)"StaffExternalServiceImpl_23", (String)"hrmp-haos-mservice", (Object[])new Object[0]));
        }
    }

    private void cantModify(StringBuilder errMsg, StaffBo staffBoIn, DynamicObject staffDyn) {
        Long inStaffCycleId;
        String enable;
        Date yearIn;
        Long inStaffProjectId;
        Long inOrgId;
        StringBuilder fieldSb = new StringBuilder();
        String inNumber = staffBoIn.getNumber();
        if (HRStringUtils.isNotEmpty((String)inNumber) && !HRStringUtils.equals((String)inNumber, (String)staffDyn.getString("number"))) {
            fieldSb.append(ResManager.loadKDString((String)"\u7f16\u7801\u3001", (String)"StaffExternalServiceImpl_24", (String)"hrmp-haos-mservice", (Object[])new Object[0]));
        }
        if ((inOrgId = staffBoIn.getOrgId()) != null && !inOrgId.equals(staffDyn.getLong("org.id"))) {
            fieldSb.append(ResManager.loadKDString((String)"\u4e3b\u7ba1\u8d23\u4efb\u3001", (String)"StaffExternalServiceImpl_25", (String)"hrmp-haos-mservice", (Object[])new Object[0]));
        }
        if ((inStaffProjectId = staffBoIn.getStaffProjectId()) != null && !inStaffProjectId.equals(staffDyn.getLong("staffproject.id"))) {
            fieldSb.append(ResManager.loadKDString((String)"\u63a7\u7f16\u89c4\u5219\u3001", (String)"StaffExternalServiceImpl_26", (String)"hrmp-haos-mservice", (Object[])new Object[0]));
        }
        if (Objects.nonNull(yearIn = staffBoIn.getYear()) && HRDateTimeUtils.truncateDate((Date)staffDyn.getDate("year")) == HRDateTimeUtils.truncateDate((Date)yearIn)) {
            fieldSb.append(ResManager.loadKDString((String)"\u7f16\u5236\u5e74\u4efd\u3001", (String)"StaffExternalServiceImpl_27", (String)"hrmp-haos-mservice", (Object[])new Object[0]));
        }
        if (HRStringUtils.equals((String)(enable = staffDyn.getString("enable")), (String)"1") && (inStaffCycleId = staffBoIn.getStaffCycleId()) != null && !inStaffCycleId.equals(staffDyn.getLong("staffcycle.id"))) {
            fieldSb.append(ResManager.loadKDString((String)"\u586b\u62a5\u671f\u95f4\u3001", (String)"StaffExternalServiceImpl_28", (String)"hrmp-haos-mservice", (Object[])new Object[0]));
        }
        if (HRStringUtils.isNotEmpty((String)fieldSb.toString())) {
            errMsg.append(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e0d\u5141\u8bb8\u4fee\u6539\uff1b", (String)"StaffExternalServiceImpl_29", (String)"hrmp-haos-mservice", (Object[])new Object[0]), fieldSb.substring(0, fieldSb.length() - 1)));
        }
    }

    private void coverBoData(StaffBo staffBo, StaffBo staffBoIn) {
        if (HRStringUtils.isNotEmpty((String)staffBoIn.getName())) {
            staffBo.setName(staffBoIn.getName());
        }
        if (!this.longIsNullOrZero(staffBoIn.getStaffCycleId())) {
            staffBo.setStaffCycleId(staffBoIn.getStaffCycleId());
        }
        this.coverStaffDimension((StaffDimensionBaseBo)staffBo, (StaffDimensionBaseBo)staffBoIn);
        this.coverStaffControl((StaffControlBo)staffBo, (StaffControlBo)staffBoIn);
        List useOrgEntryBoList = staffBo.getUseOrgEntryBoList();
        Map<Long, StaffUseOrgBo> adminOrgIdVsBoList = staffBoIn.getUseOrgEntryBoList().stream().collect(Collectors.toMap(StaffUseOrgBo::getAdminOrgBoId, bo -> bo));
        for (StaffUseOrgBo staffUseOrgBo : useOrgEntryBoList) {
            Long adminOrgBoId = staffUseOrgBo.getAdminOrgBoId();
            StaffUseOrgBo staffUseOrgBoForIn = adminOrgIdVsBoList.get(adminOrgBoId);
            if (Objects.isNull(staffUseOrgBoForIn)) continue;
            this.coverStaffDimension((StaffDimensionBaseBo)staffUseOrgBo, (StaffDimensionBaseBo)staffUseOrgBoForIn);
            this.coverStaffControl((StaffControlBo)staffUseOrgBo, (StaffControlBo)staffUseOrgBoForIn);
            if (Objects.nonNull(staffUseOrgBoForIn.getYearStaffNumWithSub())) {
                staffUseOrgBo.setYearStaffNumWithSub(staffUseOrgBoForIn.getYearStaffNumWithSub());
            }
            this.coverStaffCount((StaffCountBo)staffUseOrgBo, (StaffCountBo)staffUseOrgBoForIn);
            String staffControlStrategy = staffUseOrgBoForIn.getStaffControlStrategy();
            if (HRStringUtils.equals((String)staffControlStrategy, (String)"4")) {
                staffUseOrgBo.getPositionDimensionBoList().clear();
                staffUseOrgBo.getJobDimensionBoList().clear();
                staffUseOrgBo.getLaborDimensionBoList().clear();
                staffUseOrgBo.getMultiDimensionMap().clear();
                continue;
            }
            Map<String, StaffMultiDimensionBo> groupKeyVsPositionDimensionBoMap = staffUseOrgBo.getPositionDimensionBoList().stream().collect(Collectors.toMap(bo -> "" + bo.getAdminOrgBoId() + bo.getKeyFieldId(), bo -> bo));
            List positionDimensionBoForInList = staffUseOrgBoForIn.getPositionDimensionBoList();
            for (StaffMultiDimensionBo positionDimensionBoForIn : positionDimensionBoForInList) {
                Long keyFieldIdForIn = positionDimensionBoForIn.getKeyFieldId();
                StaffMultiDimensionBo positionDimensionBo = groupKeyVsPositionDimensionBoMap.get("" + adminOrgBoId + keyFieldIdForIn);
                if (Objects.isNull(positionDimensionBo)) continue;
                this.coverStaffControl((StaffControlBo)positionDimensionBo, (StaffControlBo)positionDimensionBoForIn);
                this.coverStaffCount((StaffCountBo)positionDimensionBo, (StaffCountBo)positionDimensionBoForIn);
            }
            List<StaffMultiDimensionBo> multiDimensionBosExcludePos = this.getMultiDimensionBosExcludePos(staffUseOrgBo);
            Map<String, StaffMultiDimensionBo> groupKeyVsDimensionBoMap = multiDimensionBosExcludePos.stream().collect(Collectors.toMap(bo -> "" + bo.getAdminOrgBoId() + bo.getKeyFieldId(), bo -> bo));
            List<StaffMultiDimensionBo> multiDimensionBosExcludePosForIn = this.getMultiDimensionBosExcludePos(staffUseOrgBoForIn);
            this.coverMultiDimensionBo(staffUseOrgBo, multiDimensionBosExcludePos, groupKeyVsDimensionBoMap, multiDimensionBosExcludePosForIn);
        }
        this.synPositionDimension(useOrgEntryBoList);
    }

    private void coverMultiDimensionBo(StaffUseOrgBo staffUseOrgBo, List<StaffMultiDimensionBo> multiDimensionBoList, Map<String, StaffMultiDimensionBo> groupKeyVsLaborDimensionBoMap, List<StaffMultiDimensionBo> multiDimensionBoForInList) {
        for (StaffMultiDimensionBo multiDimensionBoForIn : multiDimensionBoForInList) {
            String changeType = multiDimensionBoForIn.getChangeType();
            if (HRStringUtils.equals((String)changeType, (String)"2")) {
                multiDimensionBoList.removeIf(bo -> bo.getKeyFieldId().equals(multiDimensionBoForIn.getKeyFieldId()));
            }
            Long keyFieldIdForIn = multiDimensionBoForIn.getKeyFieldId();
            StaffMultiDimensionBo laborDimensionBo = groupKeyVsLaborDimensionBoMap.get("" + multiDimensionBoForIn.getAdminOrgBoId() + keyFieldIdForIn);
            if (Objects.isNull(laborDimensionBo)) {
                Long dimensionIdIn;
                if (this.longIsNullOrZero(multiDimensionBoForIn.getEntryId())) {
                    multiDimensionBoForIn.setEntryId(Long.valueOf(idCreator.getId()));
                }
                if (HRStringUtils.isEmpty((String)multiDimensionBoForIn.getStaffControlStrategy())) {
                    multiDimensionBoForIn.setStaffControlStrategy(staffUseOrgBo.getStaffControlStrategy());
                }
                if (HRStringUtils.isEmpty((String)multiDimensionBoForIn.getStaffElasticControl())) {
                    multiDimensionBoForIn.setStaffElasticControl(staffUseOrgBo.getStaffElasticControl());
                }
                if (multiDimensionBoForIn.getStaffElasticCount() != null && !multiDimensionBoForIn.getStaffElasticCount().equals(0)) {
                    multiDimensionBoForIn.setStaffElasticCount(staffUseOrgBo.getStaffElasticCount());
                }
                if (1020L == (dimensionIdIn = multiDimensionBoForIn.getDimensionId())) {
                    staffUseOrgBo.getJobDimensionBoList().add(multiDimensionBoForIn);
                    continue;
                }
                if (1050L == dimensionIdIn) {
                    staffUseOrgBo.getLaborDimensionBoList().add(multiDimensionBoForIn);
                    continue;
                }
                List multiDimensionBOList = staffUseOrgBo.getMultiDimensionMap().getOrDefault(dimensionIdIn, new ArrayList());
                multiDimensionBOList.add(multiDimensionBoForIn);
                staffUseOrgBo.getMultiDimensionMap().put(dimensionIdIn, multiDimensionBOList);
                continue;
            }
            if (this.longIsNullOrZero(multiDimensionBoForIn.getEntryId())) {
                multiDimensionBoForIn.setEntryId(Long.valueOf(idCreator.getId()));
            }
            laborDimensionBo.setChangeType(multiDimensionBoForIn.getChangeType());
            this.coverStaffControl((StaffControlBo)laborDimensionBo, (StaffControlBo)multiDimensionBoForIn);
            this.coverStaffCount((StaffCountBo)laborDimensionBo, (StaffCountBo)multiDimensionBoForIn);
        }
    }

    private void coverStaffControl(StaffControlBo staffBo, StaffControlBo staffBoIn) {
        if (HRStringUtils.isNotEmpty((String)staffBoIn.getStaffControlStrategy())) {
            staffBo.setStaffControlStrategy(staffBoIn.getStaffControlStrategy());
        }
        if (HRStringUtils.isNotEmpty((String)staffBoIn.getStaffElasticControl())) {
            staffBo.setStaffElasticControl(staffBoIn.getStaffElasticControl());
        }
        if (Objects.nonNull(staffBoIn.getStaffElasticCount())) {
            staffBo.setStaffElasticCount(staffBoIn.getStaffElasticCount());
        }
    }

    private void coverStaffControlForDyn(DynamicObject dyn, String prefix, StaffControlBo staffBo) {
        String staffControlStrategy = staffBo.getStaffControlStrategy();
        if (HRStringUtils.isNotEmpty((String)staffControlStrategy)) {
            dyn.set(prefix + "controlstrategy", (Object)staffBo.getStaffControlStrategy());
            if (HRStringUtils.equals((String)staffControlStrategy, (String)"3")) {
                dyn.set(prefix + "elasticcontrol", (Object)staffBo.getStaffElasticControl());
                dyn.set(prefix + "elasticcount", (Object)staffBo.getStaffElasticCount());
            } else {
                dyn.set(prefix + "elasticcontrol", (Object)"");
                dyn.set(prefix + "elasticcount", (Object)0);
            }
        }
    }

    private void coverStaffDimension(StaffDimensionBaseBo staffDimensionBaseBo, StaffDimensionBaseBo inStaffDimensionBaseBo) {
        List staffDimensionIdListForUseOrgBoIn = inStaffDimensionBaseBo.getStaffDimensionIdList();
        staffDimensionBaseBo.setStaffDimensionIdList(staffDimensionIdListForUseOrgBoIn);
    }

    private void coverStaffCount(StaffCountBo staffCountBo, StaffCountBo staffCountBoIn) {
        if (staffCountBoIn.getYearStaff() != null) {
            staffCountBo.setYearStaff(staffCountBoIn.getYearStaff());
        }
        if (staffCountBoIn.getMonthStaff1() != null) {
            staffCountBo.setMonthStaff1(staffCountBoIn.getMonthStaff1());
        }
        if (staffCountBoIn.getMonthStaff2() != null) {
            staffCountBo.setMonthStaff2(staffCountBoIn.getMonthStaff2());
        }
        if (staffCountBoIn.getMonthStaff3() != null) {
            staffCountBo.setMonthStaff3(staffCountBoIn.getMonthStaff3());
        }
        if (staffCountBoIn.getMonthStaff4() != null) {
            staffCountBo.setMonthStaff4(staffCountBoIn.getMonthStaff4());
        }
        if (staffCountBoIn.getMonthStaff5() != null) {
            staffCountBo.setMonthStaff5(staffCountBoIn.getMonthStaff5());
        }
        if (staffCountBoIn.getMonthStaff6() != null) {
            staffCountBo.setMonthStaff6(staffCountBoIn.getMonthStaff6());
        }
        if (staffCountBoIn.getMonthStaff7() != null) {
            staffCountBo.setMonthStaff7(staffCountBoIn.getMonthStaff7());
        }
        if (staffCountBoIn.getMonthStaff8() != null) {
            staffCountBo.setMonthStaff8(staffCountBoIn.getMonthStaff8());
        }
        if (staffCountBoIn.getMonthStaff9() != null) {
            staffCountBo.setMonthStaff9(staffCountBoIn.getMonthStaff9());
        }
        if (staffCountBoIn.getMonthStaff10() != null) {
            staffCountBo.setMonthStaff10(staffCountBoIn.getMonthStaff10());
        }
        if (staffCountBoIn.getMonthStaff11() != null) {
            staffCountBo.setMonthStaff11(staffCountBoIn.getMonthStaff11());
        }
        if (staffCountBoIn.getMonthStaff12() != null) {
            staffCountBo.setMonthStaff12(staffCountBoIn.getMonthStaff12());
        }
    }

    private void afterValidateInBoParameter(StaffBo staffBoIn, StaffBo staffBo, DynamicObject staffDyn) {
    }

    private void buildStaffDyn(StaffBo staffBo, DynamicObject staffDyn) {
        staffDyn.set("name", (Object)staffBo.getName());
        staffDyn.set("staffcycle", (Object)staffCycleIdVsDynMap.get(staffBo.getStaffCycleId()));
        this.coverStaffControlForDyn(staffDyn, "staff", (StaffControlBo)staffBo);
        this.coverStaffDimensionForDyn(staffDyn, "", (StaffDimensionBaseBo)staffBo);
        List useOrgEntryBoList = staffBo.getUseOrgEntryBoList();
        Map<Long, String> adminOrgBoIdVsLongNumberMap = this.getAdminOrgBoIdVsLongMap(useOrgEntryBoList);
        Map<Long, DynamicObject> adminOrgIdVsDynMap = this.getAdminOrgIdVsDynMap(useOrgEntryBoList);
        Map<Long, DynamicObject> positionIdVsDynMap = this.getPositionIdVsDynMap(useOrgEntryBoList);
        Map<Long, DynamicObject> jobIdVsDynMap = this.getJobIdVsDynMap(useOrgEntryBoList);
        Map<Long, DynamicObject> laborIdVsDynMap = this.getLaborIdVsDynMap(useOrgEntryBoList);
        Map<String, Map<Long, DynamicObject>> otherMultiDiIdDynMap = this.getOtherMultiDiIdDynMap(useOrgEntryBoList);
        DynamicObjectCollection dutyOrgEntryCol = staffDyn.getDynamicObjectCollection("aentryentity");
        DynamicObjectType dutyOrgEntryType = dutyOrgEntryCol.getDynamicObjectType();
        DynamicObjectCollection useOrgEntryCol = staffDyn.getDynamicObjectCollection("bentryentity");
        DynamicObjectType useOrgEntryType = useOrgEntryCol.getDynamicObjectType();
        for (StaffUseOrgBo staffUseOrgBo : useOrgEntryBoList) {
            String changeType;
            DynamicObject newUseOrgEntryDyn = new DynamicObject(useOrgEntryType);
            newUseOrgEntryDyn.set("id", (Object)staffUseOrgBo.getEntryId());
            newUseOrgEntryDyn.set("pid", (Object)staffUseOrgBo.getParentEntryId());
            Long adminOrgId = staffUseOrgBo.getAdminOrgId();
            Long adminOrgBoId = staffUseOrgBo.getAdminOrgBoId();
            newUseOrgEntryDyn.set("buseorg", (Object)this.generateEmptyDynByEntityNameAndId("haos_adminorgdetail", adminOrgId, adminOrgIdVsDynMap.get(adminOrgId)));
            newUseOrgEntryDyn.set("buseorgboid", (Object)staffUseOrgBo.getAdminOrgBoId());
            newUseOrgEntryDyn.set("bstructlongnumber", (Object)adminOrgBoIdVsLongNumberMap.get(staffUseOrgBo.getAdminOrgBoId()));
            this.coverStaffControlForDyn(newUseOrgEntryDyn, "b", (StaffControlBo)staffUseOrgBo);
            this.coverStaffDimensionForDyn(newUseOrgEntryDyn, "b", (StaffDimensionBaseBo)staffUseOrgBo);
            Integer yearStaffNumWithSub = staffUseOrgBo.getYearStaffNumWithSub();
            if (Objects.nonNull(yearStaffNumWithSub) && !yearStaffNumWithSub.equals(-1)) {
                newUseOrgEntryDyn.set("byearstaffnumwithsub", (Object)yearStaffNumWithSub);
                DynamicObject newDutyOrgEntryDyn = new DynamicObject(dutyOrgEntryType);
                newDutyOrgEntryDyn.set("adutyorg", (Object)this.generateEmptyDynByEntityNameAndId("haos_adminorgdetail", adminOrgId, adminOrgIdVsDynMap.get(adminOrgId)));
                newDutyOrgEntryDyn.set("astructlongnumber", (Object)adminOrgBoIdVsLongNumberMap.get(adminOrgBoId));
                newDutyOrgEntryDyn.set("astaffcount", (Object)yearStaffNumWithSub);
                this.coverStaffControlForDyn(newDutyOrgEntryDyn, "a", (StaffControlBo)staffUseOrgBo);
                this.coverStaffDimensionForDyn(newDutyOrgEntryDyn, "a", (StaffDimensionBaseBo)staffBo);
                dutyOrgEntryCol.add((Object)newDutyOrgEntryDyn);
            }
            this.coverStaffCountForDyn(newUseOrgEntryDyn, "b", (StaffCountBo)staffUseOrgBo);
            List dimensionIdListForUseOrg = newUseOrgEntryDyn.getDynamicObjectCollection("bstaffdimension").stream().map(dimension -> dimension.getLong("fbasedataid.id")).collect(Collectors.toList());
            if (dimensionIdListForUseOrg.contains(1010L)) {
                List positionDimensionBoList = staffUseOrgBo.getPositionDimensionBoList();
                DynamicObjectCollection positionEntryDynCol = newUseOrgEntryDyn.getDynamicObjectCollection("centryentity");
                DynamicObjectType positionEntryType = positionEntryDynCol.getDynamicObjectType();
                for (StaffMultiDimensionBo positionDimensionBo : positionDimensionBoList) {
                    DynamicObject newPositionEntryDyn = new DynamicObject(positionEntryType);
                    newPositionEntryDyn.set("id", (Object)positionDimensionBo.getEntryId());
                    newPositionEntryDyn.set("cdutyworkrole", (Object)this.generateEmptyDynByEntityNameAndId("hbpm_positionhr", adminOrgId, positionIdVsDynMap.get(positionDimensionBo.getKeyFieldId())));
                    this.coverStaffControlForDyn(newPositionEntryDyn, "c", (StaffControlBo)positionDimensionBo);
                    this.coverStaffCountForDyn(newPositionEntryDyn, "c", (StaffCountBo)positionDimensionBo);
                    positionEntryDynCol.add((Object)newPositionEntryDyn);
                }
            }
            if (dimensionIdListForUseOrg.contains(1020L)) {
                List jobDimensionBoList = staffUseOrgBo.getJobDimensionBoList();
                DynamicObjectCollection jobEntryDynCol = newUseOrgEntryDyn.getDynamicObjectCollection("dentryentity");
                DynamicObjectType jobEntryType = jobEntryDynCol.getDynamicObjectType();
                for (StaffMultiDimensionBo jobDimensionBo : jobDimensionBoList) {
                    changeType = jobDimensionBo.getChangeType();
                    if (HRStringUtils.equals((String)changeType, (String)"2")) continue;
                    DynamicObject newJobEntryDyn = new DynamicObject(jobEntryType);
                    newJobEntryDyn.set("id", (Object)jobDimensionBo.getEntryId());
                    DynamicObject jobDyn = jobIdVsDynMap.get(jobDimensionBo.getKeyFieldId());
                    if (Objects.isNull(jobDyn)) continue;
                    newJobEntryDyn.set("djob", (Object)this.generateEmptyDynByEntityNameAndId("hbjm_jobhr", adminOrgId, jobDyn));
                    this.coverStaffControlForDyn(newJobEntryDyn, "d", (StaffControlBo)jobDimensionBo);
                    this.coverStaffCountForDyn(newJobEntryDyn, "d", (StaffCountBo)jobDimensionBo);
                    jobEntryDynCol.add((Object)newJobEntryDyn);
                }
            }
            if (dimensionIdListForUseOrg.contains(1050L)) {
                List laborDimensionBoList = staffUseOrgBo.getLaborDimensionBoList();
                DynamicObjectCollection laborEntryDynCol = newUseOrgEntryDyn.getDynamicObjectCollection("eentryentity");
                DynamicObjectType laborEntryType = laborEntryDynCol.getDynamicObjectType();
                for (StaffMultiDimensionBo laborDimensionBo : laborDimensionBoList) {
                    changeType = laborDimensionBo.getChangeType();
                    if (HRStringUtils.equals((String)changeType, (String)"2")) continue;
                    DynamicObject newLaborEntryDyn = new DynamicObject(laborEntryType);
                    newLaborEntryDyn.set("id", (Object)laborDimensionBo.getEntryId());
                    DynamicObject laborDyn = laborIdVsDynMap.get(laborDimensionBo.getKeyFieldId());
                    if (Objects.isNull(laborDyn)) continue;
                    newLaborEntryDyn.set("elaborreltype", (Object)this.generateEmptyDynByEntityNameAndId("hbss_laborreltype", adminOrgId, laborDyn));
                    this.coverStaffControlForDyn(newLaborEntryDyn, "e", (StaffControlBo)laborDimensionBo);
                    this.coverStaffCountForDyn(newLaborEntryDyn, "e", (StaffCountBo)laborDimensionBo);
                    laborEntryDynCol.add((Object)newLaborEntryDyn);
                }
            }
            this.buildOtherMultiDimensionToUseOrg(newUseOrgEntryDyn, staffUseOrgBo, otherMultiDiIdDynMap);
            useOrgEntryCol.add((Object)newUseOrgEntryDyn);
        }
        this.setStaffNumWithSub(staffDyn, useOrgEntryCol);
    }

    private void buildOtherMultiDimensionToUseOrg(DynamicObject newUseOrgEntryDyn, StaffUseOrgBo staffUseOrgBo, Map<String, Map<Long, DynamicObject>> otherMultiDiIdDynMap) {
        Map multiDimensionMap = staffUseOrgBo.getMultiDimensionMap();
        List dimensionIdListForUseOrg = newUseOrgEntryDyn.getDynamicObjectCollection("bstaffdimension").stream().map(dimension -> dimension.getLong("fbasedataid.id")).collect(Collectors.toList());
        for (Map.Entry entry : multiDimensionMap.entrySet()) {
            Long dimensionId = (Long)entry.getKey();
            List multiDimensionBos = (List)entry.getValue();
            DynamicObject staffDimensionConfig = staffDimensionIdVsDynMap.get(dimensionId);
            DynamicDimensionEnum dimensionEnum = DynamicDimensionEnum.match((String)staffDimensionConfig.getString("staffdimension"));
            String entityType = this.getBaseDataTypeByDimension(dimensionEnum);
            if (dimensionEnum == null || HRStringUtils.isEmpty((String)entityType) || !dimensionIdListForUseOrg.contains(dimensionId)) continue;
            DynamicObjectCollection multiEntryDynCol = newUseOrgEntryDyn.getDynamicObjectCollection(dimensionEnum.getEntryentityName());
            DynamicObjectType multiEntryType = multiEntryDynCol.getDynamicObjectType();
            for (StaffMultiDimensionBo multiDimensionBo : multiDimensionBos) {
                String changeType = multiDimensionBo.getChangeType();
                if (HRStringUtils.equals((String)changeType, (String)"2")) continue;
                DynamicObject newEntryDyn = new DynamicObject(multiEntryType);
                newEntryDyn.set("id", (Object)multiDimensionBo.getEntryId());
                Map<Long, DynamicObject> baseDataIdMap = otherMultiDiIdDynMap.get(entityType);
                DynamicObject baseDataDyn = baseDataIdMap.get(multiDimensionBo.getKeyFieldId());
                if (Objects.isNull(baseDataDyn)) continue;
                DynamicObject dimensionDataDyn = this.generateEmptyDynByEntityNameAndId(entityType, staffUseOrgBo.getAdminOrgId(), baseDataDyn);
                newEntryDyn.set(dimensionEnum.getEntryBaseDataIdentity(), (Object)dimensionDataDyn);
                this.coverStaffControlForDyn(newEntryDyn, dimensionEnum.getPrefix(), (StaffControlBo)multiDimensionBo);
                this.coverStaffCountForDyn(newEntryDyn, dimensionEnum.getPrefix(), (StaffCountBo)multiDimensionBo);
                multiEntryDynCol.add((Object)newEntryDyn);
            }
        }
    }

    private void setStaffNumWithSub(DynamicObject staffDyn, DynamicObjectCollection useOrgEntryCol) {
        Map<Long, DynamicObject> idVsDynMap = useOrgEntryCol.stream().collect(Collectors.toMap(info -> info.getLong("id"), info -> info, (o1, o2) -> o1));
        List useOrgInfoSortList = useOrgEntryCol.stream().sorted(Comparator.comparing(o -> o.getString("bstructlongnumber"))).collect(Collectors.toList());
        long staffCycleId = staffDyn.getLong("staffcycle.id");
        for (int i = useOrgInfoSortList.size() - 1; i >= 0; --i) {
            int staffNumWithSub;
            int staffCount;
            DynamicObject useOrgInfo = (DynamicObject)useOrgInfoSortList.get(i);
            Object yearNumWithSubObject = useOrgInfo.get("byearstaffnumwithsub");
            if (Objects.isNull(yearNumWithSubObject)) {
                Integer maxStaffCount = this.getCurUseOrgEntryMaxStaffCount(staffCycleId, useOrgInfo);
                if (Objects.isNull(maxStaffCount)) continue;
                staffCount = maxStaffCount;
            } else {
                staffCount = (Integer)yearNumWithSubObject;
            }
            long parentEntryId = useOrgInfo.getLong("pid");
            DynamicObject parentDyn = idVsDynMap.get(parentEntryId);
            if (Objects.isNull(parentDyn)) continue;
            Object staffNumWithSubObject = parentDyn.get("bstaffnumwithsub");
            if (Objects.nonNull(staffNumWithSubObject)) {
                staffNumWithSub = (Integer)staffNumWithSubObject;
                staffNumWithSub += staffCount;
            } else {
                staffNumWithSub = staffCount;
            }
            parentDyn.set("bstaffnumwithsub", (Object)staffNumWithSub);
        }
    }

    private Map<Long, String> getAdminOrgBoIdVsLongMap(List<StaffUseOrgBo> useOrgEntryBoList) {
        List adminOrgBoIdList = useOrgEntryBoList.stream().map(StaffUseOrgBo::getAdminOrgBoId).collect(Collectors.toList());
        DynamicObject[] orgStructDynArr = AdminOrgStructRepository.getInstance().queryEffStructInfoByOrgId("id, adminorg, structlongnumber", adminOrgBoIdList);
        return Arrays.stream(orgStructDynArr).collect(Collectors.toMap(dyn -> dyn.getLong("adminorg.id"), dyn -> dyn.getString("structlongnumber")));
    }

    private Integer getCurUseOrgEntryMaxStaffCount(long staffCycleId, DynamicObject useOrgEntry) {
        Integer maxStaffCount = null;
        if (STAFF_CYCLE_MONTH.equals(staffCycleId)) {
            for (int i = 1; i <= 12; ++i) {
                Object o = useOrgEntry.get("bmonthstaff" + i);
                if (!Objects.nonNull(o)) continue;
                maxStaffCount = Objects.isNull(maxStaffCount) ? (Integer)o : Integer.valueOf(Math.max(maxStaffCount, (Integer)o));
            }
        } else if (Objects.nonNull(useOrgEntry.get("byearstaff"))) {
            maxStaffCount = (Integer)useOrgEntry.get("byearstaff");
        }
        return maxStaffCount;
    }

    private Map<Long, DynamicObject> getAdminOrgIdVsDynMap(List<StaffUseOrgBo> useOrgEntryBoList) {
        List adminOrgIdList = useOrgEntryBoList.stream().map(StaffUseOrgBo::getAdminOrgId).collect(Collectors.toList());
        DynamicObject[] adminOrgDynArr = AdOrgRepository.getInstance().queryBaseFieldAdminOrgByIdList(adminOrgIdList);
        return Arrays.stream(adminOrgDynArr).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn));
    }

    private Map<Long, DynamicObject> getPositionIdVsDynMap(List<StaffUseOrgBo> useOrgEntryBoList) {
        ArrayList positionIdList = Lists.newArrayListWithExpectedSize((int)16);
        useOrgEntryBoList.forEach(bo -> positionIdList.addAll(bo.getPositionDimensionBoList().stream().map(StaffMultiDimensionBo::getKeyFieldId).collect(Collectors.toList())));
        HRBaseServiceHelper helper = new HRBaseServiceHelper(StaffEntryHelperEnum.positionEntry.getKeyFieldEntityName());
        QFilter idFilter = new QFilter("id", "in", (Object)positionIdList);
        DynamicObject[] dynArr = helper.queryOriginalArray("id, number, name, enable, boid", new QFilter[]{idFilter});
        return Arrays.stream(dynArr).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn));
    }

    private Map<Long, DynamicObject> getJobIdVsDynMap(List<StaffUseOrgBo> useOrgEntryBoList) {
        ArrayList jobIdList = Lists.newArrayListWithExpectedSize((int)16);
        useOrgEntryBoList.forEach(bo -> jobIdList.addAll(bo.getJobDimensionBoList().stream().map(StaffMultiDimensionBo::getKeyFieldId).collect(Collectors.toList())));
        HRBaseServiceHelper helper = new HRBaseServiceHelper(StaffEntryHelperEnum.jobEntry.getKeyFieldEntityName());
        QFilter idFilter = new QFilter("id", "in", (Object)jobIdList);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObject[] dynArr = helper.queryOriginalArray("id, number, name, enable, boid", new QFilter[]{idFilter, enableFilter});
        return Arrays.stream(dynArr).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn));
    }

    private Map<Long, DynamicObject> getLaborIdVsDynMap(List<StaffUseOrgBo> useOrgEntryBoList) {
        ArrayList laborIdList = Lists.newArrayListWithExpectedSize((int)16);
        useOrgEntryBoList.forEach(bo -> laborIdList.addAll(bo.getLaborDimensionBoList().stream().map(StaffMultiDimensionBo::getKeyFieldId).collect(Collectors.toList())));
        HRBaseServiceHelper helper = new HRBaseServiceHelper(StaffEntryHelperEnum.laborRelTypeEntry.getKeyFieldEntityName());
        QFilter idFilter = new QFilter("id", "in", (Object)laborIdList);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObject[] dynArr = helper.queryOriginalArray("id, number, name, enable", new QFilter[]{idFilter, enableFilter});
        return Arrays.stream(dynArr).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn));
    }

    private Map<String, Map<Long, DynamicObject>> getOtherMultiDiIdDynMap(List<StaffUseOrgBo> useOrgEntryBoList) {
        HashMap entityTypeDimensionIdMap = Maps.newHashMapWithExpectedSize((int)16);
        useOrgEntryBoList.forEach(userOrg -> {
            Map multiDimensionMap = userOrg.getMultiDimensionMap();
            for (Map.Entry entry : multiDimensionMap.entrySet()) {
                String entityType;
                Long dimensionId = (Long)entry.getKey();
                List multiDimensionBos = (List)entry.getValue();
                DynamicObject dimensionConfig = staffDimensionIdVsDynMap.get(dimensionId);
                DynamicDimensionEnum dimensionEnum = DynamicDimensionEnum.match((String)dimensionConfig.getString("staffdimension"));
                if (dimensionEnum == null || HRStringUtils.isEmpty((String)(entityType = this.getBaseDataTypeByDimension(dimensionEnum)))) continue;
                Set baseDataIds = multiDimensionBos.stream().map(StaffMultiDimensionBo::getKeyFieldId).collect(Collectors.toSet());
                entityTypeDimensionIdMap.put(entityType, baseDataIds);
            }
        });
        HashMap otherMultiDiIdDynMap = Maps.newHashMapWithExpectedSize((int)16);
        entityTypeDimensionIdMap.forEach((entityType, baseDataIds) -> {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityType);
            QFilter idFilter = new QFilter("id", "in", baseDataIds);
            QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
            DynamicObject[] baseDataArr = serviceHelper.queryOriginalArray("id, number, name, enable", new QFilter[]{idFilter, enableFilter});
            Map<Long, DynamicObject> baseDataIdMap = Arrays.stream(baseDataArr).collect(Collectors.toMap(baseData -> baseData.getLong("id"), baseData -> baseData));
            otherMultiDiIdDynMap.put(entityType, baseDataIdMap);
        });
        return otherMultiDiIdDynMap;
    }

    private String getBaseDataTypeByDimension(DynamicDimensionEnum dimensionEnum) {
        if (dimensionEnum == null) {
            return null;
        }
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"haos_staff");
        Map entityMap = dataEntityType.getAllFields();
        IDataEntityProperty property = (IDataEntityProperty)entityMap.get(dimensionEnum.getEntryBaseDataIdentity());
        if (property instanceof BasedataProp) {
            return ((BasedataProp)property).getBaseEntityId();
        }
        return null;
    }

    private void coverStaffCountForDyn(DynamicObject newUseOrgEntryDyn, String prefix, StaffCountBo staffCountBo) {
        if (staffCountBo.getYearStaff() != null) {
            if (staffCountBo.getYearStaff().equals(-1)) {
                newUseOrgEntryDyn.set(prefix + "yearstaff", null);
            } else {
                newUseOrgEntryDyn.set(prefix + "yearstaff", (Object)staffCountBo.getYearStaff());
            }
        }
        IntStream.range(1, 13).forEach(i -> this.setMonthCount(newUseOrgEntryDyn, prefix, i, staffCountBo));
    }

    private void setMonthCount(DynamicObject newUseOrgEntryDyn, String prefix, Integer month, StaffCountBo staffCountBo) {
        Integer monthStaff = this.monthVsGetStaffMap.get(month).apply(staffCountBo);
        if (monthStaff != null) {
            if (this.negative.equals(monthStaff)) {
                newUseOrgEntryDyn.set(prefix + "monthstaff" + month, null);
            } else {
                newUseOrgEntryDyn.set(prefix + "monthstaff" + month, (Object)monthStaff);
            }
        }
    }

    private DynamicObject generateEmptyDynByEntityNameAndId(String entityName, Long adminOrgId, DynamicObject dyn) {
        HRBaseServiceHelper adminOrgHelper = new HRBaseServiceHelper(entityName);
        DynamicObject newDyn = adminOrgHelper.generateEmptyDynamicObject();
        if (HRStringUtils.equals((String)"haos_adminorgdetail", (String)entityName)) {
            newDyn.set("id", (Object)adminOrgId);
        } else {
            newDyn.set("id", (Object)dyn.getLong("id"));
        }
        if (HRStringUtils.equals((String)"haos_adminorgdetail", (String)entityName) || HRStringUtils.equals((String)"hbpm_positionhr", (String)entityName) || HRStringUtils.equals((String)"hbjm_jobhr", (String)entityName)) {
            newDyn.set("boid", dyn.get("boid"));
        }
        newDyn.set("enable", (Object)dyn.getString("enable"));
        newDyn.set("number", (Object)dyn.getString("number"));
        newDyn.set("name", dyn.get("name"));
        return newDyn;
    }

    private void coverStaffDimensionForDyn(DynamicObject staffDyn, String prefix, StaffDimensionBaseBo staffDimensionBaseBo) {
        List staffDimensionIdList = staffDimensionBaseBo.getStaffDimensionIdList();
        if (Objects.isNull(staffDimensionIdList)) {
            return;
        }
        DynamicObjectCollection dimensionMulBaseDataCol = staffDyn.getDynamicObjectCollection(prefix + "staffdimension");
        dimensionMulBaseDataCol.clear();
        DynamicObjectType entryType = dimensionMulBaseDataCol.getDynamicObjectType();
        for (Long staffDimensionId : staffDimensionIdList) {
            DynamicObject row = new DynamicObject(entryType);
            row.set("fbasedataid", (Object)staffDimensionIdVsDynMap.get(staffDimensionId));
            dimensionMulBaseDataCol.add((Object)row);
        }
        staffDyn.set(prefix + "staffdimension", (Object)dimensionMulBaseDataCol);
    }

    private OperationResult callOp(String operate, DynamicObject[] staffDynArr, String type) {
        OperationServiceImpl opImpl = new OperationServiceImpl();
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("sourceType", "interface");
        if (HRStringUtils.isNotEmpty((String)type)) {
            operateOption.setVariableValue("callType", type);
        }
        return opImpl.localInvokeOperation(operate, staffDynArr, operateOption);
    }

    @Override
    public HRMServiceResult saveStaff(StaffBo staffBoIn) {
        return this.validateAndCallOp(staffBoIn, "");
    }

    private HRMServiceResult validateAndCallOp(StaffBo staffBoIn, String type) {
        Long staffId = staffBoIn.getStaffId();
        String msg = this.mustInputValidate(staffBoIn, staffId);
        if (HRStringUtils.isNotEmpty((String)msg)) {
            return HRMServiceResult.fail((String)msg);
        }
        DynamicObject staffDyn = StaffRepository.getInstance().loadDynamicObject(staffId);
        StaffCommonService.STAFF_INTERFACE_STAFF_ID.set(staffId);
        StaffBo staffBo = this.getStaffBo(staffDyn);
        if (Objects.isNull(staffBo)) {
            return HRMServiceResult.fail((String)ResManager.loadKDString((String)"staffid\u586b\u5199\u6709\u8bef\uff0c\u6ca1\u6709\u6b64\u7f16\u5236\u4fe1\u606f\uff1b", (String)"StaffExternalServiceImpl_30", (String)"hrmp-haos-mservice", (Object[])new Object[0]));
        }
        String msgStr = this.beforeValidateInBoParameter(staffBoIn, staffBo, staffDyn);
        if (HRStringUtils.isNotEmpty((String)msgStr)) {
            return HRMServiceResult.fail((String)msgStr);
        }
        this.coverBoData(staffBo, staffBoIn);
        this.afterValidateInBoParameter(staffBoIn, staffBo, staffDyn);
        this.buildStaffDyn(staffBo, staffDyn);
        OperationResult operationResult = this.callOp("save", new DynamicObject[]{staffDyn}, type);
        if (operationResult.isSuccess()) {
            return HRMServiceResult.success();
        }
        String errorMsg = this.packageErrorMsg(operationResult);
        return HRMServiceResult.fail((String)errorMsg);
    }

    private boolean longIsNullOrZero(Long aLong) {
        return aLong == null || aLong == 0L;
    }

    static {
        enableVsNameMap = Maps.newHashMapWithExpectedSize((int)2);
    }
}

