/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.mservice.webapi.api.utils;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DBRoute;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.haos.business.domain.repository.adorg.AdOrgRepository;
import kd.hr.haos.mservice.webapi.api.model.adminorg.AdminOrgOperateResultModel;
import kd.hr.haos.mservice.webapi.api.model.adminorg.param.AdminOrgOperateParamModel;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class AdminOrgOperateUtils {
    public static ArrayList<DynamicObject> setDynamicObject(int type, String metaData, ArrayList<AdminOrgOperateParamModel> dataList) {
        ArrayList<DynamicObject> dynObjList = new ArrayList<DynamicObject>();
        AdminOrgOperateParamModel model = new AdminOrgOperateParamModel();
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)metaData);
        DynamicObject dynObj = new DynamicObject((DynamicObjectType)dataEntityType);
        Date currentDate = HRDateTimeUtils.truncateDate((Date)new Date());
        for (int i = 0; i < dataList.size(); ++i) {
            model = dataList.get(i);
            dynObj = new DynamicObject((DynamicObjectType)dataEntityType);
            HRBaseServiceHelper helper = new HRBaseServiceHelper("bos_org");
            dynObj.set("effdt", (Object)model.getEffdt());
            DynamicObject bosOrgDyn = helper.loadDynamicObject(new QFilter[]{new QFilter("id", "in", (Object)model.getOrg())});
            if (type == 1) {
                dynObj.set("establishmentdate", (Object)model.getEffdt());
                dynObj.set("org", (Object)bosOrgDyn);
            }
            if (!HRObjectUtils.isEmpty((Object)model.getName())) {
                LocaleString name = new LocaleString();
                name.setLocaleValue_zh_CN(model.getName().getZh_CN());
                name.setLocaleValue_en(model.getName().getZh_US());
                name.setLocaleValue_zh_TW(model.getName().getZh_TW());
                dynObj.set("name", (Object)name);
            }
            dynObj.set("number", (Object)model.getNumber());
            QFilter idFilter = new QFilter("boid", "in", (Object)model.getParentorg());
            if (type == 1) {
                MainEntityType adminOrgEntityType = MetadataServiceHelper.getDataEntityType((String)"haos_adminorgdetail");
                DynamicObject parentDynObj = new DynamicObject((DynamicObjectType)adminOrgEntityType);
                parentDynObj.set("boid", (Object)model.getParentorg());
                dynObj.set("parentorg", (Object)parentDynObj);
                dynObj.set("orgid", (Object)model.getAdminorg());
            } else {
                DynamicObject[] parentAdminOrgDynObjs = AdOrgRepository.queryAdminHisInfo((QFilter)idFilter, (Date)currentDate);
                if (parentAdminOrgDynObjs.length > 0) {
                    dynObj.set("parentorg", (Object)parentAdminOrgDynObjs[0]);
                }
            }
            dynObj.set("index", (Object)AdminOrgOperateUtils.getIndex(model));
            if (type == 3 || type == 2) {
                DynamicObject[] adminOrgDynObjs;
                if (!HRObjectUtils.isEmpty((Object)model.getName())) {
                    if (!HRObjectUtils.isEmpty((Object)model.getName().getZh_CN())) {
                        dynObj.set("nameold", (Object)model.getName().getZh_CN());
                    } else if (!HRObjectUtils.isEmpty((Object)model.getName().getZh_TW())) {
                        dynObj.set("nameold", (Object)model.getName().getZh_TW());
                    } else if (!HRObjectUtils.isEmpty((Object)model.getName().getZh_US())) {
                        dynObj.set("nameold", (Object)model.getName().getZh_US());
                    }
                }
                if ((adminOrgDynObjs = AdOrgRepository.queryAdminHisInfo((QFilter)(idFilter = new QFilter("boid", "in", (Object)model.getAdminorg())), (Date)model.getEffdt())).length > 0) {
                    dynObj.set("parentorgold", adminOrgDynObjs[0].get("parentorg"));
                    dynObj.set("adminorg", (Object)adminOrgDynObjs[0]);
                }
                dynObj.set("tobedisableflag", (Object)model.isTobedisableflag());
                dynObj.set("openapiflag", (Object)"1");
                if (bosOrgDyn == null) {
                    dynObj.set("org", adminOrgDynObjs[0].get("org"));
                } else {
                    dynObj.set("org", (Object)bosOrgDyn);
                }
            }
            if (!HRObjectUtils.isEmpty((Object)model.getAdminOrgType())) {
                helper = new HRBaseServiceHelper("haos_adminorgtype");
                dynObj.set("adminorgtype", (Object)helper.loadDynamicObject(new QFilter[]{new QFilter("id", "in", (Object)model.getAdminOrgType())}));
            }
            if (!HRObjectUtils.isEmpty((Object)model.getCorporateOrg())) {
                helper = new HRBaseServiceHelper("hbss_lawentity");
                dynObj.set("corporateorg", (Object)helper.loadDynamicObject(new QFilter[]{new QFilter("id", "in", (Object)model.getCorporateOrg())}));
            }
            if (!HRObjectUtils.isEmpty((Object)model.getAdminOrgLayer())) {
                helper = new HRBaseServiceHelper("haos_adminorglayer");
                dynObj.set("adminorglayer", (Object)helper.loadDynamicObject(new QFilter[]{new QFilter("id", "in", (Object)model.getAdminOrgLayer())}));
            }
            if (!HRObjectUtils.isEmpty((Object)model.getAdminOrgFunction())) {
                helper = new HRBaseServiceHelper("haos_adminorgfunction");
                dynObj.set("adminorgfunction", (Object)helper.loadDynamicObject(new QFilter[]{new QFilter("id", "in", (Object)model.getAdminOrgFunction())}));
            }
            if (!HRObjectUtils.isEmpty((Object)model.getCompanyArea())) {
                helper = new HRBaseServiceHelper("bd_country");
                dynObj.set("companyarea", (Object)helper.loadDynamicObject(new QFilter[]{new QFilter("id", "in", (Object)model.getCompanyArea())}));
            }
            if (!HRObjectUtils.isEmpty((Object)model.getCity())) {
                helper = new HRBaseServiceHelper("bd_admindivision");
                DynamicObject cityDyn = helper.loadDynamicObject(new QFilter[]{new QFilter("id", "in", (Object)model.getCity())});
                dynObj.set("city", (Object)helper.loadDynamicObject(new QFilter[]{new QFilter("id", "in", (Object)model.getCity())}));
                if (HRObjectUtils.isEmpty((Object)model.getCompanyArea())) {
                    dynObj.set("companyarea", (Object)cityDyn.getDynamicObject("country"));
                }
            }
            if (!HRObjectUtils.isEmpty((Object)model.getWorkplace())) {
                helper = new HRBaseServiceHelper("hbss_workplace");
                dynObj.set("workplace", (Object)helper.loadDynamicObject(new QFilter[]{new QFilter("id", "in", (Object)model.getWorkplace())}));
            }
            if (!HRObjectUtils.isEmpty((Object)model.getCompanyType())) {
                helper = new HRBaseServiceHelper("haos_companytype");
                dynObj.set("companytype", (Object)helper.loadDynamicObject(new QFilter[]{new QFilter("id", "in", (Object)model.getCompanyType())}));
            }
            if (!HRObjectUtils.isEmpty((Object)model.getIndustryType())) {
                helper = new HRBaseServiceHelper("hbss_industrytype");
                dynObj.set("industrytype", (Object)helper.loadDynamicObject(new QFilter[]{new QFilter("id", "in", (Object)model.getIndustryType())}));
            }
            if (!HRObjectUtils.isEmpty((Object)model.getDepartmentType())) {
                helper = new HRBaseServiceHelper("haos_departmenttype");
                dynObj.set("departmenttype", (Object)helper.loadDynamicObject(new QFilter[]{new QFilter("id", "in", (Object)model.getDepartmentType())}));
            }
            if (!HRObjectUtils.isEmpty((Object)model.getSafeLevel())) {
                helper = new HRBaseServiceHelper("haos_safelevel");
                dynObj.set("safelevel", (Object)helper.loadDynamicObject(new QFilter[]{new QFilter("id", "in", (Object)model.getSafeLevel())}));
            }
            if (!HRObjectUtils.isEmpty((Object)model.getSafeType())) {
                helper = new HRBaseServiceHelper("haos_safetype");
                dynObj.set("safetype", (Object)helper.loadDynamicObject(new QFilter[]{new QFilter("id", "in", (Object)model.getSafeType())}));
            }
            if (!HRObjectUtils.isEmpty((Object)model.getSafeDescription())) {
                LocaleString safedescription = new LocaleString();
                safedescription.setLocaleValue_zh_CN(model.getSafeDescription().getZh_CN());
                safedescription.setLocaleValue_en(model.getSafeDescription().getZh_US());
                safedescription.setLocaleValue_zh_TW(model.getSafeDescription().getZh_TW());
                dynObj.set("safedescription", (Object)safedescription);
            }
            if (!HRObjectUtils.isEmpty((Object)model.getPositioning())) {
                LocaleString positioning = new LocaleString();
                positioning.setLocaleValue_zh_CN(model.getPositioning().getZh_CN());
                positioning.setLocaleValue_en(model.getPositioning().getZh_US());
                positioning.setLocaleValue_zh_TW(model.getPositioning().getZh_TW());
                dynObj.set("positioning", (Object)positioning);
            }
            if (!HRObjectUtils.isEmpty((Object)model.getDetailAddress())) {
                LocaleString detailaddress = new LocaleString();
                detailaddress.setLocaleValue_zh_CN(model.getDetailAddress().getZh_CN());
                detailaddress.setLocaleValue_en(model.getDetailAddress().getZh_US());
                detailaddress.setLocaleValue_zh_TW(model.getDetailAddress().getZh_TW());
                dynObj.set("detailaddress", (Object)detailaddress);
            }
            if (!HRObjectUtils.isEmpty((Object)model.getMainduty())) {
                LocaleString mainduty = new LocaleString();
                mainduty.setLocaleValue_zh_CN(model.getMainduty().getZh_CN());
                mainduty.setLocaleValue_en(model.getMainduty().getZh_US());
                mainduty.setLocaleValue_zh_TW(model.getMainduty().getZh_TW());
                dynObj.set("mainduty", (Object)mainduty);
            }
            if (!HRObjectUtils.isEmpty((Object)model.getGroupVision())) {
                LocaleString groupvision = new LocaleString();
                groupvision.setLocaleValue_zh_CN(model.getGroupVision().getZh_CN());
                groupvision.setLocaleValue_en(model.getGroupVision().getZh_US());
                groupvision.setLocaleValue_zh_TW(model.getGroupVision().getZh_TW());
                dynObj.set("groupvision", (Object)groupvision);
            }
            if (!HRObjectUtils.isEmpty((Object)model.getGroupMission())) {
                LocaleString groupmission = new LocaleString();
                groupmission.setLocaleValue_zh_CN(model.getGroupMission().getZh_CN());
                groupmission.setLocaleValue_en(model.getGroupMission().getZh_US());
                groupmission.setLocaleValue_zh_TW(model.getGroupMission().getZh_TW());
                dynObj.set("groupmission", (Object)groupmission);
            }
            if (!HRObjectUtils.isEmpty((Object)model.getSimpleName())) {
                LocaleString simplename = new LocaleString();
                simplename.setLocaleValue_zh_CN(model.getSimpleName().getZh_CN());
                simplename.setLocaleValue_en(model.getSimpleName().getZh_US());
                simplename.setLocaleValue_zh_TW(model.getSimpleName().getZh_TW());
                dynObj.set("simplename", (Object)simplename);
            }
            if (!HRObjectUtils.isEmpty((Object)model.getDescription())) {
                LocaleString description = new LocaleString();
                description.setLocaleValue_zh_CN(model.getDescription().getZh_CN());
                description.setLocaleValue_en(model.getDescription().getZh_US());
                description.setLocaleValue_zh_TW(model.getDescription().getZh_TW());
                dynObj.set("description", (Object)description);
            }
            dynObjList.add(dynObj);
        }
        return dynObjList;
    }

    private static Integer getIndex(AdminOrgOperateParamModel model) {
        Integer index = model.getIndex();
        if (index == null) {
            int maxIndex = 1;
            QFilter currentVersionFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('1'));
            QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
            QFilter parentOrgFilter = new QFilter("parentorg", "=", (Object)model.getParentorg());
            DynamicObject[] adminOrgDyns = AdOrgRepository.getInstance().queryOriginalArray("id, index", new QFilter[]{currentVersionFilter, initStatusFilter, parentOrgFilter});
            if (adminOrgDyns.length > 0) {
                for (DynamicObject adminOrgDyn : adminOrgDyns) {
                    if (adminOrgDyn.getInt("index") <= maxIndex) continue;
                    maxIndex = adminOrgDyn.getInt("index");
                }
            }
            return maxIndex + 1;
        }
        return index;
    }

    public static Map<String, String> baseDataEffectiveCheck(ArrayList<AdminOrgOperateParamModel> dataList) {
        HashMap<String, String> errorMap = new HashMap<String, String>(dataList.size());
        AdminOrgOperateParamModel model = new AdminOrgOperateParamModel();
        for (int i = 0; i < dataList.size(); ++i) {
            model = dataList.get(i);
            StringBuilder checkInfo = new StringBuilder();
            DynamicObject baseDataDynObj = null;
            if (!HRObjectUtils.isEmpty((Object)model.getAdminOrgType()) && HRObjectUtils.isEmpty((Object)(baseDataDynObj = AdminOrgOperateUtils.getBaseInfoDynObj("haos_adminorgtype", model.getAdminOrgType(), "1")))) {
                checkInfo.append("adminorgtype,");
            }
            if (!HRObjectUtils.isEmpty((Object)model.getCorporateOrg()) && HRObjectUtils.isEmpty((Object)(baseDataDynObj = AdminOrgOperateUtils.getBaseInfoDynObj("hbss_lawentity", model.getCorporateOrg(), "1")))) {
                checkInfo.append("corporateorg,");
            }
            if (!HRObjectUtils.isEmpty((Object)model.getAdminOrgLayer()) && HRObjectUtils.isEmpty((Object)(baseDataDynObj = AdminOrgOperateUtils.getBaseInfoDynObj("haos_adminorglayer", model.getAdminOrgLayer(), "1")))) {
                checkInfo.append("adminorglayer,");
            }
            if (!HRObjectUtils.isEmpty((Object)model.getAdminOrgFunction()) && HRObjectUtils.isEmpty((Object)(baseDataDynObj = AdminOrgOperateUtils.getBaseInfoDynObj("haos_adminorgfunction", model.getAdminOrgFunction(), "1")))) {
                checkInfo.append("adminorgfunction,");
            }
            if (!HRObjectUtils.isEmpty((Object)model.getCompanyArea()) && HRObjectUtils.isEmpty((Object)(baseDataDynObj = AdminOrgOperateUtils.getBaseInfoDynObj("bd_country", model.getCompanyArea(), "1")))) {
                checkInfo.append("companyarea,");
            }
            if (!HRObjectUtils.isEmpty((Object)model.getCity()) && HRObjectUtils.isEmpty((Object)(baseDataDynObj = AdminOrgOperateUtils.getBaseInfoDynObj("bd_admindivision", model.getCity(), "1")))) {
                checkInfo.append("city,");
            }
            if (!HRObjectUtils.isEmpty((Object)model.getWorkplace()) && HRObjectUtils.isEmpty((Object)(baseDataDynObj = AdminOrgOperateUtils.getBaseInfoDynObj("hbss_workplace", model.getWorkplace(), "1")))) {
                checkInfo.append("workplace,");
            }
            if (!HRObjectUtils.isEmpty((Object)model.getCompanyType()) && HRObjectUtils.isEmpty((Object)(baseDataDynObj = AdminOrgOperateUtils.getBaseInfoDynObj("haos_companytype", model.getCompanyType(), "1")))) {
                checkInfo.append("companytype,");
            }
            if (!HRObjectUtils.isEmpty((Object)model.getIndustryType()) && HRObjectUtils.isEmpty((Object)(baseDataDynObj = AdminOrgOperateUtils.getBaseInfoDynObj("hbss_industrytype", model.getIndustryType(), "1")))) {
                checkInfo.append("industrytype,");
            }
            if (!HRObjectUtils.isEmpty((Object)model.getDepartmentType()) && HRObjectUtils.isEmpty((Object)(baseDataDynObj = AdminOrgOperateUtils.getBaseInfoDynObj("haos_departmenttype", model.getDepartmentType(), "1")))) {
                checkInfo.append("departmenttype,");
            }
            if (!HRObjectUtils.isEmpty((Object)model.getSafeLevel()) && HRObjectUtils.isEmpty((Object)(baseDataDynObj = AdminOrgOperateUtils.getBaseInfoDynObj("haos_safelevel", model.getSafeLevel(), "1")))) {
                checkInfo.append("safelevel,");
            }
            if (!HRObjectUtils.isEmpty((Object)model.getSafeType()) && HRObjectUtils.isEmpty((Object)(baseDataDynObj = AdminOrgOperateUtils.getBaseInfoDynObj("haos_safetype", model.getSafeType(), "1")))) {
                checkInfo.append("safetype,");
            }
            if (checkInfo.length() <= 0) continue;
            errorMap.put(model.getNumber(), checkInfo.substring(0, checkInfo.length() - 1) + " is not exists or enbale is not 1;");
        }
        return errorMap;
    }

    public static Map<String, Long> getSuccessMap(List<Long> ids, Map<String, String> errorMap) {
        DynamicObject[] adminOrgDynObjs;
        HashMap<String, Long> successMap = new HashMap<String, Long>();
        QFilter idFilter = new QFilter("boid", "in", ids);
        for (DynamicObject dynamicObject : adminOrgDynObjs = AdOrgRepository.queryAdminHisInfo((QFilter)idFilter, (Date)new Date())) {
            if (HRObjectUtils.isEmpty(errorMap)) {
                successMap.put((String)dynamicObject.get("number"), (Long)dynamicObject.get("boid"));
                continue;
            }
            if (!HRObjectUtils.isEmpty((Object)errorMap.get(dynamicObject.get("number")))) continue;
            successMap.put((String)dynamicObject.get("number"), (Long)dynamicObject.get("boid"));
        }
        return successMap;
    }

    public static AdminOrgOperateResultModel serviceMapToResultModel(Map<String, Object> serviceMap, ArrayList<DynamicObject> dynObjList, boolean isNeedSuccessMap, String dataType) {
        AdminOrgOperateResultModel resultModel = new AdminOrgOperateResultModel();
        if (serviceMap.get("errorCode").equals("true")) {
            resultModel.setStatus(1);
            return resultModel;
        }
        if (serviceMap.get("message") != null && !serviceMap.get("message").equals("")) {
            resultModel.setStatus(0);
            resultModel.setErrorInfo((String)serviceMap.get("message"));
            return resultModel;
        }
        Map errorMap = new HashMap();
        Map<String, Long> successMap = new HashMap<String, Long>();
        if (isNeedSuccessMap) {
            if (serviceMap.get("data") != null) {
                errorMap = (Map)serviceMap.get("data");
            }
            if (errorMap == null || errorMap.size() == 0) {
                resultModel.setStatus(1);
                for (int i = 0; i < dynObjList.size(); ++i) {
                    DynamicObject dynObj = dynObjList.get(i);
                    DynamicObject adminOrgDybObj = (DynamicObject)dynObj.get("adminorg");
                    successMap.put((String)dynObj.get("number"), (Long)adminOrgDybObj.get("boid"));
                }
            } else {
                resultModel.setStatus(2);
                for (int i = 0; i < dynObjList.size(); ++i) {
                    DynamicObject dynObj = dynObjList.get(i);
                    if (errorMap.get(dynObj.get("number")) != null) continue;
                    DynamicObject adminOrgDybObj = (DynamicObject)dynObj.get("adminorg");
                    successMap.put((String)dynObj.get("number"), (Long)adminOrgDybObj.get("boid"));
                }
            }
        } else if (dataType.equals("Map")) {
            if (serviceMap.get("data") != null) {
                errorMap = (Map)serviceMap.get("data");
                if (errorMap.size() > 0) {
                    resultModel.setStatus(2);
                }
            } else {
                resultModel.setStatus(1);
            }
        } else if (dataType.equals("ArrayList")) {
            ArrayList resultList = (ArrayList)serviceMap.get("data");
            errorMap = (Map)resultList.get(0);
            successMap = (Map)resultList.get(1);
            if (errorMap.size() > 0) {
                resultModel.setStatus(2);
            } else {
                resultModel.setStatus(1);
            }
        }
        resultModel.setErrorMap(errorMap);
        resultModel.setSuccessMap(successMap);
        return resultModel;
    }

    public static String dataCheck(DynamicObject dynamicObject, int type) {
        QFilter idFilter;
        HRBaseServiceHelper helper;
        DynamicObject admindivisionDynObj;
        if (HRObjectUtils.isEmpty((Object)dynamicObject.get("effdt"))) {
            return "effdt is null";
        }
        if (!AdminOrgOperateUtils.isValidDate(AdminOrgOperateUtils.dateToString((Date)dynamicObject.get("effdt")))) {
            return "The date format is incorrect";
        }
        if (HRObjectUtils.isEmpty((Object)dynamicObject.get("number"))) {
            return "number is null";
        }
        if (HRStringUtils.isNotEmpty((String)dynamicObject.getString("number")) && dynamicObject.getString("number").contains("!")) {
            return "number can't have !;";
        }
        OrmLocaleValue name = (OrmLocaleValue)dynamicObject.get("name");
        if (name.size() == 0) {
            return "Name is null";
        }
        String zhName = name.getLocaleValue_zh_CN();
        String enName = name.getLocaleValue_en();
        String twName = name.getLocaleValue_zh_TW();
        if (zhName != null && (zhName.contains("!") || zhName.contains("_") || zhName.contains("\\"))) {
            return "zh_CN can't have !_\\";
        }
        if (enName != null && (enName.contains("!") || enName.contains("_") || enName.contains("\\"))) {
            return "zh_US can't have !_\\";
        }
        if (twName != null && (twName.contains("!") || twName.contains("_") || twName.contains("\\"))) {
            return "zh_TW can't have !_\\";
        }
        if (HRObjectUtils.isEmpty((Object)dynamicObject.get("index"))) {
            return "index is null";
        }
        if ((Integer)dynamicObject.get("index") <= 0 || (Integer)dynamicObject.get("index") > 99999) {
            return "index need between 1-99999";
        }
        if (HRObjectUtils.isEmpty((Object)dynamicObject.get("adminorgtype"))) {
            return "adminorgtype is null";
        }
        if (((String)dynamicObject.get("number")).contains("!")) {
            return "number can't have !";
        }
        if (HRObjectUtils.isEmpty((Object)dynamicObject.get("parentorg"))) {
            return "parentorg is null";
        }
        if (HRDateTimeUtils.dayBefore((Date)new Date(), (Date)((Date)dynamicObject.get("effdt")))) {
            return "The effdt cannot be in the future";
        }
        if (type != 1 && HRDateTimeUtils.dayBefore((Date)((Date)dynamicObject.get("effdt")), (Date)((Date)dynamicObject.get("parentorg.establishmentdate")))) {
            return "effdt need after parentorg establishmentdate";
        }
        String billenable = dynamicObject.getString("billenable");
        if (!(HRObjectUtils.isEmpty((Object)billenable) || HRObjectUtils.equals((Object)billenable, (Object)"1") || HRObjectUtils.equals((Object)billenable, (Object)"0"))) {
            return "billenable is invalid";
        }
        if (type == 1) {
            if (!dynamicObject.getDataEntityType().toString().equals("homs_orgfastchgadd")) {
                return "DynamicObject type is not homs_orgfastchgadd";
            }
            if (HRObjectUtils.isEmpty((Object)dynamicObject.get("org"))) {
                return "org is null";
            }
        } else if (type == 2) {
            if (!dynamicObject.getDataEntityType().toString().equals("homs_orgfastchgparent")) {
                return "DynamicObject type is not homs_orgfastchgparent";
            }
            if (HRObjectUtils.isEmpty((Object)dynamicObject.get("adminorg"))) {
                return "adminorg object not Specified";
            }
        } else if (type == 3) {
            if (!dynamicObject.getDataEntityType().toString().equals("homs_orgfastchginfo")) {
                return "DynamicObject type is not homs_orgfastchginfo";
            }
            if (HRObjectUtils.isEmpty((Object)dynamicObject.get("adminorg"))) {
                return "adminorg object not Specified";
            }
        } else if (type == 4) {
            if (!dynamicObject.getDataEntityType().toString().equals("homs_orgfastchgdisable")) {
                return "DynamicObject type is not homs_orgfastchgdisable";
            }
        } else if (type == 5 && !dynamicObject.getDataEntityType().toString().equals("homs_orgfastchgenable")) {
            return "DynamicObject type is not homs_orgfastchgenable";
        }
        HashMap<Object, Object> baseDataMap = new HashMap();
        baseDataMap = AdminOrgOperateUtils.getBaseDataFieldToEntityMap();
        for (Map.Entry<Object, Object> iteratorMap : baseDataMap.entrySet()) {
            DynamicObject resultDynObj;
            String key = (String)iteratorMap.getKey();
            String value = (String)iteratorMap.getValue();
            if (HRObjectUtils.isEmpty((Object)dynamicObject.get(key)) || !HRObjectUtils.isEmpty((Object)(resultDynObj = AdminOrgOperateUtils.getBaseInfoDynObj(value, (Long)dynamicObject.get(key + ".id"), "1")))) continue;
            return key + " is not exists or enbale is not 1";
        }
        if (!(HRObjectUtils.isEmpty((Object)dynamicObject.get("city")) || HRObjectUtils.isEmpty((Object)dynamicObject.get("companyarea")) || (admindivisionDynObj = (helper = new HRBaseServiceHelper("bd_admindivision")).loadDynamicObject(new QFilter[]{idFilter = new QFilter("id", "in", dynamicObject.get("city.id"))})).get("country.id").equals(dynamicObject.get("companyarea.id")))) {
            return "companyarea and city mismatch";
        }
        return "";
    }

    public static DynamicObject getBaseInfoDynObj(String entityName, Long id, String status) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityName);
        QFilter enableFilter = null;
        if (!HRObjectUtils.isEmpty((Object)status)) {
            enableFilter = new QFilter("enable", "=", (Object)status);
        }
        QFilter idFilter = new QFilter("id", "=", (Object)id);
        DynamicObject dynObj = helper.loadDynamicObject(new QFilter[]{enableFilter, idFilter});
        return dynObj;
    }

    private static HashMap<String, String> getBaseDataFieldToEntityMap() {
        HashMap<String, String> baseDataMap = new HashMap<String, String>();
        baseDataMap.put("adminorgtype", "haos_adminorgtype");
        baseDataMap.put("corporateorg", "hbss_lawentity");
        baseDataMap.put("adminorglayer", "haos_adminorglayer");
        baseDataMap.put("adminorgfunction", "haos_adminorgfunction");
        baseDataMap.put("companyarea", "bd_country");
        baseDataMap.put("city", "bd_admindivision");
        baseDataMap.put("workplace", "hbss_workplace");
        baseDataMap.put("companytype", "haos_companytype");
        baseDataMap.put("industrytype", "hbss_industrytype");
        baseDataMap.put("departmenttype", "haos_departmenttype");
        baseDataMap.put("safelevel", "haos_safelevel");
        baseDataMap.put("safetype", "haos_safetype");
        return baseDataMap;
    }

    public static String getErrorInfoToString(OperationResult operationResult) {
        String errorInfo = "";
        if (!HRObjectUtils.isEmpty((Object)operationResult.getMessage())) {
            errorInfo = operationResult.getMessage();
        }
        if (operationResult != null && !operationResult.isSuccess() && operationResult.getValidateResult() != null && operationResult.getValidateResult().getValidateErrors() != null && operationResult.getValidateResult().getValidateErrors().size() > 0 && operationResult.getValidateResult().getValidateErrors().get(0) != null && ((ValidateResult)operationResult.getValidateResult().getValidateErrors().get(0)).getAllErrorInfo() != null && ((ValidateResult)operationResult.getValidateResult().getValidateErrors().get(0)).getAllErrorInfo().get(0) != null) {
            errorInfo = errorInfo + ((OperateErrorInfo)((ValidateResult)operationResult.getValidateResult().getValidateErrors().get(0)).getAllErrorInfo().get(0)).toString();
        }
        if (errorInfo.equals("")) {
            errorInfo = "unknown check error";
        }
        return errorInfo;
    }

    public static Map<String, Object> dataSizeCheck(int size) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (size > 500) {
            resultMap.put("message", "No more than 500");
            resultMap.put("errorCode", false);
            return resultMap;
        }
        return resultMap;
    }

    public static HashMap<String, Object> getParentDynObj(ArrayList<DynamicObject> dynObjList, String fieldName) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ArrayList<Long> idLists = new ArrayList<Long>();
        DynamicObject dynamicObject = null;
        for (int i = 0; i < dynObjList.size(); ++i) {
            dynamicObject = dynObjList.get(i);
            if (dynamicObject.get(fieldName) == null) continue;
            idLists.add((Long)dynamicObject.get(fieldName + ".boid"));
        }
        QFilter idFilter = new QFilter("boid", "in", idLists);
        DynamicObject[] adminOrgDynObjs = AdOrgRepository.queryAdminHisInfo((QFilter)idFilter, (Date)new Date());
        for (int i = 0; i < adminOrgDynObjs.length; ++i) {
            resultMap.put((String)adminOrgDynObjs[i].get("boid"), adminOrgDynObjs[i]);
        }
        return resultMap;
    }

    public static DynamicObject getParentDynObj(DynamicObject dynamicObject, String fieldName) {
        QFilter idFilter;
        DynamicObject[] adminOrgDynObjs;
        ArrayList<Long> idLists = new ArrayList<Long>();
        if (dynamicObject.get(fieldName) != null) {
            idLists.add((Long)dynamicObject.get(fieldName + ".boid"));
        }
        if ((adminOrgDynObjs = AdOrgRepository.queryAdminHisInfo((QFilter)(idFilter = new QFilter("boid", "in", idLists)), (Date)new Date())).length > 0) {
            return adminOrgDynObjs[0];
        }
        return null;
    }

    public static DynamicObject setDynamicObject(DynamicObject dynamicObject, HashMap<String, Object> parentMap) {
        DynamicObject parentDynObj;
        DynamicObject cityDynObj;
        dynamicObject.set("billtype", (Object)"1");
        dynamicObject.set("billstatus", (Object)"C");
        dynamicObject.set("auditstatus", (Object)"C");
        if (!HRObjectUtils.isEmpty((Object)dynamicObject.get("city")) && HRObjectUtils.isEmpty((Object)dynamicObject.get("companyarea")) && (cityDynObj = AdminOrgOperateUtils.getBaseInfoDynObj("bd_admindivision", (Long)dynamicObject.get("city.id"), null)) != null) {
            dynamicObject.set("companyarea", cityDynObj.get("country"));
        }
        if (HRObjectUtils.isEmpty((Object)dynamicObject.get("city")) && HRObjectUtils.isEmpty((Object)dynamicObject.get("companyarea")) && HRObjectUtils.isEmpty((Object)dynamicObject.get("workplace")) && !HRObjectUtils.isEmpty((Object)(parentDynObj = (DynamicObject)parentMap.get(dynamicObject.get("parentorg.boid"))))) {
            dynamicObject.set("companyarea", parentDynObj.get("companyarea"));
            dynamicObject.set("city", parentDynObj.get("city"));
            dynamicObject.set("workplace", parentDynObj.get("workplace"));
        }
        return dynamicObject;
    }

    public static boolean isValidDate(String sDate) {
        String datePattern1 = "\\d{4}-\\d{2}-\\d{2}";
        String datePattern2 = "^((\\d{2}(([02468][048])|([13579][26]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))";
        if (sDate != null) {
            Pattern pattern = Pattern.compile(datePattern1);
            Matcher match = pattern.matcher(sDate);
            if (match.matches()) {
                pattern = Pattern.compile(datePattern2);
                match = pattern.matcher(sDate);
                return match.matches();
            }
            return false;
        }
        return false;
    }

    public static String dateToString(Date date) {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd");
        return fmt.format(date);
    }

    public static Set<Long> getOrgByBillEntry(Long changeTypeId) {
        HashSet<Long> resultSet = new HashSet<Long>();
        StringBuilder sb = new StringBuilder();
        sb.append("select a.fadminorgboid ").append("from t_homs_orgchgbillentry a ").append("left join t_homs_orgchgbill b on b.fid = a.fid ").append("left join t_haos_adminorg c on a.fadminorgid = c.fid ").append("where b.fbillstatus in('B','D')");
        Long[] obj = null;
        if (changeTypeId != null) {
            sb.append(" and a.fchangetypeid=?");
            obj = new Long[]{changeTypeId};
        }
        try (DataSet ds = HRDBUtil.queryDataSet((String)"queryBillOrgList", (DBRoute)new DBRoute("haos"), (String)sb.toString(), obj);){
            for (Row data : ds) {
                resultSet.add(data.getLong("fadminorgboid"));
            }
        }
        return resultSet;
    }

    public static boolean checkSameNameInTheBill(Long adminOrgId, Long parentId, String name) {
        boolean result = false;
        StringBuilder sb = new StringBuilder();
        sb.append("select a.fadminorgboid ").append("from t_homs_orgchgbillentry a ").append("left join t_homs_orgchgbill b on b.fid = a.fid ").append("left join t_haos_adminorg c on a.fparentid = c.fid").append(" where b.fbillstatus in('B','D')").append(" and a.fname = '").append(name).append("'").append(" and c.fboid = ").append(parentId).append(" and a.fadminorgboid not in (").append(adminOrgId).append(")");
        try (DataSet ds = HRDBUtil.queryDataSet((String)"queryBillOrgList", (DBRoute)new DBRoute("haos"), (String)sb.toString(), null);){
            for (Row data : ds) {
                result = true;
            }
        }
        return result;
    }
}

