/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.application.impl.staff;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.application.staff.ISyncPersonStaffApplication;
import kd.hr.haos.business.domain.service.impl.staff.OrgUseStaffDetailServiceImpl;
import kd.hr.haos.business.domain.service.impl.staff.StaffProjectServiceImpl;
import kd.hr.haos.business.domain.service.impl.staff.SyncPersonStaffServiceImpl;
import kd.hr.haos.business.domain.service.staff.IOrgUseStaffDetailService;
import kd.hr.haos.business.domain.service.staff.IStaffProjectService;
import kd.hr.haos.business.domain.service.staff.ISyncPersonStaffService;
import kd.hr.haos.business.service.staff.bean.PageHelperVO;
import kd.hr.haos.business.service.staff.bean.StaffSyncPersonInfoHelperBo;
import kd.hr.haos.common.constants.staff.OrgStaffConstants;

public class SyncPersonStaffApplicationImpl
implements ISyncPersonStaffApplication,
OrgStaffConstants {
    private static Log LOG = LogFactory.getLog(SyncPersonStaffApplicationImpl.class);
    private ISyncPersonStaffService syncPersonStaffService = new SyncPersonStaffServiceImpl();
    private IOrgUseStaffDetailService iOrgUseStaffDetailService = new OrgUseStaffDetailServiceImpl();
    private IStaffProjectService staffProjectService = new StaffProjectServiceImpl();
    private int progress = 0;

    @Override
    public void doSyncBuAllPerson(Long orgId, Date startDate) {
        LOG.info("start sync person info to staff, orgId = {}", (Object)orgId);
        List<Long> useOrgIdList = this.syncPersonStaffService.queryUseOrgIdListByOrgId(orgId);
        LOG.info("1. get useOrgIdList end, size={}, list={}", (Object)useOrgIdList.size(), useOrgIdList);
        if (CollectionUtils.isEmpty(useOrgIdList)) {
            return;
        }
        this.doSyncBuAllPerson(useOrgIdList, startDate);
        LOG.info("sync end ,orgId = {}", (Object)orgId);
    }

    @Override
    public int getProgress() {
        return this.progress;
    }

    private void doSyncBuAllPerson(List<Long> useOrgIdList, Date startDate) {
        this.iOrgUseStaffDetailService.delByUseOrgIdAndDateList(useOrgIdList, startDate);
        StaffSyncPersonInfoHelperBo syncHelperBo = new StaffSyncPersonInfoHelperBo(startDate);
        boolean flag = true;
        while (flag) {
            PageHelperVO pageHelperVO = this.syncPersonStaffService.getOrgPerson(syncHelperBo, useOrgIdList);
            List<DynamicObject> staffPersonInfos = pageHelperVO.getStaffDimensionDy();
            int pageCount = pageHelperVO.getPageCount();
            if (pageCount < syncHelperBo.getPage()) {
                flag = false;
            }
            LOG.info("staffPersonInfos_count ={}", (Object)staffPersonInfos.size());
            this.syncStaff(staffPersonInfos, false);
        }
    }

    private void syncStaff(List<DynamicObject> staffPersonInfos, boolean fromRevise) {
        if (CollectionUtils.isEmpty(staffPersonInfos)) {
            return;
        }
        List<Long> depEmpIdList = staffPersonInfos.stream().map(dyn -> dyn.getLong("orgperson")).collect(Collectors.toList());
        if (!fromRevise) {
            this.iOrgUseStaffDetailService.delByDepEmpIdListInStaffTYPE(depEmpIdList, Collections.singletonList("1"));
        }
        Map<String, List<DynamicObject>> result = this.staffProjectService.batchCallRuleEngineFromSync(staffPersonInfos);
        List<DynamicObject> matchRuleDyns = result.getOrDefault("match", Lists.newArrayList());
        this.iOrgUseStaffDetailService.delByDepEmpIdListInStaffTYPE(matchRuleDyns.stream().map(dyn -> dyn.getLong("orgperson")).collect(Collectors.toList()), Arrays.asList("1", "3", "4"));
        List<DynamicObject> notMatchRuleDyns = result.getOrDefault("notmatch", Lists.newArrayList());
        DynamicObject[] notMatchRuleDynArr = notMatchRuleDyns.toArray(new DynamicObject[0]);
        List<Long> needAddStaffDepempList = this.syncPersonStaffService.saveToPersonStaffInfo(notMatchRuleDynArr);
        this.iOrgUseStaffDetailService.saveByDepempIdList(needAddStaffDepempList);
    }

    @Override
    public void doSyncByPersonId(List<Long> person, Date startDate, boolean fromRevise) {
        StaffSyncPersonInfoHelperBo syncHelperBo = new StaffSyncPersonInfoHelperBo(startDate);
        List<DynamicObject> staffPersonInfos = this.syncPersonStaffService.getPerson(syncHelperBo, person);
        this.iOrgUseStaffDetailService.delByPersonIdAndDateList(person, startDate);
        this.syncStaff(staffPersonInfos, fromRevise);
    }
}

