/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.application.impl.structproject;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.haos.business.application.impl.structproject.StructConfigBaseDataTypeStrategy;
import kd.hr.haos.business.application.impl.structproject.StructProjectConfigContext;
import kd.hr.hbp.common.util.HRStringUtils;

public class StructConfigEmptyStrategy
extends StructConfigBaseDataTypeStrategy {
    public StructConfigEmptyStrategy(StructProjectConfigContext structProjectConfigContext, String entityType) {
        super(structProjectConfigContext, entityType);
    }

    @Override
    public boolean buildStructConfig() {
        Set propKeySetDiff = (Set)this.params.get("propKeySetDiff");
        if (CollectionUtils.isEmpty((Collection)propKeySetDiff)) {
            return true;
        }
        Iterator iterator = propKeySetDiff.iterator();
        while (iterator.hasNext()) {
            String propKey = (String)iterator.next();
            if (HRStringUtils.isEmpty((String)propKey)) continue;
            Map<Long, List<DynamicObject>> otClassifyStructProjectMap = this.structProjectConfigContext.getOtClassifyStructProjectMap();
            IDataEntityProperty property = this.getDynamicProperty(propKey);
            List<Object> structProjectList = Lists.newArrayListWithExpectedSize((int)16);
            String baseEntityId = "";
            if (!(property instanceof BasedataProp) && !(property instanceof MulBasedataProp) || CollectionUtils.isEmpty(otClassifyStructProjectMap)) continue;
            String string = baseEntityId = property instanceof BasedataProp ? ((BasedataProp)property).getBaseEntityId() : ((MulBasedataProp)property).getBaseEntityId();
            if (property instanceof OrgProp && "01".equals(((OrgProp)property).getOrgFunc())) {
                structProjectList.addAll((Collection)otClassifyStructProjectMap.get(1010L));
            } else {
                structProjectList = super.getStructProjectByBaseDataType(baseEntityId);
            }
            iterator.remove();
            super.buildStructConfigResultMap(propKey, baseEntityId, (List<DynamicObject>)structProjectList);
        }
        return !CollectionUtils.isEmpty((Collection)propKeySetDiff);
    }

    private IDataEntityProperty getDynamicProperty(String propKey) {
        if (HRStringUtils.isEmpty((String)propKey)) {
            return null;
        }
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)this.entityType);
        if (dataEntityType == null) {
            return null;
        }
        Map entityMap = dataEntityType.getAllFields();
        if (propKey.contains(".")) {
            String[] propKeyArr = propKey.split("\\.");
            if (propKeyArr.length < 2) {
                throw new KDBizException("can not find base data entity type!");
            }
            IDataEntityProperty property = (IDataEntityProperty)entityMap.get(propKeyArr[0]);
            if (property instanceof BasedataProp) {
                String baseEntityId = ((BasedataProp)property).getBaseEntityId();
                MainEntityType cascadeDataEntityType = MetadataServiceHelper.getDataEntityType((String)baseEntityId);
                Map cascadePropertyMap = cascadeDataEntityType.getAllFields();
                return (IDataEntityProperty)cascadePropertyMap.get(propKeyArr[1]);
            }
            if (property instanceof EntryProp) {
                DynamicObjectType entryProperty = ((EntryProp)property).getDynamicCollectionItemPropertyType();
                return entryProperty.getProperty(propKeyArr[1]);
            }
            if (property instanceof MulBasedataProp) {
                String baseEntityId = ((MulBasedataProp)property).getBaseEntityId();
                MainEntityType cascadeDataEntityType = MetadataServiceHelper.getDataEntityType((String)baseEntityId);
                return cascadeDataEntityType.getProperty(propKeyArr[1]);
            }
        }
        return (IDataEntityProperty)entityMap.get(propKey);
    }
}

