/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.application.impl.structproject;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.application.impl.structproject.StructProjectConfigContext;
import kd.hr.haos.business.application.structproject.IStructProjectApplication;
import kd.hr.haos.business.domain.repository.adorg.AdOrgRepository;
import kd.hr.haos.business.domain.repository.adorg.AdminOrgStructRepository;
import kd.hr.haos.business.domain.repository.structproject.StructProjectRepository;
import kd.hr.haos.business.domain.service.impl.structproject.StructConfigServiceImpl;
import kd.hr.haos.business.domain.service.impl.structproject.StructProjectServiceImpl;
import kd.hr.haos.business.domain.service.structproject.IStructConfigService;
import kd.hr.haos.business.domain.service.structproject.IStructProjectService;
import kd.hr.haos.business.service.adminorg.AdminOrgHisServiceHelper;
import kd.hr.haos.business.service.otherstruct.OtherStructService;
import kd.hr.haos.business.servicehelper.OrgBatchBillHelper;
import kd.hr.haos.common.constants.structproject.StructProjectConstants;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.collections4.trie.PatriciaTrie;

public class StructProjectApplicationImpl
implements IStructProjectApplication,
StructProjectConstants {
    private static final Log logger = LogFactory.getLog(StructProjectApplicationImpl.class);
    private IStructConfigService structConfigService = new StructConfigServiceImpl();
    private IStructProjectService structProjectService = new StructProjectServiceImpl();
    private AdminOrgStructRepository adminOrgStructRepository = AdminOrgStructRepository.getInstance();
    private StructProjectRepository structProjectRepository = StructProjectRepository.getInstance();

    @Override
    public List<Map<String, Object>> queryStructProConfig(String entityType, String propKey, Long otClassify) {
        return this.queryStructProConfig(entityType, propKey, otClassify, null);
    }

    @Override
    public List<Map<String, Object>> queryStructProConfig(String entityType, String propKey, Long otClassify, String baseDataType) {
        logger.info("queryStructProConfig entityType:{}, propKey:{}, otClassify:{}, baseDataType:{}", new Object[]{entityType, propKey, otClassify, baseDataType});
        List<Object> result = Lists.newArrayListWithExpectedSize((int)16);
        if (HRStringUtils.isEmpty((String)entityType)) {
            logger.info("entityType can not be empty!");
            return result;
        }
        if (HRStringUtils.isEmpty((String)baseDataType) && HRStringUtils.isEmpty((String)propKey)) {
            logger.info("propKey and baseDataType can not be empty in the same time!");
            return result;
        }
        HashMap structConfigParam = Maps.newHashMapWithExpectedSize((int)16);
        HashMap param = Maps.newHashMapWithExpectedSize((int)16);
        if (!HRStringUtils.isEmpty((String)baseDataType)) {
            param.put("baseDataType", Collections.singletonList(baseDataType));
        }
        if (!HRStringUtils.isEmpty((String)propKey)) {
            param.put("propkey", Collections.singletonList(propKey));
        }
        structConfigParam.put(entityType, param);
        StructProjectConfigContext structProjectConfigContext = new StructProjectConfigContext(structConfigParam);
        structProjectConfigContext.doGetStructConfigInfo();
        result = structProjectConfigContext.getStructConfigResult();
        logger.info("queryStructProConfig result:{}", (Object)JSON.toJSONString((Object)result));
        return result;
    }

    @Override
    public List<Map<String, Object>> batchQueryStructProConfig(Map<String, Map<String, Object>> structConfigParam) {
        logger.info("batchQueryStructProConfig structConfigParam:{}", (Object)JSON.toJSONString(structConfigParam));
        List<Object> result = Lists.newArrayListWithExpectedSize((int)16);
        if (CollectionUtils.isEmpty(structConfigParam)) {
            return result;
        }
        StructProjectConfigContext structProjectConfigContext = new StructProjectConfigContext(structConfigParam);
        structProjectConfigContext.doGetStructConfigInfo();
        result = structProjectConfigContext.getStructConfigResult();
        logger.info("batchQueryStructProConfig result:{}", (Object)JSON.toJSONString((Object)result));
        return result;
    }

    @Override
    public Map<String, Map<String, Object>> queryStructInfoByProId(List<Long> orgIds, Date queryDate, Long structProjectId, boolean needStructLongNameAndNumber) {
        logger.info("queryStructInfoByProId orgIds:{}, structProjectId:{}, needStructLongNameAndNumber:{}", new Object[]{JSON.toJSONString(orgIds), structProjectId, needStructLongNameAndNumber});
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        if (CollectionUtils.isEmpty(orgIds) || structProjectId == null) {
            return result;
        }
        if (queryDate == null) {
            queryDate = new Date();
        }
        Map<Object, Object> orgLongNameMap = Maps.newHashMapWithExpectedSize((int)16);
        if (needStructLongNameAndNumber) {
            orgLongNameMap = OrgBatchBillHelper.getOrgLongName(new HashSet<Long>(orgIds), queryDate, structProjectId.toString());
        }
        String selectFields = "id, adminorg, structproject, structlongnumber,parentorg.id";
        DynamicObject[] structInfoArr = this.adminOrgStructRepository.queryStructHisByIdAndProjId(selectFields, orgIds, queryDate, structProjectId);
        Map<Long, DynamicObject> adminOrgInfoMap = this.getAdminOrgInfoMapFromStruct(structInfoArr, queryDate);
        for (DynamicObject structInfo : structInfoArr) {
            long adminOrgId = structInfo.getLong("adminorg.id");
            DynamicObject adminOrgInfo = adminOrgInfoMap.get(adminOrgId);
            HashMap structInfoMap = Maps.newHashMapWithExpectedSize((int)16);
            if (adminOrgInfo != null) {
                structInfoMap.put("boid", adminOrgId);
                structInfoMap.put("number", adminOrgInfo.get("number"));
                structInfoMap.put("name", adminOrgInfo.get("name"));
                structInfoMap.put("id", adminOrgInfo.get("id"));
            }
            structInfoMap.put("parentorg", structInfo.get("parentorg.id"));
            structInfoMap.put("structproject", structInfo.get("structproject.id"));
            structInfoMap.put("structlongnumber", structInfo.get("structlongnumber"));
            structInfoMap.put("longname", orgLongNameMap.getOrDefault(adminOrgId, ""));
            result.put(String.valueOf(adminOrgId), structInfoMap);
        }
        return result;
    }

    private Map<Long, DynamicObject> getAdminOrgInfoMapFromStruct(DynamicObject[] structInfoArr, Date queryDate) {
        Set<Long> adminOrgSet = Arrays.stream(structInfoArr).map(structInfo -> structInfo.getLong("adminorg.id")).collect(Collectors.toSet());
        DynamicObject[] adminOrgInfoArr = AdOrgRepository.getInstance().queryOriginalByBoAndEffDate("id, name, number, enable, boid", adminOrgSet, queryDate);
        return Arrays.stream(adminOrgInfoArr).collect(Collectors.toMap(adminOrgInfo -> adminOrgInfo.getLong("boid"), adminOrgInfo -> adminOrgInfo));
    }

    @Override
    public Map<String, Map<String, Object>> queryStructInfoByProIdAndLevel(List<Long> orgIds, Date queryDate, Long structProjectId, Integer level) {
        logger.info("queryStructInfoByProIdAndLevel orgIds:{}, queryDate:{}, level:{}", new Object[]{JSON.toJSONString(orgIds), queryDate, level});
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        if (structProjectId == null || structProjectId == 0L) {
            return result;
        }
        if (queryDate == null) {
            queryDate = new Date();
        }
        ArrayList structLongNumbers = Lists.newArrayListWithExpectedSize((int)16);
        List<Object> structHisInfoConSubList = Lists.newArrayListWithExpectedSize((int)16);
        String selectField = "id, structlongnumber, level, adminorg, parentorg.id";
        if (!CollectionUtils.isEmpty(orgIds)) {
            DynamicObject[] structHisInfoArr = this.adminOrgStructRepository.queryStructHisByIdAndProjId(selectField, orgIds, queryDate, structProjectId);
            if (structHisInfoArr == null || structHisInfoArr.length == 0) {
                return result;
            }
            List<String> structLongNumberList = Arrays.stream(structHisInfoArr).map(structHisInfo -> structHisInfo.getString("structlongnumber")).collect(Collectors.toList());
            structLongNumbers.addAll(AdminOrgHisServiceHelper.filterUnNecessaryStructLongNumber(structLongNumberList));
            DynamicObject[] structInfoConSubArr = this.adminOrgStructRepository.queryHisByStructLongNumberAndProjId(selectField, structLongNumbers, queryDate, structProjectId);
            PatriciaTrie patriciaTrie = new PatriciaTrie();
            for (DynamicObject subStructHisInfo : structInfoConSubArr) {
                patriciaTrie.put((Object)subStructHisInfo.getString("structlongnumber"), (Object)subStructHisInfo);
            }
            for (DynamicObject structHisInfo2 : structHisInfoArr) {
                patriciaTrie.prefixMap((Object)structHisInfo2.getString("structlongnumber")).values().stream().filter(dy -> structHisInfo2.getInt("level") + level >= dy.getInt("level")).forEach(structHisInfoConSubList::add);
            }
        } else {
            long id;
            DynamicObject rootStructInfo;
            DynamicObject structProject = this.structProjectRepository.queryByPk("id, rootorg", structProjectId);
            if (structProject != null && (rootStructInfo = this.adminOrgStructRepository.queryCurrOneByOrgId("structlongnumber", id = structProject.getLong("rootorg.id"), structProjectId)) != null) {
                QFilter structLongNumberFilter = new QFilter("structlongnumber", "like", (Object)(rootStructInfo.getString("structlongnumber") + "%"));
                structLongNumberFilter.and("level", "<=", (Object)level);
                DynamicObject[] structInfoConSubArr = this.adminOrgStructRepository.queryHisByProjIdAndFilter(selectField, queryDate, structProjectId, structLongNumberFilter);
                structHisInfoConSubList = Arrays.stream(structInfoConSubArr).collect(Collectors.toList());
            }
        }
        Map<Long, DynamicObject> adminOrgInfoMapFromStruct = this.getAdminOrgInfoMapFromStruct(structHisInfoConSubList.toArray(new DynamicObject[0]), queryDate);
        for (DynamicObject structHisInfo3 : structHisInfoConSubList) {
            long adminOrgId = structHisInfo3.getLong("adminorg.id");
            DynamicObject adminOrgInfo = adminOrgInfoMapFromStruct.get(adminOrgId);
            HashMap structInfoMap = Maps.newHashMapWithExpectedSize((int)16);
            if (adminOrgInfo != null) {
                structInfoMap.put("number", adminOrgInfo.getString("number"));
                structInfoMap.put("name", adminOrgInfo.getString("name"));
                structInfoMap.put("enable", adminOrgInfo.getString("enable"));
            }
            structInfoMap.put("boid", adminOrgId);
            structInfoMap.put("parentorg", structHisInfo3.getLong("parentorg.id"));
            structInfoMap.put("structlongnumber", structHisInfo3.getString("structlongnumber"));
            result.put(String.valueOf(adminOrgId), structInfoMap);
        }
        return result;
    }

    @Override
    public Map<String, Map<String, Object>> queryStructProjectById(List<Long> structProjectIds) {
        logger.info("queryStructProjectById structProjectIds:{}", (Object)JSON.toJSONString(structProjectIds));
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        DynamicObject[] structProjectInfoArr = CollectionUtils.isEmpty(structProjectIds) ? this.structProjectService.queryAllStructProject() : this.structProjectService.queryStructProjectById(structProjectIds);
        if (structProjectInfoArr == null || structProjectInfoArr.length == 0) {
            return result;
        }
        for (DynamicObject structProject : structProjectInfoArr) {
            HashMap structProjectMap = Maps.newHashMapWithExpectedSize((int)16);
            long structProjectId = structProject.getLong("id");
            structProjectMap.put("id", structProjectId);
            structProjectMap.put("number", structProject.getString("number"));
            structProjectMap.put("name", structProject.get("name"));
            structProjectMap.put("otclassify", structProject.getLong("otclassify.id"));
            structProjectMap.put("org", structProject.getLong("org.id"));
            structProjectMap.put("rootorg", structProject.getLong("rootorg.id"));
            structProjectMap.put("isincludevirtualorg", structProject.getBoolean("isincludevirtualorg"));
            structProjectMap.put("issyspreset", structProject.get("issyspreset"));
            structProjectMap.put("description", structProject.get("description"));
            structProjectMap.put("enable", structProject.get("enable"));
            result.put(String.valueOf(structProjectId), structProjectMap);
        }
        return result;
    }

    @Override
    public void doWithStructModify(DynamicObject structProject) {
        Long oldRootOrgId = this.structProjectService.getOldRootOrgId(structProject.getLong("id"));
        Long newRootOrgId = structProject.getLong("rootorg.id");
        String rootType = structProject.getString("roottype");
        if (!oldRootOrgId.equals(newRootOrgId)) {
            this.structProjectService.doWithStructModify(structProject, 1010L);
        }
        if ("2".equals(rootType) && oldRootOrgId.equals(newRootOrgId)) {
            long orgId = structProject.getLong("rootorg.id");
            DynamicObject[] dynamicObjects = AdOrgRepository.getInstance().loadByIds(Collections.singleton(orgId));
            if (dynamicObjects != null && dynamicObjects.length >= 1) {
                Date rooteffdt;
                Date establishmentdate = dynamicObjects[0].getDate("establishmentdate");
                if (establishmentdate.compareTo(rooteffdt = structProject.getDate("rooteffdt")) != 0) {
                    this.structProjectService.doWithStructModify(structProject, 1020L);
                } else {
                    this.structProjectService.doWithStructModify(structProject, 0L);
                }
            }
        } else if ("1".equals(rootType) && oldRootOrgId.equals(newRootOrgId)) {
            Date newDate;
            long structProjectId = structProject.getLong("id");
            DynamicObject structInDB = StructProjectRepository.getInstance().queryOneByStructProjectId("id, effdt", structProjectId);
            Date oldDate = structInDB.getDate("effdt");
            if (oldDate.compareTo(newDate = structProject.getDate("effdt")) != 0) {
                this.structProjectService.doWithStructModify(structProject, 1020L);
            }
        }
    }

    @Override
    public void doWithAddNew(DynamicObject structProject) {
        this.structProjectService.doWithAddNew(structProject);
    }

    @Override
    public Boolean isRootOrgMaintain(DynamicObject structProject) {
        return this.structProjectService.isRootOrgMaintain(structProject);
    }

    @Override
    public void doWithEnable(DynamicObject[] dataEntities) {
        this.structProjectService.doWithEnable(dataEntities);
    }

    @Override
    public void doWithDelete(DynamicObject[] dataEntities) {
        if (dataEntities != null && dataEntities.length > 0) {
            Set<Long> structProjectIds = Arrays.stream(dataEntities).map(dyn -> dyn.getLong("id")).collect(Collectors.toSet());
            new OtherStructService().deleteByStructProject(structProjectIds);
            Long[] ids = structProjectIds.toArray(new Long[0]);
            this.structProjectService.delete(ids);
        }
    }

    @Override
    public Map<String, Object> queryRootByStructId(Long structProjectId, Date queryDate) {
        String selectFields;
        DynamicObject structInfo;
        logger.info("queryStructProjectRootByStructId , structProjectId:{}", (Object)structProjectId);
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        if (structProjectId == null) {
            return result;
        }
        if (queryDate == null) {
            queryDate = new Date();
        }
        if ((structInfo = this.adminOrgStructRepository.queryRootByStructId(selectFields = "id, adminorg, structproject", structProjectId, queryDate)) != null) {
            result.put("id", structInfo.getLong("adminorg"));
        }
        return result;
    }
}

