/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.application.impl.structproject;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.haos.business.application.impl.structproject.StructConfigBaseDataTypeStrategy;
import kd.hr.haos.business.application.impl.structproject.StructConfigDefaultStrategy;
import kd.hr.haos.business.application.impl.structproject.StructConfigEmptyStrategy;
import kd.hr.haos.business.application.impl.structproject.StructProjectConfigQueryService;
import kd.hr.haos.business.domain.repository.structproject.StructProjectRepository;
import kd.hr.haos.business.domain.service.impl.orgteam.OtClassifyServiceImpl;
import kd.hr.haos.business.domain.service.impl.structproject.StructConfigServiceImpl;
import kd.hr.haos.business.domain.service.orgteam.IOtClassifyService;
import kd.hr.haos.business.domain.service.structproject.IStructConfigService;

public class StructProjectConfigContext {
    private static Map<String, List<String>> STRUCT_PROJECT_ENTITY = Maps.newHashMapWithExpectedSize((int)16);
    private Map<String, DynamicObject> entityTypeDynMap = Maps.newHashMapWithExpectedSize((int)16);
    private Map<String, Map<String, Object>> entityTypeParamMap;
    private Map<Long, List<DynamicObject>> otClassifyStructProjectMap;
    private Map<Long, DynamicObject> otClassifyInfoMap;
    private List<Map<String, Object>> structConfigResult = Lists.newArrayListWithExpectedSize((int)16);
    private IStructConfigService structConfigService = new StructConfigServiceImpl();
    private StructProjectRepository structProjectRepository = StructProjectRepository.getInstance();
    private IOtClassifyService otClassifyService = new OtClassifyServiceImpl();

    public StructProjectConfigContext(Map<String, Map<String, Object>> entityTypeParamMap) {
        this.entityTypeParamMap = entityTypeParamMap;
        this.prepareConfigData();
    }

    private void prepareConfigData() {
        String selectField = "entitytype, issyspreset, entryentity, entryentity.isallowmodify, entryentity.propkey, entryentity.teamtype, entryentity.otclassify, subentryentity.structproject, subentryentity.subentryissyspreset";
        Set<String> entityTypes = this.entityTypeParamMap.keySet();
        DynamicObject[] structConfigInfoArr = this.structConfigService.queryStructConfigByEntityType(selectField, entityTypes);
        if (structConfigInfoArr.length != 0) {
            this.entityTypeDynMap = Arrays.stream(structConfigInfoArr).collect(Collectors.toMap(structConfigInfo -> structConfigInfo.getString("entitytype.number"), structConfigInfo -> structConfigInfo));
        }
        DynamicObject[] otClassifyInfoArr = this.otClassifyService.queryOriginalOtClassifyById("id, teamtype.id, teamtype.iscustom", null);
        this.otClassifyInfoMap = Arrays.stream(otClassifyInfoArr).collect(Collectors.toMap(otClassifyInfo -> otClassifyInfo.getLong("id"), otClassifyInfo -> otClassifyInfo));
        selectField = "id, name, number, otclassify, relyonstructproject, enable, issyspreset, istoallareas";
        DynamicObject[] structProjectArr = this.structProjectRepository.queryStructProjectByOtClassify(selectField, null);
        this.otClassifyStructProjectMap = Arrays.stream(structProjectArr).collect(Collectors.groupingBy(structProject -> structProject.getLong("otclassify.id")));
    }

    public void doGetStructConfigInfo() {
        Set<Map.Entry<String, Map<String, Object>>> entityTypeParamEntries = this.entityTypeParamMap.entrySet();
        for (Map.Entry<String, Map<String, Object>> entityTypeParamEntry : entityTypeParamEntries) {
            String entityType = entityTypeParamEntry.getKey();
            DynamicObject structConfigInfo = this.entityTypeDynMap.get(entityType);
            StructProjectConfigQueryService structProjectConfigQueryService = this.getConfigQueryService(entityType, structConfigInfo);
            structProjectConfigQueryService.invokeStructConfigChain();
        }
    }

    public StructProjectConfigQueryService getConfigQueryService(String entityType, DynamicObject structConfigInfo) {
        StructConfigDefaultStrategy structConfigDefaultStrategy = new StructConfigDefaultStrategy(this, entityType);
        structConfigDefaultStrategy.setStructConfigInfo(structConfigInfo);
        StructConfigEmptyStrategy structConfigEmptyStrategy = new StructConfigEmptyStrategy(this, entityType);
        StructConfigBaseDataTypeStrategy structConfigBaseDataTypeStrategy = new StructConfigBaseDataTypeStrategy(this, entityType);
        structConfigDefaultStrategy.setNextConfigQueryService(structConfigEmptyStrategy);
        structConfigEmptyStrategy.setNextConfigQueryService(structConfigBaseDataTypeStrategy);
        return structConfigDefaultStrategy;
    }

    public Map<String, Map<String, Object>> getEntityTypeParamMap() {
        return this.entityTypeParamMap;
    }

    public Map<Long, List<DynamicObject>> getOtClassifyStructProjectMap() {
        return this.otClassifyStructProjectMap;
    }

    public List<Map<String, Object>> getStructConfigResult() {
        return this.structConfigResult;
    }

    public Map<Long, DynamicObject> getOtClassifyInfoMap() {
        return this.otClassifyInfoMap;
    }

    public Map<String, List<String>> getStructEntityMapper() {
        return STRUCT_PROJECT_ENTITY;
    }

    static {
        ArrayList entityForAdminOrg = Lists.newArrayListWithExpectedSize((int)16);
        entityForAdminOrg.add("haos_adminorghr");
        entityForAdminOrg.add("haos_adminorghishr");
        entityForAdminOrg.add("haos_adminorgf7");
        STRUCT_PROJECT_ENTITY.put("adminorg", entityForAdminOrg);
        ArrayList entityForProjectTeam = Lists.newArrayListWithExpectedSize((int)16);
        entityForProjectTeam.add("haos_projectteamhr");
        entityForProjectTeam.add("haos_projteambaseinfo");
        STRUCT_PROJECT_ENTITY.put("projteam", entityForProjectTeam);
        ArrayList entityForOrgTeam = Lists.newArrayListWithExpectedSize((int)16);
        entityForOrgTeam.add("haos_orgteamf7hr");
        entityForOrgTeam.add("haos_orgteamf7nopermhr");
        entityForOrgTeam.add("haos_adminorgteam");
        STRUCT_PROJECT_ENTITY.put("orgteam", entityForOrgTeam);
    }
}

