/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.domain.repository.adorg;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.haos.business.domain.repository.HAOSBaseRepository;
import kd.hr.haos.business.domain.repository.QFilterHelper;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynKey;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;

public class AdOrgRepository
extends HAOSBaseRepository {
    private static final HRBaseServiceHelper AD_LEFTJOIN_SORT_HELPER = new HRBaseServiceHelper("haos_adminsortcodequery");

    private AdOrgRepository() {
        super(AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey());
    }

    public static AdOrgRepository getInstance() {
        return Instance.INSTANCE;
    }

    @Deprecated
    public DynamicObject[] queryOriginalArray(String fields, QFilter[] qFilters) {
        return this.serviceHelper.queryOriginalArray(fields, qFilters);
    }

    public DynamicObject[] load(QFilter qFilter) {
        return this.serviceHelper.loadDynamicObjectArray(new QFilter[]{qFilter, QFilterHelper.createValidHisVersionFilter(), QFilterHelper.createInitFinishedFilter()});
    }

    public DynamicObject loadByBoIdAndDate(Long boId, Date date) {
        QFilter qFilter = new QFilter("boid", "=", (Object)boId);
        qFilter.and("bsed", "<=", (Object)date).and("bsled", ">=", (Object)date);
        qFilter.and(QFilterHelper.createValidHisVersionFilter()).and(QFilterHelper.createInitFinishedFilter());
        return this.serviceHelper.loadDynamicObject(qFilter);
    }

    public DynamicObject[] queryByBoIdAndDataStatus(String fields, Long orgId, List<String> dataStatusList) {
        QFilter qFilter = new QFilter("boid", "in", (Object)orgId);
        qFilter.and("datastatus", "in", dataStatusList);
        return this.serviceHelper.query(fields, qFilter.toArray());
    }

    public DynamicObjectCollection queryOrgColByBoDate(Set<Long> orgIdSet, Date startDate, Date endDate) {
        QFilter qFilter = new QFilter("boid", "in", orgIdSet);
        qFilter.and(QFilterHelper.createValidHisVersionFilter()).and(QFilterHelper.createInitFinishedFilter()).and(QFilterHelper.createOverlapsFilter(startDate, endDate));
        return this.serviceHelper.queryOriginalCollection("id,boid,parentorg.id,structnumber,bsed,bsled,belongcompany.id,adminorgtype.adminorgtypestd.id,index", qFilter.toArray());
    }

    public DynamicObject[] queryHisOrgColByBoDate(String selectFields, Set<Long> orgIdSet, Date startDate, Date endDate) {
        QFilter qFilter = new QFilter("boid", "in", orgIdSet);
        qFilter.and(QFilterHelper.createValidHisVersionFilter()).and(QFilterHelper.createInitFinishedFilter()).and(QFilterHelper.createOverlapsFilter(startDate, endDate));
        return this.serviceHelper.query(selectFields, qFilter.toArray());
    }

    public DynamicObject[] queryAllHisOriginalArrayByBo(String selectFields) {
        return this.serviceHelper.queryOriginalArray(selectFields, new QFilter[]{QFilterHelper.createValidHisVersionFilter(), QFilterHelper.createInitFinishedFilter()});
    }

    public DynamicObject[] queryAllHisOriginalArrayByBo(String selectFields, Set<Long> boSet) {
        QFilter boIdFilter = new QFilter("boid", "in", boSet);
        return this.serviceHelper.queryOriginalArray(selectFields, new QFilter[]{boIdFilter, QFilterHelper.createValidHisVersionFilter(), QFilterHelper.createInitFinishedFilter()});
    }

    @Override
    public DynamicObject[] queryPerformanceUpdateFields(Collection<Long> adminOrgIds) {
        QFilter boIdFilter = new QFilter("boid", "in", adminOrgIds);
        return this.serviceHelper.query("boid, level, structlongnumber, sortcode", new QFilter[]{boIdFilter, QFilterHelper.createEffectingDataFilter()});
    }

    public DynamicObject[] queryOrgInfoByBoId(String selectFields, List<Long> boIds) {
        QFilter filter = new QFilter("iscurrentversion", "=", (Object)"1");
        filter.and("boid", "in", boIds);
        return this.serviceHelper.query(selectFields, new QFilter[]{filter});
    }

    public DynamicObject[] queryArrayOrderBy(String fields, QFilter[] qFilters, String orderBy) {
        return AD_LEFTJOIN_SORT_HELPER.query(fields, qFilters, orderBy);
    }

    public static DynamicObject[] queryAdminHisInfo(QFilter DataFilter, Date date) {
        QFilter dataStatusFilter = new QFilter("datastatus", "in", Arrays.asList(EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()));
        QFilter effectDateFilter = new QFilter("bsed", "<=", (Object)date);
        QFilter loseEffectDateFilter = new QFilter("bsled", ">=", (Object)date);
        QFilter currentVersionFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0'));
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        HRBaseServiceHelper adminOrgServiceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        return adminOrgServiceHelper.loadDynamicObjectArray("haos_adminorgdetail", new QFilter[]{DataFilter, dataStatusFilter, effectDateFilter, loseEffectDateFilter, currentVersionFilter, initStatusFilter});
    }

    public static DynamicObject[] queryAdminHisInfo(String selectFiled, QFilter DataFilter, Date date) {
        QFilter dataStatusFilter = new QFilter("datastatus", "in", Arrays.asList(EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()));
        QFilter effectDateFilter = new QFilter("bsed", "<=", (Object)date);
        QFilter loseEffectDateFilter = new QFilter("bsled", ">=", (Object)date);
        QFilter currentVersionFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0'));
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        HRBaseServiceHelper adminOrgServiceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        return adminOrgServiceHelper.queryOriginalArray(selectFiled, new QFilter[]{DataFilter, dataStatusFilter, effectDateFilter, loseEffectDateFilter, currentVersionFilter, initStatusFilter});
    }

    public DynamicObject[] loadAdminOrg(String fields, List<QFilter> filterList, String orderBy, int pageIndex, int pageSize) {
        QFilter[] filters = new QFilter[]{QFilterHelper.createHisCurrentDataFilter(), QFilterHelper.createInitFinishedFilter()};
        filters = QFilterHelper.convert2Array(filters, QFilterHelper.convert2Array(filterList));
        return BusinessDataServiceHelper.load((String)this.serviceHelper.getEntityName(), (String)fields, (QFilter[])filters, (String)orderBy, (int)pageIndex, (int)pageSize);
    }

    public DynamicObject[] loadAdminOrgByOneLevel(String fields, long adOrgBo, List<QFilter> filterList, String orderBy, int pageIndex, int pageSize) {
        QFilter parentFilter = new QFilter("parentorg.id", "=", (Object)adOrgBo);
        QFilter[] filters = new QFilter[]{parentFilter, QFilterHelper.createHisCurrentDataFilter(), QFilterHelper.createInitFinishedFilter()};
        filters = QFilterHelper.convert2Array(filters, QFilterHelper.convert2Array(filterList));
        return BusinessDataServiceHelper.load((String)this.serviceHelper.getEntityName(), (String)fields, (QFilter[])filters, (String)orderBy, (int)pageIndex, (int)pageSize);
    }

    public DynamicObject[] queryOriginalAdminOrgByParent(String fields, List<Long> adOrgBoList, List<QFilter> filterList) {
        QFilter parentFilter = new QFilter("parentorg.id", "in", adOrgBoList);
        QFilter[] filters = new QFilter[]{parentFilter, QFilterHelper.createHisCurrentDataFilter(), QFilterHelper.createInitFinishedFilter()};
        filters = QFilterHelper.convert2Array(filters, QFilterHelper.convert2Array(filterList));
        return this.serviceHelper.queryOriginalArray(fields, filters);
    }

    public DynamicObject[] loadQueryEntityByNameOrNumberOrderBySortCode(String selectFields, String nameOrNumber, List<QFilter> filterList, int pageIndex, int pageSize) {
        QFilter nameOrNumberFilter = new QFilter("name", "like", (Object)(nameOrNumber + "%")).or("number", "like", (Object)(nameOrNumber + "%"));
        QFilter sortCodeDataFilter = new QFilter("haos_orgsortcode.iscurrentversion", "=", (Object)"0");
        QFilter[] filters = QFilterHelper.convert2Array(new QFilter[]{nameOrNumberFilter, QFilterHelper.createInitFinishedFilter(), QFilterHelper.createValidHisCurrentDataFilter(), sortCodeDataFilter}, QFilterHelper.convert2Array(filterList));
        return BusinessDataServiceHelper.load((String)AD_LEFTJOIN_SORT_HELPER.getEntityName(), (String)selectFields, (QFilter[])filters, (String)"haos_orgsortcode.sortcode", (int)pageIndex, (int)pageSize);
    }

    public DynamicObject[] queryBaseFieldAdminOrgByIdList(List<Long> idList) {
        QFilter idFilter = new QFilter("id", "in", idList);
        return this.serviceHelper.queryOriginalArray("id, boid, number, name, enable", new QFilter[]{idFilter});
    }

    public DynamicObject[] queryOriginalByBoAndEffDate(String fields, Collection<Long> boCollection, Date effDate) {
        QFilter boFilter = new QFilter("boid", "in", boCollection);
        QFilter hisFilter = QFilterHelper.createValidHisVersionFilterByOnePoint(effDate);
        return this.serviceHelper.queryOriginalArray(fields, new QFilter[]{boFilter, hisFilter});
    }

    public DynamicObject[] queryOriginalByBoAndEffectData(String selectFields, Set<Long> boSet, Date effectDate) {
        QFilter boFilter = new QFilter("boid", "in", boSet);
        QFilter effectFilter = QFilterHelper.createValidHisVersionFilter(effectDate);
        return this.serviceHelper.queryOriginalArray(selectFields, new QFilter[]{boFilter, effectFilter});
    }

    public List<Long> queryExistIds(Collection<Long> ids) {
        QFilter filter = new QFilter("id", "in", ids);
        DynamicObject[] existData = this.serviceHelper.queryOriginalArray("id", new QFilter[]{filter});
        return Arrays.stream(existData).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
    }

    public Date getMinDateByBoId(Long boId) {
        if (boId == null || boId == 0L) {
            return null;
        }
        QFilter qFilter = new QFilter("boid", "=", (Object)boId);
        qFilter.and(QFilterHelper.createValidHisVersionFilter()).and(QFilterHelper.createInitFinishedFilter());
        DynamicObjectCollection col = this.serviceHelper.queryOriginalCollection("bsed", qFilter.toArray(), "bsed asc");
        return col == null || col.size() == 0 ? null : ((DynamicObject)col.get(0)).getDate("bsed");
    }

    public DynamicObject[] queryOriginalHisByStructNumber(String selectField, Collection<String> structNumbers, Date date) {
        QFilter filter = new QFilter("structnumber", "in", structNumbers);
        filter.and(QFilterHelper.createValidHisVersionFilterByOnePoint(date)).and(QFilterHelper.createInitFinishedFilter());
        return this.serviceHelper.query(selectField, new QFilter[]{filter});
    }

    public DynamicObject[] loadVirtualColByBo(Set<Long> boSet, Date startDate) {
        QFilter qFilter = new QFilter("boid", "in", boSet);
        qFilter.and("isvirtualorg", "=", (Object)Boolean.TRUE);
        qFilter.and(QFilterHelper.createInitFinishedFilter());
        qFilter.and("datastatus", "in", Arrays.asList(EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus(), EnumHisDataVersionStatus.TEMP.getStatus()));
        if (startDate != null) {
            qFilter.and("bsled", ">=", (Object)startDate);
        }
        return this.serviceHelper.loadDynamicObjectArray(qFilter.toArray());
    }

    public void deleteVirtualOrgByOrgSet(Set<Long> orgSet) {
        QFilter qFilter = new QFilter("boid", "in", orgSet);
        qFilter.and("isvirtualorg", "=", (Object)Boolean.TRUE);
        this.serviceHelper.deleteByFilter(qFilter.toArray());
    }

    public void deleteTempVirtualOrg(Set<Long> orgSet) {
        QFilter qFilter = new QFilter("boid", "in", orgSet);
        qFilter.and("isvirtualorg", "=", (Object)Boolean.TRUE);
        qFilter.and("datastatus", "=", (Object)EnumHisDataVersionStatus.TEMP.getStatus());
        this.serviceHelper.deleteByFilter(qFilter.toArray());
    }

    public DynamicObjectCollection queryColByNumber(String selectField, Set<String> numberSet, Set<Long> boIdSet) {
        QFilter qFilter = new QFilter("number", "in", numberSet);
        qFilter.and("boid", "not in", boIdSet);
        return this.serviceHelper.queryOriginalCollection(selectField, new QFilter[]{qFilter, QFilterHelper.createValidHisVersionFilter(), QFilterHelper.createInitFinishedFilter()});
    }

    public boolean existsVirtualByOrgSet(Set<Long> orgSet) {
        QFilter qFilter = new QFilter("id", "in", orgSet);
        qFilter.and("isvirtualorg", "=", (Object)Boolean.TRUE);
        return this.serviceHelper.isExists(qFilter);
    }

    public static DynamicObject[] getOrgDyArrByNumbers(List<String> numbers, Date bsed) {
        QFilter numberFilter = new QFilter("number", "in", numbers);
        QFilter dataStatusfilter = new QFilter("datastatus", "in", (Object)new String[]{"1", "2"});
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter iscurrentversionFilter = new QFilter("iscurrentversion", "in", (Object)new String[]{"1", "0"});
        QFilter initstatusFilter = new QFilter("initstatus", "=", (Object)"2");
        QFilter bsedFilter = new QFilter("bsled", ">=", (Object)bsed);
        HRBaseServiceHelper adminOrgServiceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        DynamicObject[] dysInDB = adminOrgServiceHelper.queryOriginalArray("boid, id, number, bsed, bsled", new QFilter[]{numberFilter, dataStatusfilter, initstatusFilter, iscurrentversionFilter, enableFilter, bsedFilter});
        return dysInDB;
    }

    public DynamicObject[] queryOriginalByStructNumber(String selectField, Set<String> structNumbers) {
        QFilter filter = new QFilter("structnumber", "in", structNumbers);
        filter.and(QFilterHelper.createValidHisCurrentDataFilter());
        return this.serviceHelper.query(selectField, new QFilter[]{filter});
    }

    public DynamicObject[] queryOriginalEffAndTempByStructNumber(String selectField, Set<String> structNumbers) {
        QFilter filter = new QFilter("structnumber", "in", structNumbers);
        filter.and(QFilterHelper.createCurrentVersionDataFilter());
        return this.serviceHelper.query(selectField, new QFilter[]{filter});
    }

    public DynamicObjectCollection queryColByNumber(String selectField, Set<String> numberSet) {
        QFilter qFilter = new QFilter("number", "in", numberSet);
        return this.serviceHelper.queryOriginalCollection(selectField, new QFilter[]{qFilter, QFilterHelper.createEffectingHisVersionFilter(), QFilterHelper.createInitFinishedFilter()});
    }

    public DynamicObject[] loadByBoIdList(String selectField, List<Long> boId) {
        QFilter qFilter = new QFilter("boid", "in", boId);
        qFilter.and(QFilterHelper.createHisCurrentDataFilter());
        return this.serviceHelper.query(selectField, new QFilter[]{qFilter});
    }

    public DynamicObject[] queryAdminBoIdByIds(List<Long> ids) {
        QFilter qFilter = new QFilter("id", "in", ids);
        return this.serviceHelper.query("boid", new QFilter[]{qFilter});
    }

    private static class Instance {
        private static AdOrgRepository INSTANCE = new AdOrgRepository();

        private Instance() {
        }
    }
}

