/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.domain.repository.adorg;

import java.util.Collection;
import java.util.Date;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.business.domain.repository.HAOSBaseRepository;
import kd.hr.haos.business.domain.repository.QFilterHelper;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynKey;

public class AdOrgSortCodeRepository
extends HAOSBaseRepository {
    private AdOrgSortCodeRepository() {
        super(AdminOrgHisDynKey.ADMIN_SORT_KEY.getDynKey());
    }

    public static AdOrgSortCodeRepository getInstance() {
        return Instance.INSTANCE;
    }

    public DynamicObject[] queryAllHisOriginalArrayByOrgId(String selectFields) {
        return this.serviceHelper.queryOriginalArray(selectFields, new QFilter[]{QFilterHelper.createValidHisVersionFilter(), QFilterHelper.createInitFinishedFilter()});
    }

    public DynamicObjectCollection querySortCodeColByBoDate(Set<Long> boIdSet, Date startDate, Date endDate) {
        QFilter qFilter = new QFilter("adminorg", "in", boIdSet);
        qFilter.and(QFilterHelper.createValidHisVersionFilter()).and(QFilterHelper.createInitFinishedFilter()).and(QFilterHelper.createOverlapsFilter(startDate, endDate));
        return this.serviceHelper.queryOriginalCollection("id,sortcode,adminorg.id,bsed,bsled", qFilter.toArray());
    }

    @Override
    public DynamicObject[] queryPerformanceUpdateFields(Collection<Long> adminOrgIds) {
        QFilter orgFilter = new QFilter("adminorg", "in", adminOrgIds);
        return this.serviceHelper.queryOriginalArray("adminorg as adminorg.id, sortcode", new QFilter[]{orgFilter, QFilterHelper.createValidHisCurrentDataFilter()});
    }

    private static class Instance {
        private static AdOrgSortCodeRepository INSTANCE = new AdOrgSortCodeRepository();

        private Instance() {
        }
    }
}

