/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.domain.repository.customstruct;

import com.alibaba.fastjson.JSONArray;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.QFilterHelper;
import kd.hr.haos.business.domain.repository.customstruct.NumberPrefixRepository;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.HisBaseBo;
import kd.hr.hbp.business.domain.model.newhismodel.enable.HisEnableParamBo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class CustomStructHelper {
    private static final int MAX_INDEX = 99999;

    public static void disableOrEnableByBoIds(List<Long> boIds, String entityNumber, boolean disable) {
        if (CollectionUtils.isEmpty(boIds)) {
            return;
        }
        HisBaseBo hisBaseBo = new HisBaseBo();
        hisBaseBo.setEntityNumber(entityNumber);
        hisBaseBo.setBoIdList(boIds);
        HisEnableParamBo hisEnableParamBo = new HisEnableParamBo();
        hisEnableParamBo.setDisabled(disable);
        hisEnableParamBo.setHisBaseBo(hisBaseBo);
        HisModelController hisModelController = HisModelController.getInstance();
        hisModelController.disableOrEnableBo(hisEnableParamBo);
    }

    public static void deleteByBoIds(List<Long> boIds, String entityNumber) {
        if (CollectionUtils.isEmpty(boIds)) {
            return;
        }
        HisBaseBo hisBaseBo = new HisBaseBo();
        hisBaseBo.setEntityNumber(entityNumber);
        hisBaseBo.setBoIdList(boIds);
        HisModelController hisModelController = HisModelController.getInstance();
        hisModelController.deleteBo(hisBaseBo);
    }

    public static DynamicObject[] queryCurDyByOrgTeamBoIds(HRBaseServiceHelper serviceHelper, List<Long> orgTeamBoIds, String selectProperties) {
        if (CollectionUtils.isEmpty(orgTeamBoIds)) {
            return new DynamicObject[0];
        }
        QFilter hisCurrentDataFilter = QFilterHelper.createHisCurrentDataFilter();
        QFilter orgTeamBoIdFilter = new QFilter("orgteam", "in", orgTeamBoIds);
        QFilter[] filters = new QFilter[]{hisCurrentDataFilter, orgTeamBoIdFilter};
        return HRStringUtils.isEmpty((String)selectProperties) ? serviceHelper.loadDynamicObjectArray(filters) : serviceHelper.query(selectProperties, filters);
    }

    public static long getStructProjectId(FormShowParameter formShowParameter) {
        String structProjectIdsStr = (String)formShowParameter.getCustomParam("struct_project_ids");
        if (HRStringUtils.isEmpty((String)structProjectIdsStr)) {
            return 1010L;
        }
        List structProjectIds = JSONArray.parseArray((String)structProjectIdsStr, Long.class);
        if (!CollectionUtils.isEmpty((Collection)structProjectIds)) {
            return (Long)structProjectIds.get(0);
        }
        return 1010L;
    }

    public static long getOtClassifyId(FormShowParameter formShowParameter) {
        Object otClassifyIdStr = formShowParameter.getCustomParam("struct_project_classify_id");
        if (otClassifyIdStr == null) {
            return 1010L;
        }
        return (Long)otClassifyIdStr;
    }

    public static String generateStructLongNumber(DynamicObject orgTeam) {
        String structNumber = orgTeam.getString("structnumber");
        DynamicObject parent = orgTeam.getDynamicObject("parent");
        if (HRObjectUtils.isEmpty((Object)parent)) {
            return structNumber;
        }
        String parentStructLongNumber = parent.getString("structlongnumber");
        return String.join((CharSequence)"!", parentStructLongNumber, structNumber);
    }

    public static String generateSortCode(DynamicObject orgTeam) {
        int index = orgTeam.getInt("index");
        if (index > 99999) {
            index = 99999;
        }
        DynamicObject parent = orgTeam.getDynamicObject("parent");
        String sortCode = "0000" + index;
        sortCode = sortCode.substring(sortCode.length() - 5);
        if (HRObjectUtils.isEmpty((Object)parent)) {
            return sortCode;
        }
        String parentSortCode = parent.getString("sortcode");
        return String.join((CharSequence)"!", parentSortCode, sortCode);
    }

    public static int calculateLevel(String structLongNumber) {
        return structLongNumber.split("!").length;
    }

    public static String realNumberToShowNumber(String realNumber, long otClassifyId) {
        String numberPrefix = NumberPrefixRepository.getRepository().getNumberPrefixById(otClassifyId);
        return realNumber.replaceFirst(numberPrefix + "_", "");
    }

    public static String showNumberToRealNumber(String showNumber, String numberPrefix) {
        return String.join((CharSequence)"_", numberPrefix, showNumber);
    }

    public static String getCustomOrgTeamEntityName(String numberPrefix) {
        return String.format("%s_%s", "haos_cusadminorgteam", numberPrefix.toLowerCase());
    }
}

