/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.domain.repository.orgteam;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.HAOSBaseRepository;
import kd.hr.haos.business.domain.repository.IRepository;
import kd.hr.haos.business.domain.repository.QFilterHelper;
import kd.hr.haos.common.constants.masterdata.AdminOrgConstants;
import kd.hr.haos.common.constants.structproject.StructProjectConstants;

public class CustomOTStructRepository
extends HAOSBaseRepository
implements IRepository {
    public static final String SELECT_FIELD_4_CASCADE_TREE = "id, boid, orgteam.id, parentorgteam.id, structlongnumber, bsed, bsled";

    private CustomOTStructRepository() {
        super("haos_customotstruct");
    }

    public static CustomOTStructRepository getInstance() {
        return Instance.INSTANCE;
    }

    public DynamicObject[] loadCurrentByOTBo(Set<Long> boSet) {
        QFilter otBoFilter = new QFilter("orgteam.id", "in", boSet);
        otBoFilter.and((QFilter)StructProjectConstants.ORG_STRUCTURE_FILTER.get());
        return this.serviceHelper.loadDynamicObjectArray(new QFilter[]{otBoFilter, QFilterHelper.createHisCurrentDataFilter()});
    }

    public DynamicObject[] loadHisByOTBo(Set<Long> boSet, List<Long> structProjectIdList) {
        QFilter otBoFilter = new QFilter("orgteam.id", "in", boSet);
        otBoFilter.and("structproject", "in", structProjectIdList);
        return this.serviceHelper.loadDynamicObjectArray(new QFilter[]{otBoFilter, QFilterHelper.createValidHisVersionFilter(), QFilterHelper.createInitFinishedFilter()});
    }

    public DynamicObject[] loadByOrgTeam(Set<Long> set) {
        QFilter filter = new QFilter("orgteam.id", "in", set);
        filter.and((QFilter)StructProjectConstants.ORG_STRUCTURE_FILTER.get());
        return this.serviceHelper.loadDynamicObjectArray(new QFilter[]{filter, QFilterHelper.createValidHisVersionFilter(), QFilterHelper.createInitFinishedFilter()});
    }

    public DynamicObjectCollection queryHisColByBoId(String selectFields, Set<Long> set) {
        QFilter boFilter = new QFilter("orgteam.id", "in", set);
        boFilter.and((QFilter)StructProjectConstants.ORG_STRUCTURE_FILTER.get());
        return this.serviceHelper.queryOriginalCollection(selectFields, new QFilter[]{boFilter, QFilterHelper.createValidHisVersionFilter(), QFilterHelper.createInitFinishedFilter()});
    }

    public DynamicObject[] loadCurrentByOTBo(Set<Long> boSet, Date bsed, List<Long> structProjectIdList) {
        QFilter otBoFilter = new QFilter("orgteam.id", "in", boSet);
        otBoFilter.and("structproject", "in", structProjectIdList);
        return this.serviceHelper.loadDynamicObjectArray(new QFilter[]{otBoFilter, QFilterHelper.createValidHisVersionFilter(bsed), QFilterHelper.createInitFinishedFilter()});
    }

    public DynamicObject loadCurrentHisVersionByOTBo(Long bo, List<Long> structProjectIdList) {
        QFilter otBoFilter = new QFilter("orgteam.id", "=", (Object)bo);
        otBoFilter.and("structproject", "in", structProjectIdList);
        return this.serviceHelper.loadDynamicObject(new QFilter[]{otBoFilter, QFilterHelper.createInitFinishedFilter(), QFilterHelper.createEffectingHisVersionFilter()});
    }

    public DynamicObject[] loadHisByBoDate(Set<Long> boSet, Date startDate, Date endDate) {
        QFilter qFilter = new QFilter("orgteam.id", "in", boSet);
        qFilter.and((QFilter)StructProjectConstants.ORG_STRUCTURE_FILTER.get());
        qFilter.and(QFilterHelper.createValidHisVersionFilter()).and(QFilterHelper.createInitFinishedFilter()).and(QFilterHelper.createOverlapsFilter(startDate, endDate));
        return this.serviceHelper.loadDynamicObjectArray(qFilter.toArray());
    }

    public DynamicObjectCollection queryHisColByBoDate(Set<Long> boSet, Date startDate, Date endDate) {
        return this.queryHisColByBoDate(boSet, startDate, endDate, AdminOrgConstants.ADMINORG_STRUCT);
    }

    public DynamicObjectCollection queryHisColByBoDate(Set<Long> boSet, Date startDate, Date endDate, Long structProjectId) {
        QFilter qFilter = new QFilter("orgteam.id", "in", boSet);
        qFilter.and(QFilterHelper.createValidHisVersionFilter()).and(QFilterHelper.createInitFinishedFilter()).and(QFilterHelper.createOverlapsFilter(startDate, endDate));
        qFilter.and("structproject", "=", (Object)structProjectId);
        return this.serviceHelper.queryOriginalCollection("orgteam.id,structlongnumber", qFilter.toArray());
    }

    public DynamicObjectCollection queryHisColBySLN(Set<String> likeStructLongNumberSet, Set<String> equalsStructLongNumberSet, Date startDate, Date endDate) {
        return this.queryHisColBySLN(likeStructLongNumberSet, equalsStructLongNumberSet, startDate, endDate, Arrays.asList(AdminOrgConstants.ADMINORG_STRUCT, AdminOrgConstants.PROJECT_TEAM));
    }

    public DynamicObjectCollection queryHisColBySLN(Set<String> likeStructLongNumberSet, Set<String> equalsStructLongNumberSet, Date startDate, Date endDate, List<Long> structProjectList) {
        QFilter qFilter = new QFilter("structlongnumber", "in", equalsStructLongNumberSet);
        if (!CollectionUtils.isEmpty(likeStructLongNumberSet)) {
            likeStructLongNumberSet.forEach(sln -> qFilter.or("structlongnumber", "like", (Object)(sln + "%")));
        }
        QFilter dateQFilter = QFilterHelper.createValidHisVersionFilter().and(QFilterHelper.createInitFinishedFilter()).and(QFilterHelper.createOverlapsFilter(startDate, endDate));
        dateQFilter.and("structproject", "in", structProjectList);
        return this.serviceHelper.queryOriginalCollection(SELECT_FIELD_4_CASCADE_TREE, new QFilter[]{qFilter, dateQFilter});
    }

    public DynamicObjectCollection queryAllEnablingDataColBySLN(String selectFields, Set<String> likeStructLongNumberSet, List<Long> structProjectList) {
        QFilter qFilter = QFilterHelper.create1NotEquals1Filter();
        if (!CollectionUtils.isEmpty(likeStructLongNumberSet)) {
            likeStructLongNumberSet.forEach(sln -> qFilter.or("structlongnumber", "like", (Object)(sln + "%")));
        }
        QFilter enablingFilter = QFilterHelper.createEnablingFilter();
        QFilter structProjectFilter = new QFilter("structproject", "in", structProjectList);
        return this.serviceHelper.queryOriginalCollection(selectFields, new QFilter[]{qFilter, enablingFilter, structProjectFilter});
    }

    public DynamicObject[] queryOriginalHis4CascadeByOtBo(Set<Long> boSet, Date bsed) {
        return this.queryOriginalHis4CascadeByOtBoAndStructProject(boSet, bsed, Arrays.asList(1010L, 1020L));
    }

    public DynamicObject[] queryOriginalHis4CascadeByOtBoAndStructProject(Set<Long> boSet, Date bsed, List<Long> structProjectIdList) {
        QFilter otBoFilter = new QFilter("orgteam.id", "in", boSet);
        otBoFilter.and("structproject", "in", structProjectIdList);
        return this.serviceHelper.queryOriginalArray("id, orgteam.id, structlongnumber", new QFilter[]{otBoFilter, QFilterHelper.createValidHisVersionFilter(bsed), QFilterHelper.createInitFinishedFilter()});
    }

    public DynamicObject[] queryOriginalCurDataCascadeByOtBo(String selectFields, Set<Long> boSet, List<Long> structProjectIdList) {
        QFilter otBoFilter = new QFilter("orgteam.id", "in", boSet);
        otBoFilter.and("structproject", "in", structProjectIdList);
        return this.serviceHelper.queryOriginalArray(selectFields, new QFilter[]{otBoFilter, QFilterHelper.createValidHisCurrentDataFilter(), QFilterHelper.createInitFinishedFilter()});
    }

    public DynamicObject[] queryOriginalHisBySLN(Set<String> likeStructLongNumberList, Set<String> equalsStructLongNumberList, Date bsed) {
        return this.queryOriginalHisBySLNByStructProject(likeStructLongNumberList, equalsStructLongNumberList, bsed, Arrays.asList(1010L, 1020L));
    }

    public DynamicObject[] queryOriginalHisBySLNByStructProject(Set<String> likeStructLongNumberList, Set<String> equalsStructLongNumberList, Date bsed, List<Long> structProjectIdList) {
        if (CollectionUtils.isEmpty(likeStructLongNumberList)) {
            likeStructLongNumberList = Collections.emptySet();
        }
        if (CollectionUtils.isEmpty(equalsStructLongNumberList)) {
            equalsStructLongNumberList = Collections.emptySet();
        }
        if (CollectionUtils.isEmpty(likeStructLongNumberList) && CollectionUtils.isEmpty(equalsStructLongNumberList)) {
            return new DynamicObject[0];
        }
        QFilter equalsFilter = equalsStructLongNumberList.stream().map(SLN -> new QFilter("structlongnumber", "=", SLN)).reduce(QFilterHelper.create1NotEquals1Filter(), (qFilter, qFilter2) -> qFilter.or(qFilter2));
        QFilter likeQFilter = likeStructLongNumberList.stream().map(SLN -> new QFilter("structlongnumber", "like", (Object)(SLN + "%"))).reduce(QFilterHelper.create1NotEquals1Filter(), (qFilter, qFilter2) -> qFilter.or(qFilter2));
        return this.serviceHelper.queryOriginalArray(SELECT_FIELD_4_CASCADE_TREE, new QFilter[]{likeQFilter.or(equalsFilter), QFilterHelper.createValidHisVersionFilter(bsed), QFilterHelper.createInitFinishedFilter(), new QFilter("structproject", "in", structProjectIdList)});
    }

    public DynamicObject[] queryOriginalHisByOtBo(Set<Long> boSet, Date bsed, List<Long> structProjectIdList) {
        QFilter otBoFilter = new QFilter("orgteam.id", "in", boSet);
        otBoFilter.and("structproject", "in", structProjectIdList);
        return this.serviceHelper.queryOriginalArray(SELECT_FIELD_4_CASCADE_TREE, new QFilter[]{otBoFilter, QFilterHelper.createValidHisVersionFilter(bsed), QFilterHelper.createInitFinishedFilter()});
    }

    public DynamicObject queryOriginalByOtBo(String selectFields, long bo) {
        QFilter structProjectFilter = (QFilter)StructProjectConstants.ORG_STRUCTURE_FILTER.get();
        return this.serviceHelper.queryOriginalOne(selectFields, new QFilter[]{new QFilter("orgteam", "=", (Object)bo), structProjectFilter, QFilterHelper.createHisCurrentDataFilter()});
    }

    public DynamicObject[] queryAllDataByOtBo(String selectFields, Set<Long> boSet, List<Long> structProjectIdList) {
        QFilter structProjectFilter = new QFilter("structproject", "in", structProjectIdList);
        return this.serviceHelper.query(selectFields, new QFilter[]{new QFilter("orgteam", "in", boSet), structProjectFilter});
    }

    public DynamicObject[] queryOTStructByOrgTeamBoIdSet(String selectFields, Set<Long> boIdSet) {
        QFilter boFilter = new QFilter("orgteam.id", "in", boIdSet);
        boFilter.and((QFilter)StructProjectConstants.ORG_STRUCTURE_FILTER.get());
        QFilter hisCurrentDataFilter = QFilterHelper.createHisCurrentDataFilter();
        return this.serviceHelper.queryOriginalArray(selectFields, new QFilter[]{boFilter, hisCurrentDataFilter, QFilterHelper.createInitFinishedFilter()});
    }

    public DynamicObject[] queryOTAllCurAndSubDynBySNSet(String selectFields, Set<String> structLongNumberSet, List<String> dataStatusList) {
        if (ObjectUtils.isEmpty(structLongNumberSet)) {
            return new DynamicObject[0];
        }
        QFilter currentDataFilter = QFilterHelper.createHisCurrentDataFilter();
        QFilter snlFilter = null;
        for (String sn : structLongNumberSet) {
            if (snlFilter == null) {
                snlFilter = new QFilter("structlongnumber", "like", (Object)(sn + "%"));
                continue;
            }
            snlFilter.or(new QFilter("structlongnumber", "like", (Object)(sn + "%")));
        }
        if (!ObjectUtils.isEmpty(dataStatusList)) {
            currentDataFilter.and(new QFilter("datastatus", "in", dataStatusList));
        }
        return this.serviceHelper.queryOriginalArray(selectFields, new QFilter[]{snlFilter, currentDataFilter, (QFilter)StructProjectConstants.ORG_STRUCTURE_FILTER.get(), QFilterHelper.createInitFinishedFilter()});
    }

    public DynamicObject[] queryOriginal4Sub(String selectFields, Set<Long> otBoIdSet, boolean containsSelf) {
        QFilter otBoFilter = new QFilter("orgteam.id", "in", otBoIdSet);
        DynamicObject[] curStructDys = this.serviceHelper.queryOriginalArray("structlongnumber", new QFilter[]{otBoFilter, QFilterHelper.createHisCurrentDataFilter(), QFilterHelper.createInitFinishedFilter(), (QFilter)StructProjectConstants.ORG_STRUCTURE_FILTER.get()});
        List structLongNumberList = Arrays.stream(curStructDys).map(structDy -> structDy.getString("structlongnumber")).collect(Collectors.toList());
        Function<String, QFilter> createSLNFilter = SLN -> {
            if (containsSelf) {
                return new QFilter("structlongnumber", "like", (Object)(SLN + "%"));
            }
            return new QFilter("structlongnumber", "like", (Object)(SLN + "!%"));
        };
        QFilter SLNQFilter = structLongNumberList.stream().map(createSLNFilter).reduce(QFilterHelper.create1NotEquals1Filter(), (qFilter, qFilter2) -> qFilter.or(qFilter2));
        return this.serviceHelper.queryOriginalArray(selectFields, new QFilter[]{SLNQFilter, QFilterHelper.createHisCurrentDataFilter(), (QFilter)StructProjectConstants.ORG_STRUCTURE_FILTER.get()});
    }

    public int deleteDataByOtBo(Set<Long> boSet, List<Long> structProjectIdList) {
        QFilter otBoFilter = new QFilter("orgteam.id", "in", boSet);
        QFilter structProjectFilter = new QFilter("structproject", "in", structProjectIdList);
        return this.serviceHelper.deleteByFilter(new QFilter[]{otBoFilter, structProjectFilter});
    }

    public void deleteByStructProjectNotOrg(Set<Long> structProjectSet, Long orgId) {
        QFilter qFilter = new QFilter("structproject", "in", structProjectSet);
        if (orgId != null) {
            qFilter.and("orgteam", "!=", (Object)orgId);
        }
        this.serviceHelper.deleteByFilter(qFilter.toArray());
    }

    public void deleteByStructProjectOrg(Long structProjectId, Set<Long> orgSet) {
        QFilter qFilter = new QFilter("structproject", "=", (Object)structProjectId);
        qFilter.and("orgteam", "in", orgSet);
        this.serviceHelper.deleteByFilter(qFilter.toArray());
    }

    @Override
    public DynamicObject[] queryPerformanceUpdateFields(Collection<Long> adminOrgIds) {
        QFilter orgFilter = new QFilter("orgteam", "in", adminOrgIds);
        return this.serviceHelper.queryOriginalArray("orgteam as orgteam.id, level, structlongnumber", new QFilter[]{orgFilter, QFilterHelper.createValidHisCurrentDataFilter(), (QFilter)StructProjectConstants.ORG_STRUCT_FILTER.get()});
    }

    public DynamicObject[] queryByStructProjectAndOrg(String selectFields, Set<Long> structProjectSet, Set<Long> orgSet) {
        QFilter qFilter = new QFilter("structproject", "in", structProjectSet);
        if (!CollectionUtils.isEmpty(orgSet)) {
            qFilter.and(new QFilter("orgteam.id", "in", orgSet));
        }
        return this.serviceHelper.query(selectFields, qFilter.toArray());
    }

    public DynamicObject[] loadByOrgDateStructId(Set<Long> set, Date startDate, Date endDate, Long structProjectId) {
        QFilter orgFilter = new QFilter("orgteam.id", "in", set);
        orgFilter.and(QFilterHelper.createValidHisVersionFilter());
        orgFilter.and(QFilterHelper.createInitFinishedFilter());
        orgFilter.and(QFilterHelper.createOverlapsFilter(startDate, endDate));
        orgFilter.and("structproject", "=", (Object)structProjectId);
        return this.serviceHelper.loadDynamicObjectArray(orgFilter.toArray());
    }

    public DynamicObject[] loadByOrgDateOtherStruct(Set<Long> set, Date startDate, Date endDate) {
        QFilter orgFilter = new QFilter("orgteam.id", "in", set);
        orgFilter.and(QFilterHelper.createValidHisVersionFilter());
        orgFilter.and(QFilterHelper.createInitFinishedFilter());
        orgFilter.and(QFilterHelper.createOverlapsFilter(startDate, endDate));
        orgFilter.and("structproject", "not in", Arrays.asList(AdminOrgConstants.ADMINORG_STRUCT, AdminOrgConstants.PROJECT_TEAM));
        return this.serviceHelper.loadDynamicObjectArray(orgFilter.toArray());
    }

    public DynamicObject[] loadHisByStructIdBoDate(Set<Long> boSet, Date startDate, Long structProjectId) {
        QFilter qFilter = new QFilter("orgteam.id", "in", boSet);
        qFilter.and("structproject", "in", (Object)structProjectId);
        qFilter.and(QFilterHelper.createValidHisVersionFilter()).and(QFilterHelper.createInitFinishedFilter());
        qFilter.and("bsled", ">=", (Object)startDate);
        return this.serviceHelper.loadDynamicObjectArray(qFilter.toArray());
    }

    private static class Instance {
        private static CustomOTStructRepository INSTANCE = new CustomOTStructRepository();

        private Instance() {
        }
    }
}

